/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.synchronization;

import java.math.BigDecimal;
import java.math.MathContext;
import org.eclipse.linuxtools.tmf.core.synchronization.ITmfTimestampTransform;
import org.eclipse.linuxtools.tmf.core.synchronization.TmfTimestampTransform;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;

@Deprecated
public class TmfTimestampTransformLinear
implements ITmfTimestampTransform {
    private static final long serialVersionUID = -4756608071358979461L;
    private final BigDecimal fAlpha;
    private final BigDecimal fBeta;
    private static final MathContext fMc = MathContext.DECIMAL128;

    public TmfTimestampTransformLinear() {
        this.fAlpha = BigDecimal.ONE;
        this.fBeta = BigDecimal.ZERO;
    }

    public TmfTimestampTransformLinear(double alpha, double beta) {
        this.fAlpha = BigDecimal.valueOf(alpha);
        this.fBeta = BigDecimal.valueOf(beta);
    }

    public TmfTimestampTransformLinear(BigDecimal fAlpha2, BigDecimal fBeta2) {
        this.fAlpha = fAlpha2 != null ? fAlpha2 : BigDecimal.ONE;
        this.fBeta = fBeta2 != null ? fBeta2 : BigDecimal.ZERO;
    }

    @Override
    public ITmfTimestamp transform(ITmfTimestamp timestamp) {
        BigDecimal newvalue = BigDecimal.valueOf(timestamp.getValue()).multiply(this.fAlpha, fMc).add(this.fBeta);
        return new TmfTimestamp(timestamp, newvalue.longValue());
    }

    @Override
    public long transform(long timestamp) {
        BigDecimal t = BigDecimal.valueOf(timestamp).multiply(this.fAlpha, fMc).add(this.fBeta);
        return t.longValue();
    }

    @Override
    public ITmfTimestampTransform composeWith(ITmfTimestampTransform composeWith) {
        if (composeWith.equals(TmfTimestampTransform.IDENTITY)) {
            return this;
        }
        if (composeWith instanceof TmfTimestampTransformLinear) {
            TmfTimestampTransformLinear ttl = (TmfTimestampTransformLinear)composeWith;
            BigDecimal newAlpha = this.fAlpha.multiply(ttl.fAlpha, fMc);
            BigDecimal newBeta = this.fAlpha.multiply(ttl.fBeta, fMc).add(this.fBeta);
            return new TmfTimestampTransformLinear(newAlpha, newBeta);
        }
        return this;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other instanceof TmfTimestampTransformLinear) {
            TmfTimestampTransformLinear that = (TmfTimestampTransformLinear)other;
            result = that.fAlpha.equals(this.fAlpha) && that.fBeta.equals(this.fBeta);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fBeta.multiply(this.fAlpha).intValue();
        return result;
    }

    public String toString() {
        return "TmfTimestampLinear [ alpha = " + this.fAlpha.toString() + ", beta = " + this.fBeta.toString() + " ]";
    }
}

