/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIDisplayHint;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

public class MIVar {
    String name = "";
    String type = "";
    String value = "";
    String exp = "";
    private boolean isDynamic = false;
    int numchild;
    private boolean hasMore = false;
    private MIDisplayHint displayHint = MIDisplayHint.NONE;

    public MIVar(String n, int num, String t) {
        this(n, false, num, false, t, MIDisplayHint.NONE);
    }

    public MIVar(String n, boolean isDynamic, int num, boolean hasMore, String t) {
        this(n, isDynamic, num, hasMore, t, MIDisplayHint.NONE);
    }

    public MIVar(String n, boolean isDynamic, int num, boolean hasMore, String t, MIDisplayHint displayHint) {
        this.name = n;
        this.isDynamic = isDynamic;
        this.numchild = num;
        this.hasMore = hasMore;
        this.type = t;
        this.displayHint = displayHint;
    }

    public MIVar(MITuple tuple) {
        this.parse(tuple);
    }

    public String getVarName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public int getNumChild() {
        return this.numchild;
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public String getExp() {
        return this.exp;
    }

    public MIDisplayHint getDisplayHint() {
        return this.displayHint;
    }

    void parse(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value != null && value instanceof MIConst) {
                str = ((MIConst)value).getString();
            }
            if (var.equals("numchild")) {
                try {
                    this.numchild = Integer.parseInt(str.trim());
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (var.equals("name")) {
                this.name = str;
            } else if (var.equals("type")) {
                this.type = str;
            } else if (var.equals("value")) {
                this.value = str;
            } else if (var.equals("exp")) {
                this.exp = str;
            } else if (var.equals("dynamic") && str.trim().equals("1")) {
                this.isDynamic = true;
            } else if (var.equals("has_more") && str.trim().equals("1")) {
                this.hasMore = true;
            } else if (var.equals("displayhint")) {
                this.displayHint = new MIDisplayHint(str);
            }
            ++i;
        }
    }
}

