/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.action;

import java.io.File;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.gcov.action.Messages;
import org.eclipse.linuxtools.internal.gcov.dialog.OpenGCDialog;
import org.eclipse.linuxtools.internal.gcov.view.CovView;
import org.eclipse.linuxtools.internal.gcov.view.annotatedsource.GcovAnnotationModelTracker;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.PlatformUI;

public class OpenGCAction
implements IEditorLauncher {
    public void autoOpen(IPath file, boolean isCompleteCoverageResultWanted) {
        File gcda;
        String extension = file.getFileExtension();
        if ("gcno".equals(extension)) {
            gcda = file.removeFileExtension().addFileExtension("gcda").toFile();
        } else if ("gcda".equals(extension)) {
            gcda = file.toFile();
        } else {
            return;
        }
        if (isCompleteCoverageResultWanted) {
            CovView.displayCovResults(this.getDefaultBinary(file), gcda.getAbsolutePath());
        } else {
            CovView.displayCovDetailedResult(this.getDefaultBinary(file), gcda.getAbsolutePath());
        }
    }

    public void open(IPath file) {
        String msg;
        File gcda;
        File gcno;
        IPath file2;
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        String extension = file.getFileExtension();
        if ("gcno".equals(extension)) {
            file2 = file.removeFileExtension().addFileExtension("gcda");
            gcno = file.toFile();
            gcda = file2.toFile();
        } else if ("gcda".equals(extension)) {
            file2 = file.removeFileExtension().addFileExtension("gcno");
            gcda = file.toFile();
            gcno = file2.toFile();
        } else {
            return;
        }
        if (gcda == null || !gcda.isFile()) {
            msg = NLS.bind((String)Messages.OpenGCAction_file_dne_run, (Object)gcda);
            MessageDialog.openError((Shell)shell, (String)Messages.OpenGCAction_gcov_error, (String)msg);
            return;
        }
        if (gcno == null || !gcno.isFile()) {
            msg = NLS.bind((String)Messages.OpenGCAction_file_dne_compile, (Object)gcno);
            MessageDialog.openError((Shell)shell, (String)Messages.OpenGCAction_gcov_error, (String)msg);
            return;
        }
        OpenGCDialog d = new OpenGCDialog(shell, this.getDefaultBinary(file), file);
        if (d.open() != 0) {
            return;
        }
        String binaryPath = d.getBinaryFile();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(file).getProject();
        GcovAnnotationModelTracker.getInstance().addProject(project, (IPath)new Path(binaryPath));
        GcovAnnotationModelTracker.getInstance().annotateAllCEditors();
        if (d.isCompleteCoverageResultWanted()) {
            CovView.displayCovResults(binaryPath, gcda.getAbsolutePath());
        } else {
            CovView.displayCovDetailedResult(binaryPath, gcda.getAbsolutePath());
        }
    }

    private String getDefaultBinary(IPath file) {
        ICProject cproject;
        IProject project = null;
        IFile c = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(file);
        if (c != null && (project = c.getProject()) != null && project.exists() && (cproject = CoreModel.getDefault().create(project)) != null) {
            try {
                IBinary[] b = cproject.getBinaryContainer().getBinaries();
                if (b != null && b.length > 0 && b[0] != null) {
                    IResource r = b[0].getResource();
                    return r.getLocation().toOSString();
                }
            }
            catch (CModelException cModelException) {
                // empty catch block
            }
        }
        return "";
    }
}

