/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.scope.LexicalScope;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinition;

public abstract class Definition
implements IDefinition {
    private final String fFieldName;
    @NonNull
    private final LexicalScope fPath;
    private final IDefinitionScope fDefinitionScope;
    @NonNull
    private final IDeclaration fDeclaration;

    public Definition(@NonNull IDeclaration declaration, IDefinitionScope definitionScope, @NonNull String fieldName) {
        this(declaration, definitionScope, fieldName, declaration.getPath(definitionScope, fieldName));
    }

    public Definition(@NonNull IDeclaration declaration, IDefinitionScope definitionScope, @NonNull String fieldName, @NonNull LexicalScope scope) {
        this.fDeclaration = declaration;
        this.fDefinitionScope = definitionScope;
        this.fFieldName = fieldName;
        this.fPath = scope;
    }

    protected String getFieldName() {
        return this.fFieldName;
    }

    @Override
    public LexicalScope getScopePath() {
        return this.fPath;
    }

    protected IDefinitionScope getDefinitionScope() {
        return this.fDefinitionScope;
    }

    @Override
    public IDeclaration getDeclaration() {
        return this.fDeclaration;
    }

    public String toString() {
        return String.valueOf(this.fPath.toString()) + '[' + Integer.toHexString(this.hashCode()) + ']';
    }
}

