/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import java.math.BigInteger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.SimpleDatatypeDefinition;

public final class IntegerDefinition
extends SimpleDatatypeDefinition {
    private final long fValue;

    public IntegerDefinition(@NonNull IntegerDeclaration declaration, IDefinitionScope definitionScope, @NonNull String fieldName, long value) {
        super(declaration, definitionScope, fieldName);
        this.fValue = value;
    }

    public long getValue() {
        return this.fValue;
    }

    @Override
    public IntegerDeclaration getDeclaration() {
        return (IntegerDeclaration)super.getDeclaration();
    }

    @Override
    public Long getIntegerValue() {
        return this.getValue();
    }

    @Override
    public String getStringValue() {
        return this.toString();
    }

    @Override
    public String toString() {
        if (this.getDeclaration().isCharacter()) {
            char c = (char)this.fValue;
            return Character.toString(c);
        }
        return IntegerDefinition.formatNumber(this.fValue, this.getDeclaration().getBase(), this.getDeclaration().isSigned());
    }

    public static final String formatNumber(long value, int base, boolean signed) {
        String s;
        switch (base) {
            case 2: {
                s = "0b" + Long.toBinaryString(value);
                break;
            }
            case 8: {
                s = "0" + Long.toOctalString(value);
                break;
            }
            case 16: {
                s = "0x" + Long.toHexString(value);
                break;
            }
            default: {
                if (!signed && value < 0L) {
                    BigInteger bigInteger = BigInteger.valueOf(value);
                    bigInteger = bigInteger.add(BigInteger.valueOf(1L).shiftLeft(64));
                    s = bigInteger.toString();
                    break;
                }
                s = Long.toString(value);
            }
        }
        return s;
    }
}

