/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.scope.LexicalScope;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.ICompositeDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.ScopedDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;

public final class StructDefinition
extends ScopedDefinition
implements ICompositeDefinition {
    private final ImmutableList<String> fFieldNames;
    private final Definition[] fDefinitions;
    private Map<String, Definition> fDefinitionsMap = null;

    public StructDefinition(@NonNull StructDeclaration declaration, IDefinitionScope definitionScope, @NonNull String structFieldName, List<String> fieldNames, Definition[] definitions) {
        this(declaration, definitionScope, structFieldName, (Iterable<String>)fieldNames, definitions);
    }

    public StructDefinition(@NonNull StructDeclaration declaration, IDefinitionScope definitionScope, @NonNull String structFieldName, Iterable<String> fieldNames, Definition[] definitions) {
        super(declaration, definitionScope, structFieldName);
        this.fFieldNames = ImmutableList.copyOf(fieldNames);
        this.fDefinitions = definitions;
        if (this.fFieldNames.isEmpty()) {
            this.fDefinitionsMap = Collections.EMPTY_MAP;
        }
    }

    public StructDefinition(@NonNull StructDeclaration declaration, IDefinitionScope definitionScope, @NonNull LexicalScope scope, @NonNull String structFieldName, @NonNull Iterable<String> fieldNames, Definition[] definitions) {
        super(declaration, definitionScope, structFieldName, scope);
        this.fFieldNames = ImmutableList.copyOf(fieldNames);
        this.fDefinitions = definitions;
        if (this.fFieldNames.isEmpty()) {
            this.fDefinitionsMap = Collections.EMPTY_MAP;
        }
    }

    @Override
    public Definition getDefinition(String fieldName) {
        if (this.fDefinitionsMap == null) {
            ImmutableMap.Builder mapBuilder = new ImmutableMap.Builder();
            int i = 0;
            while (i < this.fFieldNames.size()) {
                if (this.fDefinitions[i] != null) {
                    mapBuilder.put((Object)((String)this.fFieldNames.get(i)), (Object)this.fDefinitions[i]);
                }
                ++i;
            }
            this.fDefinitionsMap = mapBuilder.build();
        }
        return this.fDefinitionsMap.get(fieldName);
    }

    @Override
    public List<String> getFieldNames() {
        return this.fFieldNames;
    }

    @Override
    public StructDeclaration getDeclaration() {
        return (StructDeclaration)super.getDeclaration();
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        int val = this.fFieldNames.indexOf((Object)lookupPath);
        if (val != -1) {
            return this.fDefinitions[val];
        }
        String lookupUnderscored = "_" + lookupPath;
        val = this.fFieldNames.indexOf((Object)lookupUnderscored);
        if (val != -1) {
            return this.fDefinitions[val];
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        if (this.fFieldNames != null) {
            LinkedList<String> fields = new LinkedList<String>();
            for (String field : this.fFieldNames) {
                String appendee = String.valueOf(field) + " = " + this.lookupDefinition(field).toString();
                fields.add(appendee);
            }
            Joiner joiner = Joiner.on((String)", ").skipNulls();
            builder.append(joiner.join(fields));
        }
        builder.append(" }");
        return builder.toString();
    }
}

