/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.event.types;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.ScopedDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.VariantDeclaration;

public final class VariantDefinition
extends ScopedDefinition {
    private final Definition fDefinition;
    private final String fCurrentField;
    private final String fFieldName;

    public VariantDefinition(@NonNull VariantDeclaration declaration, IDefinitionScope definitionScope, String selectedField, @NonNull String fieldName, Definition fieldValue) {
        super(declaration, definitionScope, fieldName);
        this.fFieldName = fieldName;
        this.fCurrentField = selectedField;
        this.fDefinition = fieldValue;
    }

    @Override
    public VariantDeclaration getDeclaration() {
        return (VariantDeclaration)super.getDeclaration();
    }

    public String getCurrentFieldName() {
        return this.fCurrentField;
    }

    public Definition getCurrentField() {
        return this.fDefinition;
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        if (lookupPath == null) {
            return null;
        }
        if (lookupPath.equals(this.fFieldName)) {
            return this.fDefinition;
        }
        return this.getDefinitionScope().lookupDefinition(lookupPath);
    }

    @Override
    public String toString() {
        return "{ " + this.getCurrentFieldName() + " = " + this.getCurrentField() + " }";
    }
}

