/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.scope.LexicalScope;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.EnumDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.FloatDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StringDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFStream;
import org.eclipse.linuxtools.ctf.core.trace.Utils;
import org.eclipse.linuxtools.internal.ctf.core.SafeMappedByteBuffer;
import org.eclipse.linuxtools.internal.ctf.core.event.types.ArrayDefinition;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInputPacketIndex;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInputPacketIndexEntry;

public class CTFStreamInput
implements IDefinitionScope,
AutoCloseable {
    private final CTFStream fStream;
    @NonNull
    private final File fFile;
    private final StreamInputPacketIndex fIndex;
    private long fTimestampEnd;
    private StructDeclaration fTracePacketHeaderDecl = null;
    private StructDeclaration fStreamPacketContextDecl = null;
    private long fLostSoFar = 0L;

    public CTFStreamInput(CTFStream stream, @NonNull File file) {
        this.fStream = stream;
        this.fFile = file;
        this.fIndex = new StreamInputPacketIndex();
    }

    @Override
    public void close() throws IOException {
    }

    public CTFStream getStream() {
        return this.fStream;
    }

    StreamInputPacketIndex getIndex() {
        return this.fIndex;
    }

    public String getFilename() {
        return this.fFile.getName();
    }

    public long getTimestampEnd() {
        return this.fTimestampEnd;
    }

    public void setTimestampEnd(long timestampEnd) {
        this.fTimestampEnd = timestampEnd;
    }

    @Override
    public LexicalScope getScopePath() {
        return LexicalScope.STREAM;
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        return null;
    }

    public void setupIndex() {
        BitBuffer bitBuffer = new BitBuffer();
        bitBuffer.setByteOrder(this.getStream().getTrace().getByteOrder());
        if (this.getStream().getTrace().getPacketHeader() != null) {
            this.fTracePacketHeaderDecl = this.getStream().getTrace().getPacketHeader();
        }
        if (this.getStream().getPacketContextDecl() != null) {
            this.fStreamPacketContextDecl = this.getStream().getPacketContextDecl();
        }
    }

    public boolean addPacketHeaderIndex() throws CTFReaderException {
        long fileSize;
        long currentPos = 0L;
        if (!this.fIndex.getEntries().isEmpty()) {
            StreamInputPacketIndexEntry pos = this.fIndex.getEntries().lastElement();
            currentPos = CTFStreamInput.computeNextOffset(pos);
        }
        if (currentPos < (fileSize = this.getStreamSize())) {
            StreamInputPacketIndexEntry packetIndex = new StreamInputPacketIndexEntry(currentPos);
            this.createPacketIndexEntry(fileSize, currentPos, packetIndex);
            this.fIndex.addEntry(packetIndex);
            return true;
        }
        return false;
    }

    private long getStreamSize() {
        return this.fFile.length();
    }

    private long createPacketIndexEntry(long fileSizeBytes, long packetOffsetBytes, StreamInputPacketIndexEntry packetIndex) throws CTFReaderException {
        long pos = this.readPacketHeader(fileSizeBytes, packetOffsetBytes, packetIndex);
        if (packetIndex.getContentSizeBits() > packetIndex.getPacketSizeBits()) {
            throw new CTFReaderException("Content size > packet size");
        }
        if (packetIndex.getPacketSizeBits() > (fileSizeBytes - packetIndex.getOffsetBytes()) * 8L) {
            throw new CTFReaderException("Not enough data remaining in the file for the size of this packet");
        }
        packetIndex.setDataOffsetBits(pos);
        return CTFStreamInput.computeNextOffset(packetIndex);
    }

    private static long computeNextOffset(StreamInputPacketIndexEntry packetIndex) {
        return packetIndex.getOffsetBytes() + (packetIndex.getPacketSizeBits() + 7L) / 8L;
    }

    private long readPacketHeader(long fileSizeBytes, long packetOffsetBytes, StreamInputPacketIndexEntry packetIndex) throws CTFReaderException {
        long position = -1L;
        long mapSize = 4096L;
        if (fileSizeBytes - packetIndex.getOffsetBytes() < mapSize) {
            mapSize = fileSizeBytes - packetIndex.getOffsetBytes();
        }
        try {
            Throwable throwable = null;
            Object var11_9 = null;
            try (FileChannel fc = FileChannel.open(this.fFile.toPath(), StandardOpenOption.READ);){
                ByteBuffer map = SafeMappedByteBuffer.map(fc, FileChannel.MapMode.READ_ONLY, packetOffsetBytes, mapSize);
                if (map == null) {
                    throw new CTFReaderException("Failed to allocate mapped byte buffer");
                }
                BitBuffer bitBuffer = new BitBuffer(map);
                bitBuffer.setByteOrder(this.getStream().getTrace().getByteOrder());
                if (this.fTracePacketHeaderDecl != null) {
                    this.parseTracePacketHeader(this.fTracePacketHeaderDecl, bitBuffer);
                }
                if (this.fStreamPacketContextDecl != null) {
                    this.parsePacketContext(fileSizeBytes, this.fStreamPacketContextDecl, bitBuffer, packetIndex);
                } else {
                    CTFStreamInput.setPacketContextNull(fileSizeBytes, packetIndex);
                }
                position = bitBuffer.position();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CTFReaderException(e);
        }
        return position;
    }

    private void parseTracePacketHeader(StructDeclaration tracePacketHeaderDecl, @NonNull BitBuffer bitBuffer) throws CTFReaderException {
        long streamID;
        IntegerDefinition streamIDDef;
        int magic;
        StructDefinition tracePacketHeaderDef = tracePacketHeaderDecl.createDefinition((IDefinitionScope)this.fStream.getTrace(), LexicalScope.TRACE_PACKET_HEADER, bitBuffer);
        IntegerDefinition magicDef = (IntegerDefinition)tracePacketHeaderDef.lookupDefinition("magic");
        if (magicDef != null && (magic = (int)magicDef.getValue()) != -1040441407) {
            throw new CTFReaderException("CTF magic mismatch " + Integer.toHexString(magic) + " vs " + Integer.toHexString(-1040441407));
        }
        ArrayDefinition uuidDef = (ArrayDefinition)tracePacketHeaderDef.lookupDefinition("uuid");
        if (uuidDef != null) {
            UUID uuid = Utils.getUUIDfromDefinition(uuidDef);
            if (!this.getStream().getTrace().getUUID().equals(uuid)) {
                throw new CTFReaderException("UUID mismatch");
            }
        }
        if ((streamIDDef = (IntegerDefinition)tracePacketHeaderDef.lookupDefinition("stream_id")) != null && (streamID = streamIDDef.getValue()) != this.getStream().getId()) {
            throw new CTFReaderException("Stream ID changing within a StreamInput");
        }
    }

    @NonNull
    File getFile() {
        return this.fFile;
    }

    private static void setPacketContextNull(long fileSizeBytes, StreamInputPacketIndexEntry packetIndex) {
        packetIndex.setContentSizeBits(fileSizeBytes * 8L);
        packetIndex.setPacketSizeBits(fileSizeBytes * 8L);
    }

    private void parsePacketContext(long fileSizeBytes, StructDeclaration streamPacketContextDecl, @NonNull BitBuffer bitBuffer, StreamInputPacketIndexEntry packetIndex) throws CTFReaderException {
        StructDefinition streamPacketContextDef = streamPacketContextDecl.createDefinition((IDefinitionScope)this, LexicalScope.STREAM_PACKET_CONTEXT, bitBuffer);
        for (String field : streamPacketContextDef.getDeclaration().getFieldsList()) {
            Definition id = streamPacketContextDef.lookupDefinition(field);
            if (id instanceof IntegerDefinition) {
                packetIndex.addAttribute(field, ((IntegerDefinition)id).getValue());
                continue;
            }
            if (id instanceof FloatDefinition) {
                packetIndex.addAttribute(field, ((FloatDefinition)id).getValue());
                continue;
            }
            if (id instanceof EnumDefinition) {
                packetIndex.addAttribute(field, ((EnumDefinition)id).getValue());
                continue;
            }
            if (!(id instanceof StringDefinition)) continue;
            packetIndex.addAttribute(field, ((StringDefinition)id).getValue());
        }
        Long contentSize = (Long)packetIndex.lookupAttribute("content_size");
        Long packetSize = (Long)packetIndex.lookupAttribute("packet_size");
        Long tsBegin = (Long)packetIndex.lookupAttribute("timestamp_begin");
        Long tsEnd = (Long)packetIndex.lookupAttribute("timestamp_end");
        String device = (String)packetIndex.lookupAttribute("device");
        Long cpuId = (Long)packetIndex.lookupAttribute("cpu_id");
        Long lostEvents = (Long)packetIndex.lookupAttribute("events_discarded");
        if (contentSize != null) {
            packetIndex.setContentSizeBits(contentSize.intValue());
        } else if (packetSize != null) {
            packetIndex.setContentSizeBits(packetSize);
        } else {
            packetIndex.setContentSizeBits((int)(fileSizeBytes * 8L));
        }
        if (packetSize != null) {
            packetIndex.setPacketSizeBits(packetSize.intValue());
        } else if (packetIndex.getContentSizeBits() != 0L) {
            packetIndex.setPacketSizeBits(packetIndex.getContentSizeBits());
        } else {
            packetIndex.setPacketSizeBits((int)(fileSizeBytes * 8L));
        }
        if (tsBegin != null) {
            packetIndex.setTimestampBegin(tsBegin);
        }
        if (tsEnd != null) {
            if (tsEnd == -1L) {
                tsEnd = Long.MAX_VALUE;
            }
            packetIndex.setTimestampEnd(tsEnd);
            this.setTimestampEnd(packetIndex.getTimestampEnd());
        }
        if (device != null) {
            packetIndex.setTarget(device);
        }
        if (cpuId != null) {
            packetIndex.setTarget("CPU" + cpuId.toString());
        }
        if (lostEvents != null) {
            packetIndex.setLostEvents(lostEvents - this.fLostSoFar);
            this.fLostSoFar = lostEvents;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fFile.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CTFStreamInput)) {
            return false;
        }
        CTFStreamInput other = (CTFStreamInput)obj;
        return this.fFile.equals(other.fFile);
    }
}

