/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.ctf.core.trace;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.linuxtools.ctf.core.event.EventDefinition;
import org.eclipse.linuxtools.ctf.core.event.IEventDeclaration;
import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.scope.LexicalScope;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.ICompositeDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IEventHeaderDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.SimpleDatatypeDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.VariantDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFStream;
import org.eclipse.linuxtools.ctf.core.trace.CTFStreamInputReader;
import org.eclipse.linuxtools.internal.ctf.core.SafeMappedByteBuffer;
import org.eclipse.linuxtools.internal.ctf.core.event.EventDeclaration;
import org.eclipse.linuxtools.internal.ctf.core.event.types.composite.EventHeaderDefinition;
import org.eclipse.linuxtools.internal.ctf.core.trace.StreamInputPacketIndexEntry;

public class CTFStreamInputPacketReader
implements IDefinitionScope,
AutoCloseable {
    @Nullable
    private BitBuffer fBitBuffer;
    private final CTFStreamInputReader fStreamInputReader;
    private final StructDeclaration fTracePacketHeaderDecl;
    private final StructDeclaration fStreamPacketContextDecl;
    private final IDeclaration fStreamEventHeaderDecl;
    private final StructDeclaration fStreamEventContextDecl;
    private ICompositeDefinition fCurrentTracePacketHeaderDef;
    private ICompositeDefinition fCurrentStreamEventHeaderDef;
    private ICompositeDefinition fCurrentStreamPacketContextDef;
    private StreamInputPacketIndexEntry fCurrentPacket = null;
    private long fLastTimestamp = 0L;
    private int fCurrentCpu = 0;
    private int fLostEventsInThisPacket;
    private long fLostEventsDuration;
    private boolean fHasLost = false;

    public CTFStreamInputPacketReader(CTFStreamInputReader streamInputReader) {
        this.fStreamInputReader = streamInputReader;
        ByteBuffer allocateDirect = ByteBuffer.allocateDirect(0);
        if (allocateDirect == null) {
            throw new IllegalStateException("Unable to allocate 0 bytes!");
        }
        this.fBitBuffer = new BitBuffer(allocateDirect);
        CTFStream currentStream = streamInputReader.getStreamInput().getStream();
        this.fTracePacketHeaderDecl = currentStream.getTrace().getPacketHeader();
        this.fStreamPacketContextDecl = currentStream.getPacketContextDecl();
        this.fStreamEventHeaderDecl = currentStream.getEventHeaderDeclaration();
        this.fStreamEventContextDecl = currentStream.getEventContextDecl();
    }

    public StructDefinition getEventContextDefinition(@NonNull BitBuffer input) throws CTFReaderException {
        return this.fStreamEventContextDecl.createDefinition((IDefinitionScope)this.fStreamInputReader.getStreamInput(), LexicalScope.STREAM_EVENT_CONTEXT, input);
    }

    @Deprecated
    public StructDefinition getStreamEventHeaderDefinition(@NonNull BitBuffer input) throws CTFReaderException {
        if (!(this.fStreamEventHeaderDecl instanceof StructDeclaration)) {
            throw new IllegalStateException("Definition is not a struct definition, this is a deprecated method that doesn't work so well, stop using it.");
        }
        return ((StructDeclaration)this.fStreamEventHeaderDecl).createDefinition((IDefinitionScope)this, LexicalScope.STREAM_EVENT_HEADER, input);
    }

    public StructDefinition getStreamPacketContextDefinition(@NonNull BitBuffer input) throws CTFReaderException {
        return this.fStreamPacketContextDecl.createDefinition((IDefinitionScope)this.fStreamInputReader.getStreamInput(), LexicalScope.STREAM_PACKET_CONTEXT, input);
    }

    public StructDefinition getTracePacketHeaderDefinition(@NonNull BitBuffer input) throws CTFReaderException {
        return this.fTracePacketHeaderDecl.createDefinition((IDefinitionScope)this.fStreamInputReader.getStreamInput().getStream().getTrace(), LexicalScope.TRACE_PACKET_HEADER, input);
    }

    @Override
    public void close() {
        this.fBitBuffer = null;
    }

    StreamInputPacketIndexEntry getCurrentPacket() {
        return this.fCurrentPacket;
    }

    public int getCPU() {
        return this.fCurrentCpu;
    }

    @Override
    public LexicalScope getScopePath() {
        return LexicalScope.PACKET;
    }

    @NonNull
    private ByteBuffer getByteBufferAt(long position, long size) throws CTFReaderException, IOException {
        ByteBuffer map = SafeMappedByteBuffer.map(this.fStreamInputReader.getFc(), FileChannel.MapMode.READ_ONLY, position, size);
        if (map == null) {
            throw new CTFReaderException("Failed to allocate mapped byte buffer");
        }
        return map;
    }

    void setCurrentPacket(StreamInputPacketIndexEntry currentPacket) throws CTFReaderException {
        StreamInputPacketIndexEntry prevPacket = null;
        this.fCurrentPacket = currentPacket;
        if (this.fCurrentPacket != null) {
            BitBuffer bitBuffer;
            ByteBuffer bb = null;
            try {
                bb = this.getByteBufferAt(this.fCurrentPacket.getOffsetBytes(), (this.fCurrentPacket.getPacketSizeBits() + 7L) / 8L);
            }
            catch (IOException e) {
                throw new CTFReaderException(e.getMessage(), e);
            }
            this.fBitBuffer = bitBuffer = new BitBuffer(bb);
            if (this.fTracePacketHeaderDecl != null) {
                this.fCurrentTracePacketHeaderDef = this.getTracePacketHeaderDefinition(bitBuffer);
            }
            if (this.fStreamPacketContextDecl != null) {
                this.fCurrentStreamPacketContextDef = this.getStreamPacketContextDefinition(bitBuffer);
                if (this.getCurrentPacket().getTarget() != null) {
                    this.fCurrentCpu = (int)this.getCurrentPacket().getTargetId();
                }
                this.fLostEventsInThisPacket = (int)this.getCurrentPacket().getLostEvents();
                if (this.fLostEventsInThisPacket != 0) {
                    long lostEventsStartTime;
                    this.fHasLost = true;
                    int index = this.fStreamInputReader.getStreamInput().getIndex().getEntries().indexOf(currentPacket);
                    if (index == 0) {
                        lostEventsStartTime = currentPacket.getTimestampBegin() + 1L;
                    } else {
                        prevPacket = this.fStreamInputReader.getStreamInput().getIndex().getEntries().get(index - 1);
                        lostEventsStartTime = prevPacket.getTimestampEnd();
                    }
                    this.fLostEventsDuration = Math.abs(lostEventsStartTime - currentPacket.getTimestampBegin());
                }
            }
            this.fLastTimestamp = currentPacket.getTimestampBegin();
        } else {
            this.fBitBuffer = null;
            this.fLastTimestamp = 0L;
        }
    }

    public boolean hasMoreEvents() {
        BitBuffer bitBuffer = this.fBitBuffer;
        StreamInputPacketIndexEntry currentPacket = this.fCurrentPacket;
        if (currentPacket != null && bitBuffer != null) {
            return this.fHasLost || bitBuffer.position() < currentPacket.getContentSizeBits();
        }
        return false;
    }

    public EventDefinition readNextEvent() throws CTFReaderException {
        IEventDeclaration eventDeclaration;
        int eventID = -2;
        long timestamp = 0L;
        if (this.fHasLost) {
            this.fHasLost = false;
            EventDeclaration lostEventDeclaration = EventDeclaration.getLostEventDeclaration();
            StructDeclaration lostFields = lostEventDeclaration.getFields();
            IntegerDeclaration lostFieldsDecl = (IntegerDeclaration)lostFields.getField("Lost events");
            if (lostFieldsDecl == null) {
                throw new IllegalStateException("Lost events count not declared!");
            }
            IntegerDeclaration lostEventsDurationDecl = (IntegerDeclaration)lostFields.getField("duration");
            if (lostEventsDurationDecl == null) {
                throw new IllegalStateException("Lost events duration not declared!");
            }
            IntegerDefinition lostDurationDef = new IntegerDefinition(lostFieldsDecl, null, "duration", this.fLostEventsDuration);
            IntegerDefinition lostCountDef = new IntegerDefinition(lostEventsDurationDecl, null, "Lost events", this.fLostEventsInThisPacket);
            Definition[] fields = new IntegerDefinition[]{lostCountDef, lostDurationDef};
            ImmutableList fieldNameList = ImmutableList.builder().add((Object)"Lost events").add((Object)"duration").build();
            return new EventDefinition(lostEventDeclaration, this.fStreamInputReader, this.fLastTimestamp, null, null, null, new StructDefinition(lostFields, (IDefinitionScope)this, "fields", (List<String>)fieldNameList, fields));
        }
        BitBuffer currentBitBuffer = this.fBitBuffer;
        if (currentBitBuffer == null) {
            return null;
        }
        long posStart = currentBitBuffer.position();
        if (this.fStreamEventHeaderDecl != null) {
            if (this.fStreamEventHeaderDecl instanceof IEventHeaderDeclaration) {
                this.fCurrentStreamEventHeaderDef = (ICompositeDefinition)((Object)this.fStreamEventHeaderDecl.createDefinition(null, "", currentBitBuffer));
                EventHeaderDefinition ehd = (EventHeaderDefinition)this.fCurrentStreamEventHeaderDef;
                eventID = ehd.getId();
                timestamp = this.calculateTimestamp(ehd.getTimestamp(), ehd.getTimestampLength());
            } else {
                this.fCurrentStreamEventHeaderDef = ((StructDeclaration)this.fStreamEventHeaderDecl).createDefinition(null, LexicalScope.EVENT_HEADER, currentBitBuffer);
                StructDefinition StructEventHeaderDef = (StructDefinition)this.fCurrentStreamEventHeaderDef;
                Definition idDef = StructEventHeaderDef.lookupDefinition("id");
                SimpleDatatypeDefinition simpleIdDef = null;
                if (idDef instanceof SimpleDatatypeDefinition) {
                    simpleIdDef = (SimpleDatatypeDefinition)idDef;
                } else if (idDef != null) {
                    throw new CTFReaderException("Id defintion not an integer, enum or float definiton in event header.");
                }
                IntegerDefinition timestampDef = StructEventHeaderDef.lookupInteger("timestamp");
                Definition variantDef = StructEventHeaderDef.lookupDefinition("v");
                if (variantDef instanceof VariantDefinition) {
                    StructDefinition variantCurrentField = (StructDefinition)((VariantDefinition)variantDef).getCurrentField();
                    Definition vIdDef = variantCurrentField.lookupDefinition("id");
                    if (vIdDef instanceof IntegerDefinition) {
                        simpleIdDef = (SimpleDatatypeDefinition)vIdDef;
                    }
                    timestampDef = variantCurrentField.lookupInteger("timestamp");
                }
                if (simpleIdDef != null) {
                    eventID = simpleIdDef.getIntegerValue().intValue();
                }
                if (timestampDef != null) {
                    timestamp = this.calculateTimestamp(timestampDef);
                }
            }
        }
        if ((eventDeclaration = this.fStreamInputReader.getStreamInput().getStream().getEventDeclaration(eventID)) == null) {
            throw new CTFReaderException("Incorrect event id : " + eventID);
        }
        EventDefinition eventDef = eventDeclaration.createDefinition(this.fStreamInputReader, currentBitBuffer, timestamp);
        if (posStart == currentBitBuffer.position()) {
            throw new CTFReaderException("Empty event not allowed, event: " + eventDef.getDeclaration().getName());
        }
        return eventDef;
    }

    private long calculateTimestamp(IntegerDefinition timestampDef) {
        int len = timestampDef.getDeclaration().getLength();
        long value = timestampDef.getValue();
        return this.calculateTimestamp(value, len);
    }

    private long calculateTimestamp(long value, int len) {
        if (len == 64) {
            this.fLastTimestamp = value;
            return this.fLastTimestamp;
        }
        long newval = value;
        long majorasbitmask = (1L << len) - 1L;
        if (newval < (this.fLastTimestamp & majorasbitmask)) {
            newval += 1L << len;
        }
        this.fLastTimestamp &= majorasbitmask ^ 0xFFFFFFFFFFFFFFFFL;
        this.fLastTimestamp += newval;
        return this.fLastTimestamp;
    }

    @Override
    public Definition lookupDefinition(String lookupPath) {
        if (lookupPath.equals(LexicalScope.STREAM_PACKET_CONTEXT.toString())) {
            return (Definition)((Object)this.fCurrentStreamPacketContextDef);
        }
        if (lookupPath.equals(LexicalScope.TRACE_PACKET_HEADER.toString())) {
            return (Definition)((Object)this.fCurrentTracePacketHeaderDef);
        }
        return null;
    }

    @Deprecated
    public StructDefinition getCurrentStreamEventHeader() {
        return (StructDefinition)(this.fCurrentStreamEventHeaderDef instanceof StructDefinition ? this.fCurrentStreamEventHeaderDef : null);
    }

    public ICompositeDefinition getStreamEventHeaderDefinition() {
        return this.fCurrentStreamEventHeaderDef;
    }

    public StructDefinition getCurrentPacketEventHeader() {
        if (this.fCurrentTracePacketHeaderDef instanceof StructDefinition) {
            return (StructDefinition)this.fCurrentTracePacketHeaderDef;
        }
        return null;
    }
}

