/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ctf.core.event.metadata;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.linuxtools.ctf.core.event.types.EnumDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.VariantDeclaration;
import org.eclipse.linuxtools.internal.ctf.core.event.metadata.exceptions.ParseException;

class DeclarationScope {
    private DeclarationScope fParentScope = null;
    private final Map<String, StructDeclaration> fStructs = new HashMap<String, StructDeclaration>();
    private final Map<String, EnumDeclaration> fEnums = new HashMap<String, EnumDeclaration>();
    private final Map<String, VariantDeclaration> fVariants = new HashMap<String, VariantDeclaration>();
    private final Map<String, IDeclaration> fTypes = new HashMap<String, IDeclaration>();
    private final Map<String, IDeclaration> fIdentifiers = new HashMap<String, IDeclaration>();

    public DeclarationScope() {
    }

    public DeclarationScope(DeclarationScope parentScope) {
        this.fParentScope = parentScope;
    }

    public DeclarationScope getParentScope() {
        return this.fParentScope;
    }

    public void registerType(String name, IDeclaration declaration) throws ParseException {
        if (this.fTypes.containsKey(name)) {
            throw new ParseException("Type has already been defined:" + name);
        }
        this.fTypes.put(name, declaration);
    }

    public void registerIdentifier(String name, IDeclaration declaration) throws ParseException {
        if (this.fIdentifiers.containsKey(name)) {
            throw new ParseException("Identifier has already been defined:" + name);
        }
        this.fIdentifiers.put(name, declaration);
    }

    public void registerStruct(String name, StructDeclaration declaration) throws ParseException {
        if (this.fStructs.containsKey(name)) {
            throw new ParseException("Struct has already been defined:" + name);
        }
        this.fStructs.put(name, declaration);
        String structPrefix = "struct ";
        this.registerType(String.valueOf(structPrefix) + name, declaration);
    }

    public void registerEnum(String name, EnumDeclaration declaration) throws ParseException {
        if (this.lookupEnum(name) != null) {
            throw new ParseException("Enum has already been defined:" + name);
        }
        this.fEnums.put(name, declaration);
        String enumPrefix = "enum ";
        this.registerType(String.valueOf(enumPrefix) + name, declaration);
    }

    public void registerVariant(String name, VariantDeclaration declaration) throws ParseException {
        if (this.lookupVariant(name) != null) {
            throw new ParseException("Variant has already been defined:" + name);
        }
        this.fVariants.put(name, declaration);
        String variantPrefix = "variant ";
        this.registerType(String.valueOf(variantPrefix) + name, declaration);
    }

    public IDeclaration lookupType(String name) {
        return this.fTypes.get(name);
    }

    public IDeclaration lookupTypeRecursive(String name) {
        IDeclaration declaration = this.lookupType(name);
        if (declaration != null) {
            return declaration;
        }
        if (this.fParentScope != null) {
            return this.fParentScope.lookupTypeRecursive(name);
        }
        return null;
    }

    public StructDeclaration lookupStruct(String name) {
        return this.fStructs.get(name);
    }

    public StructDeclaration lookupStructRecursive(String name) {
        StructDeclaration declaration = this.lookupStruct(name);
        if (declaration != null) {
            return declaration;
        }
        if (this.fParentScope != null) {
            return this.fParentScope.lookupStructRecursive(name);
        }
        return null;
    }

    public EnumDeclaration lookupEnum(String name) {
        return this.fEnums.get(name);
    }

    public EnumDeclaration lookupEnumRecursive(String name) {
        EnumDeclaration declaration = this.lookupEnum(name);
        if (declaration != null) {
            return declaration;
        }
        if (this.fParentScope != null) {
            return this.fParentScope.lookupEnumRecursive(name);
        }
        return null;
    }

    public VariantDeclaration lookupVariant(String name) {
        return this.fVariants.get(name);
    }

    public VariantDeclaration lookupVariantRecursive(String name) {
        VariantDeclaration declaration = this.lookupVariant(name);
        if (declaration != null) {
            return declaration;
        }
        if (this.fParentScope != null) {
            return this.fParentScope.lookupVariantRecursive(name);
        }
        return null;
    }

    public IDeclaration lookupIdentifier(String identifier) {
        return this.fIdentifiers.get(identifier);
    }

    public IDeclaration lookupIdentifierRecursive(String identifier) {
        IDeclaration declaration = this.lookupIdentifier(identifier);
        if (declaration != null) {
            return declaration;
        }
        if (this.fParentScope != null) {
            return this.fParentScope.lookupIdentifierRecursive(identifier);
        }
        return null;
    }

    public Set<String> getTypeNames() {
        return this.fTypes.keySet();
    }

    public void replaceType(String name, IDeclaration newType) throws ParseException {
        if (!this.fTypes.containsKey(name)) {
            throw new ParseException("Trace does not contain type:" + name);
        }
        this.fTypes.put(name, newType);
    }
}

