/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ctf.core.event.types;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.AbstractArrayDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.CompoundDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.internal.ctf.core.event.types.ArrayDefinition;
import org.eclipse.linuxtools.internal.ctf.core.event.types.ByteArrayDefinition;

public class SequenceDeclaration
extends CompoundDeclaration {
    private final IDeclaration fElemType;
    private final String fLengthName;
    private final Multimap<String, String> fPaths = ArrayListMultimap.create();

    public SequenceDeclaration(String lengthName, IDeclaration elemType) {
        this.fElemType = elemType;
        this.fLengthName = lengthName;
    }

    @Override
    public IDeclaration getElementType() {
        return this.fElemType;
    }

    public String getLengthName() {
        return this.fLengthName;
    }

    @Override
    public AbstractArrayDefinition createDefinition(IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFReaderException {
        Definition lenDef = null;
        if (definitionScope != null) {
            lenDef = definitionScope.lookupDefinition(this.getLengthName());
        }
        if (lenDef == null) {
            throw new CTFReaderException("Sequence length field not found");
        }
        if (!(lenDef instanceof IntegerDefinition)) {
            throw new CTFReaderException("Sequence length field not integer");
        }
        IntegerDefinition lengthDefinition = (IntegerDefinition)lenDef;
        if (lengthDefinition.getDeclaration().isSigned()) {
            throw new CTFReaderException("Sequence length must not be signed");
        }
        long length = lengthDefinition.getValue();
        if (length > Integer.MAX_VALUE || !input.canRead((int)length * this.fElemType.getMaximumSize())) {
            throw new CTFReaderException("Sequence length too long " + length);
        }
        if (this.isString()) {
            byte[] data = new byte[(int)length];
            input.get(data);
            return new ByteArrayDefinition(this, definitionScope, fieldName, data);
        }
        Collection collection = this.fPaths.get((Object)fieldName);
        while ((long)collection.size() < length) {
            this.fPaths.put((Object)fieldName, (Object)(String.valueOf(fieldName) + '[' + collection.size() + ']'));
        }
        List paths = (List)this.fPaths.get((Object)fieldName);
        ImmutableList.Builder definitions = new ImmutableList.Builder();
        int i = 0;
        while ((long)i < length) {
            String elemName = (String)paths.get(i);
            definitions.add((Object)this.fElemType.createDefinition(definitionScope, elemName, input));
            ++i;
        }
        ImmutableList build = definitions.build();
        return new ArrayDefinition(this, definitionScope, fieldName, (List<Definition>)build);
    }

    public String toString() {
        return "[declaration] sequence[" + Integer.toHexString(this.hashCode()) + ']';
    }

    @Override
    public int getMaximumSize() {
        return Integer.MAX_VALUE;
    }
}

