/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ctf.core.event.types.composite;

import java.nio.ByteOrder;
import org.eclipse.linuxtools.ctf.core.event.io.BitBuffer;
import org.eclipse.linuxtools.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.linuxtools.ctf.core.event.types.Declaration;
import org.eclipse.linuxtools.ctf.core.event.types.EnumDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IEventHeaderDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.StructDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.VariantDeclaration;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.internal.ctf.core.event.types.composite.EventHeaderDefinition;

public class EventHeaderCompactDeclaration
extends Declaration
implements IEventHeaderDeclaration {
    private static final int COMPACT_SIZE = 1;
    private static final int VARIANT_SIZE = 2;
    private static final int EXTENDED_FIELD_SIZE = 2;
    private static final int COMPACT_ID = 5;
    private static final int COMPACT_ALIGN = 1;
    private static final int EXTENDED_VALUE = 31;
    private static final int ID_SIZE = 32;
    private static final int FULL_TS = 64;
    private static final int COMPACT_TS = 27;
    private static final int COMPACT_TS_ALIGN = 1;
    private static final int MAX_SIZE = 104;
    private static final int ALIGN = 8;
    private static final String V = "v";
    private final ByteOrder fByteOrder;

    public EventHeaderCompactDeclaration(ByteOrder byteOrder) {
        this.fByteOrder = byteOrder;
    }

    @Override
    public EventHeaderDefinition createDefinition(IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFReaderException {
        this.alignRead(input);
        ByteOrder bo = input.getByteOrder();
        input.setByteOrder(this.fByteOrder);
        int enumId = (int)input.get(5, false);
        if (enumId != 31) {
            long timestamp2 = input.get(27, false);
            input.setByteOrder(bo);
            return new EventHeaderDefinition(this, enumId, timestamp2, 27);
        }
        input.position(input.position() + 3L);
        long id = input.get(32, false);
        if (id > Integer.MAX_VALUE) {
            throw new CTFReaderException("ID " + id + " larger than " + Integer.MAX_VALUE + " is currently unsupported by the parser");
        }
        long timestampLong = input.get(64, false);
        input.setByteOrder(bo);
        return new EventHeaderDefinition(this, (int)id, timestampLong, 64);
    }

    @Override
    public long getAlignment() {
        return 8L;
    }

    @Override
    public int getMaximumSize() {
        return 104;
    }

    public static boolean isCompactEventHeader(StructDeclaration declaration) {
        IDeclaration iDeclaration = declaration.getFields().get("id");
        if (!(iDeclaration instanceof EnumDeclaration)) {
            return false;
        }
        EnumDeclaration eId = (EnumDeclaration)iDeclaration;
        IntegerDeclaration containerType = eId.getContainerType();
        if (containerType.getLength() != 5) {
            return false;
        }
        if (containerType.getAlignment() != 1L) {
            return false;
        }
        iDeclaration = declaration.getFields().get(V);
        if (!(iDeclaration instanceof VariantDeclaration)) {
            return false;
        }
        VariantDeclaration vDec = (VariantDeclaration)iDeclaration;
        if (!vDec.hasField("compact") || !vDec.hasField("extended")) {
            return false;
        }
        if (vDec.getFields().size() != 2) {
            return false;
        }
        iDeclaration = vDec.getFields().get("compact");
        if (!(iDeclaration instanceof StructDeclaration)) {
            return false;
        }
        StructDeclaration compactDec = (StructDeclaration)iDeclaration;
        if (compactDec.getFields().size() != 1) {
            return false;
        }
        if (!compactDec.hasField("timestamp")) {
            return false;
        }
        iDeclaration = compactDec.getFields().get("timestamp");
        if (!(iDeclaration instanceof IntegerDeclaration)) {
            return false;
        }
        IntegerDeclaration tsDec = (IntegerDeclaration)iDeclaration;
        if (tsDec.getLength() != 27 || tsDec.isSigned() || tsDec.getAlignment() != 1L) {
            return false;
        }
        iDeclaration = vDec.getFields().get("extended");
        if (!(iDeclaration instanceof StructDeclaration)) {
            return false;
        }
        StructDeclaration extendedDec = (StructDeclaration)iDeclaration;
        if (extendedDec.getAlignment() != 8L) {
            return false;
        }
        if (!extendedDec.hasField("timestamp")) {
            return false;
        }
        if (extendedDec.getFields().size() != 2) {
            return false;
        }
        iDeclaration = extendedDec.getFields().get("timestamp");
        if (!(iDeclaration instanceof IntegerDeclaration)) {
            return false;
        }
        tsDec = (IntegerDeclaration)iDeclaration;
        if (tsDec.getLength() != 64 || tsDec.isSigned()) {
            return false;
        }
        iDeclaration = extendedDec.getFields().get("id");
        if (!(iDeclaration instanceof IntegerDeclaration)) {
            return false;
        }
        IntegerDeclaration iId = (IntegerDeclaration)iDeclaration;
        return iId.getLength() == 32 && !iId.isSigned();
    }
}

