/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.ui.providers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import org.eclipse.ptp.internal.rm.lml.core.model.LMLCheck;
import org.eclipse.ptp.internal.rm.lml.core.model.Node;
import org.eclipse.ptp.internal.rm.lml.core.model.TreeExpansion;
import org.eclipse.ptp.rm.lml.core.LMLManager;
import org.eclipse.ptp.rm.lml.core.elements.Nodedisplay;
import org.eclipse.ptp.rm.lml.core.elements.Nodedisplayelement;
import org.eclipse.ptp.rm.lml.core.elements.NodedisplaylayoutType;
import org.eclipse.ptp.rm.lml.core.events.ILguiAddedEvent;
import org.eclipse.ptp.rm.lml.core.events.ILguiRemovedEvent;
import org.eclipse.ptp.rm.lml.core.events.IMarkObjectEvent;
import org.eclipse.ptp.rm.lml.core.events.INodedisplayZoomEvent;
import org.eclipse.ptp.rm.lml.core.events.ISelectObjectEvent;
import org.eclipse.ptp.rm.lml.core.events.ITableFilterEvent;
import org.eclipse.ptp.rm.lml.core.events.ITableSortedEvent;
import org.eclipse.ptp.rm.lml.core.events.IUnmarkObjectEvent;
import org.eclipse.ptp.rm.lml.core.events.IUnselectedObjectEvent;
import org.eclipse.ptp.rm.lml.core.events.IViewUpdateEvent;
import org.eclipse.ptp.rm.lml.core.listeners.ILMLListener;
import org.eclipse.ptp.rm.lml.core.listeners.INodedisplayZoomListener;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.core.model.LMLNodeData;
import org.eclipse.ptp.rm.lml.core.model.NodedisplayAccess;
import org.eclipse.ptp.rm.lml.ui.providers.AbstractNodedisplayView;
import org.eclipse.ptp.rm.lml.ui.providers.IMinSizeNodedisplay;
import org.eclipse.ptp.rm.lml.ui.providers.NodedisplayComp;
import org.eclipse.ptp.rm.lml.ui.providers.NodedisplayCompMinSize;
import org.eclipse.ptp.rm.lml.ui.providers.support.ColorConversion;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class NodedisplayView
extends AbstractNodedisplayView {
    private Node<LMLNodeData> shownNode;
    private final int adjustCount = 10;
    private final int maximumSize = 65535;
    private Nodedisplay nodedisplay;
    private NodedisplaylayoutType nodedisplayLayout;
    private final ScrolledComposite scrollComp;
    private NodedisplayComp root = null;
    private Stack<String> zoomStack = new Stack();
    private final Cursor waitCursor;
    private final Cursor defaultCursor;
    private final boolean minSizeRectangles;
    private final FirstPaintListener firstPaintListener;
    private final JobsVisibleListener jobsListener;
    private int minRectangleSize = 7;
    private int shownLevel;

    public NodedisplayView(ILguiItem lguiItem, Nodedisplay nodedisplay, Composite parent) {
        this(lguiItem, nodedisplay, parent, true);
    }

    public NodedisplayView(ILguiItem lguiItem, Nodedisplay nodedisplay, Composite parent, boolean minSizeRectangles) {
        super(lguiItem, parent, 0);
        this.minSizeRectangles = minSizeRectangles;
        this.nodedisplay = nodedisplay;
        this.findNodedisplayLayout();
        this.setLayout((Layout)new FillLayout());
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.scrollComp = new ScrolledComposite((Composite)this, 768);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                NodedisplayView.this.disposeNodedisplay();
                NodedisplayView.this.getDisplay().removeFilter(9, (Listener)NodedisplayView.this.firstPaintListener);
                if (NodedisplayView.this.jobsListener != null) {
                    LMLManager.getInstance().removeListener((ILMLListener)NodedisplayView.this.jobsListener);
                }
                if (NodedisplayView.this.waitCursor != null) {
                    NodedisplayView.this.waitCursor.dispose();
                }
            }
        });
        this.jobsListener = new JobsVisibleListener();
        LMLManager.getInstance().addListener((ILMLListener)this.jobsListener, null);
        this.firstPaintListener = new FirstPaintListener();
        this.getDisplay().addFilter(9, (Listener)this.firstPaintListener);
        if (lguiItem != null && nodedisplay != null) {
            this.root = this.createRootNodedisplay();
            this.initNewNodedisplay();
        }
        this.defaultCursor = this.getCursor();
        this.waitCursor = new Cursor((Device)this.getDisplay(), 1);
        this.addResizeListenerForScrollPane();
        this.checkEmptyScreen();
    }

    public void disposeNodedisplay() {
        ColorConversion.disposeColors();
        if (this.root != null) {
            this.root.dispose();
            this.root = null;
        }
    }

    @Override
    public int getMaximumNodedisplayDepth() {
        if (this.nodedisplay == null) {
            return 0;
        }
        if (this.nodedisplay.getScheme() == null) {
            return 0;
        }
        return LMLCheck.getDeepestSchemeLevel((Object)this.nodedisplay.getScheme());
    }

    @Override
    public int getMinimalRectangleSize() {
        if (this.minSizeRectangles) {
            if (this.root != null) {
                return this.minRectangleSize;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public int getMinimumLevelOfDetail() {
        if (this.shownNode != null && this.shownNode.getData() != null) {
            return ((LMLNodeData)this.shownNode.getData()).getLevelIds().size();
        }
        return 0;
    }

    @Override
    public NodedisplayComp getRootNodedisplay() {
        return this.root;
    }

    public ScrolledComposite getScrollComp() {
        return this.scrollComp;
    }

    @Override
    public int getShownMaxLevel() {
        return this.shownLevel;
    }

    @Override
    public boolean goToImpName(String impName) {
        return this.goToImpName(impName, false);
    }

    public boolean goToImpName(String impName, boolean modelChanged) {
        if (this.lguiItem == null) {
            return false;
        }
        String shownImpName = null;
        if (this.root != null) {
            shownImpName = this.root.getShownImpName();
        }
        if (!modelChanged && (shownImpName == null ? impName == null : shownImpName.equals(impName))) {
            return false;
        }
        NodedisplayComp newNodedisplayComp = null;
        if (this.root != null) {
            this.root.dispose();
            this.root = null;
        }
        newNodedisplayComp = impName != null ? this.createNodedisplayFromImpName(impName) : this.createRootNodedisplay();
        this.root = newNodedisplayComp;
        this.initNewNodedisplay();
        this.layout();
        this.root.layout();
        return true;
    }

    @Override
    public void restartZoom() {
        this.zoomStack = new Stack();
    }

    @Override
    public void setFixedLevel(int level) {
        if (this.nodedisplay != null && this.nodedisplay.getScheme() != null && LMLCheck.getDeepestSchemeLevel((Object)this.nodedisplay.getScheme()) < level) {
            level = LMLCheck.getDeepestSchemeLevel((Object)this.nodedisplay.getScheme());
        }
        super.setFixedLevel(level);
    }

    @Override
    public void setMaxLevel(int maxLevel) {
        int minlevel = this.getMinimumLevelOfDetail();
        if (maxLevel < minlevel) {
            maxLevel = minlevel;
        }
        if (this.nodedisplay != null && this.nodedisplay.getScheme() != null && LMLCheck.getDeepestSchemeLevel((Object)this.nodedisplay.getScheme()) < maxLevel) {
            maxLevel = LMLCheck.getDeepestSchemeLevel((Object)this.nodedisplay.getScheme());
        }
        int nodeLevel = ((LMLNodeData)this.shownNode.getData()).getLevelIds().size();
        this.lguiItem.getLayoutAccess().setMaxLevelOnLevel(this.nodedisplayLayout, nodeLevel, maxLevel);
    }

    public void setMaxLevelInLayout(int level) {
    }

    @Override
    public void setMinimalRectangleSize(int size) {
        if (this.minSizeRectangles) {
            this.minRectangleSize = size;
            if (this.root != null) {
                ((IMinSizeNodedisplay)((Object)this.root)).setMinimumRectangleHeight(this.minRectangleSize);
                ((IMinSizeNodedisplay)((Object)this.root)).setMinimumRectangleWidth(this.minRectangleSize);
                Point newMinSize = ((IMinSizeNodedisplay)((Object)this.root)).getMinimalSize();
                while (this.minRectangleSize > 1 && (newMinSize.x > 65535 || newMinSize.y > 65535)) {
                    --this.minRectangleSize;
                    ((IMinSizeNodedisplay)((Object)this.root)).setMinimumRectangleHeight(this.minRectangleSize);
                    ((IMinSizeNodedisplay)((Object)this.root)).setMinimumRectangleWidth(this.minRectangleSize);
                    newMinSize = ((IMinSizeNodedisplay)((Object)this.root)).getMinimalSize();
                }
            }
            super.setMinimalRectangleSize(this.minRectangleSize);
            this.adjustScrollPaneSize();
        }
    }

    @Override
    public void update() {
        this.update(this.getLguiItem(), this.getNewModel());
    }

    @Override
    public void update(ILguiItem lguiItem) {
        this.setLguiItem(lguiItem);
        this.update(lguiItem, this.getNewModel());
    }

    @Override
    public void update(ILguiItem lguiItem, Nodedisplay nodedisplay) {
        super.update();
        String lastShown = null;
        if (this.root != null) {
            lastShown = this.root.getShownImpName();
        }
        ILguiItem oldLguiItem = this.lguiItem;
        Nodedisplay oldNodedisplay = this.nodedisplay;
        this.setLguiItem(lguiItem);
        this.nodedisplay = nodedisplay;
        if (this.isNodedisplayChanged(oldLguiItem, oldNodedisplay, lguiItem, nodedisplay)) {
            this.restartZoom();
            lastShown = null;
        }
        this.findNodedisplayLayout();
        if (nodedisplay != null) {
            this.goToImpName(lastShown, true);
        }
        this.checkEmptyScreen();
    }

    @Override
    public void zoomIn(String impName) {
        if (this.root == null) {
            return;
        }
        this.setCursor(this.waitCursor);
        String oldShown = this.root.getShownImpName();
        if (this.goToImpName(impName)) {
            if (oldShown == null) {
                oldShown = "";
            }
            this.zoomStack.push(oldShown);
        }
        this.notifyZoom(impName, true);
        this.setCursor(this.defaultCursor);
    }

    @Override
    public void zoomOut() {
        this.setCursor(this.waitCursor);
        if (!this.zoomStack.isEmpty()) {
            String impName = this.zoomStack.pop();
            if (impName.equals("")) {
                impName = null;
            }
            this.goToImpName(impName);
            this.notifyZoom(impName, false);
        } else {
            this.goToImpName(null);
            this.notifyZoom(null, true);
        }
        this.setCursor(this.defaultCursor);
    }

    private void addResizeListenerForScrollPane() {
        this.scrollComp.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                NodedisplayView.this.adjustScrollBarIncrements();
                NodedisplayView.this.firstPaintListener.reset();
            }
        });
    }

    private void adjustScrollBarIncrements() {
        ScrollBar xBar = this.scrollComp.getHorizontalBar();
        ScrollBar yBar = this.scrollComp.getVerticalBar();
        if (xBar != null) {
            xBar.setPageIncrement(xBar.getThumb() / 2);
            xBar.setIncrement(xBar.getThumb() / 5);
        }
        if (yBar != null) {
            yBar.setPageIncrement(yBar.getThumb() / 2);
            yBar.setIncrement(yBar.getThumb() / 5);
        }
    }

    private void adjustScrollPaneSize() {
        if (this.root != null && this.root instanceof IMinSizeNodedisplay) {
            IMinSizeNodedisplay minSizeNodedisplay = (IMinSizeNodedisplay)((Object)this.root);
            Point minSize = minSizeNodedisplay.getMinimalSize();
            this.scrollComp.setMinSize(minSize);
            this.adjustScrollBarIncrements();
        }
    }

    private void checkEmptyScreen() {
        if (this.lguiItem != null && this.nodedisplay != null) {
            this.scrollComp.setVisible(true);
        } else {
            this.scrollComp.setVisible(false);
        }
    }

    private NodedisplayComp createNodedisplayFromImpName(String impName) {
        int deepest;
        LMLNodeData nodeData = null;
        try {
            nodeData = new LMLNodeData(impName, this.nodedisplay);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            nodeData = new LMLNodeData("", this.nodedisplay);
        }
        Node newNode = new Node((Object)nodeData);
        Nodedisplayelement layout = this.findLayout(nodeData);
        int maxLevel = 10;
        if (layout.getMaxlevel() != null) {
            maxLevel = layout.getMaxlevel().intValue();
        }
        if (this.getFixedLevel() > 0) {
            maxLevel = this.getFixedLevel();
        }
        if (this.nodedisplay != null && this.nodedisplay.getScheme() != null && (deepest = LMLCheck.getDeepestSchemeLevel((Object)this.nodedisplay.getScheme())) < maxLevel) {
            maxLevel = deepest;
        }
        TreeExpansion.expandLMLNode((Node)newNode, (int)maxLevel);
        TreeExpansion.generateUsagebarsForAllLeaves((Node)newNode);
        this.shownLevel = maxLevel;
        this.shownNode = newNode;
        return this.createChildNodedisplay((Node<LMLNodeData>)newNode, layout);
    }

    private Nodedisplayelement findLayout(LMLNodeData nodeData) {
        Nodedisplayelement result = null;
        if (this.nodedisplayLayout == null) {
            return NodedisplayAccess.getDefaultLayout();
        }
        if (nodeData == null || nodeData.isRootNode()) {
            if (this.nodedisplayLayout.getEl0() != null) {
                return this.nodedisplayLayout.getEl0();
            }
            return NodedisplayAccess.getDefaultLayout();
        }
        if (this.nodedisplayLayout.getEl0() == null) {
            return NodedisplayAccess.getDefaultLayout();
        }
        ArrayList levelNumbers = LMLCheck.copyArrayList((ArrayList)nodeData.getLevelIds());
        result = LMLCheck.getNodedisplayElementByLevels((ArrayList)levelNumbers, (Nodedisplayelement)this.nodedisplayLayout.getEl0());
        if (result == null) {
            return NodedisplayAccess.getDefaultLayout();
        }
        return result;
    }

    private void findNodedisplayLayout() {
        if (this.nodedisplay != null && this.lguiItem != null) {
            this.nodedisplayLayout = this.lguiItem.getLayoutAccess().getLayoutForNodedisplay(this.nodedisplay.getId());
        }
    }

    private Nodedisplay getNewModel() {
        List nodedisplays;
        if (this.lguiItem == null) {
            return null;
        }
        String nodedisplayId = "";
        if (this.nodedisplay != null) {
            nodedisplayId = this.nodedisplay.getId();
        }
        Nodedisplay result = null;
        if (this.lguiItem.getNodedisplayAccess() != null && (result = this.lguiItem.getNodedisplayAccess().getNodedisplayById(nodedisplayId)) == null && (nodedisplays = this.lguiItem.getNodedisplayAccess().getNodedisplays()).size() > 0) {
            result = (Nodedisplay)nodedisplays.get(0);
        }
        return result;
    }

    private void initNewNodedisplay() {
        this.firstPaintListener.reset();
        this.root.addZoomListener(new ZoomListener());
        this.updateScrollPane();
        this.setMinimalRectangleSize(7);
        this.adjustScrollPaneSize();
    }

    private void updateScrollPane() {
        this.scrollComp.setContent((Control)this.root);
        this.scrollComp.setExpandHorizontal(true);
        this.scrollComp.setExpandVertical(true);
        this.layout(true);
        this.scrollComp.layout(true);
    }

    protected NodedisplayComp createChildNodedisplay(Node<LMLNodeData> newNode, Nodedisplayelement layout) {
        if (this.minSizeRectangles) {
            return new NodedisplayCompMinSize(this.lguiItem, newNode, layout, (Composite)this.scrollComp, 0);
        }
        return new NodedisplayComp(this.lguiItem, newNode, layout, (Composite)this.scrollComp, 0);
    }

    protected NodedisplayComp createRootNodedisplay() {
        this.shownLevel = this.nodedisplayLayout.getEl0().getMaxlevel().intValue();
        return this.createNodedisplayFromImpName("");
    }

    protected boolean isNodedisplayChanged(ILguiItem oldLguiItem, Nodedisplay oldNodedisplay, ILguiItem newLguiItem, Nodedisplay newNodedisplay) {
        if (oldNodedisplay == null || newNodedisplay == null) {
            return true;
        }
        if (oldNodedisplay == newNodedisplay) {
            return false;
        }
        return oldLguiItem != newLguiItem || !oldNodedisplay.getId().equals(newNodedisplay.getId());
    }

    private class FirstPaintListener
    implements Listener {
        private int paintCount = 0;

        public FirstPaintListener() {
            this.reset();
        }

        public void handleEvent(Event event) {
            if (this.paintCount < 10) {
                NodedisplayView.this.adjustScrollPaneSize();
            }
            ++this.paintCount;
        }

        public void reset() {
            this.paintCount = 0;
        }
    }

    private class JobsVisibleListener
    implements ILMLListener {
        private JobsVisibleListener() {
        }

        public void handleEvent(ILguiAddedEvent event) {
        }

        public void handleEvent(ILguiRemovedEvent event) {
        }

        public void handleEvent(IMarkObjectEvent event) {
            if (NodedisplayView.this.root != null) {
                String jobId = event.getOid();
                HashSet<Point> points = new HashSet<Point>();
                NodedisplayView.this.root.detectJobPositions(points, jobId);
                Point scrollSize = NodedisplayView.this.scrollComp.getSize();
                boolean visible = false;
                Point minPoint = null;
                for (Point p : points) {
                    if (p.x >= 0 && p.x < scrollSize.x && p.y >= 0 && p.y < scrollSize.y) {
                        visible = true;
                    }
                    if (minPoint != null && p.x >= minPoint.x && (p.x != minPoint.x || p.y >= minPoint.y)) continue;
                    minPoint = p;
                }
                if (!visible && minPoint != null) {
                    Point origin = NodedisplayView.this.scrollComp.getOrigin();
                    origin.x += minPoint.x - 5;
                    origin.y += minPoint.y - 5;
                    if (origin.x < 0) {
                        origin.x = 0;
                    }
                    if (origin.y < 0) {
                        origin.y = 0;
                    }
                    NodedisplayView.this.scrollComp.setOrigin(origin);
                }
            }
        }

        public void handleEvent(ISelectObjectEvent event) {
        }

        public void handleEvent(ITableFilterEvent event) {
        }

        public void handleEvent(ITableSortedEvent event) {
        }

        public void handleEvent(IUnmarkObjectEvent event) {
        }

        public void handleEvent(IUnselectedObjectEvent event) {
        }

        public void handleEvent(IViewUpdateEvent event) {
        }
    }

    private class ZoomListener
    implements INodedisplayZoomListener {
        private ZoomListener() {
        }

        public void handleEvent(INodedisplayZoomEvent event) {
            switch (event.getZoomType()) {
                case TREEZOOMIN: {
                    NodedisplayView.this.zoomIn(event.getNewNodeName());
                    break;
                }
                case TREEZOOMOUT: {
                    NodedisplayView.this.zoomOut();
                }
            }
        }
    }
}

