/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.ui.providers;

import org.eclipse.ptp.internal.rm.lml.ui.messages.Messages;
import org.eclipse.ptp.rm.lml.core.elements.Nodedisplay;
import org.eclipse.ptp.rm.lml.core.events.INodedisplayZoomEvent;
import org.eclipse.ptp.rm.lml.core.listeners.INodedisplayZoomListener;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.ui.providers.AbstractNodedisplayView;
import org.eclipse.ptp.rm.lml.ui.providers.NodedisplayViewDecorator;
import org.eclipse.ptp.rm.lml.ui.providers.support.BorderLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class NodedisplayViewMaxlevelAdjust
extends NodedisplayViewDecorator {
    private Button plus;
    private Button minus;
    private Composite north;
    private Font font;
    private Label maxLevelLabel;
    private final boolean addButtons;

    public NodedisplayViewMaxlevelAdjust(AbstractNodedisplayView nodedisplay, boolean addButtons, Composite parent) {
        super(nodedisplay, parent);
        this.addButtons = addButtons;
        if (addButtons) {
            this.north = new Composite((Composite)this, 0);
            this.north.setLayoutData((Object)new BorderLayout.BorderData(1));
            RowLayout layout = new RowLayout();
            layout.spacing = 0;
            layout.center = true;
            this.north.setLayout((Layout)layout);
            this.font = new Font((Device)Display.getCurrent(), "Monospaced", 12, 1);
            this.minus = new Button(this.north, 8);
            this.minus.setText(Messages.NodedisplayViewMaxlevelAdjust_1);
            this.minus.setFont(this.font);
            this.minus.pack();
            int min = Math.min(this.minus.getSize().x, this.minus.getSize().y);
            this.maxLevelLabel = new Label(this.north, 0);
            this.maxLevelLabel.setText(String.valueOf(nodedisplay.getShownMaxLevel()));
            this.plus = new Button(this.north, 8);
            this.plus.setText(Messages.NodedisplayViewMaxlevelAdjust_2);
            this.plus.setFont(this.font);
            this.plus.pack();
            int min2 = Math.min(this.plus.getSize().x, this.plus.getSize().y);
            int max = Math.max(min, min2);
            this.plus.setLayoutData((Object)new RowData(max, max));
            this.minus.setLayoutData((Object)new RowData(max, max));
            this.plus.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NodedisplayViewMaxlevelAdjust.this.increaseMaximumLevel();
                }
            });
            this.minus.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NodedisplayViewMaxlevelAdjust.this.decreaseMaximumLevel();
                }
            });
            this.north.layout();
            this.addZoomListener(new INodedisplayZoomListener(){

                public void handleEvent(INodedisplayZoomEvent event) {
                    NodedisplayViewMaxlevelAdjust.this.handleUpdate();
                }
            });
        }
    }

    public void decreaseMaximumLevel() {
        if (this.nodedisplayView.getShownMaxLevel() > this.nodedisplayView.getMinimumLevelOfDetail()) {
            this.nodedisplayView.setMaxLevel(this.nodedisplayView.getShownMaxLevel() - 1);
            this.update();
        }
    }

    public void dispose() {
        if (this.addButtons) {
            this.font.dispose();
        }
    }

    public void increaseMaximumLevel() {
        this.nodedisplayView.setMaxLevel(this.nodedisplayView.getShownMaxLevel() + 1);
        this.update();
    }

    @Override
    public void update() {
        super.update();
        this.handleUpdate();
    }

    @Override
    public void update(ILguiItem lguiItem) {
        super.update(lguiItem);
        this.handleUpdate();
    }

    @Override
    public void update(ILguiItem lguiItem, Nodedisplay nodedislay) {
        super.update(lguiItem, nodedislay);
        this.handleUpdate();
    }

    protected void handleUpdate() {
        if (this.addButtons) {
            this.maxLevelLabel.setText(String.valueOf(this.nodedisplayView.getShownMaxLevel()));
            this.north.layout();
        }
    }
}

