/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ctf.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.ctf.core.event.types.CompoundDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.Definition;
import org.eclipse.linuxtools.ctf.core.event.types.EnumDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.FloatDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.ICompositeDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.IDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.linuxtools.ctf.core.event.types.IntegerDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.StringDefinition;
import org.eclipse.linuxtools.ctf.core.event.types.VariantDefinition;
import org.eclipse.linuxtools.internal.ctf.core.event.types.ArrayDefinition;
import org.eclipse.linuxtools.internal.ctf.core.event.types.ByteArrayDefinition;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.TmfEventField;
import org.eclipse.linuxtools.tmf.ctf.core.CTFArrayField;
import org.eclipse.linuxtools.tmf.ctf.core.CTFEnumField;
import org.eclipse.linuxtools.tmf.ctf.core.CTFFloatField;
import org.eclipse.linuxtools.tmf.ctf.core.CTFIntegerArrayField;
import org.eclipse.linuxtools.tmf.ctf.core.CTFIntegerField;
import org.eclipse.linuxtools.tmf.ctf.core.CTFStringField;
import org.eclipse.linuxtools.tmf.ctf.core.CTFStructField;
import org.eclipse.linuxtools.tmf.ctf.core.CTFVariantField;
import org.eclipse.linuxtools.tmf.ctf.core.CtfEnumPair;
import org.eclipse.linuxtools.tmf.ctf.core.Messages;

public abstract class CtfTmfEventField
extends TmfEventField {
    protected CtfTmfEventField(String name, Object value, ITmfEventField[] fields) {
        super(name.startsWith("_") ? name.substring(1) : name, value, fields);
    }

    @Deprecated
    public static CtfTmfEventField parseField(Definition fieldDef, String fieldName) {
        return CtfTmfEventField.parseField((IDefinition)fieldDef, fieldName);
    }

    public static CtfTmfEventField parseField(IDefinition fieldDef, String fieldName) {
        CtfTmfEventField field = null;
        if (fieldDef instanceof IntegerDefinition) {
            IntegerDefinition intDef = (IntegerDefinition)fieldDef;
            int base = intDef.getDeclaration().getBase();
            field = new CTFIntegerField(fieldName, intDef.getValue(), base, intDef.getDeclaration().isSigned());
        } else if (fieldDef instanceof EnumDefinition) {
            EnumDefinition enumDef = (EnumDefinition)fieldDef;
            field = new CTFEnumField(fieldName, new CtfEnumPair(enumDef.getValue(), enumDef.getIntegerValue()));
        } else if (fieldDef instanceof StringDefinition) {
            field = new CTFStringField(fieldName, ((StringDefinition)fieldDef).getValue());
        } else if (fieldDef instanceof FloatDefinition) {
            FloatDefinition floatDef = (FloatDefinition)fieldDef;
            field = new CTFFloatField(fieldName, floatDef.getValue());
        } else if (fieldDef instanceof ArrayDefinition) {
            ArrayDefinition arrayDef = (ArrayDefinition)fieldDef;
            IDeclaration decl = arrayDef.getDeclaration();
            if (!(decl instanceof CompoundDeclaration)) {
                throw new IllegalArgumentException("Array definitions should only come from sequence or array declarations");
            }
            CompoundDeclaration arrDecl = (CompoundDeclaration)decl;
            IDeclaration elemType = null;
            List definitions = arrayDef.getDefinitions();
            elemType = arrDecl.getElementType();
            if (elemType instanceof IntegerDeclaration) {
                IntegerDeclaration elemIntType = (IntegerDeclaration)elemType;
                if (elemIntType.isCharacter()) {
                    field = new CTFStringField(fieldName, arrayDef.toString());
                } else {
                    long[] values = new long[arrayDef.getLength()];
                    int i = 0;
                    while (i < arrayDef.getLength()) {
                        IDefinition elem = (IDefinition)arrayDef.getDefinitions().get(i);
                        if (elem == null) break;
                        values[i] = ((IntegerDefinition)elem).getValue();
                        ++i;
                    }
                    field = new CTFIntegerArrayField(fieldName, values, elemIntType.getBase(), elemIntType.isSigned());
                }
            } else {
                CtfTmfEventField[] elements = new CtfTmfEventField[arrayDef.getLength()];
                int i = 0;
                for (IDefinition definition : definitions) {
                    CtfTmfEventField curField;
                    elements[i] = curField = CtfTmfEventField.parseField(definition, String.valueOf(fieldName) + '[' + i + ']');
                    ++i;
                }
                field = new CTFArrayField(fieldName, elements);
            }
        } else if (fieldDef instanceof ByteArrayDefinition) {
            field = new CTFStringField(fieldName, fieldDef.toString());
        } else if (fieldDef instanceof ICompositeDefinition) {
            ICompositeDefinition strDef = (ICompositeDefinition)fieldDef;
            ArrayList<CtfTmfEventField> list = new ArrayList<CtfTmfEventField>();
            for (String curFieldName : strDef.getFieldNames()) {
                list.add(CtfTmfEventField.parseField(strDef.getDefinition(curFieldName), curFieldName));
            }
            field = new CTFStructField(fieldName, list.toArray(new CtfTmfEventField[list.size()]));
        } else if (fieldDef instanceof VariantDefinition) {
            VariantDefinition varDef = (VariantDefinition)fieldDef;
            String curFieldName = varDef.getCurrentFieldName();
            Definition curFieldDef = varDef.getCurrentField();
            if (curFieldDef != null) {
                CtfTmfEventField subField = CtfTmfEventField.parseField((IDefinition)curFieldDef, curFieldName);
                field = new CTFVariantField(fieldName, subField);
            } else {
                field = new CTFStringField(curFieldName, "");
            }
        } else {
            field = new CTFStringField(fieldName, String.valueOf(Messages.CtfTmfEventField_UnsupportedType) + fieldDef.getClass().toString());
        }
        return field;
    }

    public String toString() {
        return String.valueOf(this.getName()) + '=' + this.getFormattedValue();
    }
}

