/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ctf.core;

import com.google.common.collect.ImmutableSet;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.ctf.core.event.CTFClock;
import org.eclipse.linuxtools.ctf.core.event.IEventDeclaration;
import org.eclipse.linuxtools.ctf.core.trace.CTFReaderException;
import org.eclipse.linuxtools.ctf.core.trace.CTFTrace;
import org.eclipse.linuxtools.ctf.core.trace.CTFTraceReader;
import org.eclipse.linuxtools.internal.tmf.ctf.core.Activator;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventField;
import org.eclipse.linuxtools.tmf.core.event.ITmfEventType;
import org.eclipse.linuxtools.tmf.core.event.TmfEventField;
import org.eclipse.linuxtools.tmf.core.event.TmfEventTypeManager;
import org.eclipse.linuxtools.tmf.core.exceptions.TmfTraceException;
import org.eclipse.linuxtools.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfEventParser;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTraceProperties;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTraceWithPreDefinedEvents;
import org.eclipse.linuxtools.tmf.core.trace.TmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TraceValidationStatus;
import org.eclipse.linuxtools.tmf.core.trace.indexer.ITmfPersistentlyIndexable;
import org.eclipse.linuxtools.tmf.core.trace.indexer.ITmfTraceIndexer;
import org.eclipse.linuxtools.tmf.core.trace.indexer.TmfBTreeTraceIndexer;
import org.eclipse.linuxtools.tmf.core.trace.indexer.checkpoint.TmfCheckpoint;
import org.eclipse.linuxtools.tmf.core.trace.location.ITmfLocation;
import org.eclipse.linuxtools.tmf.ctf.core.CtfConstants;
import org.eclipse.linuxtools.tmf.ctf.core.CtfIterator;
import org.eclipse.linuxtools.tmf.ctf.core.CtfIteratorManager;
import org.eclipse.linuxtools.tmf.ctf.core.CtfLocation;
import org.eclipse.linuxtools.tmf.ctf.core.CtfLocationInfo;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfContext;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfEvent;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfEventType;
import org.eclipse.linuxtools.tmf.ctf.core.CtfTmfTimestamp;
import org.eclipse.linuxtools.tmf.ctf.core.Messages;

public class CtfTmfTrace
extends TmfTrace
implements ITmfEventParser,
ITmfTraceProperties,
ITmfPersistentlyIndexable,
ITmfTraceWithPreDefinedEvents,
AutoCloseable {
    protected static final int DEFAULT_CACHE_SIZE = 50000;
    private static final String CLOCK_HOST_PROPERTY = "uuid";
    private static final int CONFIDENCE = 10;
    private CTFTrace fTrace;
    private static int fCheckpointSize = -1;

    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> eventType) throws TmfTraceException {
        this.setCacheSize();
        super.initTrace(resource, path, eventType);
        try {
            this.fTrace = new CTFTrace(path);
            CtfIteratorManager.addTrace(this);
            CtfTmfContext ctx = (CtfTmfContext)this.seekEvent(0L);
            CtfTmfEvent event = this.getNext(ctx);
            if (ctx.getLocation().equals((Object)CtfIterator.NULL_LOCATION) || ctx.getCurrentEvent() == null) {
                this.setStartTime(TmfTimestamp.BIG_BANG);
            } else {
                ITmfTimestamp curTime = event.getTimestamp();
                this.setStartTime(curTime);
                this.setEndTime(curTime);
            }
            Throwable throwable = null;
            Object var7_9 = null;
            try (CtfIterator iter = CtfIteratorManager.getIterator(this, ctx);){
                for (IEventDeclaration ied : iter.getEventDeclarations()) {
                    CtfTmfEventType ctfTmfEventType = CtfTmfEventType.get(this, ied.getName());
                    if (ctfTmfEventType != null) continue;
                    ArrayList<TmfEventField> content = new ArrayList<TmfEventField>();
                    for (String fieldName : ied.getFields().getFieldsList()) {
                        content.add(new TmfEventField(fieldName, null, null));
                    }
                    TmfEventField contentTree = new TmfEventField(":root:", null, content.toArray(new ITmfEventField[content.size()]));
                    ctfTmfEventType = new CtfTmfEventType(ied.getName(), (ITmfTrace)this, (ITmfEventField)contentTree);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CTFReaderException e) {
            throw new TmfTraceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void close() {
        this.dispose();
    }

    public synchronized void dispose() {
        CtfIteratorManager.removeTrace(this);
        if (this.fTrace != null) {
            this.fTrace.close();
            this.fTrace = null;
        }
        super.dispose();
    }

    public IStatus validate(IProject project, String path) {
        TraceValidationStatus status;
        block23: {
            status = new TraceValidationStatus(10, "org.eclipse.linuxtools.tmf.ctf.core");
            try {
                Throwable throwable = null;
                Object var5_8 = null;
                try (CTFTrace temp = new CTFTrace(path);){
                    if (!temp.majorIsSet()) {
                        status = new Status(4, "org.eclipse.linuxtools.tmf.ctf.core", Messages.CtfTmfTrace_MajorNotSet);
                        break block23;
                    }
                    Throwable throwable2 = null;
                    Object var8_13 = null;
                    try (CTFTraceReader ctfTraceReader = new CTFTraceReader(temp);){
                        if (!ctfTraceReader.hasMoreEvents()) {
                            status = new Status(4, "org.eclipse.linuxtools.tmf.ctf.core", Messages.CtfTmfTrace_NoEvent);
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (CTFReaderException e) {
                status = new Status(4, "org.eclipse.linuxtools.tmf.ctf.core", String.valueOf(Messages.CtfTmfTrace_ReadingError) + ": " + e.toString());
            }
            catch (BufferOverflowException e) {
                status = new Status(4, "org.eclipse.linuxtools.tmf.ctf.core", String.valueOf(Messages.CtfTmfTrace_ReadingError) + ": " + Messages.CtfTmfTrace_BufferOverflowErrorMessage);
            }
        }
        return status;
    }

    public ITmfLocation getCurrentLocation() {
        return null;
    }

    public double getLocationRatio(ITmfLocation location) {
        CtfLocation curLocation = (CtfLocation)location;
        CtfTmfContext context = new CtfTmfContext(this);
        context.setLocation((ITmfLocation)curLocation);
        context.seek(curLocation.getLocationInfo());
        CtfLocationInfo currentTime = (CtfLocationInfo)context.getLocation().getLocationInfo();
        long startTime = CtfTmfTrace.getIterator(this, context).getStartTime();
        long endTime = CtfTmfTrace.getIterator(this, context).getEndTime();
        return ((double)currentTime.getTimestamp() - (double)startTime) / (double)(endTime - startTime);
    }

    public synchronized ITmfContext seekEvent(ITmfLocation location) {
        CtfLocation currentLocation = (CtfLocation)location;
        CtfTmfContext context = new CtfTmfContext(this);
        if (this.fTrace == null) {
            context.setLocation(null);
            context.setRank(-1L);
            return context;
        }
        if (currentLocation == null) {
            currentLocation = new CtfLocation(new CtfLocationInfo(0L, 0L));
            context.setRank(0L);
        }
        if (currentLocation.getLocationInfo() == CtfLocation.INVALID_LOCATION) {
            currentLocation = new CtfLocation(this.getCTFTrace().getCurrentEndTime() + 1L, 0L);
        }
        context.setLocation((ITmfLocation)currentLocation);
        if (location == null) {
            long timestamp = CtfTmfTrace.getIterator(this, context).getCurrentTimestamp();
            currentLocation = new CtfLocation(timestamp, 0L);
        }
        if (context.getRank() != 0L) {
            context.setRank(-1L);
        }
        return context;
    }

    public synchronized ITmfContext seekEvent(double ratio) {
        CtfTmfContext context = new CtfTmfContext(this);
        if (this.fTrace == null) {
            context.setLocation(null);
            context.setRank(-1L);
            return context;
        }
        long end = this.getCTFTrace().getCurrentEndTime();
        long start = this.getCTFTrace().getCurrentStartTime();
        long diff = end - start;
        long ratioTs = Math.round((double)diff * ratio) + start;
        context.seek(ratioTs);
        context.setRank(-1L);
        return context;
    }

    public synchronized CtfTmfEvent getNext(ITmfContext context) {
        if (this.fTrace == null) {
            return null;
        }
        CtfTmfEvent event = null;
        if (context instanceof CtfTmfContext) {
            if (context.getLocation() == null || CtfLocation.INVALID_LOCATION.equals(context.getLocation().getLocationInfo())) {
                return null;
            }
            CtfTmfContext ctfContext = (CtfTmfContext)context;
            event = ctfContext.getCurrentEvent();
            if (event != null) {
                this.updateAttributes(context, event.getTimestamp());
                ctfContext.advance();
                ctfContext.increaseRank();
            }
        }
        return event;
    }

    public CTFTrace getCTFTrace() {
        return this.fTrace;
    }

    public String getHostId() {
        String clockHost;
        CTFClock clock = this.getCTFTrace().getClock();
        if (clock != null && (clockHost = (String)clock.getProperty(CLOCK_HOST_PROPERTY)) != null) {
            return clockHost;
        }
        return super.getHostId();
    }

    public Map<String, String> getTraceProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(this.fTrace.getEnvironment());
        properties.put(Messages.CtfTmfTrace_HostID, this.getHostId());
        return properties;
    }

    public long getOffset() {
        if (this.fTrace != null) {
            return this.fTrace.getOffset();
        }
        return 0L;
    }

    public Set<ITmfEventType> getContainedEventTypes() {
        TmfEventTypeManager instance = TmfEventTypeManager.getInstance();
        Set eventTypes = instance.getTypes(CtfTmfEventType.computeContextName((ITmfTrace)this));
        return ImmutableSet.copyOf((Collection)eventTypes);
    }

    public CtfTmfEvent parseEvent(ITmfContext context) {
        CtfTmfEvent event = null;
        if (context instanceof CtfTmfContext) {
            ITmfContext tmpContext = this.seekEvent(context.getLocation());
            event = this.getNext(tmpContext);
        }
        return event;
    }

    protected void setCacheSize() {
        this.setCacheSize(50000);
    }

    private static CtfIterator getIterator(CtfTmfTrace trace, CtfTmfContext context) {
        return CtfIteratorManager.getIterator(trace, context);
    }

    public CtfIterator createIterator() {
        try {
            return new CtfIterator(this);
        }
        catch (CTFReaderException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return null;
        }
    }

    public CtfTmfTimestamp createTimestamp(long ts) {
        return new CtfTmfTimestamp(this.getTimestampTransform().transform(ts));
    }

    public synchronized int getCheckpointSize() {
        if (fCheckpointSize == -1) {
            TmfCheckpoint c = new TmfCheckpoint((ITmfTimestamp)new CtfTmfTimestamp(0L), (ITmfLocation)new CtfLocation(0L, 0L), 0L);
            ByteBuffer b = ByteBuffer.allocate(1024);
            b.clear();
            c.serialize(b);
            fCheckpointSize = b.position();
        }
        return fCheckpointSize;
    }

    protected ITmfTraceIndexer createIndexer(int interval) {
        return new TmfBTreeTraceIndexer((ITmfTrace)this, interval);
    }

    public ITmfLocation restoreLocation(ByteBuffer bufferIn) {
        return new CtfLocation(bufferIn);
    }

    public boolean isComplete() {
        if (this.getResource() == null) {
            return true;
        }
        String host = null;
        String port = null;
        String sessionName = null;
        try {
            host = this.getResource().getPersistentProperty(CtfConstants.LIVE_HOST);
            port = this.getResource().getPersistentProperty(CtfConstants.LIVE_PORT);
            sessionName = this.getResource().getPersistentProperty(CtfConstants.LIVE_SESSION_NAME);
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), e);
            return true;
        }
        return host == null || port == null || sessionName == null;
    }

    public void setComplete(boolean isComplete) {
        super.setComplete(isComplete);
        try {
            if (isComplete) {
                this.getResource().setPersistentProperty(CtfConstants.LIVE_HOST, null);
                this.getResource().setPersistentProperty(CtfConstants.LIVE_PORT, null);
                this.getResource().setPersistentProperty(CtfConstants.LIVE_SESSION_NAME, null);
            }
        }
        catch (CoreException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }
}

