/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.encoding;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.sse.core.internal.encoding.CodedIO;
import org.eclipse.wst.sse.core.internal.encoding.ContentBasedPreferenceGateway;
import org.eclipse.wst.sse.core.internal.encoding.ContentTypeEncodingPreferences;

public class NonContentBasedEncodingRules {
    private static final String getJavaPlatformDefaultEncoding() {
        String enc = System.getProperty("file.encoding");
        if (enc != null && enc.trim().length() == 0) {
            enc = null;
        }
        return enc;
    }

    public static String getUserSpecifiedDefaultForContentType(IFile iFile) {
        String enc = null;
        IContentType contentType = null;
        try {
            contentType = iFile.getContentDescription().getContentType();
            if (contentType != null) {
                enc = contentType.getDefaultCharset();
            }
            if (enc == null || enc.trim().length() == 0) {
                enc = ContentBasedPreferenceGateway.getPreferencesString(contentType, "inputCodeset");
            }
            if (enc != null && enc.trim().length() == 0) {
                enc = null;
            }
        }
        catch (CoreException coreException) {
            enc = null;
        }
        return enc;
    }

    public static String getUserSpecifiedDefaultForContentType(String contentTypeId) {
        String enc = null;
        IContentType contentType = Platform.getContentTypeManager().getContentType(contentTypeId);
        if (contentType != null) {
            enc = contentType.getDefaultCharset();
        }
        if (enc == null || enc.trim().length() == 0) {
            enc = ContentBasedPreferenceGateway.getPreferencesString(contentTypeId, "inputCodeset");
        }
        if (enc != null && enc.trim().length() == 0) {
            enc = null;
        }
        return enc;
    }

    private static final String getWorkbenchSpecifiedDefaultEncoding() {
        ResourcesPlugin resourcePlugin = ResourcesPlugin.getPlugin();
        String enc = resourcePlugin.getPluginPreferences().getString("encoding");
        if (enc != null && enc.trim().length() == 0) {
            enc = null;
        }
        return enc;
    }

    public static final String useDefaultNameRules(String specDefault) {
        String enc = null;
        String result = null;
        enc = specDefault;
        if (enc != null) {
            result = enc;
        } else {
            enc = ContentTypeEncodingPreferences.getUserSpecifiedDefaultEncodingPreference();
            if (enc != null && enc.trim().length() > 0) {
                result = enc.trim();
            } else {
                if ((enc == null || enc.trim().length() == 0) && (enc = NonContentBasedEncodingRules.getWorkbenchSpecifiedDefaultEncoding()) != null) {
                    result = enc.trim();
                }
                if ((enc == null || enc.trim().length() == 0) && (enc = NonContentBasedEncodingRules.getJavaPlatformDefaultEncoding()) != null) {
                    result = enc;
                }
            }
        }
        result = CodedIO.checkMappingOverrides(result);
        return result;
    }

    private NonContentBasedEncodingRules() {
    }
}

