/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.valgrind.massif;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.linuxtools.internal.valgrind.massif.MassifHeapTreeNode;
import org.eclipse.linuxtools.profiling.ui.ProfileUIUtils;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class MassifPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.linuxtools.valgrind.massif";
    public static final String EDITOR_ID = "org.eclipse.linuxtools.valgrind.massif.chartEditor";
    private static MassifPlugin plugin;
    private ISourceLocator locator;
    public static final String TOOL_ID = "org.eclipse.linuxtools.valgrind.launch.massif";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static FontMetrics getFontMetrics(Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return fontMetrics;
    }

    public void openEditorForNode(MassifHeapTreeNode element) {
        Object obj;
        if (this.locator instanceof ISourceLookupDirector && (obj = ((ISourceLookupDirector)this.locator).getSourceElement((Object)element.getFilename())) instanceof IStorage) {
            try {
                if (obj instanceof IFile) {
                    ProfileUIUtils.openEditorAndSelect((IFile)((IFile)obj), (int)element.getLine());
                } else {
                    String fullFilePath = ((IStorage)obj).getFullPath().toOSString();
                    ProfileUIUtils.openEditorAndSelect((String)fullFilePath, (int)element.getLine());
                }
            }
            catch (BadLocationException | PartInitException e) {
                e.printStackTrace();
            }
        }
    }

    protected void setSourceLocator(ISourceLocator locator) {
        this.locator = locator;
    }

    public static MassifPlugin getDefault() {
        return plugin;
    }
}

