/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal.series;

import java.text.DecimalFormat;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.swtchart.ISeriesLabel;
import org.swtchart.internal.Util;

public class SeriesLabel
implements ISeriesLabel {
    private boolean isVisible = false;
    protected Font font = DEFAULT_FONT;
    protected Color color = Display.getDefault().getSystemColor(2);
    private String format = "#.###########";
    private String[] formats;
    private static final int DEFAULT_COLOR = 2;
    private static final Font DEFAULT_FONT = Display.getDefault().getSystemFont();
    private static final String DEFAULT_FORMAT = "#.###########";

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format == null ? DEFAULT_FORMAT : format;
    }

    public String[] getFormats() {
        if (this.formats == null) {
            return null;
        }
        String[] copiedFormats = new String[this.formats.length];
        System.arraycopy(this.formats, 0, copiedFormats, 0, this.formats.length);
        return copiedFormats;
    }

    public void setFormats(String[] formats) {
        if (formats == null) {
            this.formats = null;
            return;
        }
        this.formats = new String[formats.length];
        System.arraycopy(formats, 0, this.formats, 0, formats.length);
    }

    public Color getForeground() {
        return this.color;
    }

    public void setForeground(Color color) {
        if (color != null && color.isDisposed()) {
            SWT.error((int)5);
        }
        this.color = color == null ? Display.getDefault().getSystemColor(2) : color;
    }

    public Font getFont() {
        if (this.font.isDisposed()) {
            this.font = DEFAULT_FONT;
        }
        return this.font;
    }

    public void setFont(Font font) {
        if (font != null && font.isDisposed()) {
            SWT.error((int)5);
        }
        this.font = font == null ? DEFAULT_FONT : font;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    protected void draw(GC gc, int h, int v, double ySeriesValue, int seriesIndex, int alignment) {
        if (!this.isVisible) {
            return;
        }
        gc.setForeground(this.color);
        gc.setFont(this.getFont());
        String format1 = this.format;
        if (this.formats != null && this.formats.length > seriesIndex) {
            format1 = this.formats[seriesIndex];
        }
        if (format1 == null || format1.equals("")) {
            return;
        }
        String text = this.isDecimalFormat(format1) ? new DecimalFormat(format1).format(ySeriesValue) : format1.replaceAll("'", "");
        if (alignment == 0x1000000) {
            Point p = Util.getExtentInGC(this.font, text);
            gc.drawString(text, (int)((double)h - (double)p.x / 2.0), (int)((double)v - (double)p.y / 2.0), true);
        } else if (alignment == 1024) {
            gc.drawString(text, h, v, true);
        }
    }

    private boolean isDecimalFormat(String text) {
        StringBuilder nonEscapedPart = new StringBuilder();
        String[] elements = text.split("'");
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                nonEscapedPart.append(elements[i]);
                i += 2;
            }
        }
        return nonEscapedPart.indexOf("#") != -1 || nonEscapedPart.indexOf("0") != -1;
    }
}

