/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core.model;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import org.eclipse.rse.core.model.ILabeledObject;
import org.eclipse.rse.core.model.IProperty;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.IPropertySetContainer;
import org.eclipse.rse.core.model.IPropertyType;
import org.eclipse.rse.core.model.IRSEModelObject;
import org.eclipse.rse.core.model.IRSEPersistableContainer;
import org.eclipse.rse.core.model.Property;
import org.eclipse.rse.core.model.PropertyType;
import org.eclipse.rse.core.model.RSEModelObject;

public class PropertySet
extends RSEModelObject
implements IPropertySet,
IRSEModelObject,
ILabeledObject,
Observer {
    private String _name;
    private String _label = null;
    private String _description = null;
    private Map _properties;
    private IPropertySetContainer _container = null;
    protected static IPropertyType _defaultType = PropertyType.getStringPropertyType();

    public PropertySet(IPropertySet propertySet) {
        this._name = propertySet.getName();
        this._description = propertySet.getDescription();
        this._properties = new LinkedHashMap();
        if (propertySet instanceof ILabeledObject) {
            ILabeledObject p = (ILabeledObject)((Object)propertySet);
            this._label = p.getLabel();
        }
        String[] keys = propertySet.getPropertyKeys();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            IProperty property = propertySet.getProperty(key);
            this.addProperty(key, new Property(property));
            ++i;
        }
        this.setDirty(true);
    }

    public PropertySet(String name) {
        this._name = name;
        this._properties = new LinkedHashMap();
        this.setDirty(true);
    }

    public String getName() {
        return this._name;
    }

    public String getLabel() {
        if (this._label != null) {
            return this._label;
        }
        return this._name;
    }

    public void setLabel(String label) {
        this._label = label;
        this.setDirty(true);
    }

    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
        this.setDirty(true);
    }

    public String[] getPropertyKeys() {
        Set set = this._properties.keySet();
        return set.toArray(new String[set.size()]);
    }

    public void setName(String name) {
        this._name = name;
        this.setDirty(true);
    }

    public void setProperties(Map map) {
        this._properties = new LinkedHashMap(map.size());
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof IProperty) {
                this.addProperty(key, (IProperty)value);
                continue;
            }
            if (!(value instanceof String)) continue;
            this.addProperty(key, (String)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProperty addProperty(String key, IProperty property) {
        Map map = this._properties;
        synchronized (map) {
            this._properties.put(key, property);
        }
        this.setDirty(true);
        return property;
    }

    public IProperty addProperty(String key, String value) {
        IProperty property = this.getProperty(key);
        if (property != null) {
            property.setValue(value);
        } else {
            property = this.addProperty(key, value, _defaultType);
        }
        return property;
    }

    public IProperty addProperty(String key, String value, IPropertyType type) {
        Property property = new Property(key, value, type, true);
        return this.addProperty(key, property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeProperty(String key) {
        Object value = null;
        Map map = this._properties;
        synchronized (map) {
            value = this._properties.remove(key);
        }
        if (value == null) {
            return false;
        }
        this.setDirty(true);
        return true;
    }

    public IProperty getProperty(String key) {
        return (IProperty)this._properties.get(key);
    }

    public String getPropertyValue(String key) {
        IProperty property = this.getProperty(key);
        if (property != null) {
            return property.getValue();
        }
        return null;
    }

    public IPropertyType getPropertyType(String key) {
        IProperty property = this.getProperty(key);
        if (property != null) {
            return property.getType();
        }
        return null;
    }

    public boolean commit() {
        return this.getPersistableParent().commit();
    }

    public IRSEPersistableContainer[] getPersistableChildren() {
        return IRSEPersistableContainer.NO_CHILDREN;
    }

    public IRSEPersistableContainer getPersistableParent() {
        IRSEPersistableContainer result = null;
        if (this._container instanceof IRSEPersistableContainer) {
            result = (IRSEPersistableContainer)((Object)this._container);
        }
        return result;
    }

    public void setContainer(IPropertySetContainer container) {
        this._container = container;
    }

    public IPropertySetContainer getContainer() {
        return this._container;
    }

    public void update(Observable o, Object arg) {
        this.setDirty(true);
    }
}

