/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.reflog;

import java.text.MessageFormat;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.AbstractBranchSelectionDialog;
import org.eclipse.egit.ui.internal.repository.tree.AdditionalRefNode;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class RefSelectionDialog
extends AbstractBranchSelectionDialog {
    public RefSelectionDialog(Shell parentShell, Repository repository) {
        super(parentShell, repository, 214);
    }

    protected void refNameSelected(String refName) {
        this.getButton(0).setEnabled(refName != null);
    }

    protected String getTitle() {
        String repoName = !this.repo.isBare() ? this.repo.getDirectory().getParentFile().getName() : this.repo.getDirectory().getName();
        return MessageFormat.format(UIText.RefSelectionDialog_Title, repoName);
    }

    protected void createCustomArea(Composite parent) {
        this.branchTree.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof AdditionalRefNode) {
                    AdditionalRefNode ref = (AdditionalRefNode)element;
                    return "HEAD".equals(((Ref)ref.getObject()).getName());
                }
                return true;
            }
        });
    }

    protected String getMessageText() {
        return UIText.RefSelectionDialog_Messsage;
    }
}

