/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;

class ImplicitsAnalysis {
    private final boolean hasUserDeclaredConstructor;
    private boolean hasUserDeclaredCopyConstructor;
    private boolean hasUserDeclaredCopyAssignmentOperator;
    private final boolean hasUserDeclaredDestructor;
    private final ICPPClassType classType;

    ImplicitsAnalysis(ICPPASTCompositeTypeSpecifier compSpec, ICPPClassType clsType) {
        boolean hasUserDeclaredCAO;
        this.classType = clsType;
        ICPPASTFunctionDeclarator[] ctors = this.getUserDeclaredCtorOrDtor(compSpec, true);
        this.hasUserDeclaredConstructor = ctors.length > 0;
        this.hasUserDeclaredCopyConstructor = false;
        this.hasUserDeclaredCopyAssignmentOperator = false;
        this.hasUserDeclaredDestructor = this.getUserDeclaredCtorOrDtor(compSpec, false).length > 0;
        int i = 0;
        while (i < ctors.length) {
            block4: {
                ICPPASTFunctionDeclarator dcltor = ctors[i];
                ICPPASTParameterDeclaration[] ps = dcltor.getParameters();
                if (ps.length >= 1 && this.hasTypeReferenceToClassType(ps[0])) {
                    int j = 1;
                    while (j < ps.length) {
                        if (ps[j].getDeclarator().getInitializer() != null) {
                            ++j;
                            continue;
                        }
                        break block4;
                    }
                    this.hasUserDeclaredCopyConstructor = true;
                }
            }
            ++i;
        }
        this.hasUserDeclaredCopyAssignmentOperator = hasUserDeclaredCAO = this.getUserDeclaredCopyAssignmentOperators(compSpec).length > 0;
    }

    public int getImplicitsToDeclareCount() {
        return (!this.hasUserDeclaredDestructor ? 1 : 0) + (!this.hasUserDeclaredConstructor ? 1 : 0) + (!this.hasUserDeclaredCopyConstructor ? 1 : 0) + (!this.hasUserDeclaredCopyAssignmentOperator ? 1 : 0);
    }

    private ICPPASTFunctionDeclarator[] getUserDeclaredCtorOrDtor(ICPPASTCompositeTypeSpecifier compSpec, boolean constructor) {
        ArrayList<ICPPASTFunctionDeclarator> result = new ArrayList<ICPPASTFunctionDeclarator>();
        IASTDeclaration[] members = compSpec.getMembers();
        char[] name = compSpec.getName().getLookupKey();
        IASTDeclarator dcltor = null;
        IASTDeclSpecifier spec = null;
        IASTDeclaration[] iASTDeclarationArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                block9: {
                    IASTDeclaration member;
                    block7: {
                        member = iASTDeclarationArray[n2];
                        if (!(member instanceof IASTSimpleDeclaration)) break block7;
                        IASTDeclarator[] dtors = ((IASTSimpleDeclaration)member).getDeclarators();
                        if (dtors.length == 0 || dtors.length > 1) break block8;
                        dcltor = dtors[0];
                        spec = ((IASTSimpleDeclaration)member).getDeclSpecifier();
                        break block9;
                    }
                    if (member instanceof IASTFunctionDefinition) {
                        dcltor = ((IASTFunctionDefinition)member).getDeclarator();
                        spec = ((IASTFunctionDefinition)member).getDeclSpecifier();
                    }
                }
                if (dcltor instanceof ICPPASTFunctionDeclarator && spec instanceof IASTSimpleDeclSpecifier && ((IASTSimpleDeclSpecifier)spec).getType() == 0) {
                    boolean nameEquals = false;
                    char[] dtorname = ASTQueries.findInnermostDeclarator(dcltor).getName().getLookupKey();
                    if (constructor) {
                        nameEquals = CharArrayUtils.equals(dtorname, name);
                    } else if (dtorname.length > 0 && dtorname[0] == '~') {
                        nameEquals = CharArrayUtils.equals(dtorname, 1, name.length, name);
                    }
                    if (nameEquals) {
                        result.add((ICPPASTFunctionDeclarator)dcltor);
                    }
                }
            }
            ++n2;
        }
        return result.toArray(new ICPPASTFunctionDeclarator[result.size()]);
    }

    private ICPPASTFunctionDeclarator[] getUserDeclaredCopyAssignmentOperators(ICPPASTCompositeTypeSpecifier compSpec) {
        ArrayList<ICPPASTFunctionDeclarator> result = new ArrayList<ICPPASTFunctionDeclarator>();
        IASTDeclaration[] members = compSpec.getMembers();
        IASTDeclarator dcltor = null;
        IASTDeclaration[] iASTDeclarationArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                ICPPASTParameterDeclaration[] ps;
                char[] nchars;
                block5: {
                    IASTDeclaration member;
                    block3: {
                        member = iASTDeclarationArray[n2];
                        if (!(member instanceof IASTSimpleDeclaration)) break block3;
                        IASTDeclarator[] dtors = ((IASTSimpleDeclaration)member).getDeclarators();
                        if (dtors.length == 0 || dtors.length > 1) break block4;
                        dcltor = dtors[0];
                        break block5;
                    }
                    if (member instanceof IASTFunctionDefinition) {
                        dcltor = ((IASTFunctionDefinition)member).getDeclarator();
                    }
                }
                if (dcltor instanceof ICPPASTFunctionDeclarator && CharArrayUtils.equals(nchars = ASTQueries.findInnermostDeclarator(dcltor).getName().getLookupKey(), OverloadableOperator.ASSIGN.toCharArray()) && (ps = ((ICPPASTFunctionDeclarator)dcltor).getParameters()).length == 1 && this.hasTypeReferenceToClassType(ps[0])) {
                    result.add((ICPPASTFunctionDeclarator)dcltor);
                }
            }
            ++n2;
        }
        return result.toArray(new ICPPASTFunctionDeclarator[result.size()]);
    }

    private boolean hasTypeReferenceToClassType(IASTParameterDeclaration dec) {
        IType t;
        if (dec instanceof ICPPASTParameterDeclaration && (t = CPPVisitor.createType((ICPPASTParameterDeclaration)dec, false)) != null && (t = SemanticUtil.getNestedType(t, 1)) instanceof ICPPReferenceType && !((ICPPReferenceType)t).isRValueReference()) {
            t = SemanticUtil.getNestedType(t, 13);
            return this.classType.isSameType(t);
        }
        return false;
    }

    public boolean hasUserDeclaredConstructor() {
        return this.hasUserDeclaredConstructor;
    }

    public boolean hasUserDeclaredCopyConstructor() {
        return this.hasUserDeclaredCopyConstructor;
    }

    public boolean hasUserDeclaredCopyAssignmentOperator() {
        return this.hasUserDeclaredCopyAssignmentOperator;
    }

    public boolean hasUserDeclaredDestructor() {
        return this.hasUserDeclaredDestructor;
    }
}

