/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.IPDOMIndexerTask;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIncludeStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDirective;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISignificantMacros;
import org.eclipse.cdt.core.parser.IncludeExportPatterns;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.internal.core.dom.IIncludeFileResolutionHeuristics;
import org.eclipse.cdt.internal.core.dom.parser.ASTTranslationUnit;
import org.eclipse.cdt.internal.core.index.FileContentKey;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IWritableIndex;
import org.eclipse.cdt.internal.core.index.IndexBasedFileContentProvider;
import org.eclipse.cdt.internal.core.parser.IMacroDictionary;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContentProvider;
import org.eclipse.cdt.internal.core.parser.util.LRUCache;
import org.eclipse.cdt.internal.core.pdom.ITodoTaskUpdater;
import org.eclipse.cdt.internal.core.pdom.IndexerInputAdapter;
import org.eclipse.cdt.internal.core.pdom.IndexerProgress;
import org.eclipse.cdt.internal.core.pdom.Messages;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.cdt.internal.core.pdom.PDOMWriter;
import org.eclipse.cdt.utils.EFSExtensionManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractIndexerTask
extends PDOMWriter {
    private static final int MAX_ERRORS = 500;
    private int fUpdateFlags = 1;
    private UnusedHeaderStrategy fIndexHeadersWithoutContext = UnusedHeaderStrategy.useDefaultLanguage;
    private boolean fIndexFilesWithoutConfiguration = true;
    private List<LinkageTask> fRequestsPerLinkage = new ArrayList<LinkageTask>();
    private Map<IIndexFile, IndexFileContent> fIndexContentCache = new LRUCache<IIndexFile, IndexFileContent>(500);
    private Map<IIndexFileLocation, IIndexFragmentFile[]> fIndexFilesCache = new LRUCache<IIndexFileLocation, IIndexFragmentFile[]>(5000);
    private Map<IIndexFileLocation, LocationTask> fOneLinkageTasks = new HashMap<IIndexFileLocation, LocationTask>();
    private Object[] fFilesToUpdate;
    private List<Object> fFilesToRemove = new ArrayList<Object>();
    private int fASTOptions;
    private int fForceNumberFiles = 0;
    protected IWritableIndex fIndex;
    private ITodoTaskUpdater fTodoTaskUpdater;
    private final boolean fIsFastIndexer;
    private long fFileSizeLimit = 0L;
    private InternalFileContentProvider fCodeReaderFactory;
    private int fSwallowOutOfMemoryError = 5;
    private final LinkedList<AbstractIndexerTask> fUrgentTasks;
    boolean fTaskCompleted;
    private IndexerProgress fInfo = new IndexerProgress();

    public AbstractIndexerTask(Object[] filesToUpdate, Object[] filesToRemove, IndexerInputAdapter resolver, boolean fastIndexer) {
        super(resolver);
        this.fIsFastIndexer = fastIndexer;
        this.fFilesToUpdate = filesToUpdate;
        Collections.addAll(this.fFilesToRemove, filesToRemove);
        this.incrementRequestedFilesCount(this.fFilesToUpdate.length + this.fFilesToRemove.size());
        this.fUrgentTasks = new LinkedList();
    }

    public final void setIndexHeadersWithoutContext(UnusedHeaderStrategy mode) {
        this.fIndexHeadersWithoutContext = mode;
    }

    public final void setIndexFilesWithoutBuildConfiguration(boolean val) {
        this.fIndexFilesWithoutConfiguration = val;
    }

    public UnusedHeaderStrategy getIndexHeadersWithoutContext() {
        return this.fIndexHeadersWithoutContext;
    }

    public boolean indexFilesWithoutConfiguration() {
        return this.fIndexFilesWithoutConfiguration;
    }

    public final void setUpdateFlags(int flags) {
        this.fUpdateFlags = flags;
    }

    public final void setForceFirstFiles(int number) {
        this.fForceNumberFiles = number;
    }

    public final void setFileSizeLimit(long limit) {
        this.fFileSizeLimit = limit;
    }

    public synchronized boolean acceptUrgentTask(IPDOMIndexerTask urgentTask) {
        if (!(urgentTask instanceof AbstractIndexerTask)) {
            return false;
        }
        AbstractIndexerTask task = (AbstractIndexerTask)((Object)urgentTask);
        if (task.fIsFastIndexer != this.fIsFastIndexer || task.fIndexFilesWithoutConfiguration != this.fIndexFilesWithoutConfiguration || this.fIndexFilesWithoutConfiguration && task.fIndexHeadersWithoutContext != this.fIndexHeadersWithoutContext || this.fTaskCompleted) {
            return false;
        }
        if (task.fFilesToUpdate.length > (this.fFilesToUpdate != null ? this.fFilesToUpdate.length : this.getProgressInformation().fRequestedFilesCount)) {
            return false;
        }
        this.fUrgentTasks.add(task);
        return true;
    }

    private synchronized boolean hasUrgentTasks() {
        return !this.fUrgentTasks.isEmpty();
    }

    private synchronized AbstractIndexerTask getUrgentTask() {
        return this.fUrgentTasks.poll();
    }

    protected abstract IWritableIndex createIndex();

    protected abstract IIncludeFileResolutionHeuristics createIncludeHeuristics();

    protected abstract IncludeFileContentProvider createReaderFactory();

    protected ITodoTaskUpdater createTodoTaskUpdater() {
        return null;
    }

    protected IncludeExportPatterns getIncludeExportPatterns() {
        return null;
    }

    protected int[] getLinkagesToParse() {
        if (this.fIndexHeadersWithoutContext == UnusedHeaderStrategy.useCPP) {
            return PDOMManager.IDS_FOR_LINKAGES_TO_INDEX_C_FIRST;
        }
        return PDOMManager.IDS_FOR_LINKAGES_TO_INDEX;
    }

    protected IParserLogService getLogService() {
        return ParserUtil.getParserLogService();
    }

    protected void logError(IStatus s) {
        CCorePlugin.log((IStatus)s);
    }

    protected void logException(Throwable e) {
        CCorePlugin.log((Throwable)e);
    }

    protected String getMessage(MessageKind kind, Object ... arguments) {
        switch (kind) {
            case parsingFileTask: {
                return NLS.bind((String)Messages.AbstractIndexerTask_parsingFileTask, (Object[])arguments);
            }
            case errorWhileParsing: {
                return NLS.bind((String)Messages.AbstractIndexerTask_errorWhileParsing, (Object[])arguments);
            }
            case tooManyIndexProblems: {
                return Messages.AbstractIndexerTask_tooManyIndexProblems;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexerProgress getProgressInformation() {
        IndexerProgress indexerProgress = this.fInfo;
        synchronized (indexerProgress) {
            return new IndexerProgress(this.fInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateFileCount(int sources, int primaryHeader, int header) {
        IndexerProgress indexerProgress = this.fInfo;
        synchronized (indexerProgress) {
            this.fInfo.fCompletedSources += sources;
            this.fInfo.fPrimaryHeaderCount += primaryHeader;
            this.fInfo.fCompletedHeaders += header;
        }
    }

    private final void reportFile(boolean wasCounted, UpdateKind kind) {
        if (wasCounted) {
            if (kind == UpdateKind.REQUIRED_SOURCE) {
                this.updateFileCount(1, 0, 0);
            } else {
                this.updateFileCount(0, 1, 1);
            }
        } else {
            this.updateFileCount(0, 0, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void incrementRequestedFilesCount(int delta) {
        IndexerProgress indexerProgress = this.fInfo;
        synchronized (indexerProgress) {
            this.fInfo.fRequestedFilesCount += delta;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void runTask(IProgressMonitor monitor) throws InterruptedException {
        block38: {
            block36: {
                if (!this.fIndexFilesWithoutConfiguration) {
                    this.fIndexHeadersWithoutContext = UnusedHeaderStrategy.skip;
                }
                this.fIndex = this.createIndex();
                if (this.fIndex != null) break block36;
                var15_2 = this;
                synchronized (var15_2) {
                    this.fTaskCompleted = true;
                }
                return;
            }
            try {
                this.fTodoTaskUpdater = this.createTodoTaskUpdater();
                this.fASTOptions = 20;
                if (this.getSkipReferences() == AbstractIndexerTask.SKIP_ALL_REFERENCES) {
                    this.fASTOptions |= 1;
                }
                this.fIndex.resetCacheCounters();
                this.fIndex.acquireReadLock();
                try {
                    try {
                        try {
                            files /* !! */  = new HashMap<Integer, List<IIndexFileLocation>>();
                            indexFilesToRemove = new ArrayList<IIndexFragmentFile>();
                            this.extractFiles(files /* !! */ , indexFilesToRemove, monitor);
                            this.setResume(true);
                            this.removeFilesInIndex(this.fFilesToRemove, indexFilesToRemove, monitor);
                            moreFiles = null;
                            while (true) {
                                var8_15 = this.getLinkagesToParse();
                                var7_13 = var8_15.length;
                                var6_11 = 0;
                                while (var6_11 < var7_13) {
                                    linkageID = var8_15[var6_11];
                                    filesForLinkage = files /* !! */ .get(linkageID);
                                    if (filesForLinkage != null) {
                                        this.parseLinkage(linkageID, filesForLinkage, monitor);
                                        it = this.fOneLinkageTasks.values().iterator();
                                        while (it.hasNext()) {
                                            task = it.next();
                                            if (!task.isCompleted()) continue;
                                            it.remove();
                                        }
                                        this.fIndexContentCache.clear();
                                        this.fIndexFilesCache.clear();
                                    }
                                    if (this.hasUrgentTasks()) break;
                                    ++var6_11;
                                }
                                linkageID = this;
                                synchronized (linkageID) {
                                    if (this.fUrgentTasks.isEmpty()) {
                                        if (moreFiles == null) {
                                            this.fTaskCompleted = true;
                                            break;
                                        }
                                        files /* !! */  = moreFiles;
                                        moreFiles = null;
                                    }
                                    // MONITOREXIT @DISABLED, blocks:[2, 3, 4, 5, 6, 22, 12] lbl62 : MonitorExitStatement: MONITOREXIT : linkageID
                                    if (true) ** GOTO lbl84
                                }
                                do {
                                    if (moreFiles == null) {
                                        moreFiles = files /* !! */ ;
                                    } else {
                                        for (Map.Entry<Integer, List<IIndexFileLocation>> entry : files /* !! */ .entrySet()) {
                                            list = moreFiles.get(entry.getKey());
                                            if (list == null) {
                                                moreFiles.put(entry.getKey(), entry.getValue());
                                                continue;
                                            }
                                            list.addAll(0, (Collection<IIndexFileLocation>)entry.getValue());
                                        }
                                    }
                                    files /* !! */  = new HashMap<K, V>();
                                    this.fFilesToUpdate = urgentTask.fFilesToUpdate;
                                    this.fForceNumberFiles = urgentTask.fForceNumberFiles;
                                    this.fFilesToRemove = urgentTask.fFilesToRemove;
                                    this.incrementRequestedFilesCount(this.fFilesToUpdate.length + this.fFilesToRemove.size());
                                    this.extractFiles(files /* !! */ , indexFilesToRemove, monitor);
                                    this.removeFilesInIndex(this.fFilesToRemove, indexFilesToRemove, monitor);
lbl84:
                                    // 2 sources

                                } while ((urgentTask = this.getUrgentTask()) != null);
                            }
                            if (!monitor.isCanceled()) {
                                this.setResume(false);
                            }
                        }
                        finally {
                            this.fIndex.flush();
                        }
                    }
                    catch (CoreException e) {
                        this.logException(e);
                        this.fIndex.releaseReadLock();
                        break block38;
                    }
                }
                catch (Throwable var13_20) {
                    this.fIndex.releaseReadLock();
                    throw var13_20;
                }
                this.fIndex.releaseReadLock();
            }
            catch (Throwable var14_21) {
                var15_3 = this;
                synchronized (var15_3) {
                    this.fTaskCompleted = true;
                }
                throw var14_21;
            }
        }
        var15_4 = this;
        synchronized (var15_4) {
            this.fTaskCompleted = true;
        }
    }

    private void setResume(boolean value) throws InterruptedException, CoreException {
        this.fIndex.acquireWriteLock();
        try {
            this.fIndex.getWritableFragment().setProperty("org.eclipse.cdt.internal.core.index.resume", String.valueOf(value));
        }
        finally {
            this.fIndex.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFiles(HashMap<Integer, List<IIndexFileLocation>> files, List<IIndexFragmentFile> iFilesToRemove, IProgressMonitor monitor) throws CoreException {
        boolean forceAll = (this.fUpdateFlags & 1) != 0;
        boolean checkTimestamps = (this.fUpdateFlags & 2) != 0;
        boolean checkFileContentsHash = (this.fUpdateFlags & 0x10) != 0;
        boolean forceUnresolvedIncludes = (this.fUpdateFlags & 0x80) != 0;
        boolean both = this.fIndexHeadersWithoutContext == UnusedHeaderStrategy.useBoth;
        int count = 0;
        int forceFirst = this.fForceNumberFiles;
        BitSet linkages = new BitSet();
        Object[] objectArray = this.fFilesToUpdate;
        int n = this.fFilesToUpdate.length;
        int n2 = 0;
        while (n2 < n) {
            Object tu = objectArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            boolean force = forceAll || --forceFirst >= 0;
            IIndexFileLocation ifl = this.fResolver.resolveFile(tu);
            if (ifl != null) {
                int linkageID;
                IIndexFragmentFile[] indexFiles = this.fIndex.getWritableFiles(ifl);
                boolean isSourceUnit = this.fResolver.isSourceUnit(tu);
                linkages.clear();
                boolean regularContent = this.isRequiredInIndex(tu, ifl, isSourceUnit);
                boolean indexedUnconditionally = this.fResolver.isIndexedUnconditionally(ifl);
                if (regularContent || indexedUnconditionally) {
                    UpdateKind updateKind;
                    UpdateKind updateKind2 = isSourceUnit ? UpdateKind.REQUIRED_SOURCE : (updateKind = regularContent && both ? UpdateKind.REQUIRED_HEADER : UpdateKind.ONE_LINKAGE_HEADER);
                    if (regularContent || indexFiles.length == 0) {
                        AbstractLanguage[] langs;
                        AbstractLanguage[] abstractLanguageArray = langs = this.fResolver.getLanguages(tu, this.fIndexHeadersWithoutContext);
                        int n3 = langs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            AbstractLanguage lang = abstractLanguageArray[n4];
                            linkageID = lang.getLinkageID();
                            boolean foundInLinkage = false;
                            int i = 0;
                            while (i < indexFiles.length) {
                                IIndexFragmentFile ifile = indexFiles[i];
                                if (ifile != null && ifile.getLinkageID() == linkageID && ifile.hasContent()) {
                                    boolean update;
                                    foundInLinkage = true;
                                    indexFiles[i] = null;
                                    boolean bl = update = force || forceUnresolvedIncludes && ifile.hasUnresolvedInclude() || this.isModified(checkTimestamps, checkFileContentsHash, ifl, tu, ifile);
                                    if (update && this.requestUpdate(linkageID, ifl, ifile, tu, updateKind)) {
                                        ++count;
                                        linkages.set(linkageID);
                                    }
                                }
                                ++i;
                            }
                            if (!foundInLinkage && this.requestUpdate(linkageID, ifl, null, tu, updateKind)) {
                                linkages.set(linkageID);
                                ++count;
                            }
                            ++n4;
                        }
                    }
                }
                IIndexFragmentFile[] iIndexFragmentFileArray = indexFiles;
                int n5 = indexFiles.length;
                int n6 = 0;
                while (n6 < n5) {
                    IIndexFragmentFile ifile = iIndexFragmentFileArray[n6];
                    if (ifile != null) {
                        IIndexInclude ctx = ifile.getParsedInContext();
                        if (ctx == null && !indexedUnconditionally && ifile.hasContent()) {
                            iFilesToRemove.add(ifile);
                            ++count;
                        } else {
                            boolean update = force || forceUnresolvedIncludes && ifile.hasUnresolvedInclude() || this.isModified(checkTimestamps, checkFileContentsHash, ifl, tu, ifile);
                            linkageID = ifile.getLinkageID();
                            if (update && this.requestUpdate(linkageID, ifl, ifile, tu, UpdateKind.OTHER_HEADER)) {
                                ++count;
                                linkages.set(linkageID);
                            }
                        }
                    }
                    ++n6;
                }
                int lid = linkages.nextSetBit(0);
                while (lid >= 0) {
                    this.addPerLinkage(lid, ifl, files);
                    lid = linkages.nextSetBit(lid + 1);
                }
            }
            ++n2;
        }
        AbstractIndexerTask abstractIndexerTask = this;
        synchronized (abstractIndexerTask) {
            this.incrementRequestedFilesCount(count - this.fFilesToUpdate.length);
            this.fFilesToUpdate = null;
        }
    }

    private void addPerLinkage(int linkageID, IIndexFileLocation ifl, HashMap<Integer, List<IIndexFileLocation>> files) {
        List<IIndexFileLocation> list = files.get(linkageID);
        if (list == null) {
            list = new LinkedList<IIndexFileLocation>();
            files.put(linkageID, list);
        }
        list.add(ifl);
    }

    private boolean isRequiredInIndex(Object tu, IIndexFileLocation ifl, boolean isSourceUnit) {
        if (this.fResolver.isIndexedOnlyIfIncluded(tu)) {
            return false;
        }
        if (this.fIndexHeadersWithoutContext != UnusedHeaderStrategy.skip) {
            return true;
        }
        return isSourceUnit && (this.fIndexFilesWithoutConfiguration || this.fResolver.isFileBuildConfigured(tu));
    }

    private boolean isModified(boolean checkTimestamps, boolean checkFileContentsHash, IIndexFileLocation ifl, Object tu, IIndexFragmentFile file) throws CoreException {
        if (checkTimestamps && (this.fResolver.getLastModified(ifl) != file.getTimestamp() || this.computeFileSizeAndEncodingHashcode(ifl) != file.getSizeAndEncodingHashcode())) {
            return !checkFileContentsHash || this.computeFileContentsHash(tu) != file.getContentsHash();
        }
        return false;
    }

    private long computeFileContentsHash(Object tu) {
        FileContent codeReader = this.fResolver.getCodeReader(tu);
        return codeReader != null ? codeReader.getContentsHash() : 0L;
    }

    private boolean requestUpdate(int linkageID, IIndexFileLocation ifl, IIndexFragmentFile ifile, Object tu, UpdateKind kind) {
        LinkageTask fileMap = this.createRequestMap(linkageID);
        return fileMap.requestUpdate(ifl, ifile, tu, kind, this.fOneLinkageTasks);
    }

    private LinkageTask createRequestMap(int linkageID) {
        LinkageTask map = this.findRequestMap(linkageID);
        if (map == null) {
            map = new LinkageTask(linkageID);
            this.fRequestsPerLinkage.add(map);
        }
        return map;
    }

    private LinkageTask findRequestMap(int linkageID) {
        for (LinkageTask map : this.fRequestsPerLinkage) {
            if (map.fLinkageID != linkageID) continue;
            return map;
        }
        return null;
    }

    @Override
    protected void reportFileWrittenToIndex(PDOMWriter.FileInAST file, IIndexFragmentFile ifile) throws CoreException {
        FileContentKey fck = file.fileContentKey;
        IIndexFileLocation location = fck.getLocation();
        boolean wasCounted = false;
        UpdateKind kind = UpdateKind.OTHER_HEADER;
        LinkageTask map = this.findRequestMap(fck.getLinkageID());
        LocationTask locTask = null;
        if (map != null && (locTask = map.find(location)) != null) {
            kind = locTask.fKind;
            FileVersionTask v = locTask.findVersion(ifile);
            if (v != null) {
                wasCounted = v.fOutdated;
                v.setUpdated();
            } else {
                wasCounted = locTask.fCountedUnknownVersion;
                locTask.fCountedUnknownVersion = false;
            }
            locTask.fStoredAVersion = true;
        }
        this.fIndexContentCache.remove(ifile);
        this.fIndexFilesCache.remove(file.fileContentKey.getLocation());
        LocationTask task = this.fOneLinkageTasks.remove(location);
        if (task != null && task != locTask && task.fKind == UpdateKind.ONE_LINKAGE_HEADER && !task.isCompleted()) {
            task.fKind = UpdateKind.OTHER_HEADER;
            if (task.isCompleted()) {
                if (!wasCounted) {
                    kind = UpdateKind.ONE_LINKAGE_HEADER;
                    wasCounted = true;
                } else {
                    this.reportFile(wasCounted, UpdateKind.ONE_LINKAGE_HEADER);
                }
            }
        }
        this.reportFile(wasCounted, kind);
    }

    private void removeFilesInIndex(List<Object> filesToRemove, List<IIndexFragmentFile> indexFilesToRemove, IProgressMonitor monitor) throws InterruptedException, CoreException {
        if (!filesToRemove.isEmpty() || !indexFilesToRemove.isEmpty()) {
            this.fIndex.acquireWriteLock();
            try {
                for (Object tu : filesToRemove) {
                    IIndexFragmentFile[] ifiles;
                    if (monitor.isCanceled()) {
                        return;
                    }
                    IIndexFileLocation ifl = this.fResolver.resolveFile(tu);
                    if (ifl == null) continue;
                    IIndexFragmentFile[] iIndexFragmentFileArray = ifiles = this.fIndex.getWritableFiles(ifl);
                    int n = ifiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IIndexFragmentFile ifile = iIndexFragmentFileArray[n2];
                        this.fIndex.clearFile(ifile);
                        ++n2;
                    }
                    this.incrementRequestedFilesCount(-1);
                }
                for (IIndexFragmentFile ifile : indexFilesToRemove) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    this.fIndex.clearFile(ifile);
                    this.incrementRequestedFilesCount(-1);
                }
            }
            finally {
                this.fIndex.releaseWriteLock();
            }
        }
        filesToRemove.clear();
    }

    private void parseLinkage(int linkageID, List<IIndexFileLocation> files, IProgressMonitor monitor) throws CoreException, InterruptedException {
        Object scannerInfo;
        Object tu;
        LocationTask locTask;
        IIndexFileLocation ifl;
        LinkageTask map = this.findRequestMap(linkageID);
        if (map == null || files == null || files.isEmpty()) {
            return;
        }
        Iterator<IIndexFileLocation> it = files.iterator();
        while (it.hasNext()) {
            ifl = it.next();
            locTask = map.find(ifl);
            if (locTask == null || locTask.isCompleted()) {
                it.remove();
                continue;
            }
            if (locTask.fKind != UpdateKind.REQUIRED_SOURCE) continue;
            if (monitor.isCanceled() || this.hasUrgentTasks()) {
                return;
            }
            tu = locTask.fTu;
            scannerInfo = this.getScannerInfo(linkageID, tu);
            this.parseFile(tu, this.getLanguage(tu, linkageID), ifl, (IScannerInfo)scannerInfo, null, monitor);
        }
        it = files.iterator();
        while (it.hasNext()) {
            ifl = it.next();
            locTask = map.find(ifl);
            if (locTask == null || locTask.isCompleted()) {
                it.remove();
                continue;
            }
            for (FileVersionTask versionTask : locTask.fVersionTasks) {
                if (!versionTask.fOutdated) continue;
                if (monitor.isCanceled() || this.hasUrgentTasks()) {
                    return;
                }
                this.parseVersionInContext(linkageID, map, ifl, versionTask, locTask.fTu, new LinkedHashSet<IIndexFile>(), monitor);
            }
        }
        it = files.iterator();
        while (it.hasNext()) {
            ifl = it.next();
            locTask = map.find(ifl);
            if (locTask == null || locTask.isCompleted()) {
                it.remove();
                continue;
            }
            if (!locTask.needsVersion()) continue;
            if (monitor.isCanceled() || this.hasUrgentTasks()) {
                return;
            }
            tu = locTask.fTu;
            scannerInfo = this.getScannerInfo(linkageID, tu);
            this.parseFile(tu, this.getLanguage(tu, linkageID), ifl, (IScannerInfo)scannerInfo, null, monitor);
            if (!locTask.isCompleted()) continue;
            it.remove();
        }
        this.fIndex.acquireWriteLock();
        try {
            for (IIndexFileLocation ifl2 : files) {
                locTask = map.find(ifl2);
                if (locTask == null || locTask.isCompleted() || locTask.needsVersion()) continue;
                if (monitor.isCanceled() || this.hasUrgentTasks()) {
                    return;
                }
                Iterator<FileVersionTask> it2 = locTask.fVersionTasks.iterator();
                while (it2.hasNext()) {
                    FileVersionTask v = (FileVersionTask)it2.next();
                    if (!v.fOutdated) continue;
                    this.fIndex.clearFile(v.fIndexFile);
                    this.reportFile(true, locTask.fKind);
                    locTask.removeVersionTask(it2);
                    this.fIndexContentCache.remove(v.fIndexFile);
                    this.fIndexFilesCache.remove(ifl2);
                }
            }
        }
        finally {
            this.fIndex.releaseWriteLock();
        }
    }

    private void parseVersionInContext(int linkageID, LinkageTask map, IIndexFileLocation ifl, FileVersionTask versionTask, Object tu, LinkedHashSet<IIndexFile> safeGuard, IProgressMonitor monitor) throws CoreException, InterruptedException {
        IIndexFragmentFile headerFile = versionTask.fIndexFile;
        int safeguardSize = safeGuard.size();
        IIndexFragmentFile ctxFile;
        while ((ctxFile = this.findContextFile(linkageID, map, versionTask, safeGuard, monitor)) != null && ctxFile != headerFile) {
            Object contextTu = this.fResolver.getInputFile(ctxFile.getLocation());
            if (contextTu == null) {
                return;
            }
            IScannerInfo scannerInfo = this.getScannerInfo(linkageID, contextTu);
            AbstractLanguage language = this.getLanguage(contextTu, linkageID);
            PDOMWriter.FileContext ctx = new PDOMWriter.FileContext(ctxFile, headerFile);
            HashSet<IIndexFragmentFile> dependencies = null;
            boolean done = false;
            while (!done) {
                done = true;
                InternalFileContentProvider.DependsOnOutdatedFileException d = this.parseFile(tu, language, ifl, scannerInfo, ctx, monitor);
                if (d == null) continue;
                if (dependencies == null) {
                    dependencies = new HashSet<IIndexFragmentFile>();
                }
                if (!dependencies.add(d.fIndexFile) || this.parseFile(d.fTu, language, d.fIndexFile.getLocation(), scannerInfo, new PDOMWriter.FileContext(ctxFile, d.fIndexFile), monitor) != null) continue;
                done = false;
            }
            if (!ctx.fLostPragmaOnceSemantics) {
                return;
            }
            this.restoreSet(safeGuard, safeguardSize);
        }
        return;
    }

    private IScannerInfo getScannerInfo(int linkageID, Object contextTu) {
        IScannerInfo scannerInfo = this.fResolver.getBuildConfiguration(linkageID, contextTu);
        if (scannerInfo instanceof ExtendedScannerInfo) {
            ((ExtendedScannerInfo)scannerInfo).setIncludeExportPatterns(this.getIncludeExportPatterns());
        }
        return scannerInfo;
    }

    private void restoreSet(LinkedHashSet<?> set, int restoreSize) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            it.next();
            if (restoreSize == 0) {
                it.remove();
                continue;
            }
            --restoreSize;
        }
    }

    private IIndexFragmentFile findContextFile(int linkageID, LinkageTask map, FileVersionTask versionTask, LinkedHashSet<IIndexFile> safeGuard, IProgressMonitor monitor) throws CoreException, InterruptedException {
        IIndexFragmentFile ctxFile = versionTask.fIndexFile;
        IIndexInclude ctxInclude;
        while ((ctxInclude = ctxFile.getParsedInContext()) != null) {
            FileVersionTask ctxVersionTask;
            IIndexFragmentFile nextCtx = (IIndexFragmentFile)ctxInclude.getIncludedBy();
            if (nextCtx == null) {
                return nextCtx;
            }
            if (!safeGuard.add(nextCtx)) {
                return null;
            }
            IIndexFileLocation ctxIfl = nextCtx.getLocation();
            LocationTask ctxTask = map.find(ctxIfl);
            if (ctxTask != null && (ctxVersionTask = ctxTask.findVersion(nextCtx)) != null && ctxVersionTask.fOutdated) {
                this.parseVersionInContext(linkageID, map, ctxIfl, ctxVersionTask, ctxTask.fTu, safeGuard, monitor);
                if (ctxVersionTask.fOutdated || !versionTask.fOutdated) {
                    return null;
                }
                nextCtx = ctxFile;
            }
            ctxFile = nextCtx;
        }
        return ctxFile;
    }

    private InternalFileContentProvider.DependsOnOutdatedFileException parseFile(Object tu, AbstractLanguage lang, IIndexFileLocation ifl, IScannerInfo scanInfo, PDOMWriter.FileContext ctx, IProgressMonitor pm) throws CoreException, InterruptedException {
        IPath path = this.getLabel(ifl);
        Object th = null;
        try {
            if (this.fShowActivity) {
                this.trace("Indexer: parsing " + path.toOSString());
            }
            pm.subTask(this.getMessage(MessageKind.parsingFileTask, path.lastSegment(), path.removeLastSegments(1).toString()));
            FileContent codeReader = this.fResolver.getCodeReader(tu);
            boolean isSource = this.fResolver.isSourceUnit(tu);
            long start = System.currentTimeMillis();
            IASTTranslationUnit ast = this.createAST(lang, codeReader, scanInfo, isSource, this.fASTOptions, ctx, pm);
            this.fStatistics.fParsingTime = (int)((long)this.fStatistics.fParsingTime + (System.currentTimeMillis() - start));
            if (ast != null) {
                ((ASTTranslationUnit)ast).setOriginatingTranslationUnit((ITranslationUnit)tu);
                this.writeToIndex(lang.getLinkageID(), ast, codeReader, ctx, pm);
            }
        }
        catch (CoreException e) {
            th = e;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InternalFileContentProvider.DependsOnOutdatedFileException) {
                return (InternalFileContentProvider.DependsOnOutdatedFileException)cause;
            }
            th = e;
        }
        catch (StackOverflowError e) {
            th = e;
        }
        catch (AssertionError e) {
            th = e;
        }
        catch (OutOfMemoryError e) {
            if (--this.fSwallowOutOfMemoryError < 0) {
                throw e;
            }
            th = e;
        }
        if (th != null) {
            this.swallowError(path, (Throwable)th);
        }
        return null;
    }

    private AbstractLanguage getLanguage(Object tu, int linkageID) {
        AbstractLanguage[] abstractLanguageArray = this.fResolver.getLanguages(tu, UnusedHeaderStrategy.useBoth);
        int n = abstractLanguageArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractLanguage language = abstractLanguageArray[n2];
            if (language.getLinkageID() == linkageID) {
                return language;
            }
            ++n2;
        }
        return null;
    }

    private IPath getLabel(IIndexFileLocation ifl) {
        String fullPath = ifl.getFullPath();
        if (fullPath != null) {
            return new Path(fullPath);
        }
        IPath path = IndexLocationFactory.getAbsolutePath(ifl);
        if (path != null) {
            return path;
        }
        URI uri = ifl.getURI();
        return new Path(EFSExtensionManager.getDefault().getPathFromURI(uri));
    }

    private void swallowError(IPath file, Throwable e) throws CoreException {
        IStatus s;
        if (e instanceof CoreException) {
            Throwable masked;
            s = ((CoreException)e).getStatus();
            if (s.getCode() == 4 && "org.eclipse.cdt.core".equals(s.getPlugin())) {
                throw (CoreException)e;
            }
            Throwable exception = s.getException();
            if (exception != null && (masked = this.getMaskedException(exception)) != exception) {
                e = masked;
                exception = null;
            }
            if (exception == null) {
                s = new Status(s.getSeverity(), s.getPlugin(), s.getCode(), s.getMessage(), e);
            }
        } else {
            e = this.getMaskedException(e);
            s = this.createStatus(this.getMessage(MessageKind.errorWhileParsing, file), e);
        }
        this.logError(s);
        if (++this.fStatistics.fErrorCount > 500) {
            throw new CoreException(this.createStatus(this.getMessage(MessageKind.tooManyIndexProblems, new Object[0])));
        }
    }

    private Throwable getMaskedException(Throwable e) {
        if (e instanceof OutOfMemoryError || e instanceof StackOverflowError || e instanceof AssertionError) {
            return new InvocationTargetException(e);
        }
        return e;
    }

    private final IASTTranslationUnit createAST(AbstractLanguage language, FileContent codeReader, IScannerInfo scanInfo, boolean isSource, int options, PDOMWriter.FileContext ctx, IProgressMonitor pm) throws CoreException {
        IIndexFile[] iIndexFileArray;
        if (codeReader == null) {
            return null;
        }
        if (isSource) {
            options |= 8;
        }
        if (this.fFileSizeLimit > 0L && this.fResolver.getFileSize(codeReader.getFileLocation()) > this.fFileSizeLimit) {
            if (this.fShowActivity) {
                this.trace("Indexer: Skipping large file " + codeReader.getFileLocation());
            }
            return null;
        }
        if (ctx == null) {
            iIndexFileArray = null;
        } else {
            IIndexFile[] iIndexFileArray2 = new IIndexFile[2];
            iIndexFileArray2[0] = ctx.fContext;
            iIndexFileArray = iIndexFileArray2;
            iIndexFileArray2[1] = ctx.fOldFile;
        }
        IIndexFile[] ctx2header = iIndexFileArray;
        if (this.fCodeReaderFactory == null) {
            InternalFileContentProvider fileContentProvider = this.createInternalFileContentProvider();
            if (this.fIsFastIndexer) {
                IndexBasedFileContentProvider ibfcp = new IndexBasedFileContentProvider(this.fIndex, this.fResolver, language.getLinkageID(), fileContentProvider, this);
                ibfcp.setContextToHeaderGap(ctx2header);
                ibfcp.setFileSizeLimit(this.fFileSizeLimit);
                this.fCodeReaderFactory = ibfcp;
            } else {
                this.fCodeReaderFactory = fileContentProvider;
            }
            this.fCodeReaderFactory.setIncludeResolutionHeuristics(this.createIncludeHeuristics());
        } else if (this.fIsFastIndexer) {
            IndexBasedFileContentProvider ibfcp = (IndexBasedFileContentProvider)this.fCodeReaderFactory;
            ibfcp.setContextToHeaderGap(ctx2header);
            ibfcp.setLinkage(language.getLinkageID());
        }
        IASTTranslationUnit ast = language.getASTTranslationUnit(codeReader, scanInfo, (IncludeFileContentProvider)this.fCodeReaderFactory, (IIndex)this.fIndex, options, this.getLogService());
        if (pm.isCanceled()) {
            return null;
        }
        return ast;
    }

    private InternalFileContentProvider createInternalFileContentProvider() {
        IncludeFileContentProvider fileContentProvider = this.createReaderFactory();
        if (fileContentProvider instanceof InternalFileContentProvider) {
            return (InternalFileContentProvider)fileContentProvider;
        }
        throw new IllegalArgumentException("Invalid file content provider");
    }

    private void writeToIndex(int linkageID, IASTTranslationUnit ast, FileContent codeReader, PDOMWriter.FileContext ctx, IProgressMonitor pm) throws CoreException, InterruptedException {
        IASTTranslationUnit.IDependencyTree.IASTInclusionNode[] inclusions;
        HashSet<FileContentKey> enteredFiles = new HashSet<FileContentKey>();
        ArrayList<PDOMWriter.FileInAST> orderedFileKeys = new ArrayList<PDOMWriter.FileInAST>();
        IIndexFileLocation topIfl = this.fResolver.resolveASTPath(ast.getFilePath());
        FileContentKey topKey = new FileContentKey(linkageID, topIfl, ast.getSignificantMacros());
        enteredFiles.add(topKey);
        IASTTranslationUnit.IDependencyTree tree = ast.getDependencyTree();
        IASTTranslationUnit.IDependencyTree.IASTInclusionNode[] iASTInclusionNodeArray = inclusions = tree.getInclusions();
        int n = inclusions.length;
        int n2 = 0;
        while (n2 < n) {
            IASTTranslationUnit.IDependencyTree.IASTInclusionNode inclusion = iASTInclusionNodeArray[n2];
            this.collectOrderedFileKeys(linkageID, inclusion, enteredFiles, orderedFileKeys);
            ++n2;
        }
        IIndexFragmentFile newFile = this.selectIndexFile(linkageID, topIfl, ast.getSignificantMacros());
        if (ctx != null) {
            orderedFileKeys.add(new PDOMWriter.FileInAST(topKey, codeReader));
            ctx.fNewFile = newFile;
        } else if (newFile == null) {
            orderedFileKeys.add(new PDOMWriter.FileInAST(topKey, codeReader));
        }
        PDOMWriter.FileInAST[] fileKeys = orderedFileKeys.toArray(new PDOMWriter.FileInAST[orderedFileKeys.size()]);
        try {
            this.addSymbols(ast, fileKeys, this.fIndex, false, ctx, this.fTodoTaskUpdater, pm);
        }
        catch (CoreException e) {
            this.withdrawRequests(linkageID, fileKeys);
            throw e;
        }
        catch (RuntimeException e) {
            this.withdrawRequests(linkageID, fileKeys);
            throw e;
        }
        catch (Error e) {
            this.withdrawRequests(linkageID, fileKeys);
            throw e;
        }
    }

    private void collectOrderedFileKeys(int linkageID, IASTTranslationUnit.IDependencyTree.IASTInclusionNode inclusion, HashSet<FileContentKey> enteredFiles, ArrayList<PDOMWriter.FileInAST> orderedFileKeys) throws CoreException {
        IASTPreprocessorIncludeStatement include = inclusion.getIncludeDirective();
        if (include.createsAST()) {
            IASTTranslationUnit.IDependencyTree.IASTInclusionNode[] nested;
            IIndexFileLocation ifl = this.fResolver.resolveASTPath(include.getPath());
            FileContentKey fileKey = new FileContentKey(linkageID, ifl, include.getSignificantMacros());
            boolean isFirstEntry = enteredFiles.add(fileKey);
            IASTTranslationUnit.IDependencyTree.IASTInclusionNode[] iASTInclusionNodeArray = nested = inclusion.getNestedInclusions();
            int n = nested.length;
            int n2 = 0;
            while (n2 < n) {
                IASTTranslationUnit.IDependencyTree.IASTInclusionNode element = iASTInclusionNodeArray[n2];
                this.collectOrderedFileKeys(linkageID, element, enteredFiles, orderedFileKeys);
                ++n2;
            }
            if (isFirstEntry && this.selectIndexFile(linkageID, ifl, include.getSignificantMacros()) == null) {
                orderedFileKeys.add(new PDOMWriter.FileInAST(include, fileKey));
            }
        }
    }

    private void withdrawRequests(int linkageID, PDOMWriter.FileInAST[] fileKeys) {
        LinkageTask map = this.findRequestMap(linkageID);
        if (map != null) {
            PDOMWriter.FileInAST[] fileInASTArray = fileKeys;
            int n = fileKeys.length;
            int n2 = 0;
            while (n2 < n) {
                PDOMWriter.FileInAST fileKey = fileInASTArray[n2];
                LocationTask locTask = map.find(fileKey.fileContentKey.getLocation());
                if (locTask != null) {
                    if (locTask.fCountedUnknownVersion) {
                        locTask.fCountedUnknownVersion = false;
                        this.reportFile(true, locTask.fKind);
                    } else {
                        for (FileVersionTask fc : locTask.fVersionTasks) {
                            if (!fc.fOutdated) continue;
                            this.reportFile(true, locTask.fKind);
                            fc.setUpdated();
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public final IndexFileContent getFileContent(int linkageID, IIndexFileLocation ifl, IIndexFile file) throws CoreException, InternalFileContentProvider.DependsOnOutdatedFileException {
        FileVersionTask task;
        LocationTask request;
        LinkageTask map = this.findRequestMap(linkageID);
        if (map != null && (request = map.find(ifl)) != null && (task = request.findVersion(file)) != null && task.fOutdated) {
            throw new InternalFileContentProvider.DependsOnOutdatedFileException(request.fTu, task.fIndexFile);
        }
        IndexFileContent fc = this.fIndexContentCache.get(file);
        if (fc == null) {
            fc = new IndexFileContent(file);
            this.fIndexContentCache.put(file, fc);
        }
        return fc;
    }

    IIndexFragmentFile selectIndexFile(int linkageID, IIndexFileLocation ifl, ISignificantMacros sigMacros) throws CoreException {
        IIndexFragmentFile[] files;
        FileVersionTask task;
        LocationTask locTask;
        LinkageTask map = this.findRequestMap(linkageID);
        if (map != null && (locTask = map.find(ifl)) != null && (task = locTask.findVersion(sigMacros)) != null) {
            return task.fOutdated ? null : task.fIndexFile;
        }
        IIndexFragmentFile[] iIndexFragmentFileArray = files = this.getAvailableIndexFiles(linkageID, ifl);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragmentFile file = iIndexFragmentFileArray[n2];
            if (sigMacros.equals(file.getSignificantMacros())) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    public IIndexFile selectIndexFile(int linkageID, IIndexFileLocation ifl, IMacroDictionary md) throws CoreException {
        IIndexFragmentFile[] files;
        LocationTask request;
        LinkageTask map = this.findRequestMap(linkageID);
        if (map != null && (request = map.find(ifl)) != null) {
            for (FileVersionTask fileVersion : request.fVersionTasks) {
                IIndexFragmentFile indexFile = fileVersion.fIndexFile;
                if (!md.satisfies(indexFile.getSignificantMacros())) continue;
                if (fileVersion.fOutdated) {
                    return null;
                }
                return indexFile;
            }
        }
        IIndexFragmentFile[] iIndexFragmentFileArray = files = this.getAvailableIndexFiles(linkageID, ifl);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragmentFile indexFile = iIndexFragmentFileArray[n2];
            if (md.satisfies(indexFile.getSignificantMacros())) {
                return indexFile;
            }
            ++n2;
        }
        return null;
    }

    public IIndexFragmentFile[] getAvailableIndexFiles(int linkageID, IIndexFileLocation ifl) throws CoreException {
        IIndexFragmentFile[] files = this.fIndexFilesCache.get(ifl);
        if (files == null) {
            IIndexFragmentFile[] fragFiles = this.fIndex.getWritableFiles(linkageID, ifl);
            int j = 0;
            int i = 0;
            while (i < fragFiles.length) {
                if (fragFiles[i].hasContent()) {
                    if (j != i) {
                        fragFiles[j] = fragFiles[i];
                    }
                    ++j;
                }
                ++i;
            }
            if (j == fragFiles.length) {
                files = fragFiles;
            } else {
                files = new IIndexFragmentFile[j];
                System.arraycopy(fragFiles, 0, files, 0, j);
            }
            this.fIndexFilesCache.put(ifl, files);
        }
        return files;
    }

    public static class FileVersionTask {
        private final IIndexFragmentFile fIndexFile;
        private boolean fOutdated;

        FileVersionTask(IIndexFragmentFile file) {
            this.fIndexFile = file;
            this.fOutdated = true;
        }

        void setUpdated() {
            this.fOutdated = false;
        }
    }

    public static class IndexFileContent {
        private Object[] fPreprocessingDirectives;
        private ICPPUsingDirective[] fDirectives;

        public IndexFileContent(IIndexFile ifile) throws CoreException {
            this.setPreprocessorDirectives(ifile.getIncludes(), ifile.getMacros());
            this.setUsingDirectives(ifile.getUsingDirectives());
        }

        public Object[] getPreprocessingDirectives() throws CoreException {
            return this.fPreprocessingDirectives;
        }

        public ICPPUsingDirective[] getUsingDirectives() throws CoreException {
            return this.fDirectives;
        }

        public void setPreprocessorDirectives(IIndexInclude[] includes, IIndexMacro[] macros) throws CoreException {
            this.fPreprocessingDirectives = IndexFileContent.merge(includes, macros);
        }

        public void setUsingDirectives(ICPPUsingDirective[] usingDirectives) {
            this.fDirectives = usingDirectives;
        }

        public static Object[] merge(IIndexInclude[] includes, IIndexMacro[] macros) throws CoreException {
            Object[] merged = new Object[includes.length + macros.length];
            int i = 0;
            int m = 0;
            int ioffset = IndexFileContent.getOffset(includes, i);
            int moffset = IndexFileContent.getOffset(macros, m);
            int k = 0;
            while (k < merged.length) {
                if (ioffset <= moffset) {
                    merged[k] = includes[i];
                    ioffset = IndexFileContent.getOffset(includes, ++i);
                } else {
                    merged[k] = macros[m];
                    moffset = IndexFileContent.getOffset(macros, ++m);
                }
                ++k;
            }
            return merged;
        }

        private static int getOffset(IIndexMacro[] macros, int m) throws CoreException {
            if (m < macros.length) {
                return macros[m].getFileLocation().getNodeOffset();
            }
            return Integer.MAX_VALUE;
        }

        private static int getOffset(IIndexInclude[] includes, int i) throws CoreException {
            if (i < includes.length) {
                return includes[i].getNameOffset();
            }
            return Integer.MAX_VALUE;
        }
    }

    private static class LinkageTask {
        final int fLinkageID;
        private final Map<IIndexFileLocation, LocationTask> fLocationTasks;

        LinkageTask(int linkageID) {
            this.fLinkageID = linkageID;
            this.fLocationTasks = new HashMap<IIndexFileLocation, LocationTask>();
        }

        boolean requestUpdate(IIndexFileLocation ifl, IIndexFragmentFile ifile, Object tu, UpdateKind kind, Map<IIndexFileLocation, LocationTask> oneLinkageTasks) {
            LocationTask locTask = this.fLocationTasks.get(ifl);
            if (locTask == null) {
                locTask = new LocationTask();
                this.fLocationTasks.put(ifl, locTask);
            }
            boolean result = locTask.requestUpdate(ifile, tu, kind);
            if (kind == UpdateKind.ONE_LINKAGE_HEADER && locTask.fVersionTasks.isEmpty()) {
                oneLinkageTasks.put(ifl, locTask);
            }
            return result;
        }

        LocationTask find(IIndexFileLocation ifl) {
            return this.fLocationTasks.get(ifl);
        }
    }

    private static class LocationTask {
        private boolean fCountedUnknownVersion;
        private boolean fStoredAVersion;
        Object fTu;
        UpdateKind fKind = UpdateKind.OTHER_HEADER;
        private List<FileVersionTask> fVersionTasks = Collections.emptyList();

        private LocationTask() {
        }

        boolean requestUpdate(IIndexFragmentFile ifile, Object tu, UpdateKind kind) {
            if (tu != null) {
                this.fTu = tu;
            }
            if (this.fKind == null || kind != null && kind.compareTo(this.fKind) < 0) {
                this.fKind = kind;
            }
            if (ifile == null) {
                assert (this.fVersionTasks.isEmpty());
                boolean countRequest = !this.fCountedUnknownVersion;
                this.fCountedUnknownVersion = true;
                return countRequest;
            }
            return this.addVersionTask(ifile);
        }

        private boolean addVersionTask(IIndexFragmentFile ifile) {
            FileVersionTask fc = this.findVersion(ifile);
            if (fc != null) {
                return false;
            }
            fc = new FileVersionTask(ifile);
            boolean countRequest = true;
            if (this.fCountedUnknownVersion) {
                this.fCountedUnknownVersion = false;
                countRequest = false;
            }
            switch (this.fVersionTasks.size()) {
                case 0: {
                    this.fVersionTasks = Collections.singletonList(fc);
                    break;
                }
                case 1: {
                    ArrayList<FileVersionTask> newList = new ArrayList<FileVersionTask>(2);
                    newList.add(this.fVersionTasks.get(0));
                    newList.add(fc);
                    this.fVersionTasks = newList;
                    break;
                }
                default: {
                    this.fVersionTasks.add(fc);
                }
            }
            return countRequest;
        }

        void removeVersionTask(Iterator<FileVersionTask> it) {
            if (this.fVersionTasks.size() == 1) {
                this.fVersionTasks = Collections.emptyList();
            } else {
                it.remove();
            }
        }

        private FileVersionTask findVersion(IIndexFile ifile) {
            for (FileVersionTask fc : this.fVersionTasks) {
                if (!fc.fIndexFile.equals(ifile)) continue;
                return fc;
            }
            return null;
        }

        FileVersionTask findVersion(ISignificantMacros sigMacros) throws CoreException {
            for (FileVersionTask fc : this.fVersionTasks) {
                if (!sigMacros.equals(fc.fIndexFile.getSignificantMacros())) continue;
                return fc;
            }
            return null;
        }

        boolean isCompleted() {
            for (FileVersionTask fc : this.fVersionTasks) {
                if (!fc.fOutdated) continue;
                return false;
            }
            if (this.fKind == UpdateKind.OTHER_HEADER) {
                return true;
            }
            return this.fStoredAVersion;
        }

        public boolean needsVersion() {
            if (this.fKind == UpdateKind.OTHER_HEADER) {
                return false;
            }
            return !this.fStoredAVersion;
        }
    }

    protected static enum MessageKind {
        parsingFileTask,
        errorWhileParsing,
        tooManyIndexProblems;

    }

    public static enum UnusedHeaderStrategy {
        skip,
        useC,
        useCPP,
        useDefaultLanguage,
        useBoth;

    }

    private static enum UpdateKind {
        REQUIRED_SOURCE,
        REQUIRED_HEADER,
        ONE_LINKAGE_HEADER,
        OTHER_HEADER;

    }
}

