/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.pdom.Checksums;
import org.eclipse.cdt.internal.core.pdom.IPDOM;
import org.eclipse.cdt.internal.core.pdom.WritablePDOM;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.cdt.internal.core.pdom.indexer.Messages;
import org.eclipse.cdt.internal.core.pdom.indexer.PDOMIndexerTask;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;

public class TeamPDOMImportOperation
implements IWorkspaceRunnable {
    static final String CHECKSUMS_NAME = "checksums.dat";
    static final String INDEX_NAME = "cdt-index.pdom";
    private static final Pattern PROJECT_VAR_PATTERN = Pattern.compile("\\$\\{(project_[a-zA-Z0-9]*)\\}");
    private static final String PROJECT_VAR_REPLACEMENT_BEGIN = "\\${$1:";
    private static final String PROJECT_VAR_REPLACEMENT_END = "}";
    private static final String DOLLAR_OR_BACKSLASH_REPLACEMENT = "\\\\$0";
    private static final Pattern DOLLAR_OR_BACKSLASH_PATTERN = Pattern.compile("[\\$\\\\]");
    private ICProject fProject;
    private boolean fSuccess;
    private boolean fShowActivity;

    public TeamPDOMImportOperation(ICProject project) {
        this.fProject = project;
        this.fShowActivity = PDOMIndexerTask.checkDebugOption("org.eclipse.cdt.core/debug/indexer/activity", "true");
    }

    public void run(IProgressMonitor pm) {
        if (this.fShowActivity) {
            System.out.println("Indexer: PDOMImporter start");
        }
        this.fSuccess = false;
        Throwable ex = null;
        try {
            File importFile = this.getImportLocation();
            if (importFile.exists()) {
                this.doImportIndex(importFile, pm);
                this.fSuccess = true;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
        catch (ZipException e) {
            ex = e;
        }
        catch (IOException e) {
            ex = e;
        }
        catch (CoreException e) {
            ex = e;
        }
        if (ex != null) {
            CCorePlugin.log((Throwable)ex);
        }
        if (this.fShowActivity) {
            System.out.println("Indexer: PDOMImporter completed, ok=" + this.fSuccess);
        }
    }

    public boolean wasSuccessful() {
        return this.fSuccess;
    }

    private File getImportLocation() throws CoreException {
        IProject project = this.fProject.getProject();
        String locationString = IndexerPreferences.getIndexImportLocation(project);
        return TeamPDOMImportOperation.expandLocation(project, locationString);
    }

    static File expandLocation(IProject project, String loc) throws CoreException {
        String replacement = PROJECT_VAR_REPLACEMENT_BEGIN + DOLLAR_OR_BACKSLASH_PATTERN.matcher(project.getName()).replaceAll(DOLLAR_OR_BACKSLASH_REPLACEMENT) + PROJECT_VAR_REPLACEMENT_END;
        loc = PROJECT_VAR_PATTERN.matcher(loc).replaceAll(replacement);
        IStringVariableManager varManager = VariablesPlugin.getDefault().getStringVariableManager();
        Path location = new Path(varManager.performStringSubstitution(loc));
        if (!location.isAbsolute() && project.getLocation() != null) {
            location = project.getLocation().append((IPath)location);
        }
        return location.toFile();
    }

    private void doImportIndex(File importFile, IProgressMonitor monitor) throws CoreException, InterruptedException, IOException {
        ZipFile zip = new ZipFile(importFile);
        Map<?, ?> checksums = null;
        try {
            this.importIndex(zip, monitor);
            checksums = this.getChecksums(zip);
        }
        finally {
            try {
                zip.close();
            }
            catch (IOException e) {
                CCorePlugin.log((Throwable)e);
            }
        }
        this.checkIndex(checksums, monitor);
    }

    private void importIndex(ZipFile zip, IProgressMonitor monitor) throws CoreException, IOException {
        ZipEntry indexEntry = zip.getEntry(INDEX_NAME);
        if (indexEntry == null) {
            throw new CoreException(CCorePlugin.createStatus((String)NLS.bind((String)Messages.PDOMImportTask_errorInvalidArchive, (Object)zip.getName())));
        }
        InputStream stream = zip.getInputStream(indexEntry);
        CCoreInternals.getPDOMManager().importProjectPDOM(this.fProject, stream, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<?, ?> getChecksums(ZipFile zip) {
        ZipEntry indexEntry = zip.getEntry(CHECKSUMS_NAME);
        if (indexEntry == null) return Collections.EMPTY_MAP;
        try (ObjectInputStream input = new ObjectInputStream(zip.getInputStream(indexEntry));){
            Object obj = input.readObject();
            if (!(obj instanceof Map)) return Collections.EMPTY_MAP;
            Map map = (Map)obj;
            return map;
        }
        catch (Exception e) {
            CCorePlugin.log((Throwable)e);
        }
        return Collections.EMPTY_MAP;
    }

    private void checkIndex(Map<?, ?> checksums, IProgressMonitor monitor) throws CoreException, InterruptedException {
        IPDOM obj = CCoreInternals.getPDOMManager().getPDOM(this.fProject);
        if (!(obj instanceof WritablePDOM)) {
            return;
        }
        WritablePDOM pdom = (WritablePDOM)obj;
        pdom.acquireReadLock();
        try {
            ArrayList<FileAndChecksum> filesToCheck = new ArrayList<FileAndChecksum>();
            if (!pdom.isSupportedVersion()) {
                throw new CoreException(CCorePlugin.createStatus((String)NLS.bind((String)Messages.PDOMImportTask_errorInvalidPDOMVersion, (Object)this.fProject.getElementName())));
            }
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IIndexFragmentFile[] filesToDelete = pdom.getAllFiles();
            int i = 0;
            while (i < filesToDelete.length) {
                this.checkMonitor(monitor);
                IIndexFragmentFile ifile = filesToDelete[i];
                byte[] checksum = null;
                ITranslationUnit tu = null;
                IIndexFileLocation ifl = ifile.getLocation();
                String fullPathStr = ifl.getFullPath();
                if (fullPathStr != null) {
                    Path fullPath = new Path(fullPathStr);
                    IFile file = root.getFile((IPath)fullPath);
                    boolean exists = file.exists();
                    if (!exists) {
                        try {
                            file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                            exists = file.exists();
                        }
                        catch (CoreException e) {
                            CCorePlugin.log((Throwable)e);
                        }
                    }
                    if (exists && (tu = (ITranslationUnit)CoreModel.getDefault().create(file)) != null) {
                        checksum = Checksums.getChecksum(checksums, file);
                    }
                }
                if (checksum != null) {
                    filesToCheck.add(new FileAndChecksum(tu, ifile, checksum));
                    filesToDelete[i] = null;
                }
                ++i;
            }
            List<FileAndChecksum> updateTimestamps = this.getUnchangedWithDifferentTimestamp(checksums, filesToCheck, monitor);
            this.updateIndex(pdom, 1, filesToDelete, updateTimestamps, monitor);
        }
        finally {
            pdom.releaseReadLock();
        }
    }

    private void checkMonitor(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private void updateIndex(WritablePDOM pdom, int giveupReadlocks, IIndexFragmentFile[] filesToDelete, List<FileAndChecksum> updateTimestamps, IProgressMonitor monitor) throws InterruptedException, CoreException {
        pdom.acquireWriteLock(giveupReadlocks, null);
        try {
            IIndexFragmentFile[] iIndexFragmentFileArray = filesToDelete;
            int n = filesToDelete.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexFragmentFile ifile = iIndexFragmentFileArray[n2];
                if (ifile != null) {
                    this.checkMonitor(monitor);
                    pdom.clearFile(ifile);
                }
                ++n2;
            }
            for (FileAndChecksum fc : updateTimestamps) {
                IResource r;
                this.checkMonitor(monitor);
                IIndexFragmentFile file = fc.fIFile;
                if (file == null || (r = fc.fFile.getResource()) == null) continue;
                file.setTimestamp(r.getLocalTimeStamp());
            }
        }
        finally {
            pdom.releaseWriteLock(giveupReadlocks, true);
        }
    }

    private List<FileAndChecksum> getUnchangedWithDifferentTimestamp(Map<?, ?> checksums, List<FileAndChecksum> filesToCheck, IProgressMonitor monitor) {
        MessageDigest md;
        try {
            md = Checksums.getAlgorithm(checksums);
        }
        catch (NoSuchAlgorithmException e) {
            CCorePlugin.log((Throwable)e);
            return Collections.emptyList();
        }
        ArrayList<FileAndChecksum> result = new ArrayList<FileAndChecksum>();
        for (FileAndChecksum cs : filesToCheck) {
            IPath location;
            this.checkMonitor(monitor);
            ITranslationUnit tu = cs.fFile;
            if (tu == null || (location = tu.getLocation()) == null) continue;
            try {
                byte[] checksum;
                IResource res;
                File file = location.toFile();
                if (!file.isFile() || (res = cs.fFile.getResource()) != null && res.getLocalTimeStamp() == cs.fIFile.getTimestamp() || !Arrays.equals(checksum = Checksums.computeChecksum(md, file), cs.fChecksum)) continue;
                result.add(cs);
            }
            catch (IOException e) {
                CCorePlugin.log((Throwable)e);
                result.add(cs);
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
                result.add(cs);
            }
        }
        return result;
    }

    private static final class FileAndChecksum {
        public ITranslationUnit fFile;
        public IIndexFragmentFile fIFile;
        public byte[] fChecksum;

        public FileAndChecksum(ITranslationUnit tu, IIndexFragmentFile ifile, byte[] checksum) {
            this.fFile = tu;
            this.fIFile = ifile;
            this.fChecksum = checksum;
        }
    }
}

