/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.internal.core.indexer.FileEncodingRegistry;
import org.eclipse.ptp.internal.rdt.core.IRemoteIndexerInfoProvider;
import org.eclipse.ptp.internal.rdt.core.RemoteScannerInfo;

public class RemoteIndexerInfoProvider
implements IRemoteIndexerInfoProvider,
Serializable {
    private static final long serialVersionUID = 2L;
    private Map<String, RemoteScannerInfo> pathMap;
    private Map<Integer, RemoteScannerInfo> linkageMap;
    private Map<String, String> languageMap;
    private Map<String, Map<String, String>> languagePropertyMap;
    private Set<String> headerSet;
    private Set<String> indexerPreferences;
    private FileEncodingRegistry fFileEncodingRegistry;
    private Set<String> fValidSourceUnitNames;

    public RemoteIndexerInfoProvider() {
    }

    public RemoteIndexerInfoProvider(Map<String, RemoteScannerInfo> pathMap, Map<Integer, RemoteScannerInfo> linkageMap, Map<String, String> languageMap, Map<String, Map<String, String>> languagePropertyMap, Set<String> headerSet, Set<String> indexerPreferences, FileEncodingRegistry fileEncodingRegistry, Set<String> fValidSourceUnitNames) {
        this.pathMap = pathMap;
        this.linkageMap = linkageMap;
        this.languageMap = languageMap;
        this.languagePropertyMap = languagePropertyMap;
        this.headerSet = headerSet;
        this.indexerPreferences = indexerPreferences;
        this.fFileEncodingRegistry = fileEncodingRegistry;
        this.fValidSourceUnitNames = fValidSourceUnitNames;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (RemoteIndexerInfoProvider.empty(this.pathMap)) {
            this.pathMap = null;
        }
        if (RemoteIndexerInfoProvider.empty(this.linkageMap)) {
            this.linkageMap = null;
        }
        if (RemoteIndexerInfoProvider.empty(this.languageMap)) {
            this.languageMap = null;
        }
        if (RemoteIndexerInfoProvider.empty(this.languagePropertyMap)) {
            this.languagePropertyMap = null;
        }
        if (RemoteIndexerInfoProvider.empty(this.headerSet)) {
            this.headerSet = null;
        }
        if (RemoteIndexerInfoProvider.empty(this.indexerPreferences)) {
            this.indexerPreferences = null;
        }
        out.defaultWriteObject();
    }

    private static boolean empty(Map<?, ?> field) {
        return field != null && field.isEmpty();
    }

    private static boolean empty(Collection<?> field) {
        return field != null && field.isEmpty();
    }

    private static <T> IScannerInfo getScannerInfo(Map<T, RemoteScannerInfo> map, T key) {
        if (map == null) {
            return new RemoteScannerInfo();
        }
        IScannerInfo si = map.get(key);
        return si == null ? new RemoteScannerInfo() : si;
    }

    public IScannerInfo getScannerInformation(String path) {
        return RemoteIndexerInfoProvider.getScannerInfo(this.pathMap, path);
    }

    public IScannerInfo getDefaultScannerInformation(int linkageId) {
        return RemoteIndexerInfoProvider.getScannerInfo(this.linkageMap, linkageId);
    }

    @Override
    public String getLanguageID(String path) {
        return this.languageMap == null ? null : this.languageMap.get(path);
    }

    @Override
    public boolean isHeaderUnit(String path) {
        return this.headerSet == null ? false : this.headerSet.contains(path);
    }

    @Override
    public boolean checkIndexerPreference(String key) {
        return this.indexerPreferences == null ? false : this.indexerPreferences.contains(key);
    }

    @Override
    public Map<String, String> getLanguageProperties(String languageId) {
        if (this.languagePropertyMap == null) {
            return Collections.emptyMap();
        }
        return this.languagePropertyMap.get(languageId);
    }

    @Override
    public FileEncodingRegistry getFileEncodingRegistry() {
        return this.fFileEncodingRegistry;
    }

    @Override
    public Set<String> getFValidSourceUnitNames() {
        return this.fValidSourceUnitNames;
    }

    public String toString() {
        return "pathMap:" + this.pathMap + " linkageMap:" + this.linkageMap + " languageMap:" + this.languageMap + " languagePropertyMap" + this.languagePropertyMap + " isHeaderMap:" + this.headerSet + " preferences: " + this.indexerPreferences + " fFileEncodingRegistry: " + this.fFileEncodingRegistry + " fValidSourceUnitNames: " + this.fValidSourceUnitNames;
    }
}

