/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.dom.ast;

import java.util.ArrayList;
import java.util.BitSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.ICompositeType;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IEnumerator;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IParameter;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.ISemanticProblem;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.core.dom.ast.c.ICArrayType;
import org.eclipse.cdt.core.dom.ast.c.ICQualifierType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBasicType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNamespace;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPPointerToMemberType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameter;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.IGPPQualifierType;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTTypeId;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;
import org.eclipse.cdt.internal.core.dom.parser.c.ICInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTypeId;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPUnknownMemberClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.core.runtime.CoreException;

public class ASTTypeUtil {
    private static final String COMMA_SPACE = ", ";
    private static final String EMPTY_STRING = "";
    private static final String SPACE = " ";
    private static final int DEAULT_ITYPE_SIZE = 2;

    public static String getParameterTypeString(IFunctionType type) {
        StringBuilder result = new StringBuilder();
        ASTTypeUtil.appendParameterTypeString(type, result);
        return result.toString();
    }

    private static void appendParameterTypeString(IFunctionType ft, StringBuilder result) {
        IType[] types = ft.getParameterTypes();
        result.append(Keywords.cpLPAREN);
        boolean needComma = false;
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (type != null) {
                if (needComma) {
                    result.append(COMMA_SPACE);
                }
                ASTTypeUtil.appendType(type, true, result);
                needComma = true;
            }
            ++n2;
        }
        if (ft instanceof ICPPFunctionType && ((ICPPFunctionType)ft).takesVarArgs()) {
            if (needComma) {
                result.append(COMMA_SPACE);
            }
            result.append(Keywords.cpELLIPSIS);
        }
        result.append(Keywords.cpRPAREN);
    }

    public static boolean functionTakesParameters(IFunction function) {
        IParameter[] parameters = function.getParameters();
        if (parameters.length == 0) {
            return false;
        }
        return parameters.length != 1 || !SemanticUtil.isVoidType(parameters[0].getType());
    }

    public static String getTypeListString(IType[] types) {
        return ASTTypeUtil.getTypeListString(types, true);
    }

    public static String getTypeListString(IType[] types, boolean normalize) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < types.length) {
            if (types[i] != null) {
                ASTTypeUtil.appendType(types[i], normalize, result);
                if (i < types.length - 1) {
                    result.append(COMMA_SPACE);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static String getArgumentListString(ICPPTemplateArgument[] args, boolean normalize) {
        StringBuilder result = new StringBuilder();
        ASTTypeUtil.appendArgumentList(args, normalize, result);
        return result.toString();
    }

    private static void appendArgumentList(ICPPTemplateArgument[] args, boolean normalize, StringBuilder result) {
        boolean first = true;
        result.append('<');
        ICPPTemplateArgument[] iCPPTemplateArgumentArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPTemplateArgument arg = iCPPTemplateArgumentArray[n2];
            if (!first) {
                result.append(',');
            }
            first = false;
            ASTTypeUtil.appendArgument(arg, normalize, result);
            ++n2;
        }
        result.append('>');
    }

    public static String getArgumentString(ICPPTemplateArgument arg, boolean normalize) {
        StringBuilder buf = new StringBuilder();
        ASTTypeUtil.appendArgument(arg, normalize, buf);
        return buf.toString();
    }

    private static void appendArgument(ICPPTemplateArgument arg, boolean normalize, StringBuilder buf) {
        IValue val = arg.getNonTypeValue();
        if (val != null) {
            ASTTypeUtil.appendType(arg.getTypeOfNonTypeValue(), normalize, buf);
            buf.append(val.getSignature());
        } else {
            IType type = normalize ? arg.getTypeValue() : arg.getOriginalTypeValue();
            ASTTypeUtil.appendType(type, normalize, buf);
        }
    }

    public static String[] getParameterTypeStringArray(IFunctionType type) {
        IType[] parms = type.getParameterTypes();
        String[] result = new String[parms.length];
        int i = 0;
        while (i < parms.length) {
            if (parms[i] != null) {
                result[i] = ASTTypeUtil.getType(parms[i]);
            }
            ++i;
        }
        return result;
    }

    private static void appendTypeString(IType type, boolean normalize, StringBuilder result) {
        boolean needSpace = false;
        if (type instanceof IArrayType) {
            IValue val;
            result.append(Keywords.cpLBRACKET);
            if (type instanceof ICArrayType) {
                ICArrayType catype = (ICArrayType)type;
                if (catype.isConst()) {
                    result.append("const");
                    needSpace = true;
                }
                if (catype.isRestrict()) {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("restrict");
                    needSpace = true;
                }
                if (catype.isStatic()) {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("static");
                    needSpace = true;
                }
                if (catype.isVolatile()) {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append("volatile");
                }
            }
            if ((val = ((IArrayType)type).getSize()) != null && val != Value.UNKNOWN) {
                if (normalize) {
                    if (needSpace) {
                        result.append(SPACE);
                        needSpace = false;
                    }
                    result.append(val.getSignature());
                } else {
                    Long v = val.numericalValue();
                    if (v != null) {
                        if (needSpace) {
                            result.append(SPACE);
                            needSpace = false;
                        }
                        result.append(v);
                    }
                }
            }
            result.append(Keywords.cpRBRACKET);
        } else if (type instanceof IBasicType) {
            IBasicType basicType = (IBasicType)type;
            IBasicType.Kind kind = basicType.getKind();
            if (basicType.isSigned()) {
                if (!normalize || kind == IBasicType.Kind.eChar) {
                    result.append("signed");
                    needSpace = true;
                }
            } else if (basicType.isUnsigned()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append("unsigned");
                needSpace = true;
            }
            if (basicType.isLong()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append("long");
                needSpace = true;
            } else if (basicType.isShort()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append("short");
                needSpace = true;
            } else if (basicType.isLongLong()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append("long long");
                needSpace = true;
            }
            if (basicType.isComplex()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append(Keywords.c_COMPLEX);
                needSpace = true;
            }
            if (basicType.isImaginary()) {
                if (needSpace) {
                    result.append(SPACE);
                    needSpace = false;
                }
                result.append(Keywords.c_IMAGINARY);
                needSpace = true;
            }
            switch (kind) {
                case eChar: {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    result.append("char");
                    break;
                }
                case eDouble: {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    result.append("double");
                    break;
                }
                case eFloat: {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    result.append("float");
                    break;
                }
                case eFloat128: {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    result.append("__float128");
                    break;
                }
                case eInt: {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    result.append("int");
                    break;
                }
                case eInt128: {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    result.append("__int128");
                    break;
                }
                case eVoid: {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    result.append("void");
                    break;
                }
                case eBoolean: {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    if (basicType instanceof ICPPBasicType) {
                        result.append("bool");
                        break;
                    }
                    result.append(Keywords.c_BOOL);
                    break;
                }
                case eWChar: {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    result.append("wchar_t");
                    break;
                }
                case eChar16: {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    result.append("char16_t");
                    break;
                }
                case eChar32: {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    result.append("char32_t");
                    break;
                }
                case eNullPtr: {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    result.append("std::nullptr_t");
                    break;
                }
            }
        } else if (type instanceof ICPPTemplateParameter) {
            ASTTypeUtil.appendCppName((ICPPTemplateParameter)((Object)type), normalize, normalize, result);
        } else if (type instanceof ICPPBinding) {
            if (type instanceof IEnumeration) {
                result.append("enum");
                result.append(SPACE);
            }
            boolean qualify = normalize || type instanceof ITypedef && type instanceof ICPPSpecialization;
            ASTTypeUtil.appendCppName((ICPPBinding)((Object)type), normalize, qualify, result);
        } else if (type instanceof ICompositeType) {
            ASTTypeUtil.appendNameCheckAnonymous((ICompositeType)type, result);
        } else if (type instanceof ITypedef) {
            result.append(((ITypedef)type).getNameCharArray());
        } else if (type instanceof ICPPReferenceType) {
            if (((ICPPReferenceType)type).isRValueReference()) {
                result.append(Keywords.cpAND);
            } else {
                result.append(Keywords.cpAMPER);
            }
        } else if (type instanceof ICPPParameterPackType) {
            result.append(Keywords.cpELLIPSIS);
        } else if (type instanceof IEnumeration) {
            result.append("enum");
            result.append(SPACE);
            ASTTypeUtil.appendNameCheckAnonymous((IEnumeration)type, result);
        } else if (type instanceof IFunctionType) {
            ASTTypeUtil.appendParameterTypeString((IFunctionType)type, result);
            needSpace = false;
            if (type instanceof ICPPFunctionType) {
                ICPPFunctionType ft = (ICPPFunctionType)type;
                needSpace = ASTTypeUtil.appendCVQ(result, needSpace, ft.isConst(), ft.isVolatile(), false);
            }
        } else if (type instanceof IPointerType) {
            if (type instanceof ICPPPointerToMemberType) {
                ASTTypeUtil.appendTypeString(((ICPPPointerToMemberType)type).getMemberOfClass(), normalize, result);
                result.append(Keywords.cpCOLONCOLON);
            }
            result.append(Keywords.cpSTAR);
            needSpace = true;
            IPointerType pt = (IPointerType)type;
            needSpace = ASTTypeUtil.appendCVQ(result, needSpace, pt.isConst(), pt.isVolatile(), pt.isRestrict());
        } else if (type instanceof IQualifierType) {
            if (type instanceof ICQualifierType) {
                if (((ICQualifierType)type).isRestrict()) {
                    result.append("restrict");
                    needSpace = true;
                }
            } else if (type instanceof IGPPQualifierType && ((IGPPQualifierType)type).isRestrict()) {
                result.append("restrict");
                needSpace = true;
            }
            IQualifierType qt = (IQualifierType)type;
            needSpace = ASTTypeUtil.appendCVQ(result, needSpace, qt.isConst(), qt.isVolatile(), false);
        } else if (type instanceof TypeOfDependentExpression) {
            result.append(((TypeOfDependentExpression)type).getSignature());
        } else if (type instanceof ISemanticProblem) {
            result.append('?');
        } else if (type != null) {
            result.append('@').append(type.hashCode());
        }
    }

    private static void appendTemplateParameter(ICPPTemplateParameter type, boolean normalize, StringBuilder result) {
        if (normalize) {
            result.append('#');
            result.append(Integer.toString(type.getParameterID(), 16));
            if (type.isParameterPack()) {
                result.append("(...)");
            }
        } else {
            result.append(type.getName());
        }
    }

    private static boolean appendCVQ(StringBuilder target, boolean needSpace, boolean isConst, boolean isVolatile, boolean isRestrict) {
        if (isConst) {
            if (needSpace) {
                target.append(SPACE);
            }
            target.append("const");
            needSpace = true;
        }
        if (isVolatile) {
            if (needSpace) {
                target.append(SPACE);
            }
            target.append("volatile");
            needSpace = true;
        }
        if (isRestrict) {
            if (needSpace) {
                target.append(SPACE);
            }
            target.append("restrict");
            needSpace = true;
        }
        return needSpace;
    }

    public static String getType(IType type) {
        return ASTTypeUtil.getType(type, true);
    }

    public static String getType(IType type, boolean normalize) {
        StringBuilder result = new StringBuilder();
        ASTTypeUtil.appendType(type, normalize, result);
        return result.toString();
    }

    public static void appendType(IType type, boolean normalize, StringBuilder result) {
        IType tj;
        IType[] types = new IType[2];
        int i = 0;
        IQualifierType cvq = null;
        ICPPReferenceType ref = null;
        while (type != null && ++i < 100) {
            if (type instanceof ITypedef) {
                if (!normalize) {
                    if (ref != null) {
                        types = ArrayUtil.append(IType.class, types, ref);
                        ref = null;
                    }
                    if (cvq != null) {
                        types = ArrayUtil.append(IType.class, types, cvq);
                        cvq = null;
                    }
                    types = ArrayUtil.append(IType.class, types, type);
                    type = null;
                }
            } else if (type instanceof ICPPReferenceType) {
                cvq = null;
                if (ref == null || ref.isRValueReference()) {
                    ref = (ICPPReferenceType)type;
                }
            } else {
                if (cvq != null && (type instanceof IQualifierType || type instanceof IPointerType)) {
                    type = SemanticUtil.addQualifiers(type, cvq.isConst(), cvq.isVolatile(), false);
                    cvq = null;
                }
                if (type instanceof IQualifierType) {
                    cvq = (IQualifierType)type;
                } else {
                    if (ref != null) {
                        types = ArrayUtil.append(IType.class, types, ref);
                        ref = null;
                    }
                    if (cvq != null) {
                        types = ArrayUtil.append(IType.class, types, cvq);
                        cvq = null;
                    }
                    types = ArrayUtil.append(IType.class, types, type);
                }
            }
            type = type instanceof ITypeContainer ? ((ITypeContainer)type).getType() : (type instanceof IFunctionType ? ((IFunctionType)type).getReturnType() : null);
        }
        ArrayList<IType> postfix = null;
        BitSet parenthesis = null;
        boolean needParenthesis = false;
        boolean needSpace = false;
        int j = types.length;
        while (--j >= 0) {
            tj = types[j];
            if (tj == null) continue;
            if (j > 0 && types[j - 1] instanceof IQualifierType) {
                if (needSpace) {
                    result.append(SPACE);
                }
                ASTTypeUtil.appendTypeString(types[j - 1], normalize, result);
                result.append(SPACE);
                ASTTypeUtil.appendTypeString(tj, normalize, result);
                needSpace = true;
                --j;
                continue;
            }
            if (tj instanceof IFunctionType || tj instanceof IArrayType) {
                if (j == 0) {
                    if (needSpace) {
                        result.append(SPACE);
                    }
                    ASTTypeUtil.appendTypeString(tj, normalize, result);
                    needSpace = true;
                    continue;
                }
                if (postfix == null) {
                    postfix = new ArrayList<IType>();
                }
                postfix.add(tj);
                needParenthesis = true;
                continue;
            }
            if (needSpace) {
                result.append(SPACE);
            }
            if (needParenthesis && postfix != null) {
                result.append('(');
                if (parenthesis == null) {
                    parenthesis = new BitSet();
                }
                parenthesis.set(postfix.size() - 1);
            }
            ASTTypeUtil.appendTypeString(tj, normalize, result);
            needParenthesis = false;
            needSpace = true;
        }
        if (postfix != null) {
            j = postfix.size() - 1;
            while (j >= 0) {
                if (parenthesis != null && parenthesis.get(j)) {
                    result.append(')');
                }
                tj = (IType)postfix.get(j);
                ASTTypeUtil.appendTypeString(tj, normalize, result);
                --j;
            }
        }
    }

    public static String getType(IASTDeclarator declarator) {
        while (declarator.getNestedDeclarator() != null) {
            declarator = declarator.getNestedDeclarator();
        }
        IBinding binding = declarator.getName().resolveBinding();
        IType type = null;
        if (binding instanceof IEnumerator) {
            type = ((IEnumerator)binding).getType();
        } else if (binding instanceof IFunction) {
            type = ((IFunction)binding).getType();
        } else if (binding instanceof ITypedef) {
            type = ((ITypedef)binding).getType();
        } else if (binding instanceof IVariable) {
            type = ((IVariable)binding).getType();
        }
        if (type != null) {
            return ASTTypeUtil.getType(type);
        }
        return EMPTY_STRING;
    }

    public static String getNodeType(IASTNode node) {
        if (node instanceof IASTDeclarator) {
            return ASTTypeUtil.getType((IASTDeclarator)node);
        }
        if (node instanceof IASTName && ((IASTName)node).resolveBinding() instanceof IVariable) {
            return ASTTypeUtil.getType(((IVariable)((IASTName)node).resolveBinding()).getType());
        }
        if (node instanceof IASTName && ((IASTName)node).resolveBinding() instanceof IFunction) {
            return ASTTypeUtil.getType(((IFunction)((IASTName)node).resolveBinding()).getType());
        }
        if (node instanceof IASTName && ((IASTName)node).resolveBinding() instanceof IType) {
            return ASTTypeUtil.getType((IType)((Object)((IASTName)node).resolveBinding()));
        }
        if (node instanceof IASTTypeId) {
            return ASTTypeUtil.getType((IASTTypeId)node);
        }
        return EMPTY_STRING;
    }

    public static String getType(IASTTypeId typeId) {
        if (typeId instanceof CASTTypeId) {
            return ASTTypeUtil.createCType(typeId.getAbstractDeclarator());
        }
        if (typeId instanceof CPPASTTypeId) {
            return ASTTypeUtil.createCPPType(typeId.getAbstractDeclarator());
        }
        return EMPTY_STRING;
    }

    private static String createCType(IASTDeclarator declarator) {
        IType type = CVisitor.createType(declarator);
        return ASTTypeUtil.getType(type);
    }

    private static String createCPPType(IASTDeclarator declarator) {
        IType type = CPPVisitor.createType(declarator);
        return ASTTypeUtil.getType(type);
    }

    @Deprecated
    public static boolean isConst(IType type) {
        if (type instanceof IQualifierType) {
            return ((IQualifierType)type).isConst();
        }
        if (type instanceof ITypeContainer) {
            return ASTTypeUtil.isConst(((ITypeContainer)type).getType());
        }
        if (type instanceof IArrayType) {
            return ASTTypeUtil.isConst(((IArrayType)type).getType());
        }
        if (type instanceof ICPPReferenceType) {
            return ASTTypeUtil.isConst(((ICPPReferenceType)type).getType());
        }
        if (type instanceof IFunctionType) {
            return ASTTypeUtil.isConst(((IFunctionType)type).getReturnType());
        }
        if (type instanceof IPointerType) {
            return ASTTypeUtil.isConst(((IPointerType)type).getType());
        }
        if (type instanceof ITypedef) {
            return ASTTypeUtil.isConst(((ITypedef)type).getType());
        }
        return false;
    }

    public static String getQualifiedName(ICPPBinding binding) {
        StringBuilder buf = new StringBuilder();
        ASTTypeUtil.appendCppName(binding, false, true, buf);
        return buf.toString();
    }

    private static void appendCppName(IBinding binding, boolean normalize, boolean qualify, StringBuilder result) {
        ICPPTemplateParameter tpar = ASTTypeUtil.getTemplateParameter(binding);
        if (tpar != null) {
            ASTTypeUtil.appendTemplateParameter(tpar, normalize, result);
        } else {
            IBinding owner;
            if (qualify && ((owner = binding.getOwner()) instanceof ICPPNamespace || owner instanceof IType)) {
                int pos = result.length();
                ASTTypeUtil.appendCppName(owner, normalize, qualify, result);
                if (binding instanceof IIndexBinding && owner instanceof ICPPNamespace && owner.getNameCharArray().length == 0) {
                    try {
                        IIndexFile file = ((IIndexBinding)binding).getLocalToFile();
                        if (file != null) {
                            result.append('{');
                            result.append(file.getLocation().getURI().toString());
                            result.append('}');
                        }
                    }
                    catch (CoreException e) {
                        CCorePlugin.log((Throwable)e);
                    }
                }
                if (result.length() > pos) {
                    result.append("::");
                }
            }
            ASTTypeUtil.appendNameCheckAnonymous(binding, result);
        }
        if (binding instanceof ICPPTemplateInstance) {
            ASTTypeUtil.appendArgumentList(((ICPPTemplateInstance)binding).getTemplateArguments(), normalize, result);
        } else if (binding instanceof ICPPUnknownMemberClassInstance) {
            ASTTypeUtil.appendArgumentList(((ICPPUnknownMemberClassInstance)binding).getArguments(), normalize, result);
        }
    }

    private static ICPPTemplateParameter getTemplateParameter(IBinding binding) {
        if (binding instanceof ICPPTemplateParameter) {
            return (ICPPTemplateParameter)binding;
        }
        if (binding instanceof ICPPDeferredClassInstance) {
            return ASTTypeUtil.getTemplateParameter(((ICPPDeferredClassInstance)binding).getTemplateDefinition());
        }
        return null;
    }

    private static void appendNameCheckAnonymous(IBinding binding, StringBuilder result) {
        char[] name = binding.getNameCharArray();
        if (name != null && name.length > 0) {
            result.append(name);
        } else if (!(binding instanceof ICPPNamespace)) {
            ASTTypeUtil.appendNameForAnonymous(binding, result);
        }
    }

    public static char[] createNameForAnonymous(IBinding binding) {
        StringBuilder result = new StringBuilder();
        ASTTypeUtil.appendNameForAnonymous(binding, result);
        if (result.length() == 0) {
            return null;
        }
        return ASTTypeUtil.extractChars(result);
    }

    private static char[] extractChars(StringBuilder buf) {
        int length = buf.length();
        char[] result = new char[length];
        buf.getChars(0, length, result, 0);
        return result;
    }

    private static void appendNameForAnonymous(IBinding binding, StringBuilder buf) {
        IASTNode node = null;
        if (binding instanceof ICInternalBinding) {
            node = ((ICInternalBinding)((Object)binding)).getPhysicalNode();
        } else if (binding instanceof ICPPInternalBinding) {
            node = ((ICPPInternalBinding)binding).getDefinition();
        }
        if (node != null) {
            IASTFileLocation loc = node.getFileLocation();
            if (loc == null && (node = node.getParent()) != null) {
                loc = node.getFileLocation();
            }
            if (loc != null) {
                char[] fname = loc.getFileName().toCharArray();
                int fnamestart = ASTTypeUtil.findFileNameStart(fname);
                buf.append('{');
                buf.append(fname, fnamestart, fname.length - fnamestart);
                if (!(binding instanceof ICPPNamespace)) {
                    buf.append(':');
                    buf.append(loc.getNodeOffset());
                }
                buf.append('}');
            }
        }
    }

    private static int findFileNameStart(char[] fname) {
        int i = fname.length - 2;
        while (i >= 0) {
            switch (fname[i]) {
                case '/': 
                case '\\': {
                    return i + 1;
                }
            }
            --i;
        }
        return 0;
    }
}

