/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsChangeEvent;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsChangeListener;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.pdom.PDOMManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class LanguageSettingsChangeListener
implements ILanguageSettingsChangeListener {
    private PDOMManager fManager;

    public LanguageSettingsChangeListener(PDOMManager manager) {
        this.fManager = manager;
    }

    public void handleEvent(ILanguageSettingsChangeEvent event) {
        ICProjectDescription prjDescription;
        IWorkspaceRoot wspRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = wspRoot.getProject(event.getProjectName());
        if (project != null && (prjDescription = CCorePlugin.getDefault().getProjectDescription(project, false)) != null) {
            ICConfigurationDescription cfgDescription = prjDescription.getDefaultSettingConfiguration();
            String indexedId = cfgDescription.getId();
            String[] stringArray = event.getConfigurationDescriptionIds();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                if (id.equals(indexedId)) {
                    this.reindex(id, event);
                    return;
                }
                ++n2;
            }
        }
    }

    private void reindex(String cfgId, ILanguageSettingsChangeEvent event) {
        CModelManager manager = CModelManager.getDefault();
        ICProject cProject = manager.getCModel().getCProject(event.getProjectName());
        HashSet<ICElement> tuSelection = new HashSet<ICElement>();
        Set resources = event.getAffectedResources(cfgId);
        if (resources != null && !resources.isEmpty()) {
            for (IResource rc : resources) {
                tuSelection.add(manager.create(rc, cProject));
            }
            try {
                this.fManager.update(tuSelection.toArray(new ICElement[tuSelection.size()]), 1);
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
            }
        }
    }
}

