/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.core.miners;

import org.eclipse.core.runtime.IProgressMonitor;

public class StdoutProgressMonitor
implements IProgressMonitor {
    private String fTaskName;
    private String fSubTaskName;
    private int fTotalWork;
    private int fCurrentWorked;
    private boolean fIsCanceled;

    public void beginTask(String name, int totalWork) {
        this.fTaskName = name;
        this.fTotalWork = totalWork;
        System.out.println("Starting task " + name);
    }

    public void done() {
        System.out.println("Done task " + this.fTaskName);
    }

    public void internalWorked(double work) {
        this.fCurrentWorked = (int)((double)this.fCurrentWorked + work);
        this.printProgress();
    }

    public boolean isCanceled() {
        return this.fIsCanceled;
    }

    public void setCanceled(boolean value) {
        this.fIsCanceled = value;
        if (value) {
            System.out.println("Task " + this.fTaskName + " has been cancelled");
            System.out.flush();
        }
    }

    public void setTaskName(String name) {
        this.fTaskName = name;
    }

    public void subTask(String name) {
        this.fSubTaskName = name;
        this.printProgress();
    }

    public void worked(int work) {
        this.internalWorked(work);
    }

    private void printProgress() {
        System.out.println("Working... Task: " + this.fTaskName + " SubTask: " + this.fSubTaskName + " Progress: " + this.fCurrentWorked + " of " + this.fTotalWork);
        System.out.flush();
    }
}

