/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameterPackType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.Value;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPFunctionSpecialization;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPSpecialization;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPParameterSpecialization
extends PDOMCPPSpecialization
implements ICPPParameter {
    private static final int NEXT_PARAM = 44;
    private static final int DEFAULT_VALUE = 48;
    private static final int RECORD_SIZE = 53;
    private final IType fType;
    private volatile IValue fDefaultValue = Value.NOT_INITIALIZED;

    public PDOMCPPParameterSpecialization(PDOMLinkage linkage, long record, IType t) {
        super(linkage, record);
        this.fType = t;
    }

    public PDOMCPPParameterSpecialization(PDOMLinkage linkage, PDOMCPPFunctionSpecialization parent, ICPPParameter astParam, PDOMCPPParameter original, PDOMCPPParameterSpecialization next) throws CoreException {
        super(linkage, parent, (ICPPSpecialization)((Object)astParam), original);
        this.fType = null;
        this.fDefaultValue = astParam.getDefaultValue();
        Database db = this.getDB();
        db.putRecPtr(this.record + 44L, next == null ? 0L : next.getRecord());
        linkage.storeValue(this.record + 48L, this.fDefaultValue);
    }

    @Override
    protected int getRecordSize() {
        return 53;
    }

    @Override
    public int getNodeType() {
        return 32;
    }

    long getNextPtr() throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 44L);
        return rec;
    }

    @Override
    public IType getType() {
        return this.fType;
    }

    @Override
    protected IPDOMBinding loadSpecializedBinding(long record) throws CoreException {
        if (record == 0L) {
            return null;
        }
        IType type = null;
        IBinding parent = this.getParentBinding();
        if (parent instanceof ICPPSpecialization && parent instanceof ICPPFunction) {
            IType[] ptypes;
            ICPPFunctionType ftype;
            ICPPParameter[] pars = ((ICPPFunction)parent).getParameters();
            int parPos = -1;
            parPos = 0;
            while (parPos < pars.length) {
                ICPPParameter par = pars[parPos];
                if (this.equals(par)) break;
                ++parPos;
            }
            if (parPos < pars.length && (parent = ((ICPPSpecialization)parent).getSpecializedBinding()) instanceof ICPPFunction && (ftype = ((ICPPFunction)parent).getType()) != null && parPos < (ptypes = ftype.getParameterTypes()).length) {
                type = ptypes[parPos];
            }
        }
        return new PDOMCPPParameter((PDOMLinkage)this.getLinkage(), record, type);
    }

    private ICPPParameter getParameter() {
        return (ICPPParameter)this.getSpecializedBinding();
    }

    @Override
    public boolean hasDefaultValue() {
        return this.getParameter().hasDefaultValue();
    }

    @Override
    public IValue getDefaultValue() {
        if (this.fDefaultValue == Value.NOT_INITIALIZED) {
            try {
                this.fDefaultValue = ((PDOMLinkage)this.getLinkage()).loadValue(this.record + 48L);
            }
            catch (CoreException e) {
                CCorePlugin.log((Throwable)e);
                this.fDefaultValue = null;
            }
        }
        return this.fDefaultValue;
    }

    @Override
    public boolean isParameterPack() {
        return this.getType() instanceof ICPPParameterPackType;
    }

    @Override
    public boolean isAuto() {
        return this.getParameter().isAuto();
    }

    @Override
    public boolean isRegister() {
        return this.getParameter().isRegister();
    }

    @Override
    public boolean isExtern() {
        return false;
    }

    @Override
    public boolean isExternC() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public IValue getInitialValue() {
        return null;
    }
}

