/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.indexer;

import java.io.File;
import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.AbstractLanguage;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.internal.core.CCoreInternals;
import org.eclipse.cdt.internal.core.parser.InternalParserUtil;
import org.eclipse.cdt.internal.core.pdom.AbstractIndexerTask;
import org.eclipse.cdt.internal.core.pdom.IndexerInputAdapter;
import org.eclipse.cdt.internal.core.pdom.indexer.FileExistsCache;
import org.eclipse.cdt.internal.core.pdom.indexer.PotentialTranslationUnit;
import org.eclipse.cdt.internal.core.resources.PathCanonicalizationStrategy;
import org.eclipse.cdt.utils.UNCPathConverter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;

public class ProjectIndexerInputAdapter
extends IndexerInputAdapter {
    private static final boolean CASE_INSENSITIVE_FILE_SYSTEM = new File("a").equals(new File("A"));
    private static final AbstractLanguage[] NO_LANGUAGE = new AbstractLanguage[0];
    private final ICProject fCProject;
    private final HashMap<String, IIndexFileLocation> fIflCache;
    private final FileExistsCache fExistsCache;
    private AbstractLanguage fLangC;
    private AbstractLanguage fLangCpp;
    private String fProjectPrefix;

    public ProjectIndexerInputAdapter(ICProject cproject) {
        this(cproject, true);
    }

    public ProjectIndexerInputAdapter(ICProject cproject, boolean useCache) {
        this.fCProject = cproject;
        this.fProjectPrefix = String.valueOf(cproject.getProject().getFullPath().toString()) + '/';
        if (useCache) {
            this.fIflCache = new HashMap();
            this.fExistsCache = new FileExistsCache(this.isCaseInsensitiveFileSystem());
        } else {
            this.fIflCache = null;
            this.fExistsCache = null;
        }
        ILanguage l = LanguageManager.getInstance().getLanguageForContentTypeID("org.eclipse.cdt.core.cHeader");
        if (l instanceof AbstractLanguage) {
            this.fLangC = (AbstractLanguage)l;
        }
        if ((l = LanguageManager.getInstance().getLanguageForContentTypeID("org.eclipse.cdt.core.cxxHeader")) instanceof AbstractLanguage) {
            this.fLangCpp = (AbstractLanguage)l;
        }
    }

    @Override
    public boolean isCaseInsensitiveFileSystem() {
        if ("macosx".equals(Platform.getOS())) {
            return true;
        }
        return CASE_INSENSITIVE_FILE_SYSTEM;
    }

    @Override
    public IIndexFileLocation resolveASTPath(String astPath) {
        if (this.fIflCache == null) {
            return this.doResolveASTPath(astPath);
        }
        IIndexFileLocation result = this.fIflCache.get(astPath);
        if (result == null) {
            result = this.doResolveASTPath(astPath);
            this.fIflCache.put(astPath, result);
        }
        return result;
    }

    private IIndexFileLocation doResolveASTPath(String astPath) {
        return IndexLocationFactory.getIFLExpensive(this.fCProject, astPath);
    }

    @Override
    public IIndexFileLocation resolveIncludeFile(String includePath) {
        if (this.fIflCache == null) {
            return this.doResolveASTPath(includePath);
        }
        if (!this.fExistsCache.isFile(includePath)) {
            return null;
        }
        IIndexFileLocation result = this.fIflCache.get(includePath);
        if (result == null) {
            File location;
            String canonicalPath;
            result = this.doResolveASTPath(includePath);
            if (result.getFullPath() == null && !UNCPathConverter.isUNC(includePath) && !includePath.equals(canonicalPath = PathCanonicalizationStrategy.getCanonicalPath(location = new File(includePath)))) {
                result = IndexLocationFactory.getExternalIFL(canonicalPath);
                this.fIflCache.put(canonicalPath, result);
            }
            this.fIflCache.put(includePath, result);
        }
        return result;
    }

    @Override
    public boolean doesIncludeFileExist(String includePath) {
        if (this.fExistsCache != null) {
            return this.fExistsCache.isFile(includePath);
        }
        return new File(includePath).isFile();
    }

    @Override
    public long getFileSize(String astFilePath) {
        return new File(astFilePath).length();
    }

    @Override
    public String getASTPath(IIndexFileLocation ifl) {
        IPath path = IndexLocationFactory.getAbsolutePath(ifl);
        if (path != null) {
            return path.toOSString();
        }
        return ifl.getURI().getPath();
    }

    @Override
    public IScannerInfo getBuildConfiguration(int linkageID, Object tu) {
        IScannerInfo info = ((ITranslationUnit)tu).getScannerInfo(true);
        if (info == null) {
            info = new ExtendedScannerInfo();
        }
        return info;
    }

    @Override
    public long getLastModified(IIndexFileLocation ifl) {
        String fullPath = ifl.getFullPath();
        if (fullPath != null) {
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(fullPath));
            if (res != null) {
                return res.getLocalTimeStamp();
            }
            return 0L;
        }
        IPath location = IndexLocationFactory.getAbsolutePath(ifl);
        if (location != null) {
            return location.toFile().lastModified();
        }
        return 0L;
    }

    @Override
    public long getFileSize(IIndexFileLocation ifl) {
        String fullPath = ifl.getFullPath();
        IPath location = null;
        if (fullPath != null) {
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(fullPath));
            if (res != null) {
                location = res.getLocation();
            }
        } else {
            location = IndexLocationFactory.getAbsolutePath(ifl);
        }
        if (location != null) {
            return location.toFile().length();
        }
        return 0L;
    }

    @Override
    public String getEncoding(IIndexFileLocation ifl) {
        IResource res;
        String fullPath = ifl.getFullPath();
        if (fullPath != null && (res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(fullPath))) instanceof IFile) {
            try {
                return ((IFile)res).getCharset();
            }
            catch (CoreException coreException) {}
        }
        return InternalParserUtil.SYSTEM_DEFAULT_ENCODING;
    }

    @Override
    public AbstractLanguage[] getLanguages(Object tuo, AbstractIndexerTask.UnusedHeaderStrategy strategy) {
        if (tuo instanceof PotentialTranslationUnit) {
            if (this.fLangC != null) {
                if (this.fLangCpp != null) {
                    return new AbstractLanguage[]{this.fLangC, this.fLangCpp};
                }
                return new AbstractLanguage[]{this.fLangC};
            }
            if (this.fLangCpp != null) {
                return new AbstractLanguage[]{this.fLangCpp};
            }
            return NO_LANGUAGE;
        }
        ITranslationUnit tu = (ITranslationUnit)tuo;
        try {
            ILanguage lang = tu.getLanguage();
            if (lang instanceof AbstractLanguage) {
                String filename;
                boolean useCpp;
                boolean both = strategy == AbstractIndexerTask.UnusedHeaderStrategy.useBoth;
                boolean useC = strategy == AbstractIndexerTask.UnusedHeaderStrategy.useC;
                boolean bl = useCpp = strategy == AbstractIndexerTask.UnusedHeaderStrategy.useCPP;
                if ((both || useC || useCpp) && tu.isHeaderUnit() && (filename = tu.getElementName()).indexOf(46) >= 0) {
                    String contentTypeId = tu.getContentTypeId();
                    if (contentTypeId.equals("org.eclipse.cdt.core.cxxHeader") && this.fLangC != null) {
                        if (both) {
                            return new AbstractLanguage[]{(AbstractLanguage)lang, this.fLangC};
                        }
                        if (useC) {
                            return new AbstractLanguage[]{this.fLangC};
                        }
                    } else if (contentTypeId.equals("org.eclipse.cdt.core.cHeader") && this.fLangCpp != null) {
                        if (both) {
                            return new AbstractLanguage[]{(AbstractLanguage)lang, this.fLangCpp};
                        }
                        if (useCpp) {
                            return new AbstractLanguage[]{this.fLangCpp};
                        }
                    }
                }
                return new AbstractLanguage[]{(AbstractLanguage)lang};
            }
        }
        catch (CoreException e) {
            CCorePlugin.log((Throwable)e);
        }
        return NO_LANGUAGE;
    }

    @Override
    public boolean isFileBuildConfigured(Object tuo) {
        ITranslationUnit tu = (ITranslationUnit)tuo;
        return !CoreModel.isScannerInformationEmpty((IResource)tu.getResource());
    }

    @Override
    public boolean isIndexedOnlyIfIncluded(Object tu) {
        return tu instanceof PotentialTranslationUnit;
    }

    @Override
    public boolean isIndexedUnconditionally(IIndexFileLocation ifl) {
        return CCoreInternals.getPDOMManager().isFileIndexedUnconditionally(ifl);
    }

    @Override
    public int getIndexingPriority(IIndexFileLocation ifl) {
        return CCoreInternals.getPDOMManager().getIndexingPriority(ifl);
    }

    @Override
    public boolean isSourceUnit(Object tuo) {
        ITranslationUnit tu = (ITranslationUnit)tuo;
        return tu.isSourceUnit();
    }

    @Override
    public boolean isSource(String filename) {
        String id;
        IContentType ct = CCorePlugin.getContentType((IProject)this.fCProject.getProject(), (String)filename);
        return ct != null && ("org.eclipse.cdt.core.cSource".equals(id = ct.getId()) || "org.eclipse.cdt.core.cxxSource".equals(id));
    }

    @Override
    public IIndexFileLocation resolveFile(Object tuo) {
        ITranslationUnit tu = (ITranslationUnit)tuo;
        return IndexLocationFactory.getIFL(tu);
    }

    @Override
    public boolean canBePartOfSDK(IIndexFileLocation ifl) {
        String fullPath = ifl.getFullPath();
        return fullPath == null || !fullPath.startsWith(this.fProjectPrefix);
    }

    @Override
    public Object getInputFile(IIndexFileLocation location) {
        try {
            return CoreModelUtil.findTranslationUnitForLocation((IIndexFileLocation)location, (ICProject)this.fCProject);
        }
        catch (CModelException e) {
            CCorePlugin.log((Throwable)e);
            return null;
        }
    }

    @Override
    public FileContent getCodeReader(Object tuo) {
        ITranslationUnit tu = (ITranslationUnit)tuo;
        if (tu.getLocation() == null) {
            return null;
        }
        FileContent reader = FileContent.create(tu);
        if (reader != null) {
            IIndexFileLocation ifl = IndexLocationFactory.getIFL(tu);
            this.fIflCache.put(reader.getFileLocation(), ifl);
        }
        return reader;
    }
}

