/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBlockScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPVariable;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IInternalVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBuiltinVariable;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.PlatformObject;

public class CPPVariable
extends PlatformObject
implements ICPPVariable,
ICPPInternalBinding,
IInternalVariable {
    private IASTName fDefinition;
    private IASTName[] fDeclarations;
    private IType fType;
    private boolean fAllResolved;

    public CPPVariable(IASTName name) {
        boolean isDef;
        boolean bl = isDef = name == null ? false : name.isDefinition();
        if (name instanceof ICPPASTQualifiedName) {
            name = name.getLastName();
        }
        if (isDef) {
            this.fDefinition = name;
        } else {
            this.fDeclarations = new IASTName[]{name};
        }
        if (name != null) {
            name.setBinding(this);
        } else assert (this instanceof CPPBuiltinVariable);
    }

    private IASTDeclarator findDeclarator(IASTName name) {
        IASTNode node = name.getParent();
        if (node instanceof ICPPASTQualifiedName) {
            node = node.getParent();
        }
        if (!(node instanceof IASTDeclarator)) {
            return null;
        }
        IASTDeclarator dtor = (IASTDeclarator)node;
        while (dtor.getParent() instanceof IASTDeclarator) {
            dtor = (IASTDeclarator)dtor.getParent();
        }
        return dtor;
    }

    @Override
    public void addDeclaration(IASTNode node) {
        if (!(node instanceof IASTName)) {
            return;
        }
        IASTName name = (IASTName)node;
        if (this.fDefinition == null && name.isDefinition()) {
            this.fDefinition = name;
        } else {
            this.fDeclarations = this.fDeclarations == null ? new IASTName[]{name} : (this.fDeclarations.length > 0 && ((ASTNode)node).getOffset() < ((ASTNode)((Object)this.fDeclarations[0])).getOffset() ? ArrayUtil.prepend(IASTName.class, this.fDeclarations, name) : ArrayUtil.append(IASTName.class, this.fDeclarations, name));
        }
        if (this.fType instanceof IArrayType) {
            this.fType = null;
        }
    }

    @Override
    public IASTNode[] getDeclarations() {
        return this.fDeclarations;
    }

    @Override
    public IASTNode getDefinition() {
        return this.fDefinition;
    }

    @Override
    public IType getType() {
        if (this.fType != null) {
            return this.fType;
        }
        boolean doneWithDefinition = false;
        IArrayType firstCandidate = null;
        int length = this.fDeclarations == null ? 0 : this.fDeclarations.length;
        int i = 0;
        while (i <= length) {
            IASTName n;
            if (!(this.fDefinition == null || doneWithDefinition || i != length && ((ASTNode)((Object)this.fDefinition)).getOffset() >= ((ASTNode)((Object)this.fDeclarations[i])).getOffset())) {
                n = this.fDefinition;
                doneWithDefinition = true;
                --i;
            } else {
                if (i >= length) break;
                n = this.fDeclarations[i];
            }
            if (n != null) {
                while (n.getParent() instanceof IASTName) {
                    n = (IASTName)n.getParent();
                }
                IASTNode node = n.getParent();
                if (node instanceof IASTDeclarator) {
                    IType t = CPPVisitor.createType((IASTDeclarator)node);
                    if (t instanceof IArrayType && ((IArrayType)t).getSize() == null) {
                        if (firstCandidate == null) {
                            firstCandidate = (IArrayType)t;
                        }
                    } else {
                        this.fType = t;
                        return this.fType;
                    }
                }
            }
            ++i;
        }
        this.fType = firstCandidate;
        if (!this.fAllResolved) {
            this.resolveAllDeclarations();
            return this.getType();
        }
        return this.fType;
    }

    private void resolveAllDeclarations() {
        if (this.fAllResolved) {
            return;
        }
        this.fAllResolved = true;
        int length = this.fDeclarations == null ? 0 : this.fDeclarations.length;
        int i = -1;
        while (i < length) {
            IASTTranslationUnit tu;
            IASTName n;
            IASTName iASTName = n = i == -1 ? this.fDefinition : this.fDeclarations[i];
            if (n != null && (tu = n.getTranslationUnit()) != null) {
                CPPVisitor.getDeclarations(tu, this);
                return;
            }
            ++i;
        }
    }

    @Override
    public String getName() {
        return new String(this.getNameCharArray());
    }

    @Override
    public char[] getNameCharArray() {
        if (this.fDeclarations != null) {
            return this.fDeclarations[0].getSimpleID();
        }
        return this.fDefinition.getSimpleID();
    }

    @Override
    public IScope getScope() {
        return CPPVisitor.getContainingScope(this.fDefinition != null ? this.fDefinition : this.fDeclarations[0]);
    }

    @Override
    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    @Override
    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    @Override
    public boolean isGloballyQualified() throws DOMException {
        IScope scope = this.getScope();
        while (scope != null) {
            if (scope instanceof ICPPBlockScope) {
                return false;
            }
            scope = scope.getParent();
        }
        return true;
    }

    @Override
    public void addDefinition(IASTNode node) {
        this.addDeclaration(node);
    }

    public boolean hasStorageClass(int storage) {
        IASTName name = (IASTName)this.getDefinition();
        IASTNode[] ns = this.getDeclarations();
        int i = -1;
        do {
            IASTDeclSpecifier declSpec;
            if (name == null) continue;
            IASTNode parent = name.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                parent = parent.getParent();
            }
            if (!(parent instanceof IASTSimpleDeclaration) || (declSpec = ((IASTSimpleDeclaration)parent).getDeclSpecifier()).getStorageClass() != storage) continue;
            return true;
        } while (ns != null && ++i < ns.length && (name = (IASTName)ns[i]) != null);
        return false;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return this.hasStorageClass(3);
    }

    @Override
    public boolean isExtern() {
        return this.hasStorageClass(2);
    }

    @Override
    public boolean isExternC() {
        if (CPPVisitor.isExternC(this.getDefinition())) {
            return true;
        }
        IASTNode[] ds = this.getDeclarations();
        if (ds != null) {
            IASTNode[] iASTNodeArray = ds;
            int n = ds.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode element = iASTNodeArray[n2];
                if (CPPVisitor.isExternC(element)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public boolean isAuto() {
        return this.hasStorageClass(4);
    }

    @Override
    public boolean isRegister() {
        return this.hasStorageClass(5);
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    @Override
    public IBinding getOwner() {
        IASTName node = this.fDefinition != null ? this.fDefinition : this.fDeclarations[0];
        return CPPVisitor.findNameOwner(node, !this.hasStorageClass(2));
    }

    @Override
    public IValue getInitialValue() {
        return this.getInitialValue(25);
    }

    public IValue getInitialValue(int maxDepth) {
        IValue val;
        if (this.fDefinition != null && (val = this.getInitialValue(this.fDefinition, maxDepth)) != null) {
            return val;
        }
        if (this.fDeclarations != null) {
            IASTName[] iASTNameArray = this.fDeclarations;
            int n = this.fDeclarations.length;
            int n2 = 0;
            while (n2 < n) {
                IASTName decl = iASTNameArray[n2];
                if (decl == null) break;
                IValue val2 = this.getInitialValue(decl, maxDepth);
                if (val2 != null) {
                    return val2;
                }
                ++n2;
            }
        }
        return null;
    }

    private IValue getInitialValue(IASTName name, int maxDepth) {
        IASTInitializer init;
        IASTDeclarator dtor = this.findDeclarator(name);
        if (dtor != null && (init = dtor.getInitializer()) != null) {
            return SemanticUtil.getValueOfInitializer(init, this.getType(), maxDepth);
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }
}

