/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexFileSet;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.index.IndexLocationFactory;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTInternalScope;
import org.eclipse.cdt.internal.core.dom.parser.c.ICInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.c.ICInternalFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalFunction;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.internal.core.index.IndexFileSet;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.core.runtime.CoreException;

public class ASTInternal {
    public static IASTNode[] getDeclarationsOfBinding(IBinding binding) {
        if (binding instanceof ICPPInternalBinding) {
            return ((ICPPInternalBinding)binding).getDeclarations();
        }
        assert (false);
        return IASTNode.EMPTY_NODE_ARRAY;
    }

    public static IASTNode getPhysicalNodeOfScope(IScope scope) {
        if (scope instanceof IASTInternalScope) {
            return ((IASTInternalScope)scope).getPhysicalNode();
        }
        return null;
    }

    public static void addBinding(IScope scope, IBinding binding) {
        if (scope instanceof IASTInternalScope) {
            ((IASTInternalScope)scope).addBinding(binding);
        }
    }

    public static void addName(IScope scope, IASTName name) {
        if (scope instanceof IASTInternalScope) {
            ((IASTInternalScope)scope).addName(name);
        }
    }

    public static boolean isStatic(IFunction func, boolean resolveAll) {
        if (func instanceof ICPPInternalFunction) {
            return ((ICPPInternalFunction)((Object)func)).isStatic(resolveAll);
        }
        if (func instanceof ICInternalFunction) {
            return ((ICInternalFunction)((Object)func)).isStatic(resolveAll);
        }
        return func.isStatic();
    }

    public static void setFullyResolved(IBinding binding, boolean val) {
        if (binding instanceof ICInternalFunction) {
            ((ICInternalFunction)((Object)binding)).setFullyResolved(true);
        }
    }

    public static IASTNode getDeclaredInSourceFileOnly(IIndexFragment forFragment, IBinding binding, boolean requireDefinition, PDOMBinding glob) {
        IASTTranslationUnit tu;
        IASTNode result = ASTInternal.getDeclaredInSourceFileOnly(binding, requireDefinition);
        if (result == null) {
            return null;
        }
        if (requireDefinition && glob != null) {
            try {
                if (glob.hasDeclaration()) {
                    return null;
                }
            }
            catch (CoreException coreException) {}
        }
        if ((tu = result.getTranslationUnit()) != null && tu.getIndexFileSet().containsNonLocalDeclaration(binding, forFragment)) {
            return null;
        }
        return result;
    }

    public static IASTNode getDeclaredInSourceFileOnly(IBinding binding) {
        IASTNode result = ASTInternal.getDeclaredInSourceFileOnly(binding, false);
        if (result == null) {
            return null;
        }
        IASTTranslationUnit ast = result.getTranslationUnit();
        if (ast != null) {
            ITranslationUnit tu = ast.getOriginatingTranslationUnit();
            if (tu == null) {
                return null;
            }
            IIndexFileLocation location = IndexLocationFactory.getIFL(tu);
            IIndexFileSet fileSet = ast.getIndexFileSet();
            if (!(fileSet instanceof IndexFileSet)) {
                return null;
            }
            if (((IndexFileSet)fileSet).containsNonLocalDeclaration(binding, location)) {
                return null;
            }
        }
        return result;
    }

    private static IASTNode getDeclaredInSourceFileOnly(IBinding binding, boolean requireDefinition) {
        IASTNode def;
        IASTNode[] decls;
        Object ib;
        if (binding instanceof ICPPInternalBinding) {
            ib = (ICPPInternalBinding)binding;
            decls = ib.getDeclarations();
            def = ib.getDefinition();
        } else if (binding instanceof ICInternalBinding) {
            ib = (ICInternalBinding)((Object)binding);
            decls = ib.getDeclarations();
            def = ib.getDefinition();
        } else {
            return null;
        }
        if (requireDefinition && def == null) {
            return null;
        }
        IASTNode result = null;
        if (def != null) {
            if (!ASTInternal.isPartOfSource(def)) {
                return null;
            }
            result = def;
        }
        if (decls != null) {
            IASTNode[] iASTNodeArray = decls;
            int n = decls.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode node = iASTNodeArray[n2];
                if (node != null) {
                    if (!ASTInternal.isPartOfSource(node)) {
                        return null;
                    }
                    if ((result = ASTInternal.resolveConflict(result, node)) == null) {
                        return null;
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    private static boolean isPartOfSource(IASTNode decl) {
        return decl instanceof ASTNode && ((ASTNode)decl).isPartOfSourceFile();
    }

    private static IASTNode resolveConflict(IASTNode n1, IASTNode n2) {
        if (n1 == null) {
            return n2;
        }
        IASTFileLocation loc1 = n1.getFileLocation();
        if (loc1 == null) {
            return n2;
        }
        IASTFileLocation loc2 = n2.getFileLocation();
        if (loc2 != null && loc1.getContextInclusionStatement() != loc2.getContextInclusionStatement()) {
            return null;
        }
        return n1;
    }

    public static IASTNode getDeclaredInOneFileOnly(IBinding binding) {
        IASTNode def;
        IASTNode[] decls;
        Object ib;
        if (binding instanceof ICPPInternalBinding) {
            ib = (ICPPInternalBinding)binding;
            decls = ib.getDeclarations();
            def = ib.getDefinition();
        } else if (binding instanceof ICInternalBinding) {
            ib = (ICInternalBinding)((Object)binding);
            decls = ib.getDeclarations();
            def = ib.getDefinition();
        } else {
            return null;
        }
        IASTNode result = null;
        if (def != null) {
            result = def;
        }
        if (decls != null) {
            IASTNode[] iASTNodeArray = decls;
            int n = decls.length;
            int n2 = 0;
            while (n2 < n) {
                IASTNode node = iASTNodeArray[n2];
                if (node != null && (result = ASTInternal.resolveConflict(result, node)) == null) {
                    return null;
                }
                ++n2;
            }
        }
        return result;
    }

    public static void addDeclaration(IBinding b, IASTNode declaration) {
        if (b instanceof ICPPInternalBinding && declaration.isActive()) {
            ((ICPPInternalBinding)b).addDeclaration(declaration);
        }
    }

    public static void addDefinition(IBinding b, IASTNode declaration) {
        if (b instanceof ICPPInternalBinding && declaration.isActive()) {
            ((ICPPInternalBinding)b).addDefinition(declaration);
        }
    }

    public static boolean hasDeclaration(IBinding binding) {
        if (binding instanceof ICPPInternalBinding) {
            ICPPInternalBinding internal = (ICPPInternalBinding)binding;
            if (internal.getDefinition() != null) {
                return true;
            }
            IASTNode[] decls = internal.getDeclarations();
            return decls != null && decls.length > 0 && decls[0] != null;
        }
        if (binding instanceof IIndexBinding) {
            try {
                return IndexFilter.ALL_DECLARED.acceptBinding(binding);
            }
            catch (CoreException coreException) {
                return false;
            }
        }
        return binding != null;
    }
}

