/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine.pages;

import java.net.URL;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.templateengine.TemplateEngineUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.templateengine.uitree.UIElement;
import org.eclipse.cdt.ui.templateengine.uitree.uiwidgets.UIComposite;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Control;
import org.osgi.framework.Bundle;

public abstract class UIPage
extends DialogPage {
    protected UIComposite uiComposite;
    protected static String RESOURCES_ID = "org.eclipse.cdt.core.resources";
    protected final UIElement uiElement;
    protected final Map<String, String> valueStore;
    protected String title;
    protected String pageId;
    private ImageDescriptor imageDescriptor;

    protected UIPage(String name, UIElement element, Map<String, String> valueStore) {
        super(name);
        this.setTitle(name);
        this.setDescription((String)element.getAttributes().get("description"));
        try {
            String imageLoc = (String)element.getAttributes().get("image");
            if (imageLoc != null) {
                URL url = FileLocator.toFileURL((URL)FileLocator.find((Bundle)CCorePlugin.getDefault().getBundle(), (IPath)new Path(imageLoc), null));
                this.imageDescriptor = ImageDescriptor.createFromURL((URL)url);
            }
        }
        catch (Exception e) {
            TemplateEngineUtil.log((Throwable)e);
        }
        super.setImageDescriptor(this.imageDescriptor);
        this.title = name;
        this.uiElement = element;
        this.uiElement.setValues(valueStore);
        this.valueStore = valueStore;
        this.pageId = String.valueOf(CUIPlugin.getPluginId()) + "." + (String)this.uiElement.getAttributes().get("id");
    }

    public Map<String, String> getPageData() {
        return this.uiElement.getValues();
    }

    public Control getControl() {
        return this.uiComposite;
    }

    public UIComposite getComposite() {
        return this.uiComposite;
    }
}

