/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rcp.sysmon.launch.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ptp.launch.RMLaunchUtils;
import org.eclipse.ptp.launch.ui.LaunchImages;
import org.eclipse.ptp.launch.ui.tabs.LaunchConfigurationTab;
import org.eclipse.ptp.rcp.sysmon.launch.ui.Messages;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteServices;
import org.eclipse.remote.ui.IRemoteUIFileManager;
import org.eclipse.remote.ui.IRemoteUIServices;
import org.eclipse.remote.ui.RemoteUIServices;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SysMonApplicationTab
extends LaunchConfigurationTab {
    public static final String TAB_ID = "org.eclipse.ptp.rcp.sysmon.applicationTab";
    protected Text appText = null;
    protected Button appButton = null;
    protected Button browseAppButton = null;
    protected Button consoleButton = null;
    protected WidgetListener listener = new WidgetListener();
    protected final boolean combinedOutputDefault = true;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout());
        Composite mainComp = new Composite(comp, 0);
        mainComp.setLayout((Layout)this.createGridLayout(2, false, 0, 0));
        mainComp.setLayoutData((Object)new GridData(768));
        Label appLabel = new Label(mainComp, 0);
        appLabel.setText(Messages.SysMonApplicationTab_Application_program);
        appLabel.setLayoutData((Object)this.spanGridData(-1, 2));
        this.appText = new Text(mainComp, 2052);
        this.appText.setLayoutData((Object)new GridData(768));
        this.appText.addModifyListener((ModifyListener)this.listener);
        this.appButton = this.createPushButton(mainComp, Messages.SysMonApplicationTab_Browse, null);
        this.appButton.addSelectionListener((SelectionListener)this.listener);
        this.createVerticalSpacer(mainComp, 2);
        this.consoleButton = this.createCheckButton(mainComp, Messages.SysMonApplicationTab_Display_output_in_console);
        this.consoleButton.setSelection(true);
        this.consoleButton.addSelectionListener((SelectionListener)this.listener);
    }

    public String getId() {
        return TAB_ID;
    }

    public Image getImage() {
        return LaunchImages.getImage((String)LaunchImages.IMG_MAIN_TAB);
    }

    public String getName() {
        return Messages.SysMonApplicationTab_Application;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            this.appText.setText(configuration.getAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", ""));
            this.consoleButton.setSelection(configuration.getAttribute("org.eclipse.ptp.launch.ATTR_CONSOLE", false));
        }
        catch (CoreException coreException) {
            this.setErrorMessage(Messages.SysMonApplicationTab_Cannot_read_configuration);
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String appName = this.getFieldContent(this.appText.getText());
        if (appName == null) {
            this.setErrorMessage(Messages.SysMonApplicationTab_Application_program_not_specified);
            return false;
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", this.getFieldContent(this.appText.getText()));
        configuration.setAttribute("org.eclipse.ptp.launch.ATTR_CONSOLE", this.consoleButton.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", null);
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
    }

    protected void handleApplicationButtonSelected() {
        String initPath = this.appText.getText();
        final IRemoteConnection[] conn = new IRemoteConnection[1];
        try {
            this.getLaunchConfigurationDialog().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        conn[0] = RMLaunchUtils.getRemoteConnection((ILaunchConfiguration)SysMonApplicationTab.this.getLaunchConfiguration(), (IProgressMonitor)monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e.getCause());
                    }
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        if (conn[0] != null) {
            IRemoteUIFileManager fileManager;
            IRemoteUIServices remoteUIServices = RemoteUIServices.getRemoteUIServices((IRemoteServices)conn[0].getRemoteServices());
            if (remoteUIServices != null && (fileManager = remoteUIServices.getUIFileManager()) != null) {
                fileManager.setConnection(conn[0]);
                fileManager.showConnections(false);
                String path = fileManager.browseFile(this.getShell(), Messages.SysMonApplicationTab_Select_application_to_execute, initPath, 0);
                if (path != null) {
                    this.appText.setText(path.toString());
                }
            }
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.SysMonApplicationTab_Unable_to_open_connection, (String)Messages.SysMonApplicationTab_Please_specify_remote_connection_first);
        }
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            SysMonApplicationTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == SysMonApplicationTab.this.appButton) {
                SysMonApplicationTab.this.handleApplicationButtonSelected();
            } else if (source == SysMonApplicationTab.this.consoleButton) {
                SysMonApplicationTab.this.updateLaunchConfigurationDialog();
            }
        }
    }
}

