/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.trace.internal.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.trace.internal.TracingUIActivator;
import org.eclipse.ui.trace.internal.utils.DebugOptionsHandler;
import org.eclipse.ui.trace.internal.utils.TracingUtils;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceHandler
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        PreferenceHandler.setDefaultPreferences();
    }

    public static IEclipsePreferences getPreferences() {
        return new InstanceScope().getNode("org.eclipse.ui.trace");
    }

    public static Map<String, String> getPreferenceProperties() {
        IEclipsePreferences tracingPrefs = new InstanceScope().getNode("org.eclipse.ui.trace");
        String componentsAsString = tracingPrefs.get("tracingEntries", "");
        Map<String, String> options = null;
        options = !componentsAsString.equals("") ? TracingUtils.convertToMap(componentsAsString) : Collections.emptyMap();
        return options;
    }

    public static void setDefaultPreferences() {
        HashMap<String, String> prefValues = new HashMap<String, String>(5);
        prefValues.put("tracingEnabled", Boolean.toString(false));
        prefValues.put("tracingMaxFileCount", Integer.toString(10));
        prefValues.put("tracingMaxFileSize", Integer.toString(1000));
        prefValues.put("tracingOutputStandard", Boolean.toString(false));
        prefValues.put("tracingEntries", "");
        PreferenceHandler.savePreferences(prefValues);
    }

    public static void savePreferences(Map<String, String> entries) {
        IEclipsePreferences preferences = PreferenceHandler.getPreferences();
        if (entries != null) {
            for (Map.Entry<String, String> entry : entries.entrySet()) {
                preferences.put(entry.getKey(), entry.getValue());
            }
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException backingStoreEx) {
            TracingUIActivator.getDefault().logException((Exception)((Object)backingStoreEx));
        }
    }

    public static boolean isTracingEnabled() {
        IScopeContext[] lookupOrder = new IScopeContext[]{new InstanceScope()};
        IPreferencesService prefService = Platform.getPreferencesService();
        prefService.setDefaultLookupOrder("org.eclipse.ui.trace", null, new String[]{"instance"});
        return prefService.getBoolean("org.eclipse.ui.trace", "tracingEnabled", false, lookupOrder);
    }

    public static int getMaxFileCount() {
        IScopeContext[] lookupOrder = new IScopeContext[]{new InstanceScope()};
        IPreferencesService prefService = Platform.getPreferencesService();
        prefService.setDefaultLookupOrder("org.eclipse.ui.trace", null, new String[]{"instance"});
        return prefService.getInt("org.eclipse.ui.trace", "tracingMaxFileCount", 10, lookupOrder);
    }

    public static int getMaxFileSize() {
        IScopeContext[] lookupOrder = new IScopeContext[]{new InstanceScope()};
        IPreferencesService prefService = Platform.getPreferencesService();
        prefService.setDefaultLookupOrder("org.eclipse.ui.trace", null, new String[]{"instance"});
        return prefService.getInt("org.eclipse.ui.trace", "tracingMaxFileSize", 1000, lookupOrder);
    }

    public static String getFilePath() {
        IScopeContext[] lookupOrder = new IScopeContext[]{new InstanceScope()};
        IPreferencesService prefService = Platform.getPreferencesService();
        prefService.setDefaultLookupOrder("org.eclipse.ui.trace", null, new String[]{"instance"});
        return prefService.getString("org.eclipse.ui.trace", "tracingFilePath", DebugOptionsHandler.getDebugOptions().getFile() == null ? null : DebugOptionsHandler.getDebugOptions().getFile().getAbsolutePath(), lookupOrder);
    }

    public static String getOutputToStandardStream() {
        IScopeContext[] lookupOrder = new IScopeContext[]{new InstanceScope()};
        IPreferencesService prefService = Platform.getPreferencesService();
        prefService.setDefaultLookupOrder("org.eclipse.ui.trace", null, new String[]{"instance"});
        return prefService.getString("org.eclipse.ui.trace", "tracingOutputStandard", "false", lookupOrder);
    }
}

