/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.handlers;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.ide.IDEPreferenceInitializer;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.statushandlers.StatusManager;

public class ShowInSystemExplorerHandler
extends AbstractHandler {
    public static final String ID = "org.eclipse.ui.showIn.systemExplorer";
    private static final String VARIABLE_RESOURCE = "${selected_resource_loc}";
    private static final String VARIABLE_RESOURCE_URI = "${selected_resource_uri}";
    private static final String VARIABLE_FOLDER = "${selected_resource_parent_loc}";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String launchCmd;
        String logMsgPrefix;
        IResource item;
        ILog log;
        block9: {
            File canonicalPath;
            block8: {
                log = IDEWorkbenchPlugin.getDefault().getLog();
                item = this.getResource(event);
                if (item == null) {
                    return null;
                }
                try {
                    logMsgPrefix = String.valueOf(event.getCommand().getName()) + ": ";
                }
                catch (NotDefinedException notDefinedException) {
                    logMsgPrefix = String.valueOf(event.getCommand().getId()) + ": ";
                }
                try {
                    canonicalPath = this.getSystemExplorerPath(item);
                    if (canonicalPath != null) break block8;
                    StatusManager.getManager().handle((IStatus)new Status(4, IDEWorkbenchPlugin.getDefault().getBundle().getSymbolicName(), String.valueOf(logMsgPrefix) + IDEWorkbenchMessages.ShowInSystemExplorerHandler_notDetermineLocation), 3);
                    return null;
                }
                catch (Exception e) {
                    log.log((IStatus)new Status(4, IDEWorkbenchPlugin.getDefault().getBundle().getSymbolicName(), String.valueOf(logMsgPrefix) + "Unhandled failure.", (Throwable)e));
                    throw new ExecutionException("Show in Explorer command failed.", (Throwable)e);
                }
            }
            launchCmd = this.formShowInSytemExplorerCommand(canonicalPath);
            if (!"".equals(launchCmd)) break block9;
            StatusManager.getManager().handle((IStatus)new Status(4, IDEWorkbenchPlugin.getDefault().getBundle().getSymbolicName(), String.valueOf(logMsgPrefix) + IDEWorkbenchMessages.ShowInSystemExplorerHandler_commandUnavailable), 3);
            return null;
        }
        File dir = item.getWorkspace().getRoot().getLocation().toFile();
        Process p = Util.isLinux() || Util.isMac() ? Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", launchCmd}, null, dir) : Runtime.getRuntime().exec(launchCmd, null, dir);
        int retCode = p.waitFor();
        if (retCode != 0 && !Util.isWindows()) {
            log.log((IStatus)new Status(4, IDEWorkbenchPlugin.getDefault().getBundle().getSymbolicName(), String.valueOf(logMsgPrefix) + "Execution of '" + launchCmd + "' failed with return code: " + retCode));
        }
        return null;
    }

    private IResource getResource(ExecutionEvent event) {
        IResource resource = this.getSelectionResource(event);
        if (resource == null) {
            resource = this.getEditorInputResource(event);
        }
        return resource;
    }

    private IResource getSelectionResource(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        Object selectedObject = ((IStructuredSelection)selection).getFirstElement();
        IResource item = (IResource)org.eclipse.ui.internal.util.Util.getAdapter((Object)selectedObject, IResource.class);
        return item;
    }

    private IResource getEditorInputResource(ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (!(activePart instanceof IEditorPart)) {
            return null;
        }
        IEditorInput input = ((IEditorPart)activePart).getEditorInput();
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return (IResource)input.getAdapter(IResource.class);
    }

    private String formShowInSytemExplorerCommand(File path) throws IOException {
        String command = IDEWorkbenchPlugin.getDefault().getPreferenceStore().getString("SYSTEM_EXPLORER");
        command = Util.replaceAll((String)command, (String)VARIABLE_RESOURCE, (String)this.quotePath(path.getCanonicalPath()));
        command = Util.replaceAll((String)command, (String)VARIABLE_RESOURCE_URI, (String)path.getCanonicalFile().toURI().toString());
        File parent = path.getParentFile();
        if (parent != null) {
            command = Util.replaceAll((String)command, (String)VARIABLE_FOLDER, (String)this.quotePath(parent.getCanonicalPath()));
        }
        return command;
    }

    private String quotePath(String path) {
        if (Util.isLinux() || Util.isMac()) {
            path = path.replaceAll("[\"$`]", "\\\\$0");
        }
        return path;
    }

    private File getSystemExplorerPath(IResource resource) throws IOException {
        IPath location = resource.getLocation();
        if (location == null) {
            return null;
        }
        return location.toFile();
    }

    public static String getDefaultCommand() {
        return IDEPreferenceInitializer.getShowInSystemExplorerCommand();
    }
}

