/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.core;

import java.util.Collections;
import java.util.Map;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.internal.jsch.core.JSchConnection;
import org.eclipse.remote.internal.jsch.core.JSchConnectionAttributes;

public class JSchConnectionWorkingCopy
extends JSchConnection
implements IRemoteConnectionWorkingCopy {
    private final JSchConnectionAttributes fWorkingAttributes;
    private final JSchConnection fOriginal;
    private boolean fIsDirty;

    public JSchConnectionWorkingCopy(JSchConnection connection) {
        super(connection.getName(), connection.getRemoteServices());
        this.fWorkingAttributes = connection.getInfo().copy();
        this.fOriginal = connection;
        this.fIsDirty = false;
    }

    @Override
    public String getAddress() {
        return this.fWorkingAttributes.getAttribute("JSCH_ADDRESS_ATTR", "");
    }

    @Override
    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.fWorkingAttributes.getAttributes());
    }

    @Override
    public String getName() {
        return this.fWorkingAttributes.getName();
    }

    public IRemoteConnection getOriginal() {
        return this.fOriginal;
    }

    @Override
    public String getPassphrase() {
        return this.fWorkingAttributes.getSecureAttribute("JSCH_PASSPHRASE_ATTR", "");
    }

    @Override
    public String getPassword() {
        return this.fWorkingAttributes.getSecureAttribute("JSCH_PASSWORD_ATTR", "");
    }

    @Override
    public int getPort() {
        return this.fWorkingAttributes.getInt("JSCH_PORT_ATTR", 22);
    }

    @Override
    public String getProxyCommand() {
        return this.fWorkingAttributes.getAttribute("JSCH_PROXYCOMMAND_ATTR", "");
    }

    @Override
    public String getProxyConnectionName() {
        return this.fWorkingAttributes.getAttribute("JSCH_PROXYCONNECTION_ATTR", "");
    }

    @Override
    public int getTimeout() {
        return this.fWorkingAttributes.getInt("JSCH_TIMEOUT_ATTR", 0);
    }

    @Override
    public String getUsername() {
        return this.fWorkingAttributes.getAttribute("JSCH_USERNAME_ATTR", "");
    }

    @Override
    public IRemoteConnectionWorkingCopy getWorkingCopy() {
        return this;
    }

    public boolean isDirty() {
        return this.fIsDirty;
    }

    @Override
    public boolean isPasswordAuth() {
        return this.fWorkingAttributes.getBoolean("JSCH_IS_PASSWORD_ATTR", true);
    }

    public IRemoteConnection save() {
        JSchConnectionAttributes info = this.fOriginal.getInfo();
        info.getAttributes().clear();
        info.getAttributes().putAll(this.fWorkingAttributes.getAttributes());
        info.setSecureAttributes(this.fWorkingAttributes.getSecureAttributes());
        if (!this.getName().equals(info.getName())) {
            info.setName(this.getName());
            this.getManager().remove(this.fOriginal);
            this.fOriginal.fireConnectionChangeEvent(8);
        }
        info.save();
        this.getManager().add(this.fOriginal);
        this.fIsDirty = false;
        return this.fOriginal;
    }

    public void setAddress(String address) {
        this.fIsDirty = true;
        this.fWorkingAttributes.setAttribute("JSCH_ADDRESS_ATTR", address);
    }

    public void setAttribute(String key, String value) {
        this.fIsDirty = true;
        this.fWorkingAttributes.setAttribute(key, value);
    }

    public void setIsPasswordAuth(boolean flag) {
        this.fIsDirty = true;
        this.fWorkingAttributes.setAttribute("JSCH_IS_PASSWORD_ATTR", Boolean.toString(flag));
    }

    public void setName(String name) {
        this.fIsDirty = true;
        this.fWorkingAttributes.setName(name);
    }

    public void setPassphrase(String passphrase) {
        this.fIsDirty = true;
        this.fWorkingAttributes.setSecureAttribute("JSCH_PASSPHRASE_ATTR", passphrase);
    }

    public void setPassword(String password) {
        this.fIsDirty = true;
        this.fWorkingAttributes.setSecureAttribute("JSCH_PASSWORD_ATTR", password);
    }

    public void setPort(int port) {
        this.fIsDirty = true;
        this.fWorkingAttributes.setAttribute("JSCH_PORT_ATTR", Integer.toString(port));
    }

    public void setProxyCommand(String proxyCommand) {
        this.fIsDirty = true;
        this.fWorkingAttributes.setAttribute("JSCH_PROXYCOMMAND_ATTR", proxyCommand);
    }

    public void setProxyConnectionName(String proxyConnectionName) {
        this.fIsDirty = true;
        this.fWorkingAttributes.setAttribute("JSCH_PROXYCONNECTION_ATTR", proxyConnectionName);
    }

    public void setTimeout(int timeout) {
        this.fIsDirty = true;
        this.fWorkingAttributes.setAttribute("JSCH_TIMEOUT_ATTR", Integer.toString(timeout));
    }

    public void setUseLoginShell(boolean flag) {
        this.fIsDirty = true;
        this.fWorkingAttributes.setAttribute("JSCH_USE_LOGIN_SHELL_ATTR", Boolean.toString(flag));
    }

    public void setUsername(String userName) {
        this.fIsDirty = true;
        this.fWorkingAttributes.setAttribute("JSCH_USERNAME_ATTR", userName);
    }
}

