/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.jaxb.control.core.runnable;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ptp.core.util.CoreExceptionUtils;
import org.eclipse.ptp.internal.rm.jaxb.control.core.JAXBControlConstants;
import org.eclipse.ptp.internal.rm.jaxb.control.core.JAXBControlCorePlugin;
import org.eclipse.ptp.internal.rm.jaxb.control.core.LaunchController;
import org.eclipse.ptp.internal.rm.jaxb.control.core.RemoteServicesDelegate;
import org.eclipse.ptp.internal.rm.jaxb.control.core.data.LineImpl;
import org.eclipse.ptp.internal.rm.jaxb.control.core.messages.Messages;
import org.eclipse.ptp.rm.jaxb.control.core.ILaunchController;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.LineType;
import org.eclipse.ptp.rm.jaxb.core.data.ManagedFileType;
import org.eclipse.ptp.rm.jaxb.core.data.ManagedFilesType;
import org.eclipse.remote.core.IRemoteConnection;

public class ManagedFilesJob
extends Job {
    private final String uuid;
    private final ILaunchController control;
    private final List<ManagedFileType> files;
    private RemoteServicesDelegate delegate;
    private IVariableMap rmVarMap;
    private String stagingDir;
    private boolean success;
    private Operation operation;

    public ManagedFilesJob(String uuid, ManagedFilesType files, ILaunchController control) throws CoreException {
        super(Messages.ManagedFilesJob);
        this.uuid = uuid;
        this.control = control;
        this.stagingDir = files.getFileStagingLocation();
        this.files = files.getFile();
    }

    public boolean getSuccess() {
        return this.success;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        try {
            try {
                this.delegate = RemoteServicesDelegate.getDelegate(this.control.getRemoteServicesId(), this.control.getConnectionName(), (IProgressMonitor)progress.newChild(2));
                IRemoteConnection conn = this.delegate.getRemoteConnection();
                LaunchController.checkConnection(conn, progress);
            }
            catch (Exception e) {
                IStatus iStatus = CoreExceptionUtils.getErrorStatus((String)Messages.ManagedFilesJobError, (Throwable)e);
                if (monitor != null) {
                    monitor.done();
                }
                return iStatus;
            }
            this.rmVarMap = this.control.getEnvironment();
            this.success = false;
            try {
                if (this.operation == Operation.COPY) {
                    this.doCopy(monitor);
                } else if (this.operation == Operation.DELETE) {
                    this.doDelete(monitor);
                }
                this.success = true;
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (Exception e) {
                IStatus iStatus;
                block14: {
                    iStatus = CoreExceptionUtils.getErrorStatus((String)Messages.ManagedFilesJobError, (Throwable)e);
                    if (monitor == null) break block14;
                    monitor.done();
                }
                return iStatus;
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void copyFileToRemoteHost(String localPath, String remotePath, IProgressMonitor monitor) throws CoreException {
        RemoteServicesDelegate.copy(this.delegate.getLocalFileService(), localPath, this.delegate.getRemoteFileService(), remotePath, 0, monitor);
    }

    private void doCopy(IProgressMonitor monitor) throws Exception {
        this.stagingDir = this.rmVarMap.getString(this.uuid, this.stagingDir);
        boolean localTarget = this.delegate.getLocalFileService() == this.delegate.getRemoteFileService();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.files.size() * 10));
        for (ManagedFileType file : this.files) {
            File localFile = this.maybeWriteFile(file);
            progress.worked(5);
            String fileName = localFile.getName();
            if (fileName == null || fileName.length() == 0) continue;
            String pathSep = localTarget ? JAXBControlConstants.PATH_SEP : "/";
            String target = String.valueOf(this.stagingDir) + pathSep + fileName;
            SubMonitor m = progress.newChild(5);
            this.copyFileToRemoteHost(localFile.getAbsolutePath(), target, (IProgressMonitor)m);
            if (file.isDeleteSourceAfterUse()) {
                localFile.delete();
            }
            if (m.isCanceled()) break;
            AttributeType a = new AttributeType();
            a.setName(file.getName());
            if (localTarget && !new File(target).isAbsolute()) {
                a.setValue((Object)new File(System.getProperty("user.home"), target).getAbsolutePath());
            } else {
                a.setValue((Object)target);
            }
            a.setVisible(Boolean.valueOf(false));
            this.rmVarMap.put(a.getName(), a);
            progress.worked(5);
        }
    }

    private void doDelete(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.files.size() * 15));
        for (ManagedFileType file : this.files) {
            if (!file.isDeleteTargetAfterUse()) {
                progress.worked(15);
                continue;
            }
            AttributeType a = this.rmVarMap.get(file.getName());
            IFileStore store = this.delegate.getRemoteFileService().getResource(String.valueOf(a.getValue()));
            try {
                if (!store.fetchInfo(0, (IProgressMonitor)progress.newChild(5)).exists()) continue;
                store.delete(0, (IProgressMonitor)progress.newChild(10));
            }
            catch (CoreException t) {
                JAXBControlCorePlugin.log(t);
            }
        }
    }

    private File maybeWriteFile(ManagedFileType file) throws IOException, CoreException {
        String path = file.getPath();
        if (path != null) {
            path = this.rmVarMap.getString(this.uuid, path);
            return new File(path);
        }
        String name = this.rmVarMap.getString(this.uuid, file.getName());
        if (file.isUniqueIdPrefix()) {
            name = UUID.randomUUID() + name;
        }
        File sourceDir = new File(System.getProperty("java.io.tmpdir"));
        File localFile = new File(sourceDir, name);
        String contents = file.getContents();
        List lines = file.getLine();
        OutputStreamWriter fw = null;
        try {
            if (!lines.isEmpty()) {
                StringBuffer buffer = new StringBuffer();
                String s = null;
                for (LineType line : lines) {
                    s = new LineImpl(this.uuid, line, this.rmVarMap).getResolved();
                    if ("".equals(s)) continue;
                    buffer.append(s).append("\n");
                }
                contents = buffer.toString();
            } else if (file.isResolveContents()) {
                contents = this.rmVarMap.getString(this.uuid, contents);
            } else {
                int start = contents.indexOf("${ptp_rm:");
                int end = contents.length();
                if (start >= 0) {
                    start += "${ptp_rm:".length();
                    end = contents.indexOf("#");
                    if (end < 0) {
                        end = contents.indexOf("}");
                    }
                    String key = contents.substring(start, end);
                    contents = String.valueOf(this.rmVarMap.get(key).getValue());
                }
            }
            fw = new FileWriter(localFile, false);
            fw.write(contents);
            fw.flush();
        }
        finally {
            try {
                if (fw != null) {
                    fw.close();
                }
            }
            catch (IOException t) {
                JAXBControlCorePlugin.log(t);
            }
        }
        return localFile;
    }

    public static enum Operation {
        COPY,
        DELETE;

    }
}

