/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventCrossing;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkEventMotion;
import org.eclipse.swt.internal.gtk.GdkEventWindowState;
import org.eclipse.swt.internal.gtk.GdkGeometry;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GdkWindowAttr;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XFocusChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.TypedListener;

public class Shell
extends Decorations {
    int shellHandle;
    int tooltipsHandle;
    int tooltipWindow;
    int group;
    int modalGroup;
    boolean mapped;
    boolean moved;
    boolean resized;
    boolean opened;
    boolean fullScreen;
    boolean showWithParent;
    boolean modified;
    boolean center;
    int oldX;
    int oldY;
    int oldWidth;
    int oldHeight;
    int minWidth;
    int minHeight;
    Control lastActive;
    ToolTip[] toolTips;
    boolean ignoreFocusOut;
    Region originalRegion;
    static final int MAXIMUM_TRIM = 128;
    static final int BORDER = 3;

    public Shell() {
        this((Display)null);
    }

    public Shell(int style) {
        this((Display)null, style);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int style) {
        this(display, null, style, 0, false);
    }

    Shell(Display display, Shell parent, int style, int handle, boolean embedded) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        if (parent != null && parent.isDisposed()) {
            this.error(5);
        }
        this.center = parent != null && (style & 0x10000000) != 0;
        this.style = Shell.checkStyle(parent, style);
        this.parent = parent;
        this.display = display;
        if (handle != 0) {
            if (embedded) {
                this.handle = handle;
            } else {
                this.shellHandle = handle;
                this.state |= 0x400000;
            }
        }
        this.reskinWidget();
        this.createWidget(0);
    }

    public Shell(Shell parent) {
        this(parent, 2144);
    }

    public Shell(Shell parent, int style) {
        this(parent != null ? parent.display : null, parent, style, 0, false);
    }

    public static Shell gtk_new(Display display, int handle) {
        return new Shell(display, null, 8, handle, true);
    }

    public static Shell internal_new(Display display, int handle) {
        return new Shell(display, null, 8, handle, false);
    }

    static int checkStyle(Shell parent, int style) {
        style = Decorations.checkStyle(style);
        if (((style &= 0xBFFFFFFF) & 0x4000) != 0) {
            style &= 0xFFFFFB1F;
        }
        int mask = 229376;
        if ((style & 0x10000000) != 0) {
            style &= 0xEFFFFFFF;
            if (((style |= parent == null ? 1264 : 2144) & mask) == 0) {
                style |= parent == null ? 65536 : 32768;
            }
        }
        int bits = style & ~mask;
        if ((style & 0x20000) != 0) {
            return bits | 0x20000;
        }
        if ((style & 0x10000) != 0) {
            return bits | 0x10000;
        }
        if ((style & 0x8000) != 0) {
            return bits | 0x8000;
        }
        return bits;
    }

    public void addShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(21, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
        this.addListener(26, typedListener);
        this.addListener(27, typedListener);
    }

    void addToolTip(ToolTip toolTip) {
        if (this.toolTips == null) {
            this.toolTips = new ToolTip[4];
        }
        int i = 0;
        while (i < this.toolTips.length) {
            if (this.toolTips[i] == null) {
                this.toolTips[i] = toolTip;
                return;
            }
            ++i;
        }
        ToolTip[] newToolTips = new ToolTip[this.toolTips.length + 4];
        newToolTips[this.toolTips.length] = toolTip;
        System.arraycopy(this.toolTips, 0, newToolTips, 0, this.toolTips.length);
        this.toolTips = newToolTips;
    }

    void adjustTrim() {
        if (this.display.ignoreTrim) {
            return;
        }
        GtkAllocation allocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(this.shellHandle, allocation);
        int width = allocation.width;
        int height = allocation.height;
        int window = this.gtk_widget_get_window(this.shellHandle);
        GdkRectangle rect = new GdkRectangle();
        OS.gdk_window_get_frame_extents(window, rect);
        int trimWidth = Math.max(0, rect.width - width);
        int trimHeight = Math.max(0, rect.height - height);
        if (trimWidth > 128 || trimHeight > 128) {
            this.display.ignoreTrim = true;
            return;
        }
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        if ((this.style & 8) == 0) {
            hasTitle = (this.style & 0x4E0) != 0;
            hasResize = (this.style & 0x10) != 0;
            boolean bl = hasBorder = (this.style & 0x800) != 0;
        }
        if (hasTitle) {
            if (hasResize) {
                this.display.titleResizeTrimWidth = trimWidth;
                this.display.titleResizeTrimHeight = trimHeight;
                return;
            }
            if (hasBorder) {
                this.display.titleBorderTrimWidth = trimWidth;
                this.display.titleBorderTrimHeight = trimHeight;
                return;
            }
            this.display.titleTrimWidth = trimWidth;
            this.display.titleTrimHeight = trimHeight;
            return;
        }
        if (hasResize) {
            this.display.resizeTrimWidth = trimWidth;
            this.display.resizeTrimHeight = trimHeight;
            return;
        }
        if (hasBorder) {
            this.display.borderTrimWidth = trimWidth;
            this.display.borderTrimHeight = trimHeight;
            return;
        }
    }

    void bringToTop(boolean force) {
        if (!OS.gtk_widget_get_visible(this.shellHandle)) {
            return;
        }
        Display display = this.display;
        Shell activeShell = display.activeShell;
        if (activeShell == this) {
            return;
        }
        if (!force) {
            int focusHandle;
            if (activeShell == null) {
                return;
            }
            if (!display.activePending && (focusHandle = OS.gtk_window_get_focus(activeShell.shellHandle)) != 0 && !OS.gtk_widget_has_focus(focusHandle)) {
                return;
            }
        }
        boolean xFocus = false;
        if (activeShell != null) {
            display.activeShell = null;
            display.activePending = true;
        }
        int window = this.gtk_widget_get_window(this.shellHandle);
        if (xFocus || (this.style & 0x4000) != 0) {
            if (OS.isX11()) {
                int xDisplay = OS.GTK_VERSION >= OS.VERSION(2, 24, 0) ? OS.gdk_x11_display_get_xdisplay(OS.gdk_window_get_display(window)) : OS.gdk_x11_drawable_get_xdisplay(window);
                int xWindow = OS.GTK3 ? OS.gdk_x11_window_get_xid(window) : OS.gdk_x11_drawable_get_xid(window);
                OS.gdk_error_trap_push();
                OS.XSetInputFocus(xDisplay, xWindow, 2, 0);
                OS.gdk_error_trap_pop();
            }
        } else if (display.windowManager.toLowerCase().equals("metacity")) {
            OS.gdk_window_focus(window, display.lastUserEventTime);
        } else {
            OS.gdk_window_focus(window, 0);
        }
        display.activeShell = this;
        display.activePending = true;
    }

    void center() {
        if (this.parent == null) {
            return;
        }
        Rectangle rect = this.getBounds();
        Rectangle parentRect = this.display.map((Control)this.parent, null, this.parent.getClientArea());
        int x = Math.max(parentRect.x, parentRect.x + (parentRect.width - rect.width) / 2);
        int y = Math.max(parentRect.y, parentRect.y + (parentRect.height - rect.height) / 2);
        Rectangle monitorRect = this.parent.getMonitor().getClientArea();
        x = x + rect.width > monitorRect.x + monitorRect.width ? Math.max(monitorRect.x, monitorRect.x + monitorRect.width - rect.width) : Math.max(x, monitorRect.x);
        y = y + rect.height > monitorRect.y + monitorRect.height ? Math.max(monitorRect.y, monitorRect.y + monitorRect.height - rect.height) : Math.max(y, monitorRect.y);
        this.setLocation(x, y);
    }

    void checkBorder() {
    }

    void checkOpen() {
        if (!this.opened) {
            this.resized = false;
        }
    }

    int childStyle() {
        return 0;
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    void closeWidget() {
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        Rectangle trim = super.computeTrim(x, y, width, height);
        int border = 0;
        if ((this.style & 0xCF8) == 0) {
            border = OS.gtk_container_get_border_width(this.shellHandle);
        }
        if (this.isCustomResize()) {
            border = OS.gtk_container_get_border_width(this.shellHandle);
        }
        int trimWidth = this.trimWidth();
        int trimHeight = this.trimHeight();
        trim.x -= trimWidth / 2 + border;
        trim.y -= trimHeight - trimWidth / 2 + border;
        trim.width += trimWidth + border * 2;
        trim.height += trimHeight + border * 2;
        if (this.menuBar != null) {
            this.forceResize();
            GtkAllocation allocation = new GtkAllocation();
            OS.gtk_widget_get_allocation(this.menuBar.handle, allocation);
            int menuBarHeight = allocation.height;
            trim.y -= menuBarHeight;
            trim.height += menuBarHeight;
        }
        return trim;
    }

    void createHandle(int index) {
        this.state |= 0xA;
        if (this.shellHandle == 0) {
            if (this.handle == 0) {
                int type = 0;
                if ((this.style & 0x4000) != 0) {
                    type = 1;
                }
                this.shellHandle = OS.gtk_window_new(type);
            } else {
                this.shellHandle = OS.gtk_plug_new(this.handle);
            }
            if (this.shellHandle == 0) {
                this.error(2);
            }
            if (this.parent != null) {
                OS.gtk_window_set_transient_for(this.shellHandle, this.parent.topHandle());
                OS.gtk_window_set_destroy_with_parent(this.shellHandle, true);
                OS.gtk_window_set_skip_taskbar_hint(this.shellHandle, true);
            }
            if ((this.style & 0x10) != 0) {
                OS.gtk_widget_set_size_request(this.shellHandle, 0, 0);
                OS.gtk_window_set_resizable(this.shellHandle, true);
            } else {
                OS.gtk_window_set_resizable(this.shellHandle, false);
            }
            OS.gtk_window_set_title(this.shellHandle, new byte[1]);
            if ((this.style & 0xCF8) == 0) {
                OS.gtk_container_set_border_width(this.shellHandle, 1);
                if (OS.GTK3) {
                    OS.gtk_widget_override_background_color(this.shellHandle, 0, new GdkRGBA());
                } else {
                    GdkColor color = new GdkColor();
                    OS.gtk_style_get_black(OS.gtk_widget_get_style(this.shellHandle), color);
                    OS.gtk_widget_modify_bg(this.shellHandle, 0, color);
                }
            }
            if (this.isCustomResize()) {
                OS.gtk_container_set_border_width(this.shellHandle, 3);
            }
        }
        this.vboxHandle = this.gtk_box_new(1, false, 0);
        if (this.vboxHandle == 0) {
            this.error(2);
        }
        this.createHandle(index, false, true);
        OS.gtk_container_add(this.vboxHandle, this.scrolledHandle);
        OS.gtk_box_set_child_packing(this.vboxHandle, this.scrolledHandle, true, true, 0, 1);
        this.group = OS.gtk_window_group_new();
        if (this.group == 0) {
            this.error(2);
        }
        OS.gtk_widget_realize(this.shellHandle);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int filterProc(int xEvent, int gdkEvent, int data2) {
        int eventType = OS.X_EVENT_TYPE(xEvent);
        if (eventType != 10 && eventType != 9) {
            return 0;
        }
        XFocusChangeEvent xFocusEvent = new XFocusChangeEvent();
        OS.memmove(xFocusEvent, xEvent, XFocusChangeEvent.sizeof);
        switch (eventType) {
            case 9: {
                if (xFocusEvent.mode != 0 && xFocusEvent.mode != 3) return 0;
                switch (xFocusEvent.detail) {
                    case 0: 
                    case 3: 
                    case 4: {
                        this.display.activeShell = this;
                        this.display.activePending = false;
                        this.sendEvent(26);
                        if (this.isDisposed()) {
                            return 0;
                        }
                        if (!this.isCustomResize()) break;
                        OS.gdk_window_invalidate_rect(this.gtk_widget_get_window(this.shellHandle), null, false);
                    }
                }
                return 0;
            }
            case 10: {
                if (xFocusEvent.mode != 0 && xFocusEvent.mode != 3) return 0;
                switch (xFocusEvent.detail) {
                    case 1: 
                    case 3: 
                    case 4: {
                        Display display = this.display;
                        this.sendEvent(27);
                        this.setActiveControl(null);
                        if (display.activeShell == this) {
                            display.activeShell = null;
                            display.activePending = false;
                        }
                        if (this.isDisposed()) {
                            return 0;
                        }
                        if (!this.isCustomResize()) return 0;
                        OS.gdk_window_invalidate_rect(this.gtk_widget_get_window(this.shellHandle), null, false);
                    }
                }
            }
        }
        return 0;
    }

    Control findBackgroundControl() {
        return (this.state & 0x2000) != 0 || this.backgroundImage != null ? this : null;
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    public ToolBar getToolBar() {
        this.checkWidget();
        return null;
    }

    boolean hasBorder() {
        return false;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[27], 0, this.display.getClosure(27), false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[59], 0, this.display.getClosure(59), false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[47], 0, this.display.getClosure(47), false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[10], 0, this.display.getClosure(10), false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[11], 0, this.display.getClosure(11), false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[31], 0, this.display.shellMapProcClosure, false);
        OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[14], 0, this.display.getClosure(14), false);
        OS.g_signal_connect_closure(this.shellHandle, OS.move_focus, this.display.getClosure(35), false);
        if (!OS.GTK3) {
            int window = this.gtk_widget_get_window(this.shellHandle);
            OS.gdk_window_add_filter(window, this.display.filterProc, this.shellHandle);
        } else {
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[21], 0, this.display.getClosure(21), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[22], 0, this.display.getClosure(22), false);
        }
        if (this.isCustomResize()) {
            int mask = 13060;
            OS.gtk_widget_add_events(this.shellHandle, mask);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[18], 0, this.display.getClosure(18), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[29], 0, this.display.getClosure(29), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[33], 0, this.display.getClosure(33), false);
            OS.g_signal_connect_closure_by_id(this.shellHandle, this.display.signalIds[2], 0, this.display.getClosure(2), false);
        }
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    boolean isUndecorated() {
        return (this.style & 0xCF0) == 0 || (this.style & 0x4008) != 0;
    }

    boolean isCustomResize() {
        return (this.style & 8) == 0 && (this.style & 0x4010) == 16400;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void register() {
        super.register();
        this.display.addWidget(this.shellHandle, this);
    }

    void releaseParent() {
    }

    int topHandle() {
        return this.shellHandle;
    }

    void fixActiveShell() {
        if (this.display.activeShell == this) {
            Shell shell = null;
            if (this.parent != null && this.parent.isVisible()) {
                shell = this.parent.getShell();
            }
            if (shell == null && this.isUndecorated()) {
                Shell[] shells = this.display.getShells();
                int i = 0;
                while (i < shells.length) {
                    if (shells[i] != null && shells[i].isVisible()) {
                        shell = shells[i];
                        break;
                    }
                    ++i;
                }
            }
            if (shell != null) {
                shell.bringToTop(false);
            }
        }
    }

    void fixShell(Shell newShell, Control control) {
        String toolTipText;
        if (this == newShell) {
            return;
        }
        if (control == this.lastActive) {
            this.setActiveControl(null);
        }
        if ((toolTipText = control.toolTipText) != null) {
            control.setToolTipText(this, null);
            control.setToolTipText(newShell, toolTipText);
        }
    }

    int fixedSizeAllocateProc(int widget, int allocationPtr) {
        int clientWidth = 0;
        if ((this.style & 0x8000000) != 0) {
            clientWidth = this.getClientWidth();
        }
        int result = super.fixedSizeAllocateProc(widget, allocationPtr);
        if ((this.style & 0x8000000) != 0) {
            this.moveChildren(clientWidth);
        }
        return result;
    }

    void fixStyle(int handle) {
    }

    void forceResize() {
        GtkAllocation allocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(this.vboxHandle, allocation);
        this.forceResize(allocation.width, allocation.height);
    }

    void forceResize(int width, int height) {
        int border;
        int clientWidth = 0;
        if (OS.GTK3 && (this.style & 0x8000000) != 0) {
            clientWidth = this.getClientWidth();
        }
        GtkRequisition requisition = new GtkRequisition();
        this.gtk_widget_get_preferred_size(this.vboxHandle, requisition);
        GtkAllocation allocation = new GtkAllocation();
        allocation.x = border = OS.gtk_container_get_border_width(this.shellHandle);
        allocation.y = border;
        allocation.width = width;
        allocation.height = height;
        OS.gtk_widget_size_allocate(this.vboxHandle, allocation);
        if (OS.GTK3 && (this.style & 0x8000000) != 0) {
            this.moveChildren(clientWidth);
        }
    }

    public int getAlpha() {
        this.checkWidget();
        if (OS.gtk_widget_is_composited(this.shellHandle)) {
            return (int)(OS.gtk_window_get_opacity(this.shellHandle) * 255.0);
        }
        return 255;
    }

    int getResizeMode(double x, double y) {
        GtkAllocation allocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(this.shellHandle, allocation);
        int width = allocation.width;
        int height = allocation.height;
        int border = OS.gtk_container_get_border_width(this.shellHandle);
        int mode = 0;
        if (y >= (double)(height - border)) {
            mode = 16;
            if (x >= (double)(width - border - 16)) {
                mode = 14;
            } else if (x <= (double)(border + 16)) {
                mode = 12;
            }
        } else if (x >= (double)(width - border)) {
            mode = 96;
            if (y >= (double)(height - border - 16)) {
                mode = 14;
            } else if (y <= (double)(border + 16)) {
                mode = 136;
            }
        } else if (y <= (double)border) {
            mode = 138;
            if (x <= (double)(border + 16)) {
                mode = 134;
            } else if (x >= (double)(width - border - 16)) {
                mode = 136;
            }
        } else if (x <= (double)border) {
            mode = 70;
            if (y <= (double)(border + 16)) {
                mode = 134;
            } else if (y >= (double)(height - border - 16)) {
                mode = 12;
            }
        }
        return mode;
    }

    public boolean getFullScreen() {
        this.checkWidget();
        return this.fullScreen;
    }

    public Point getLocation() {
        this.checkWidget();
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gtk_window_get_position(this.shellHandle, x, y);
        return new Point(x[0], y[0]);
    }

    public boolean getMaximized() {
        this.checkWidget();
        return !this.fullScreen && super.getMaximized();
    }

    public Point getMinimumSize() {
        this.checkWidget();
        int width = Math.max(1, this.minWidth + this.trimWidth());
        int height = Math.max(1, this.minHeight + this.trimHeight());
        return new Point(width, height);
    }

    Shell getModalShell() {
        Shell shell = null;
        Shell[] modalShells = this.display.modalShells;
        if (modalShells != null) {
            int bits = 196608;
            int index = modalShells.length;
            while (--index >= 0) {
                Shell modal = modalShells[index];
                if (modal == null) continue;
                if ((modal.style & bits) != 0) {
                    Composite control = this;
                    while (control != null) {
                        if (control == modal) break;
                        control = control.parent;
                    }
                    if (control == modal) break;
                    return modal;
                }
                if ((modal.style & 0x8000) == 0) continue;
                if (shell == null) {
                    shell = this.getShell();
                }
                if (modal.parent != shell) continue;
                return modal;
            }
        }
        return null;
    }

    public boolean getModified() {
        this.checkWidget();
        return this.modified;
    }

    public Point getSize() {
        this.checkWidget();
        GtkAllocation allocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(this.vboxHandle, allocation);
        int width = allocation.width;
        int height = allocation.height;
        int border = 0;
        if ((this.style & 0xCF8) == 0) {
            border = OS.gtk_container_get_border_width(this.shellHandle);
        }
        return new Point(width + this.trimWidth() + 2 * border, height + this.trimHeight() + 2 * border);
    }

    public boolean getVisible() {
        this.checkWidget();
        return OS.gtk_widget_get_visible(this.shellHandle);
    }

    public Region getRegion() {
        this.checkWidget();
        if (this.originalRegion != null) {
            return this.originalRegion;
        }
        return this.region;
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    Shell _getShell() {
        return this;
    }

    public Shell[] getShells() {
        this.checkWidget();
        int count = 0;
        Shell[] shells = this.display.getShells();
        int i = 0;
        while (i < shells.length) {
            Composite shell = shells[i];
            while ((shell = shell.getParent()) != null && shell != this) {
            }
            if (shell == this) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        int i2 = 0;
        while (i2 < shells.length) {
            Composite shell = shells[i2];
            while ((shell = shell.getParent()) != null && shell != this) {
            }
            if (shell == this) {
                result[index++] = shells[i2];
            }
            ++i2;
        }
        return result;
    }

    int gtk_button_press_event(int widget, int event) {
        if (widget == this.shellHandle) {
            if (this.isCustomResize()) {
                if ((this.style & 0x4000) != 0 && (this.style & 0x80000) == 0) {
                    this.forceActive();
                }
                GdkEventButton gdkEvent = new GdkEventButton();
                OS.memmove(gdkEvent, event, GdkEventButton.sizeof);
                if (gdkEvent.button == 1) {
                    this.display.resizeLocationX = gdkEvent.x_root;
                    this.display.resizeLocationY = gdkEvent.y_root;
                    int[] x = new int[1];
                    int[] y = new int[1];
                    OS.gtk_window_get_position(this.shellHandle, x, y);
                    this.display.resizeBoundsX = x[0];
                    this.display.resizeBoundsY = y[0];
                    GtkAllocation allocation = new GtkAllocation();
                    OS.gtk_widget_get_allocation(this.shellHandle, allocation);
                    this.display.resizeBoundsWidth = allocation.width;
                    this.display.resizeBoundsHeight = allocation.height;
                }
            }
            return 0;
        }
        return super.gtk_button_press_event(widget, event);
    }

    int gtk_configure_event(int widget, int event) {
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gtk_window_get_position(this.shellHandle, x, y);
        if (!this.isVisible()) {
            return 0;
        }
        if (!this.moved || this.oldX != x[0] || this.oldY != y[0]) {
            this.moved = true;
            this.oldX = x[0];
            this.oldY = y[0];
            this.sendEvent(10);
        }
        return 0;
    }

    int gtk_delete_event(int widget, int event) {
        if (this.isEnabled()) {
            this.closeWidget();
        }
        return 1;
    }

    int gtk_enter_notify_event(int widget, int event) {
        if (widget != this.shellHandle) {
            return super.gtk_enter_notify_event(widget, event);
        }
        return 0;
    }

    int gtk_draw(int widget, int cairo) {
        if (widget == this.shellHandle) {
            if (this.isCustomResize()) {
                int[] width = new int[1];
                int[] height = new int[1];
                int window = this.gtk_widget_get_window(widget);
                this.gdk_window_get_size(window, width, height);
                int border = OS.gtk_container_get_border_width(widget);
                int context = OS.gtk_widget_get_style_context(this.shellHandle);
                OS.gtk_style_context_save(context);
                OS.gtk_render_frame(context, cairo, 0.0, 0.0, width[0], border);
                OS.gtk_render_frame(context, cairo, 0.0, height[0] - border, width[0], border);
                OS.gtk_render_frame(context, cairo, 0.0, border, border, height[0] - border - border);
                OS.gtk_render_frame(context, cairo, width[0] - border, border, border, height[0] - border - border);
                OS.gtk_render_frame(context, cairo, 10.0, 10.0, width[0] - 20, height[0] - 20);
                OS.gtk_style_context_restore(context);
                return 1;
            }
            return 0;
        }
        return super.gtk_draw(widget, cairo);
    }

    int gtk_expose_event(int widget, int event) {
        if (widget == this.shellHandle) {
            if (this.isCustomResize()) {
                GdkEventExpose gdkEventExpose = new GdkEventExpose();
                OS.memmove(gdkEventExpose, event, GdkEventExpose.sizeof);
                int style = OS.gtk_widget_get_style(widget);
                int window = this.gtk_widget_get_window(widget);
                int[] width = new int[1];
                int[] height = new int[1];
                this.gdk_window_get_size(window, width, height);
                GdkRectangle area = new GdkRectangle();
                area.x = gdkEventExpose.area_x;
                area.y = gdkEventExpose.area_y;
                area.width = gdkEventExpose.area_width;
                area.height = gdkEventExpose.area_height;
                byte[] detail = Converter.wcsToMbcs(null, "base", true);
                int border = OS.gtk_container_get_border_width(widget);
                int state = this.display.activeShell == this ? 3 : 2;
                OS.gtk_paint_flat_box(style, window, state, 0, area, widget, detail, 0, 0, width[0], border);
                OS.gtk_paint_flat_box(style, window, state, 0, area, widget, detail, 0, height[0] - border, width[0], border);
                OS.gtk_paint_flat_box(style, window, state, 0, area, widget, detail, 0, border, border, height[0] - border - border);
                OS.gtk_paint_flat_box(style, window, state, 0, area, widget, detail, width[0] - border, border, border, height[0] - border - border);
                OS.gtk_paint_box(style, window, state, 2, area, widget, detail, 0, 0, width[0], height[0]);
                return 1;
            }
            return 0;
        }
        return super.gtk_expose_event(widget, event);
    }

    int gtk_focus(int widget, int directionType) {
        switch (directionType) {
            case 0: 
            case 1: {
                Control control = this.display.getFocusControl();
                if (control == null || (control.state & 2) == 0 || (control.style & 0x1000000) == 0 || control.getShell() != this) break;
                int traversal = directionType == 0 ? 16 : 8;
                control.traverse(traversal);
                return 1;
            }
        }
        return super.gtk_focus(widget, directionType);
    }

    int gtk_focus_in_event(int widget, int event) {
        if (widget != this.shellHandle) {
            return super.gtk_focus_in_event(widget, event);
        }
        this.display.activeShell = this;
        this.display.activePending = false;
        this.sendEvent(26);
        return 0;
    }

    int gtk_focus_out_event(int widget, int event) {
        if (widget != this.shellHandle) {
            return super.gtk_focus_out_event(widget, event);
        }
        Display display = this.display;
        this.sendEvent(27);
        this.setActiveControl(null);
        if (display.activeShell == this && !this.ignoreFocusOut) {
            display.activeShell = null;
            display.activePending = false;
        }
        return 0;
    }

    int gtk_leave_notify_event(int widget, int event) {
        if (widget == this.shellHandle) {
            if (this.isCustomResize()) {
                GdkEventCrossing gdkEvent = new GdkEventCrossing();
                OS.memmove(gdkEvent, event, GdkEventCrossing.sizeof);
                if ((gdkEvent.state & 0x100) == 0) {
                    int window = this.gtk_widget_get_window(this.shellHandle);
                    OS.gdk_window_set_cursor(window, 0);
                    this.display.resizeMode = 0;
                }
            }
            return 0;
        }
        return super.gtk_leave_notify_event(widget, event);
    }

    int gtk_move_focus(int widget, int directionType) {
        Control control = this.display.getFocusControl();
        if (control != null) {
            int focusHandle = control.focusHandle();
            OS.gtk_widget_child_focus(focusHandle, directionType);
        }
        OS.g_signal_stop_emission_by_name(this.shellHandle, OS.move_focus);
        return 1;
    }

    int gtk_motion_notify_event(int widget, int event) {
        if (widget == this.shellHandle) {
            if (this.isCustomResize()) {
                GdkEventMotion gdkEvent = new GdkEventMotion();
                OS.memmove(gdkEvent, event, GdkEventMotion.sizeof);
                if ((gdkEvent.state & 0x100) != 0) {
                    int border = OS.gtk_container_get_border_width(this.shellHandle);
                    int dx = (int)(gdkEvent.x_root - this.display.resizeLocationX);
                    int dy = (int)(gdkEvent.y_root - this.display.resizeLocationY);
                    int x = this.display.resizeBoundsX;
                    int y = this.display.resizeBoundsY;
                    int width = this.display.resizeBoundsWidth;
                    int height = this.display.resizeBoundsHeight;
                    int newWidth = Math.max(width - dx, Math.max(this.minWidth, border + border));
                    int newHeight = Math.max(height - dy, Math.max(this.minHeight, border + border));
                    switch (this.display.resizeMode) {
                        case 70: {
                            x += width - newWidth;
                            width = newWidth;
                            break;
                        }
                        case 134: {
                            x += width - newWidth;
                            width = newWidth;
                            y += height - newHeight;
                            height = newHeight;
                            break;
                        }
                        case 138: {
                            y += height - newHeight;
                            height = newHeight;
                            break;
                        }
                        case 136: {
                            width = Math.max(width + dx, Math.max(this.minWidth, border + border));
                            y += height - newHeight;
                            height = newHeight;
                            break;
                        }
                        case 96: {
                            width = Math.max(width + dx, Math.max(this.minWidth, border + border));
                            break;
                        }
                        case 14: {
                            width = Math.max(width + dx, Math.max(this.minWidth, border + border));
                            height = Math.max(height + dy, Math.max(this.minHeight, border + border));
                            break;
                        }
                        case 16: {
                            height = Math.max(height + dy, Math.max(this.minHeight, border + border));
                            break;
                        }
                        case 12: {
                            x += width - newWidth;
                            width = newWidth;
                            height = Math.max(height + dy, Math.max(this.minHeight, border + border));
                        }
                    }
                    if (x != this.display.resizeBoundsX || y != this.display.resizeBoundsY) {
                        OS.gdk_window_move_resize(this.gtk_widget_get_window(this.shellHandle), x, y, width, height);
                    } else {
                        OS.gtk_window_resize(this.shellHandle, width, height);
                    }
                } else {
                    int mode = this.getResizeMode(gdkEvent.x, gdkEvent.y);
                    if (mode != this.display.resizeMode) {
                        int window = this.gtk_widget_get_window(this.shellHandle);
                        int cursor = OS.gdk_cursor_new_for_display(OS.gdk_display_get_default(), mode);
                        OS.gdk_window_set_cursor(window, cursor);
                        this.gdk_cursor_unref(cursor);
                        this.display.resizeMode = mode;
                    }
                }
            }
            return 0;
        }
        return super.gtk_motion_notify_event(widget, event);
    }

    int gtk_key_press_event(int widget, int event) {
        if (widget == this.shellHandle) {
            Control focusControl;
            if ((this.state & 0x10) != 0) {
                return 1;
            }
            if (this.menuBar != null && !this.menuBar.isDisposed() && (focusControl = this.display.getFocusControl()) != null && (focusControl.hooks(1) || focusControl.filters(1))) {
                int[] accel = new int[1];
                int setting = OS.gtk_settings_get_default();
                OS.g_object_get(setting, OS.gtk_menu_bar_accel, accel, 0);
                if (accel[0] != 0) {
                    int[] keyval = new int[1];
                    int[] mods = new int[1];
                    OS.gtk_accelerator_parse(accel[0], keyval, mods);
                    OS.g_free(accel[0]);
                    if (keyval[0] != 0) {
                        GdkEventKey keyEvent = new GdkEventKey();
                        OS.memmove(keyEvent, event, GdkEventKey.sizeof);
                        int mask = OS.gtk_accelerator_get_default_mod_mask();
                        if (keyEvent.keyval == keyval[0] && (keyEvent.state & mask) == (mods[0] & mask)) {
                            return focusControl.gtk_key_press_event(focusControl.focusHandle(), event);
                        }
                    }
                }
            }
            return 0;
        }
        return super.gtk_key_press_event(widget, event);
    }

    int gtk_size_allocate(int widget, int allocation) {
        GtkAllocation widgetAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(this.shellHandle, widgetAllocation);
        int width = widgetAllocation.width;
        int height = widgetAllocation.height;
        if (!this.resized || this.oldWidth != width || this.oldHeight != height) {
            this.oldWidth = width;
            this.oldHeight = height;
            this.resizeBounds(width, height, true);
        }
        return 0;
    }

    int gtk_realize(int widget) {
        int result = super.gtk_realize(widget);
        int window = this.gtk_widget_get_window(this.shellHandle);
        if ((this.style & 0x4F0) != 1264) {
            int decorations = 0;
            int functions = 0;
            if ((this.style & 8) == 0) {
                if ((this.style & 0x80) != 0) {
                    decorations |= 0x20;
                    functions |= 8;
                }
                if ((this.style & 0x400) != 0) {
                    decorations |= 0x40;
                    functions |= 0x10;
                }
                if ((this.style & 0x10) != 0) {
                    decorations |= 4;
                    functions |= 2;
                }
                if ((this.style & 0x800) != 0) {
                    decorations |= 2;
                }
                if ((this.style & 0x40) != 0) {
                    decorations |= 0x10;
                }
                if ((this.style & 0x20) != 0) {
                    decorations |= 8;
                }
                if ((this.style & 0x40) != 0) {
                    functions |= 0x20;
                }
                if ((this.style & 0x10) != 0) {
                    decorations |= 2;
                }
                functions |= 4;
            }
            OS.gdk_window_set_decorations(window, decorations);
            OS.gdk_window_set_functions(window, functions);
        }
        if ((this.style & 0x4000) != 0) {
            OS.gdk_window_set_override_redirect(window, true);
        }
        return result;
    }

    int gtk_window_state_event(int widget, int event) {
        GdkEventWindowState gdkEvent = new GdkEventWindowState();
        OS.memmove(gdkEvent, event, GdkEventWindowState.sizeof);
        this.minimized = (gdkEvent.new_window_state & 2) != 0;
        this.maximized = (gdkEvent.new_window_state & 4) != 0;
        boolean bl = this.fullScreen = (gdkEvent.new_window_state & 0x10) != 0;
        if ((gdkEvent.changed_mask & 2) != 0) {
            if (this.minimized) {
                this.sendEvent(19);
            } else {
                this.sendEvent(20);
            }
            this.updateMinimized(this.minimized);
        }
        return 0;
    }

    public void open() {
        this.checkWidget();
        this.bringToTop(false);
        if (Shell.class.isInstance(this.getParent()) && !this.getParent().isVisible()) {
            ((Shell)Shell.class.cast(this.getParent())).open();
        }
        this.setVisible(true);
        if (this.isDisposed()) {
            return;
        }
        if (!this.restoreFocus() && !this.traverseGroup(true)) {
            this.setFocus();
        }
    }

    public boolean print(GC gc) {
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        return false;
    }

    public void removeShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(21, listener);
        this.eventTable.unhook(19, listener);
        this.eventTable.unhook(20, listener);
        this.eventTable.unhook(26, listener);
        this.eventTable.unhook(27, listener);
    }

    void removeTooTip(ToolTip toolTip) {
        if (this.toolTips == null) {
            return;
        }
        int i = 0;
        while (i < this.toolTips.length) {
            if (this.toolTips[i] == toolTip) {
                this.toolTips[i] = null;
                return;
            }
            ++i;
        }
    }

    void reskinChildren(int flags) {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (shell != null) {
                shell.reskin(flags);
            }
            ++i;
        }
        if (this.toolTips != null) {
            i = 0;
            while (i < this.toolTips.length) {
                ToolTip toolTip = this.toolTips[i];
                if (toolTip != null) {
                    toolTip.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    public void setActive() {
        this.checkWidget();
        this.bringToTop(false);
    }

    void setActiveControl(Control control) {
        this.setActiveControl(control, 0);
    }

    void setActiveControl(Control control, int type) {
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] activate = control == null ? new Control[]{} : control.getPath();
        Control[] deactivate = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int index = 0;
        int length = Math.min(activate.length, deactivate.length);
        while (index < length) {
            if (activate[index] != deactivate[index]) break;
            ++index;
        }
        int i = deactivate.length - 1;
        while (i >= index) {
            if (!deactivate[i].isDisposed()) {
                deactivate[i].sendEvent(27);
            }
            --i;
        }
        i = activate.length - 1;
        while (i >= index) {
            if (!activate[i].isDisposed()) {
                Event event = new Event();
                event.detail = type;
                activate[i].sendEvent(26, event);
            }
            --i;
        }
    }

    public void setAlpha(int alpha) {
        this.checkWidget();
        if (OS.gtk_widget_is_composited(this.shellHandle)) {
            OS.gtk_window_set_opacity(this.shellHandle, (float)(alpha &= 0xFF) / 255.0f);
        }
    }

    void resizeBounds(int width, int height, boolean notify) {
        if (this.redrawWindow != 0) {
            OS.gdk_window_resize(this.redrawWindow, width, height);
        }
        if (this.enableWindow != 0) {
            OS.gdk_window_resize(this.enableWindow, width, height);
        }
        int border = OS.gtk_container_get_border_width(this.shellHandle);
        int boxWidth = width - 2 * border;
        int boxHeight = height - 2 * border;
        if (!OS.GTK3 || (this.style & 0x10) == 0) {
            OS.gtk_widget_set_size_request(this.vboxHandle, boxWidth, boxHeight);
        }
        this.forceResize(boxWidth, boxHeight);
        if (notify) {
            this.resized = true;
            this.sendEvent(11);
            if (this.isDisposed()) {
                return;
            }
            if (this.layout != null) {
                this.markLayout(false, false);
                this.updateLayout(false);
            }
        }
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        if (this.fullScreen) {
            this.setFullScreen(false);
        }
        if (this.getMaximized()) {
            boolean sameExtent;
            Rectangle rect = this.getBounds();
            boolean sameOrigin = !move || rect.x == x && rect.y == y;
            boolean bl = sameExtent = !resize || rect.width == width && rect.height == height;
            if (sameOrigin && sameExtent) {
                return 0;
            }
            this.setMaximized(false);
        }
        int result = 0;
        if (move) {
            int[] x_pos = new int[1];
            int[] y_pos = new int[1];
            OS.gtk_window_get_position(this.shellHandle, x_pos, y_pos);
            OS.gtk_window_move(this.shellHandle, x, y);
            if (x_pos[0] != x || y_pos[0] != y) {
                this.moved = true;
                this.oldX = x;
                this.oldY = y;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return 0;
                }
                result |= 0x80;
            }
        }
        if (resize) {
            boolean changed;
            width = Math.max(1, Math.max(this.minWidth, width - this.trimWidth()));
            height = Math.max(1, Math.max(this.minHeight, height - this.trimHeight()));
            if ((this.style & 0x10) != 0 || this.minHeight != 0 || this.minWidth != 0) {
                OS.gtk_window_resize(this.shellHandle, width, height);
            }
            boolean bl = changed = width != this.oldWidth || height != this.oldHeight;
            if (changed) {
                this.oldWidth = width;
                this.oldHeight = height;
                result |= 0x100;
            }
            this.resizeBounds(width, height, changed);
        }
        return result;
    }

    void setCursor(int cursor) {
        if (this.enableWindow != 0) {
            OS.gdk_window_set_cursor(this.enableWindow, cursor);
            if (!OS.isX11()) {
                OS.gdk_flush();
            } else {
                int xDisplay = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
                OS.XFlush(xDisplay);
            }
        }
        super.setCursor(cursor);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if ((this.state & 0x10) == 0 == enabled) {
            return;
        }
        Display display = this.display;
        Control control = null;
        boolean fixFocus = false;
        if (!enabled && display.focusEvent != 16) {
            control = display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        this.state = enabled ? (this.state &= 0xFFFFFFEF) : (this.state |= 0x10);
        this.enableWidget(enabled);
        if (this.isDisposed()) {
            return;
        }
        if (enabled) {
            if (this.enableWindow != 0) {
                this.cleanupEnableWindow();
            }
        } else {
            int parentHandle = this.shellHandle;
            OS.gtk_widget_realize(parentHandle);
            int window = this.gtk_widget_get_window(parentHandle);
            Rectangle rect = this.getBounds();
            GdkWindowAttr attributes = new GdkWindowAttr();
            attributes.width = rect.width;
            attributes.height = rect.height;
            attributes.event_mask = -32769;
            attributes.wclass = 1;
            attributes.window_type = 2;
            this.enableWindow = OS.gdk_window_new(window, attributes, 0);
            if (this.enableWindow != 0) {
                if (this.cursor != null) {
                    OS.gdk_window_set_cursor(this.enableWindow, this.cursor.handle);
                    if (!OS.isX11()) {
                        OS.gdk_flush();
                    } else {
                        int xDisplay = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
                        OS.XFlush(xDisplay);
                    }
                }
                if (enterNotifyEventFunc != null) {
                    this.enterNotifyEventId = OS.g_signal_add_emission_hook(enterNotifyEventSignalId, 0, enterNotifyEventFunc.getAddress(), this.enableWindow, 0);
                }
                OS.gdk_window_set_user_data(this.enableWindow, parentHandle);
                OS.gdk_window_show(this.enableWindow);
            }
        }
        if (fixFocus) {
            this.fixFocus(control);
        }
        if (enabled && display.activeShell == this && !this.restoreFocus()) {
            this.traverseGroup(false);
        }
    }

    public void setFullScreen(boolean fullScreen) {
        this.checkWidget();
        if (fullScreen) {
            OS.gtk_window_fullscreen(this.shellHandle);
        } else {
            OS.gtk_window_unfullscreen(this.shellHandle);
            if (this.maximized) {
                this.setMaximized(true);
            }
        }
        this.fullScreen = fullScreen;
    }

    public void setImeInputMode(int mode) {
        this.checkWidget();
    }

    void setInitialBounds() {
        int height;
        int width;
        if ((this.state & 0x400000) != 0) {
            GtkAllocation allocation = new GtkAllocation();
            OS.gtk_widget_get_allocation(this.shellHandle, allocation);
            width = allocation.width;
            height = allocation.height;
        } else {
            width = OS.gdk_screen_width() * 5 / 8;
            height = OS.gdk_screen_height() * 5 / 8;
            int screen = OS.gdk_screen_get_default();
            if (screen != 0 && OS.gdk_screen_get_n_monitors(screen) > 1) {
                int monitorNumber = OS.gdk_screen_get_monitor_at_window(screen, this.paintWindow());
                GdkRectangle dest = new GdkRectangle();
                OS.gdk_screen_get_monitor_geometry(screen, monitorNumber, dest);
                width = dest.width * 5 / 8;
                height = dest.height * 5 / 8;
            }
            if ((this.style & 0x10) != 0) {
                OS.gtk_window_resize(this.shellHandle, width, height);
            }
        }
        this.resizeBounds(width, height, false);
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        super.setMaximized(maximized);
        if (maximized) {
            OS.gtk_window_maximize(this.shellHandle);
        } else {
            OS.gtk_window_unmaximize(this.shellHandle);
        }
    }

    public void setMenuBar(Menu menu) {
        int menuHandle;
        boolean both;
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        boolean bl = both = menu != null && this.menuBar != null;
        if (menu != null) {
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        if (this.menuBar != null) {
            menuHandle = this.menuBar.handle;
            OS.gtk_widget_hide(menuHandle);
            this.destroyAccelGroup();
        }
        this.menuBar = menu;
        if (this.menuBar != null) {
            menuHandle = menu.handle;
            OS.gtk_widget_show(menuHandle);
            this.createAccelGroup();
            this.menuBar.addAccelerators(this.accelGroup);
        }
        GtkAllocation allocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(this.vboxHandle, allocation);
        int width = allocation.width;
        int height = allocation.height;
        this.resizeBounds(width, height, !both);
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        if (this.minimized == minimized) {
            return;
        }
        super.setMinimized(minimized);
        if (minimized) {
            OS.gtk_window_iconify(this.shellHandle);
        } else {
            OS.gtk_window_deiconify(this.shellHandle);
            this.bringToTop(false);
        }
    }

    public void setMinimumSize(int width, int height) {
        this.checkWidget();
        GdkGeometry geometry = new GdkGeometry();
        this.minWidth = geometry.min_width = Math.max(width, this.trimWidth()) - this.trimWidth();
        this.minHeight = geometry.min_height = Math.max(height, this.trimHeight()) - this.trimHeight();
        OS.gtk_window_set_geometry_hints(this.shellHandle, 0, geometry, 2);
    }

    public void setMinimumSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setMinimumSize(size.x, size.y);
    }

    public void setModified(boolean modified) {
        this.checkWidget();
        this.modified = modified;
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        if (region != null) {
            Rectangle bounds = region.getBounds();
            this.setSize(bounds.x + bounds.width, bounds.y + bounds.height);
        }
        Region regionToDispose = null;
        if ((this.style & 0x4000000) != 0) {
            if (this.originalRegion != null) {
                regionToDispose = this.region;
            }
            this.originalRegion = region;
            region = Shell.mirrorRegion(region);
        } else {
            this.originalRegion = null;
        }
        super.setRegion(region);
        if (regionToDispose != null) {
            regionToDispose.dispose();
        }
    }

    static void gdk_region_get_rectangles(int region, int[] rectangles, int[] n_rectangles) {
        if (!OS.GTK3) {
            OS.gdk_region_get_rectangles(region, rectangles, n_rectangles);
            return;
        }
        int num = Cairo.cairo_region_num_rectangles(region);
        if (n_rectangles != null) {
            n_rectangles[0] = num;
        }
        rectangles[0] = OS.g_malloc(GdkRectangle.sizeof * num);
        int n = 0;
        while (n < num) {
            Cairo.cairo_region_get_rectangle(region, n, rectangles[0] + n * GdkRectangle.sizeof);
            ++n;
        }
    }

    static Region mirrorRegion(Region region) {
        if (region == null) {
            return null;
        }
        Region mirrored = new Region(region.getDevice());
        int rgn = region.handle;
        int[] nRects = new int[1];
        int[] rects = new int[1];
        Shell.gdk_region_get_rectangles(rgn, rects, nRects);
        Rectangle bounds = region.getBounds();
        GdkRectangle rect = new GdkRectangle();
        int i = 0;
        while (i < nRects[0]) {
            OS.memmove(rect, rects[0] + i * GdkRectangle.sizeof, GdkRectangle.sizeof);
            rect.x = bounds.x + bounds.width - rect.x - rect.width;
            OS.gdk_region_union_with_rect(mirrored.handle, rect);
            ++i;
        }
        if (rects[0] != 0) {
            OS.g_free(rects[0]);
        }
        return mirrored;
    }

    void setRelations() {
    }

    public void setText(String string) {
        super.setText(string);
        int length = string.length();
        char[] chars = new char[Math.max(6, length) + 1];
        string.getChars(0, length, chars, 0);
        int i = length;
        while (i < chars.length) {
            chars[i] = 32;
            ++i;
        }
        byte[] buffer = Converter.wcsToMbcs(null, chars, true);
        OS.gtk_window_set_title(this.shellHandle, buffer);
    }

    public void setVisible(boolean visible) {
        int mask;
        this.checkWidget();
        if (this.moved) {
            this.setLocation(this.oldX, this.oldY);
        }
        if ((this.style & (mask = 229376)) != 0) {
            if (visible) {
                this.display.setModalShell(this);
                OS.gtk_window_set_modal(this.shellHandle, true);
            } else {
                this.display.clearModal(this);
                OS.gtk_window_set_modal(this.shellHandle, false);
            }
        } else {
            this.updateModal();
        }
        this.showWithParent = visible;
        if (this.gtk_widget_get_mapped(this.shellHandle) == visible) {
            return;
        }
        if (visible) {
            if (this.center && !this.moved) {
                this.center();
                if (this.isDisposed()) {
                    return;
                }
            }
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            this.mapped = false;
            OS.gtk_widget_show(this.shellHandle);
            if (this.enableWindow != 0) {
                OS.gdk_window_raise(this.enableWindow);
            }
            if (this.isDisposed()) {
                return;
            }
            if (!OS.GTK_IS_PLUG(this.shellHandle)) {
                this.display.dispatchEvents = new int[]{2, 12, 13, 14, 15, 30, 32};
                Display display = this.display;
                display.putGdkEvents();
                boolean iconic = false;
                Shell shell = this.parent != null ? this.parent.getShell() : null;
                do {
                    OS.gdk_threads_leave();
                    OS.g_main_context_iteration(0, false);
                    if (this.isDisposed()) break;
                    boolean bl = iconic = this.minimized || shell != null && shell.minimized;
                } while (!this.mapped && !iconic);
                display.dispatchEvents = null;
                if (this.isDisposed()) {
                    return;
                }
                if (!iconic) {
                    this.update(true, true);
                    if (this.isDisposed()) {
                        return;
                    }
                    this.adjustTrim();
                }
            }
            this.mapped = true;
            if ((this.style & mask) != 0) {
                this.gdk_pointer_ungrab(OS.gtk_widget_get_window(this.shellHandle), 0);
            }
            this.opened = true;
            if (!this.moved) {
                this.moved = true;
                Point location = this.getLocation();
                this.oldX = location.x;
                this.oldY = location.y;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            if (!this.resized) {
                this.resized = true;
                Point size = this.getSize();
                this.oldWidth = size.x - this.trimWidth();
                this.oldHeight = size.y - this.trimHeight();
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false);
                }
            }
        } else {
            this.fixActiveShell();
            OS.gtk_widget_hide(this.shellHandle);
            this.sendEvent(23);
        }
    }

    void setZOrder(Control sibling, boolean above, boolean fixRelations) {
        if (this.mapped) {
            this.setZOrder(sibling, above, false, false);
        }
    }

    int shellMapProc(int handle, int arg0, int user_data) {
        this.mapped = true;
        this.display.dispatchEvents = null;
        return 0;
    }

    void showWidget() {
        if ((this.state & 0x400000) != 0) {
            int children;
            if (OS.gtk_window_is_active(this.shellHandle)) {
                this.display.activeShell = this;
                this.display.activePending = true;
            }
            int list = children = OS.gtk_container_get_children(this.shellHandle);
            while (list != 0) {
                OS.gtk_container_remove(this.shellHandle, OS.g_list_data(list));
                list = OS.g_list_next(list);
            }
            OS.g_list_free(list);
        }
        OS.gtk_container_add(this.shellHandle, this.vboxHandle);
        if (this.scrolledHandle != 0) {
            OS.gtk_widget_show(this.scrolledHandle);
        }
        if (this.handle != 0) {
            OS.gtk_widget_show(this.handle);
        }
        if (this.vboxHandle != 0) {
            OS.gtk_widget_show(this.vboxHandle);
        }
    }

    int sizeAllocateProc(int handle, int arg0, int user_data) {
        int offset = 16;
        int[] x = new int[1];
        int[] y = new int[1];
        this.gdk_window_get_device_position(0, x, y, null);
        y[0] = y[0] + offset;
        int screen = OS.gdk_screen_get_default();
        if (screen != 0) {
            int monitorNumber = OS.gdk_screen_get_monitor_at_point(screen, x[0], y[0]);
            GdkRectangle dest = new GdkRectangle();
            OS.gdk_screen_get_monitor_geometry(screen, monitorNumber, dest);
            GtkAllocation allocation = new GtkAllocation();
            OS.gtk_widget_get_allocation(handle, allocation);
            int width = allocation.width;
            int height = allocation.height;
            if (x[0] + width > dest.x + dest.width) {
                x[0] = dest.x + dest.width - width;
            }
            if (y[0] + height > dest.y + dest.height) {
                y[0] = dest.y + dest.height - height;
            }
        }
        OS.gtk_window_move(handle, x[0], y[0]);
        return 0;
    }

    int sizeRequestProc(int handle, int arg0, int user_data) {
        OS.gtk_widget_hide(handle);
        return 0;
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    int trimHeight() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        if (this.fullScreen) {
            return 0;
        }
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        hasTitle = (this.style & 0x4E0) != 0;
        hasResize = (this.style & 0x10) != 0;
        boolean bl = hasBorder = (this.style & 0x800) != 0;
        if (hasTitle) {
            if (hasResize) {
                return this.display.titleResizeTrimHeight;
            }
            if (hasBorder) {
                return this.display.titleBorderTrimHeight;
            }
            return this.display.titleTrimHeight;
        }
        if (hasResize) {
            return this.display.resizeTrimHeight;
        }
        if (hasBorder) {
            return this.display.borderTrimHeight;
        }
        return 0;
    }

    int trimWidth() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        if (this.fullScreen) {
            return 0;
        }
        boolean hasTitle = false;
        boolean hasResize = false;
        boolean hasBorder = false;
        hasTitle = (this.style & 0x4E0) != 0;
        hasResize = (this.style & 0x10) != 0;
        boolean bl = hasBorder = (this.style & 0x800) != 0;
        if (hasTitle) {
            if (hasResize) {
                return this.display.titleResizeTrimWidth;
            }
            if (hasBorder) {
                return this.display.titleBorderTrimWidth;
            }
            return this.display.titleTrimWidth;
        }
        if (hasResize) {
            return this.display.resizeTrimWidth;
        }
        if (hasBorder) {
            return this.display.borderTrimWidth;
        }
        return 0;
    }

    void updateModal() {
        if (OS.GTK_IS_PLUG(this.shellHandle)) {
            return;
        }
        int group = 0;
        boolean isModalShell = false;
        if (this.display.getModalDialog() == null) {
            Shell modal = this.getModalShell();
            int mask = 229376;
            Composite shell = null;
            if (modal == null) {
                if ((this.style & mask) != 0) {
                    shell = this;
                    isModalShell = OS.gtk_window_get_modal(this.shellHandle);
                    if (isModalShell) {
                        OS.gtk_window_set_modal(this.shellHandle, false);
                    }
                }
            } else {
                shell = modal;
            }
            Shell topModalShell = shell;
            while (shell != null) {
                if ((shell.style & mask) == 0) {
                    group = shell.getShell().group;
                    break;
                }
                topModalShell = shell;
                shell = shell.parent;
            }
            if (group == 0 && topModalShell != null) {
                group = topModalShell.getShell().group;
            }
        }
        if (group == 0) {
            group = OS.gtk_window_get_group(0);
        }
        if (group != 0) {
            OS.gtk_window_group_add_window(group, this.shellHandle);
            if (isModalShell) {
                OS.gtk_window_set_modal(this.shellHandle, true);
            }
        } else if (this.modalGroup != 0) {
            OS.gtk_window_group_remove_window(this.modalGroup, this.shellHandle);
        }
        this.modalGroup = group;
    }

    void updateMinimized(boolean minimized) {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            boolean update = false;
            Shell shell = shells[i];
            while (shell != null && shell != this && !shell.isUndecorated()) {
                shell = (Shell)shell.getParent();
            }
            if (shell != null && shell != this) {
                update = true;
            }
            if (update) {
                if (minimized) {
                    if (shells[i].isVisible()) {
                        shells[i].showWithParent = true;
                        OS.gtk_widget_hide(shells[i].shellHandle);
                    }
                } else if (shells[i].showWithParent) {
                    shells[i].showWithParent = false;
                    OS.gtk_widget_show(shells[i].shellHandle);
                }
            }
            ++i;
        }
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.shellHandle);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.fixActiveShell();
        OS.gtk_widget_hide(this.shellHandle);
        super.dispose();
    }

    public void forceActive() {
        this.checkWidget();
        this.bringToTop(true);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gtk_window_get_position(this.shellHandle, x, y);
        GtkAllocation allocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(this.vboxHandle, allocation);
        int width = allocation.width;
        int height = allocation.height;
        int border = 0;
        if ((this.style & 0xCF8) == 0) {
            border = OS.gtk_container_get_border_width(this.shellHandle);
        }
        return new Rectangle(x[0], y[0], width + this.trimWidth() + 2 * border, height + this.trimHeight() + 2 * border);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.shellHandle = 0;
    }

    void releaseChildren(boolean destroy) {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (shell != null && !shell.isDisposed()) {
                shell.release(false);
            }
            ++i;
        }
        if (this.toolTips != null) {
            i = 0;
            while (i < this.toolTips.length) {
                ToolTip toolTip = this.toolTips[i];
                if (toolTip != null && !toolTip.isDisposed()) {
                    toolTip.dispose();
                }
                ++i;
            }
            this.toolTips = null;
        }
        super.releaseChildren(destroy);
    }

    void releaseWidget() {
        Region regionToDispose = null;
        if (this.originalRegion != null) {
            regionToDispose = this.region;
        }
        super.releaseWidget();
        this.destroyAccelGroup();
        this.display.clearModal(this);
        if (this.display.activeShell == this) {
            this.display.activeShell = null;
        }
        if (this.tooltipsHandle != 0) {
            OS.g_object_unref(this.tooltipsHandle);
        }
        this.tooltipsHandle = 0;
        if (this.group != 0) {
            OS.g_object_unref(this.group);
        }
        this.modalGroup = 0;
        this.group = 0;
        if (!OS.GTK3) {
            int window = this.gtk_widget_get_window(this.shellHandle);
            OS.gdk_window_remove_filter(window, this.display.filterProc, this.shellHandle);
        }
        this.lastActive = null;
        if (regionToDispose != null) {
            regionToDispose.dispose();
        }
    }

    void setToolTipText(int tipWidget, String string) {
        this.setToolTipText(tipWidget, tipWidget, string);
    }

    void setToolTipText(int rootWidget, int tipWidget, String string) {
        byte[] buffer = null;
        if (string != null && string.length() > 0) {
            char[] chars = this.fixMnemonic(string, false);
            buffer = Converter.wcsToMbcs(null, chars, true);
        }
        int oldTooltip = OS.gtk_widget_get_tooltip_text(rootWidget);
        boolean same = false;
        if (buffer == null && oldTooltip == 0) {
            same = true;
        } else if (buffer != null && oldTooltip != 0) {
            boolean bl = same = OS.strcmp(oldTooltip, buffer) == 0;
        }
        if (oldTooltip != 0) {
            OS.g_free(oldTooltip);
        }
        if (same) {
            return;
        }
        OS.gtk_widget_set_tooltip_text(rootWidget, buffer);
    }

    Point getWindowOrigin() {
        if (!this.mapped) {
            return this.getLocation();
        }
        return super.getWindowOrigin();
    }
}

