/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.launch.ui.tabs;

import java.io.File;
import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ptp.launch.PTPLaunchPlugin;
import org.eclipse.ptp.launch.RMLaunchUtils;
import org.eclipse.ptp.launch.internal.messages.Messages;
import org.eclipse.ptp.launch.ui.LaunchImages;
import org.eclipse.ptp.launch.ui.tabs.LaunchConfigurationTab;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteResource;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.eclipse.remote.ui.IRemoteUIFileService;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ApplicationTab
extends LaunchConfigurationTab {
    public static final String TAB_ID = "org.eclipse.ptp.launch.applicationLaunch.applicationTab";
    protected Text projText = null;
    protected Text appText = null;
    protected Text localAppText = null;
    protected Button projButton = null;
    protected Button appButton = null;
    protected Button browseAppButton = null;
    protected Button localAppButton = null;
    protected Button consoleButton = null;
    protected WidgetListener listener = new WidgetListener();
    protected final boolean combinedOutputDefault = true;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout());
        Composite mainComp = new Composite(comp, 0);
        mainComp.setLayout((Layout)this.createGridLayout(2, false, 0, 0));
        mainComp.setLayoutData((Object)new GridData(768));
        Label projLabel = new Label(mainComp, 0);
        projLabel.setText(Messages.ApplicationTab_Project);
        projLabel.setLayoutData((Object)this.spanGridData(-1, 2));
        this.projText = new Text(mainComp, 2052);
        this.projText.setLayoutData((Object)new GridData(768));
        this.projText.addModifyListener((ModifyListener)this.listener);
        this.projButton = this.createPushButton(mainComp, Messages.ApplicationTab_Browse_1, null);
        this.projButton.addSelectionListener((SelectionListener)this.listener);
        this.createVerticalSpacer(comp, 1);
        Label appLabel = new Label(mainComp, 0);
        appLabel.setText(Messages.ApplicationTab_Application_program);
        appLabel.setLayoutData((Object)this.spanGridData(-1, 2));
        this.appText = new Text(mainComp, 2052);
        this.appText.setLayoutData((Object)new GridData(768));
        this.appText.addModifyListener((ModifyListener)this.listener);
        this.appButton = this.createPushButton(mainComp, Messages.ApplicationTab_Browse_2, null);
        this.appButton.addSelectionListener((SelectionListener)this.listener);
        this.createVerticalSpacer(mainComp, 2);
        this.localAppButton = this.createCheckButton(mainComp, Messages.ApplicationTab_Copy_executable);
        this.localAppButton.setLayoutData((Object)new GridData(768));
        this.localAppButton.addSelectionListener((SelectionListener)this.listener);
        Label localAppLabel = new Label(mainComp, 0);
        localAppLabel.setText(Messages.ApplicationTab_Path_to_local_executable);
        localAppLabel.setLayoutData((Object)this.spanGridData(-1, 2));
        this.localAppText = new Text(mainComp, 2052);
        this.localAppText.setLayoutData((Object)new GridData(768));
        this.localAppText.addModifyListener((ModifyListener)this.listener);
        this.browseAppButton = this.createPushButton(mainComp, Messages.ApplicationTab_Browse_3, null);
        this.browseAppButton.addSelectionListener((SelectionListener)this.listener);
        this.createVerticalSpacer(mainComp, 2);
        this.consoleButton = this.createCheckButton(mainComp, Messages.ApplicationTab_Display_output);
        this.consoleButton.setSelection(true);
        this.consoleButton.addSelectionListener((SelectionListener)this.listener);
    }

    public String getId() {
        return TAB_ID;
    }

    public Image getImage() {
        return LaunchImages.getImage(LaunchImages.IMG_MAIN_TAB);
    }

    public String getName() {
        return Messages.ApplicationTab_Application;
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            this.projText.setText(configuration.getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", ""));
            this.appText.setText(configuration.getAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", ""));
            this.localAppText.setText(configuration.getAttribute("org.eclipse.ptp.launch.ATTR_LOCAL_EXECUTABLE_PATH", ""));
            this.localAppButton.setSelection(configuration.getAttribute("org.eclipse.ptp.launch.ATTR_COPY_EXECUTABLE_FROM_LOCAL", false));
            this.consoleButton.setSelection(configuration.getAttribute("org.eclipse.ptp.launch.ATTR_CONSOLE", false));
        }
        catch (CoreException coreException) {
            this.setErrorMessage(Messages.ApplicationTab_Cannot_read_configuration);
        }
        this.handleLocalApplicationButtonSelected();
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.getFieldContent(this.projText.getText());
        if (name != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateName(name, 4);
            if (status.isOK()) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                if (!project.exists()) {
                    this.setErrorMessage(NLS.bind((String)Messages.ApplicationTab_Project_does_not_exist, (Object[])new Object[]{name}));
                    return false;
                }
                if (!project.isOpen()) {
                    this.setErrorMessage(NLS.bind((String)Messages.ApplicationTab_Project_is_closed, (Object[])new Object[]{name}));
                    return false;
                }
            } else {
                this.setErrorMessage(NLS.bind((String)Messages.ApplicationTab_Invalid_project_name, (Object[])new Object[]{status.getMessage()}));
                return false;
            }
        }
        if ((name = this.getFieldContent(this.appText.getText())) == null) {
            this.setErrorMessage(Messages.ApplicationTab_Application_program_not_specified);
            return false;
        }
        if (this.localAppButton.getSelection()) {
            File file;
            name = this.getFieldContent(this.localAppText.getText());
            if (name == null) {
                this.setErrorMessage(Messages.ApplicationTab_Local_file_not_specified);
            }
            if (!(file = new File(name)).isAbsolute()) {
                this.setErrorMessage(Messages.ApplicationTab_Local_file_path_must_be_absolute);
            }
            if (!file.exists() || !file.isFile()) {
                this.setErrorMessage(Messages.ApplicationTab_Local_file_must_exist);
            }
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", this.getFieldContent(this.projText.getText()));
        configuration.setAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", this.getFieldContent(this.appText.getText()));
        configuration.setAttribute("org.eclipse.ptp.launch.ATTR_COPY_EXECUTABLE_FROM_LOCAL", this.localAppButton.getSelection());
        configuration.setAttribute("org.eclipse.ptp.launch.ATTR_LOCAL_EXECUTABLE_PATH", this.getFieldContent(this.localAppText.getText()));
        configuration.setAttribute("org.eclipse.ptp.launch.ATTR_CONSOLE", this.consoleButton.getSelection());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IProject project = this.getDefaultProject((ILaunchConfiguration)configuration);
        String projectName = null;
        if (project != null) {
            projectName = project.getName();
            String name = this.getLaunchConfigurationDialog().generateName(projectName);
            configuration.rename(name);
        }
        configuration.setAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", projectName);
        configuration.setAttribute("org.eclipse.ptp.launch.ATTR_REMOTE_EXECUTABLE_PATH", null);
        configuration.setAttribute("org.eclipse.ptp.launch.ATTR_COPY_EXECUTABLE_FROM_LOCAL", null);
        configuration.setAttribute("org.eclipse.ptp.launch.ATTR_LOCAL_EXECUTABLE_PATH", false);
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
    }

    protected IResource chooseFile() {
        final IProject project = this.getProject();
        if (project == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ApplicationTab_Please_select_the_project_first, (String)Messages.ApplicationTab_Enter_project_before_browsing);
            return null;
        }
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        BaseWorkbenchContentProvider contentProvider = new BaseWorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setTitle(Messages.ApplicationTab_Program_selection);
        dialog.setMessage(Messages.ApplicationTab_Choose_program);
        dialog.setBlockOnOpen(true);
        dialog.setAllowMultiple(false);
        dialog.setInput((Object)project);
        dialog.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 0 || !(selection[0] instanceof IFile)) {
                    return new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), 1, Messages.ApplicationTab_Selection_must_be_a_file, null);
                }
                try {
                    IResource resource = project.findMember(((IFile)selection[0]).getProjectRelativePath());
                    if (resource == null || resource.getType() != 1) {
                        return new Status(4, PTPLaunchPlugin.getUniqueIdentifier(), 1, Messages.ApplicationTab_Selection_must_be_a_file, null);
                    }
                    return new Status(0, PTPLaunchPlugin.getUniqueIdentifier(), 0, resource.getName(), null);
                }
                catch (Exception exception) {
                    return new Status(4, "org.eclipse.ptp.launch", 1, Messages.ApplicationTab_Selection_must_be_a_file, null);
                }
            }
        });
        if (dialog.open() == 0) {
            return (IResource)dialog.getFirstResult();
        }
        return null;
    }

    protected IProject chooseProject() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        dialog.setTitle(Messages.ApplicationTab_Select_project);
        dialog.setMessage(Messages.ApplicationTab_Choose_the_project);
        dialog.setElements((Object[])this.getWorkspaceRoot().getProjects());
        IProject project = this.getProject();
        if (project != null) {
            dialog.setInitialSelections(new Object[]{project});
        }
        if (dialog.open() == 0) {
            return (IProject)dialog.getFirstResult();
        }
        return null;
    }

    protected IProject getDefaultProject(ILaunchConfiguration configuration) {
        IProject project;
        String projectName = null;
        try {
            projectName = configuration.getAttribute("org.eclipse.ptp.launch.PROJECT_ATTR", null);
        }
        catch (CoreException coreException) {
            return null;
        }
        if (projectName != null && !projectName.equals("") && (project = this.getWorkspaceRoot().getProject(projectName)) != null && project.exists()) {
            return project;
        }
        IWorkbenchPage page = PTPLaunchPlugin.getActivePage();
        if (page != null) {
            IEditorInput input;
            IFile file;
            Object o;
            Object obj;
            IStructuredSelection ss;
            ISelection selection = page.getSelection();
            if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty() && (obj = ss.getFirstElement()) instanceof IAdaptable && (o = ((IAdaptable)obj).getAdapter(IResource.class)) instanceof IResource) {
                return ((IResource)o).getProject();
            }
            IEditorPart part = page.getActiveEditor();
            if (part != null && (file = (IFile)(input = part.getEditorInput()).getAdapter(IFile.class)) != null) {
                return file.getProject();
            }
        }
        return null;
    }

    protected IProject getProject() {
        String projectName = this.projText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getWorkspaceRoot().getProject(projectName);
    }

    protected void handleApplicationButtonSelected() {
        IRemoteConnection conn;
        String initPath = this.appText.getText();
        if (initPath.equals("")) {
            URI location;
            IProject project = this.getProject();
            if (project == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ApplicationTab_Please_select_the_project_first, (String)Messages.ApplicationTab_Enter_project);
                return;
            }
            IRemoteResource remoteProject = (IRemoteResource)project.getAdapter(IRemoteResource.class);
            if (remoteProject != null && (location = remoteProject.getActiveLocationURI()) != null) {
                initPath = location.getPath();
            }
        }
        if ((conn = RMLaunchUtils.getRemoteConnection(this.getLaunchConfiguration())) != null) {
            IRemoteUIFileService fileService = (IRemoteUIFileService)conn.getConnectionType().getService(IRemoteUIFileService.class);
            if (fileService != null) {
                fileService.setConnection(conn);
                fileService.showConnections(false);
                String path = fileService.browseFile(this.getShell(), Messages.ApplicationTab_Select_application, initPath, 0);
                if (path != null) {
                    this.appText.setText(path.toString());
                }
            }
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ApplicationTab_Unable_to_open_connection, (String)Messages.ApplicationTab_Please_specify_remote_connection);
        }
    }

    protected void handleBrowseLocalApplicationButtonSelected() {
        IRemoteServicesManager localServices;
        IRemoteConnectionType lconnType;
        String initPath = this.localAppText.getText();
        if (initPath.equals("")) {
            IProject project = this.getProject();
            if (project == null || project.getLocationURI() == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.ApplicationTab_Please_select_the_project_first, (String)Messages.ApplicationTab_Enter_project);
                return;
            }
            initPath = project.getLocationURI().getPath();
        }
        if ((lconnType = (localServices = PTPLaunchPlugin.getService(IRemoteServicesManager.class)).getLocalConnectionType()) != null) {
            IRemoteConnection lconn = (IRemoteConnection)lconnType.getConnections().get(0);
            IRemoteUIFileService localUIFileService = (IRemoteUIFileService)lconnType.getService(IRemoteUIFileService.class);
            if (localUIFileService != null) {
                localUIFileService.setConnection(lconn);
                String path = localUIFileService.browseFile(this.getShell(), Messages.ApplicationTab_Select_executable_to_be_copied, initPath, 0);
                if (path != null) {
                    this.localAppText.setText(path);
                }
            }
        }
    }

    protected void handleLocalApplicationButtonSelected() {
        this.localAppText.setEnabled(this.localAppButton.getSelection());
        this.browseAppButton.setEnabled(this.localAppButton.getSelection());
    }

    protected void handleProjectButtonSelected() {
        IProject project = this.chooseProject();
        if (project == null) {
            return;
        }
        String projectName = project.getName();
        this.projText.setText(projectName);
    }

    protected void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            ApplicationTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == ApplicationTab.this.projButton) {
                ApplicationTab.this.handleProjectButtonSelected();
            } else if (source == ApplicationTab.this.appButton) {
                ApplicationTab.this.handleApplicationButtonSelected();
            } else if (source == ApplicationTab.this.consoleButton) {
                ApplicationTab.this.updateLaunchConfigurationDialog();
            } else if (source == ApplicationTab.this.localAppButton) {
                ApplicationTab.this.handleLocalApplicationButtonSelected();
                ApplicationTab.this.updateLaunchConfigurationDialog();
            } else if (source == ApplicationTab.this.browseAppButton) {
                ApplicationTab.this.handleBrowseLocalApplicationButtonSelected();
            }
        }
    }
}

