/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.ui.view;

import java.text.MessageFormat;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.oprofile.core.OpcontrolException;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.sessions.SessionManager;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiMessages;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.internal.oprofile.ui.view.OprofileViewDeleteSessionAction;
import org.eclipse.linuxtools.oprofile.ui.model.IUiModelElement;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelError;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelRoot;
import org.eclipse.linuxtools.oprofile.ui.model.UiModelSession;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.swt.widgets.Shell;

public class OprofileViewSaveDefaultSessionAction
extends Action {
    private IRemoteFileProxy proxy;

    public OprofileViewSaveDefaultSessionAction() {
        super(OprofileUiMessages.getString("view.actions.savedefaultsession.label"));
    }

    public void run() {
        boolean defaultSessionExists = false;
        String defaultSessionName = null;
        UiModelRoot modelRoot = UiModelRoot.getDefault();
        IUiModelElement[] modelEvents = null;
        if (modelRoot.hasChildren()) {
            IUiModelElement[] sessions;
            IUiModelElement[] iUiModelElementArray = sessions = modelRoot.getChildren();
            int n = sessions.length;
            int n2 = 0;
            while (n2 < n) {
                IUiModelElement e = iUiModelElementArray[n2];
                if (e instanceof UiModelError) break;
                if (e instanceof UiModelSession) {
                    if (((UiModelSession)e).isDefaultSession()) {
                        defaultSessionExists = true;
                        defaultSessionName = e.getLabelText();
                        modelEvents = ((UiModelSession)e).getChildren();
                        break;
                    }
                    if (defaultSessionExists) break;
                }
                ++n2;
            }
            if (defaultSessionExists) {
                InputDialog dialog = new InputDialog(OprofileUiPlugin.getActiveWorkbenchShell(), OprofileUiMessages.getString("savedialog.title"), OprofileUiMessages.getString("savedialog.message"), OprofileUiMessages.getString("savedialog.initial"), (IInputValidator)new SaveSessionValidator());
                int result = dialog.open();
                if (result == 0) {
                    try {
                        OprofileCorePlugin.getDefault().getOpcontrolProvider().saveSession(dialog.getValue());
                        int i = 0;
                        while (i < modelEvents.length) {
                            OprofileCorePlugin.getDefault().getOpcontrolProvider().deleteSession(defaultSessionName, modelEvents[i].getLabelText());
                            ++i;
                        }
                        if (!"operf".equals(Oprofile.OprofileProject.getProfilingBinary())) {
                            OprofileCorePlugin.getDefault().getOpcontrolProvider().reset();
                        } else {
                            OprofileViewDeleteSessionAction.deleteOperfDataFolder(Oprofile.OprofileProject.getProject().getFolder("oprofile_data"));
                        }
                        OprofileUiPlugin.getDefault().getOprofileView().refreshView();
                    }
                    catch (OpcontrolException oe) {
                        OprofileCorePlugin.showErrorDialog((String)"opcontrolProvider", (CoreException)((Object)oe));
                    }
                }
            } else {
                MessageDialog.openError((Shell)OprofileUiPlugin.getActiveWorkbenchShell(), (String)OprofileUiMessages.getString("defaultsessiondialog.nodefaultsession.title"), (String)OprofileUiMessages.getString("defaultsessiondialog.nodefaultsession.message"));
            }
        }
    }

    private class SaveSessionValidator
    implements IInputValidator {
        private SessionManager session = new SessionManager(SessionManager.SESSION_LOCATION);

        public String isValid(String newText) {
            if (newText.length() == 0) {
                return "";
            }
            int index = newText.indexOf(47);
            if (index == -1) {
                index = newText.indexOf(92);
            }
            if (index != -1) {
                String format = OprofileUiMessages.getString("savedialog.validator.invalidChar");
                Object[] fmtArgs = new Object[]{newText.substring(index, index + 1), newText};
                return MessageFormat.format(format, fmtArgs);
            }
            if (newText.contains(" ") || newText.contains("\t")) {
                String format = OprofileUiMessages.getString("savedialog.validator.containsWhitespace");
                Object[] fmtArgs = new Object[]{newText};
                return MessageFormat.format(format, fmtArgs);
            }
            if (this.session.existsSession(newText)) {
                String format = OprofileUiMessages.getString("savedialog.validator.exists");
                Object[] fmtArgs = new Object[]{newText};
                return MessageFormat.format(format, fmtArgs);
            }
            try {
                OprofileViewSaveDefaultSessionAction.this.proxy = RemoteProxyManager.getInstance().getFileProxy(Oprofile.OprofileProject.getProject());
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            IFileStore fileStore = OprofileViewSaveDefaultSessionAction.this.proxy.getResource(String.valueOf(Oprofile.getDefaultSamplesDirectory()) + newText);
            if (fileStore.fetchInfo().exists()) {
                String format = OprofileUiMessages.getString("savedialog.validator.exists");
                Object[] fmtArgs = new Object[]{newText};
                return MessageFormat.format(format, fmtArgs);
            }
            return null;
        }
    }
}

