/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.launch.launching;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.linuxtools.internal.oprofile.core.OpcontrolException;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OprofileDaemonEvent;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OprofileDaemonOptions;
import org.eclipse.linuxtools.internal.oprofile.launch.OprofileLaunchMessages;
import org.eclipse.linuxtools.internal.oprofile.launch.configuration.LaunchOptions;
import org.eclipse.linuxtools.internal.oprofile.launch.configuration.OprofileCounter;
import org.eclipse.linuxtools.internal.oprofile.ui.OprofileUiPlugin;
import org.eclipse.linuxtools.internal.oprofile.ui.view.OprofileView;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractOprofileLaunchConfigurationDelegate
extends AbstractCLaunchDelegate {
    protected ILaunchConfiguration config;
    private static final String OPROFILE_DATA = "oprofile_data";
    private static final String SESSION_DIR = "--session-dir=";
    private static final String EVENTS = "--events=";
    private static final String APPEND = "--append";
    private static final String OPD_SETUP_EVENT_SEPARATOR = ":";
    private static final String OPD_SETUP_EVENT_TRUE = "1";
    private static final String OPD_SETUP_EVENT_FALSE = "0";

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.config = config;
        Oprofile.OprofileProject.setProject((IProject)this.getProject());
        LaunchOptions options = new LaunchOptions();
        options.loadConfiguration(config);
        IPath exePath = this.getExePath(config);
        options.setBinaryImage(exePath.toOSString());
        Oprofile.OprofileProject.setProfilingBinary((String)options.getOprofileComboText());
        String[] appArgs = this.getProgramArgumentsArray(config);
        String[] appEnv = this.getEnvironment(config);
        OprofileDaemonEvent[] daemonEvents = null;
        ArrayList<OprofileDaemonEvent> events = new ArrayList<OprofileDaemonEvent>();
        if (!config.getAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.USE_DEFAULT_EVENT", false)) {
            OprofileCounter[] counters = this.oprofileCounters(config);
            int i = 0;
            while (i < counters.length) {
                if (counters[i].getEnabled()) {
                    OprofileDaemonEvent[] counterEvents = counters[i].getDaemonEvents();
                    events.addAll(Arrays.asList(counterEvents));
                }
                ++i;
            }
            daemonEvents = new OprofileDaemonEvent[events.size()];
            events.toArray(daemonEvents);
        }
        if (!this.preExec(options, daemonEvents, launch)) {
            return;
        }
        Process process = null;
        if (Oprofile.OprofileProject.getProfilingBinary().equals("opcontrol")) {
            IRemoteCommandLauncher launcher = RemoteProxyManager.getInstance().getLauncher(this.oprofileProject());
            Path workingDirPath = new Path(this.oprofileWorkingDirURI(config).getPath());
            int i = 0;
            while (i < options.getExecutionsNumber()) {
                process = launcher.execute(exePath, appArgs, appEnv, (IPath)workingDirPath, monitor);
                DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(exePath.toOSString()));
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    process.destroy();
                    Status status = new Status(4, "org.eclipse.linuxtools.oprofile.launch", OprofileLaunchMessages.getString("oprofilelaunch.error.interrupted_error.status_message"));
                    throw new CoreException((IStatus)status);
                }
                ++i;
            }
        }
        if (Oprofile.OprofileProject.getProfilingBinary().equals("operf")) {
            String eventsString = null;
            StringBuilder spec = new StringBuilder();
            spec.append(EVENTS);
            boolean isCommaAllowed = false;
            int i = 0;
            while (i < events.size()) {
                OprofileDaemonEvent event = (OprofileDaemonEvent)events.get(i);
                if (isCommaAllowed) {
                    spec.append(',');
                }
                spec.append(event.getEvent().getText());
                spec.append(OPD_SETUP_EVENT_SEPARATOR);
                spec.append(event.getResetCount());
                spec.append(OPD_SETUP_EVENT_SEPARATOR);
                spec.append(event.getEvent().getUnitMask().getMaskValue());
                spec.append(OPD_SETUP_EVENT_SEPARATOR);
                spec.append(event.getProfileKernel() ? OPD_SETUP_EVENT_TRUE : OPD_SETUP_EVENT_FALSE);
                spec.append(OPD_SETUP_EVENT_SEPARATOR);
                spec.append(event.getProfileUser() ? OPD_SETUP_EVENT_TRUE : OPD_SETUP_EVENT_FALSE);
                isCommaAllowed = true;
                ++i;
            }
            eventsString = spec.toString();
            ArrayList<String> argArray = new ArrayList<String>(Arrays.asList(appArgs));
            IRemoteFileProxy proxy = RemoteProxyManager.getInstance().getFileProxy(Oprofile.OprofileProject.getProject());
            IFileStore dataFolder = proxy.getResource(String.valueOf(this.oprofileWorkingDirURI(config).getPath()) + '/' + OPROFILE_DATA);
            if (!dataFolder.fetchInfo().exists()) {
                dataFolder.mkdir(4, null);
            }
            argArray.add(0, exePath.toOSString());
            if (events.size() > 0) {
                argArray.add(0, eventsString);
            }
            argArray.add(0, SESSION_DIR + this.oprofileWorkingDirURI(config).getPath() + '/' + OPROFILE_DATA);
            argArray.add(0, "operf");
            boolean appended = false;
            int i2 = 0;
            while (i2 < options.getExecutionsNumber()) {
                if (!appended && i2 != 0) {
                    argArray.add(1, APPEND);
                    appended = true;
                }
                String[] arguments = new String[argArray.size()];
                arguments = argArray.toArray(arguments);
                try {
                    process = RuntimeProcessFactory.getFactory().exec(arguments, appEnv, Oprofile.OprofileProject.getProject());
                }
                catch (IOException e1) {
                    process.destroy();
                    Status status = new Status(4, "org.eclipse.linuxtools.oprofile.launch", OprofileLaunchMessages.getString("oprofilelaunch.error.interrupted_error.status_message"));
                    throw new CoreException((IStatus)status);
                }
                DebugPlugin.newProcess((ILaunch)launch, (Process)process, (String)this.renderProcessLabel(exePath.toOSString()));
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    process.destroy();
                    Status status = new Status(4, "org.eclipse.linuxtools.oprofile.launch", OprofileLaunchMessages.getString("oprofilelaunch.error.interrupted_error.status_message"));
                    throw new CoreException((IStatus)status);
                }
                ++i2;
            }
        }
        this.postExec(options, daemonEvents, process);
    }

    protected abstract boolean preExec(LaunchOptions var1, OprofileDaemonEvent[] var2, ILaunch var3);

    protected abstract void postExec(LaunchOptions var1, OprofileDaemonEvent[] var2, Process var3);

    protected String getPluginID() {
        return "org.eclipse.linuxtools.oprofile.launch";
    }

    protected void refreshOprofileView() {
        OprofileView view = OprofileUiPlugin.getDefault().getOprofileView();
        if (view != null) {
            view.refreshView();
        } else {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.linuxtools.oprofile.ui.OProfileView");
            }
            catch (PartInitException e2) {
                e2.printStackTrace();
            }
            OprofileUiPlugin.getDefault().getOprofileView().refreshView();
        }
    }

    protected void oprofileShutdown() throws OpcontrolException {
        OprofileCorePlugin.getDefault().getOpcontrolProvider().shutdownDaemon();
    }

    protected void oprofileReset() throws OpcontrolException {
        OprofileCorePlugin.getDefault().getOpcontrolProvider().reset();
    }

    protected void oprofileSetupDaemon(OprofileDaemonOptions options, OprofileDaemonEvent[] events) throws OpcontrolException {
        OprofileCorePlugin.getDefault().getOpcontrolProvider().setupDaemon(options, events);
    }

    protected void oprofileStartCollection() throws OpcontrolException {
        OprofileCorePlugin.getDefault().getOpcontrolProvider().startCollection();
    }

    protected void oprofileDumpSamples() throws OpcontrolException {
        OprofileCorePlugin.getDefault().getOpcontrolProvider().dumpSamples();
    }

    protected IProject oprofileProject() {
        return Oprofile.OprofileProject.getProject();
    }

    protected URI oprofileWorkingDirURI(ILaunchConfiguration config) throws CoreException {
        File workingDirectory = this.getWorkingDirectory(config);
        if (workingDirectory == null) {
            return this.getProject().getLocationURI();
        }
        URI uri = null;
        try {
            uri = new URI(workingDirectory.getAbsolutePath());
        }
        catch (URISyntaxException e) {
            Status status = new Status(4, OprofileCorePlugin.getId(), OprofileLaunchMessages.getString("oprofilelaunch.error.invalidworkingdir.status_message"));
            throw new CoreException((IStatus)status);
        }
        return uri;
    }

    protected OprofileCounter[] oprofileCounters(ILaunchConfiguration config) {
        return OprofileCounter.getCounters(config);
    }

    protected boolean oprofileStatus() throws OpcontrolException {
        if (Oprofile.OprofileProject.getProfilingBinary().equals("operf")) {
            try {
                Process p = RuntimeProcessFactory.getFactory().exec(new String[]{"operf", "--version"}, Oprofile.OprofileProject.getProject());
                return p != null;
            }
            catch (IOException e) {
                return false;
            }
        }
        return OprofileCorePlugin.getDefault().getOpcontrolProvider().status();
    }

    protected IProject getProject() {
        try {
            return CDebugUtils.verifyCProject((ILaunchConfiguration)this.config).getProject();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected IPath getExePath(ILaunchConfiguration config) throws CoreException {
        return CDebugUtils.verifyProgramPath((ILaunchConfiguration)config);
    }
}

