/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import com.ibm.icu.text.NumberFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.NumberToStringConverter;
import org.eclipse.core.databinding.conversion.StringToNumberConverter;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.internal.databinding.ClassLookupSupport;
import org.eclipse.core.internal.databinding.Pair;
import org.eclipse.core.internal.databinding.conversion.CharacterToStringConverter;
import org.eclipse.core.internal.databinding.conversion.IdentityConverter;
import org.eclipse.core.internal.databinding.conversion.IntegerToStringConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToBigDecimalConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToBigIntegerConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToByteConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToDoubleConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToFloatConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToIntegerConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToLongConverter;
import org.eclipse.core.internal.databinding.conversion.NumberToShortConverter;
import org.eclipse.core.internal.databinding.conversion.ObjectToStringConverter;
import org.eclipse.core.internal.databinding.conversion.StringToByteConverter;
import org.eclipse.core.internal.databinding.conversion.StringToCharacterConverter;
import org.eclipse.core.internal.databinding.conversion.StringToShortConverter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

class UpdateStrategy {
    private static final String BOOLEAN_CLASS = "boolean.class";
    private static final String SHORT_CLASS = "short.class";
    private static final String BYTE_CLASS = "byte.class";
    private static final String DOUBLE_CLASS = "double.class";
    private static final String FLOAT_CLASS = "float.class";
    private static final String INTEGER_CLASS = "int.class";
    private static final String LONG_CLASS = "long.class";
    private static final String CHARACTER_CLASS = "char.class";
    private static Map converterMap;
    private static final Class[] integerClasses;
    private static final Class[] floatClasses;

    static {
        integerClasses = new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, BigInteger.class};
        floatClasses = new Class[]{Float.TYPE, Float.class, Double.TYPE, Double.class, BigDecimal.class};
    }

    UpdateStrategy() {
    }

    private static Class autoboxed(Class clazz) {
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        return clazz;
    }

    protected final void checkAssignable(Object toType, Object fromType, String errorString) {
        Boolean assignableFromModelToModelConverter = this.isAssignableFromTo(fromType, toType);
        if (assignableFromModelToModelConverter != null && !assignableFromModelToModelConverter.booleanValue()) {
            throw new BindingException(String.valueOf(errorString) + " Expected: " + fromType + ", actual: " + toType);
        }
    }

    protected IConverter createConverter(Object fromType, Object toType) {
        Class fromClass;
        Class toClass;
        if (!(fromType instanceof Class) || !(toType instanceof Class)) {
            return new DefaultConverter(fromType, toType);
        }
        Class originalToClass = toClass = (Class)toType;
        if (toClass.isPrimitive()) {
            toClass = UpdateStrategy.autoboxed(toClass);
        }
        Class originalFromClass = fromClass = (Class)fromType;
        if (fromClass.isPrimitive()) {
            fromClass = UpdateStrategy.autoboxed(fromClass);
        }
        if (!((Class)toType).isPrimitive() && toClass.isAssignableFrom(fromClass)) {
            return new IdentityConverter(originalFromClass, originalToClass);
        }
        if (((Class)fromType).isPrimitive() && ((Class)toType).isPrimitive() && fromType.equals(toType)) {
            return new IdentityConverter(originalFromClass, originalToClass);
        }
        Map converterMap = UpdateStrategy.getConverterMap();
        Class[] supertypeHierarchyFlattened = ClassLookupSupport.getTypeHierarchyFlattened(fromClass);
        int i = 0;
        while (i < supertypeHierarchyFlattened.length) {
            Class currentFromClass = supertypeHierarchyFlattened[i];
            if (currentFromClass == toType) {
                return new IdentityConverter(fromClass, toClass);
            }
            Pair key = new Pair(UpdateStrategy.getKeyForClass(fromType, currentFromClass), UpdateStrategy.getKeyForClass(toType, toClass));
            Object converterOrClassname = converterMap.get(key);
            if (converterOrClassname instanceof IConverter) {
                return (IConverter)converterOrClassname;
            }
            if (converterOrClassname instanceof String) {
                String classname = (String)converterOrClassname;
                try {
                    Class<?> converterClass = Class.forName(classname);
                    IConverter result = (IConverter)converterClass.newInstance();
                    converterMap.put(key, result);
                    return result;
                }
                catch (Exception e) {
                    Policy.getLog().log((IStatus)new Status(4, "org.eclipse.core.databinding", 0, "Error while instantiating default converter", (Throwable)e));
                }
            }
            ++i;
        }
        if (fromClass.isAssignableFrom(toClass)) {
            return new IdentityConverter(originalFromClass, originalToClass);
        }
        return new DefaultConverter(fromType, toType);
    }

    private static synchronized Map getConverterMap() {
        if (converterMap == null) {
            NumberFormat integerFormat = NumberFormat.getIntegerInstance();
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            converterMap = new HashMap();
            converterMap.put(new Pair("java.util.Date", "java.lang.String"), "org.eclipse.core.internal.databinding.conversion.DateToStringConverter");
            converterMap.put(new Pair("java.lang.String", "java.lang.Boolean"), "org.eclipse.core.internal.databinding.conversion.StringToBooleanConverter");
            converterMap.put(new Pair("java.lang.String", "java.lang.Byte"), StringToByteConverter.toByte(integerFormat, false));
            converterMap.put(new Pair("java.lang.String", "java.util.Date"), "org.eclipse.core.internal.databinding.conversion.StringToDateConverter");
            converterMap.put(new Pair("java.lang.String", "java.lang.Short"), StringToShortConverter.toShort(integerFormat, false));
            converterMap.put(new Pair("java.lang.String", "java.lang.Character"), StringToCharacterConverter.toCharacter(false));
            converterMap.put(new Pair("java.lang.String", "java.lang.Integer"), StringToNumberConverter.toInteger(integerFormat, false));
            converterMap.put(new Pair("java.lang.String", "java.lang.Double"), StringToNumberConverter.toDouble(numberFormat, false));
            converterMap.put(new Pair("java.lang.String", "java.lang.Long"), StringToNumberConverter.toLong(integerFormat, false));
            converterMap.put(new Pair("java.lang.String", "java.lang.Float"), StringToNumberConverter.toFloat(numberFormat, false));
            converterMap.put(new Pair("java.lang.String", "java.math.BigInteger"), StringToNumberConverter.toBigInteger(integerFormat));
            converterMap.put(new Pair("java.lang.String", "java.math.BigDecimal"), StringToNumberConverter.toBigDecimal(numberFormat));
            converterMap.put(new Pair("java.lang.Integer", "java.lang.String"), NumberToStringConverter.fromInteger(integerFormat, false));
            converterMap.put(new Pair("java.lang.Long", "java.lang.String"), NumberToStringConverter.fromLong(integerFormat, false));
            converterMap.put(new Pair("java.lang.Double", "java.lang.String"), NumberToStringConverter.fromDouble(numberFormat, false));
            converterMap.put(new Pair("java.lang.Float", "java.lang.String"), NumberToStringConverter.fromFloat(numberFormat, false));
            converterMap.put(new Pair("java.math.BigInteger", "java.lang.String"), NumberToStringConverter.fromBigInteger(integerFormat));
            converterMap.put(new Pair("java.math.BigDecimal", "java.lang.String"), NumberToStringConverter.fromBigDecimal(numberFormat));
            converterMap.put(new Pair("java.lang.Byte", "java.lang.String"), IntegerToStringConverter.fromByte(integerFormat, false));
            converterMap.put(new Pair("java.lang.Short", "java.lang.String"), IntegerToStringConverter.fromShort(integerFormat, false));
            converterMap.put(new Pair("java.lang.Character", "java.lang.String"), CharacterToStringConverter.fromCharacter(false));
            converterMap.put(new Pair("java.lang.Object", "java.lang.String"), "org.eclipse.core.internal.databinding.conversion.ObjectToStringConverter");
            converterMap.put(new Pair("java.lang.String", INTEGER_CLASS), StringToNumberConverter.toInteger(integerFormat, true));
            converterMap.put(new Pair(INTEGER_CLASS, "java.lang.Integer"), new IdentityConverter(Integer.class, Integer.class));
            converterMap.put(new Pair(INTEGER_CLASS, "java.lang.Object"), new IdentityConverter(Integer.class, Object.class));
            converterMap.put(new Pair(INTEGER_CLASS, "java.lang.String"), NumberToStringConverter.fromInteger(integerFormat, true));
            converterMap.put(new Pair("java.lang.String", BYTE_CLASS), StringToByteConverter.toByte(integerFormat, true));
            converterMap.put(new Pair(BYTE_CLASS, "java.lang.Byte"), new IdentityConverter(Byte.class, Byte.class));
            converterMap.put(new Pair(BYTE_CLASS, "java.lang.String"), IntegerToStringConverter.fromByte(integerFormat, true));
            converterMap.put(new Pair(BYTE_CLASS, "java.lang.Object"), new IdentityConverter(Byte.class, Object.class));
            converterMap.put(new Pair("java.lang.String", DOUBLE_CLASS), StringToNumberConverter.toDouble(numberFormat, true));
            converterMap.put(new Pair(DOUBLE_CLASS, "java.lang.String"), NumberToStringConverter.fromDouble(numberFormat, true));
            converterMap.put(new Pair(DOUBLE_CLASS, "java.lang.Double"), new IdentityConverter(Double.class, Double.class));
            converterMap.put(new Pair(DOUBLE_CLASS, "java.lang.Object"), new IdentityConverter(Double.class, Object.class));
            converterMap.put(new Pair("java.lang.String", BOOLEAN_CLASS), "org.eclipse.core.internal.databinding.conversion.StringToBooleanPrimitiveConverter");
            converterMap.put(new Pair(BOOLEAN_CLASS, "java.lang.Boolean"), new IdentityConverter(Boolean.class, Boolean.class));
            converterMap.put(new Pair(BOOLEAN_CLASS, "java.lang.String"), new ObjectToStringConverter(Boolean.class));
            converterMap.put(new Pair(BOOLEAN_CLASS, "java.lang.Object"), new IdentityConverter(Boolean.class, Object.class));
            converterMap.put(new Pair("java.lang.String", FLOAT_CLASS), StringToNumberConverter.toFloat(numberFormat, true));
            converterMap.put(new Pair(FLOAT_CLASS, "java.lang.String"), NumberToStringConverter.fromFloat(numberFormat, true));
            converterMap.put(new Pair(FLOAT_CLASS, "java.lang.Float"), new IdentityConverter(Float.class, Float.class));
            converterMap.put(new Pair(FLOAT_CLASS, "java.lang.Object"), new IdentityConverter(Float.class, Object.class));
            converterMap.put(new Pair("java.lang.String", SHORT_CLASS), StringToShortConverter.toShort(integerFormat, true));
            converterMap.put(new Pair(SHORT_CLASS, "java.lang.Short"), new IdentityConverter(Short.class, Short.class));
            converterMap.put(new Pair(SHORT_CLASS, "java.lang.String"), IntegerToStringConverter.fromShort(integerFormat, true));
            converterMap.put(new Pair(SHORT_CLASS, "java.lang.Object"), new IdentityConverter(Short.class, Object.class));
            converterMap.put(new Pair("java.lang.String", LONG_CLASS), StringToNumberConverter.toLong(integerFormat, true));
            converterMap.put(new Pair(LONG_CLASS, "java.lang.String"), NumberToStringConverter.fromLong(integerFormat, true));
            converterMap.put(new Pair(LONG_CLASS, "java.lang.Long"), new IdentityConverter(Long.class, Long.class));
            converterMap.put(new Pair(LONG_CLASS, "java.lang.Object"), new IdentityConverter(Long.class, Object.class));
            converterMap.put(new Pair("java.lang.String", CHARACTER_CLASS), StringToCharacterConverter.toCharacter(true));
            converterMap.put(new Pair(CHARACTER_CLASS, "java.lang.Character"), new IdentityConverter(Character.class, Character.class));
            converterMap.put(new Pair(CHARACTER_CLASS, "java.lang.String"), CharacterToStringConverter.fromCharacter(true));
            converterMap.put(new Pair(CHARACTER_CLASS, "java.lang.Object"), new IdentityConverter(Character.class, Object.class));
            converterMap.put(new Pair("org.eclipse.core.runtime.IStatus", "java.lang.String"), "org.eclipse.core.internal.databinding.conversion.StatusToStringConverter");
            UpdateStrategy.addNumberToByteConverters(converterMap, integerFormat, integerClasses);
            UpdateStrategy.addNumberToByteConverters(converterMap, numberFormat, floatClasses);
            UpdateStrategy.addNumberToShortConverters(converterMap, integerFormat, integerClasses);
            UpdateStrategy.addNumberToShortConverters(converterMap, numberFormat, floatClasses);
            UpdateStrategy.addNumberToIntegerConverters(converterMap, integerFormat, integerClasses);
            UpdateStrategy.addNumberToIntegerConverters(converterMap, numberFormat, floatClasses);
            UpdateStrategy.addNumberToLongConverters(converterMap, integerFormat, integerClasses);
            UpdateStrategy.addNumberToLongConverters(converterMap, numberFormat, floatClasses);
            UpdateStrategy.addNumberToFloatConverters(converterMap, integerFormat, integerClasses);
            UpdateStrategy.addNumberToFloatConverters(converterMap, numberFormat, floatClasses);
            UpdateStrategy.addNumberToDoubleConverters(converterMap, integerFormat, integerClasses);
            UpdateStrategy.addNumberToDoubleConverters(converterMap, numberFormat, floatClasses);
            UpdateStrategy.addNumberToBigIntegerConverters(converterMap, integerFormat, integerClasses);
            UpdateStrategy.addNumberToBigIntegerConverters(converterMap, numberFormat, floatClasses);
            UpdateStrategy.addNumberToBigDecimalConverters(converterMap, integerFormat, integerClasses);
            UpdateStrategy.addNumberToBigDecimalConverters(converterMap, numberFormat, floatClasses);
        }
        return converterMap;
    }

    private static void addNumberToByteConverters(Map map, NumberFormat numberFormat, Class[] fromTypes) {
        int i = 0;
        while (i < fromTypes.length) {
            Class fromType = fromTypes[i];
            if (!fromType.equals(Byte.class) && !fromType.equals(Byte.TYPE)) {
                String fromName = fromType.isPrimitive() ? UpdateStrategy.getKeyForClass(fromType, null) : fromType.getName();
                map.put(new Pair(fromName, BYTE_CLASS), new NumberToByteConverter(numberFormat, fromType, true));
                map.put(new Pair(fromName, Byte.class.getName()), new NumberToByteConverter(numberFormat, fromType, false));
            }
            ++i;
        }
    }

    private static void addNumberToShortConverters(Map map, NumberFormat numberFormat, Class[] fromTypes) {
        int i = 0;
        while (i < fromTypes.length) {
            Class fromType = fromTypes[i];
            if (!fromType.equals(Short.class) && !fromType.equals(Short.TYPE)) {
                String fromName = fromType.isPrimitive() ? UpdateStrategy.getKeyForClass(fromType, null) : fromType.getName();
                map.put(new Pair(fromName, SHORT_CLASS), new NumberToShortConverter(numberFormat, fromType, true));
                map.put(new Pair(fromName, Short.class.getName()), new NumberToShortConverter(numberFormat, fromType, false));
            }
            ++i;
        }
    }

    private static void addNumberToIntegerConverters(Map map, NumberFormat numberFormat, Class[] fromTypes) {
        int i = 0;
        while (i < fromTypes.length) {
            Class fromType = fromTypes[i];
            if (!fromType.equals(Integer.class) && !fromType.equals(Integer.TYPE)) {
                String fromName = fromType.isPrimitive() ? UpdateStrategy.getKeyForClass(fromType, null) : fromType.getName();
                map.put(new Pair(fromName, INTEGER_CLASS), new NumberToIntegerConverter(numberFormat, fromType, true));
                map.put(new Pair(fromName, Integer.class.getName()), new NumberToIntegerConverter(numberFormat, fromType, false));
            }
            ++i;
        }
    }

    private static void addNumberToLongConverters(Map map, NumberFormat numberFormat, Class[] fromTypes) {
        int i = 0;
        while (i < fromTypes.length) {
            Class fromType = fromTypes[i];
            if (!fromType.equals(Long.class) && !fromType.equals(Long.TYPE)) {
                String fromName = fromType.isPrimitive() ? UpdateStrategy.getKeyForClass(fromType, null) : fromType.getName();
                map.put(new Pair(fromName, LONG_CLASS), new NumberToLongConverter(numberFormat, fromType, true));
                map.put(new Pair(fromName, Long.class.getName()), new NumberToLongConverter(numberFormat, fromType, false));
            }
            ++i;
        }
    }

    private static void addNumberToFloatConverters(Map map, NumberFormat numberFormat, Class[] fromTypes) {
        int i = 0;
        while (i < fromTypes.length) {
            Class fromType = fromTypes[i];
            if (!fromType.equals(Float.class) && !fromType.equals(Float.TYPE)) {
                String fromName = fromType.isPrimitive() ? UpdateStrategy.getKeyForClass(fromType, null) : fromType.getName();
                map.put(new Pair(fromName, FLOAT_CLASS), new NumberToFloatConverter(numberFormat, fromType, true));
                map.put(new Pair(fromName, Float.class.getName()), new NumberToFloatConverter(numberFormat, fromType, false));
            }
            ++i;
        }
    }

    private static void addNumberToDoubleConverters(Map map, NumberFormat numberFormat, Class[] fromTypes) {
        int i = 0;
        while (i < fromTypes.length) {
            Class fromType = fromTypes[i];
            if (!fromType.equals(Double.class) && !fromType.equals(Double.TYPE)) {
                String fromName = fromType.isPrimitive() ? UpdateStrategy.getKeyForClass(fromType, null) : fromType.getName();
                map.put(new Pair(fromName, DOUBLE_CLASS), new NumberToDoubleConverter(numberFormat, fromType, true));
                map.put(new Pair(fromName, Double.class.getName()), new NumberToDoubleConverter(numberFormat, fromType, false));
            }
            ++i;
        }
    }

    private static void addNumberToBigIntegerConverters(Map map, NumberFormat numberFormat, Class[] fromTypes) {
        int i = 0;
        while (i < fromTypes.length) {
            Class fromType = fromTypes[i];
            if (!fromType.equals(BigInteger.class)) {
                String fromName = fromType.isPrimitive() ? UpdateStrategy.getKeyForClass(fromType, null) : fromType.getName();
                map.put(new Pair(fromName, BigInteger.class.getName()), new NumberToBigIntegerConverter(numberFormat, fromType));
            }
            ++i;
        }
    }

    private static void addNumberToBigDecimalConverters(Map map, NumberFormat numberFormat, Class[] fromTypes) {
        int i = 0;
        while (i < fromTypes.length) {
            Class fromType = fromTypes[i];
            if (!fromType.equals(BigDecimal.class)) {
                String fromName = fromType.isPrimitive() ? UpdateStrategy.getKeyForClass(fromType, null) : fromType.getName();
                map.put(new Pair(fromName, BigDecimal.class.getName()), new NumberToBigDecimalConverter(numberFormat, fromType));
            }
            ++i;
        }
    }

    private static String getKeyForClass(Object originalValue, Class filteredValue) {
        if (originalValue instanceof Class) {
            Class originalClass = (Class)originalValue;
            if (originalClass.equals(Integer.TYPE)) {
                return INTEGER_CLASS;
            }
            if (originalClass.equals(Byte.TYPE)) {
                return BYTE_CLASS;
            }
            if (originalClass.equals(Boolean.TYPE)) {
                return BOOLEAN_CLASS;
            }
            if (originalClass.equals(Double.TYPE)) {
                return DOUBLE_CLASS;
            }
            if (originalClass.equals(Float.TYPE)) {
                return FLOAT_CLASS;
            }
            if (originalClass.equals(Long.TYPE)) {
                return LONG_CLASS;
            }
            if (originalClass.equals(Short.TYPE)) {
                return SHORT_CLASS;
            }
        }
        return filteredValue.getName();
    }

    protected Boolean isAssignableFromTo(Object fromType, Object toType) {
        if (fromType instanceof Class && toType instanceof Class) {
            Class fromClass;
            Class toClass = (Class)toType;
            if (toClass.isPrimitive()) {
                toClass = UpdateStrategy.autoboxed(toClass);
            }
            if ((fromClass = (Class)fromType).isPrimitive()) {
                fromClass = UpdateStrategy.autoboxed(fromClass);
            }
            return toClass.isAssignableFrom(fromClass) ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    static final class DefaultConverter
    implements IConverter {
        private final Object toType;
        private final Object fromType;

        DefaultConverter(Object fromType, Object toType) {
            this.toType = toType;
            this.fromType = fromType;
        }

        @Override
        public Object convert(Object fromObject) {
            return fromObject;
        }

        @Override
        public Object getFromType() {
            return this.fromType;
        }

        @Override
        public Object getToType() {
            return this.toType;
        }
    }
}

