/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.actions;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.linuxtools.internal.rpm.ui.editor.RPMHandlerUtils;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.internal.rpm.ui.editor.UiUtils;
import org.eclipse.linuxtools.internal.rpm.ui.editor.actions.Messages;
import org.eclipse.linuxtools.internal.rpm.ui.editor.parser.SpecfileSource;
import org.eclipse.linuxtools.rpm.core.RPMProject;
import org.eclipse.linuxtools.rpm.core.utils.DownloadJob;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileParser;
import org.eclipse.linuxtools.rpm.ui.editor.utils.RPMUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class SpecfileEditorDownloadSourcesActionDelegate
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        SpecfileParser specparser = new SpecfileParser();
        IResource resource = RPMHandlerUtils.getResource(event);
        RPMProject rpj = RPMHandlerUtils.getRPMProject(resource);
        IFile workFile = (IFile)rpj.getSpecFile();
        Specfile specfile = specparser.parse(workFile);
        List sourceURLList = specfile != null ? (List)specfile.getSources() : null;
        for (SpecfileSource sourceurls : sourceURLList) {
            URL url;
            try {
                String rawURL = sourceurls.getFileName();
                String resolvedURL = UiUtils.resolveDefines(specfile, rawURL);
                url = null;
                try {
                    url = new URL(resolvedURL);
                }
                catch (MalformedURLException e) {
                    SpecfileLog.logError(NLS.bind((String)Messages.DownloadSources_malformedURL, (Object)resolvedURL), e);
                    RPMUtils.showErrorDialog(shell, "Error", NLS.bind((String)Messages.DownloadSources_malformedURL, (Object)resolvedURL));
                    return null;
                }
            }
            catch (IOException e) {
                SpecfileLog.logError(Messages.DownloadSources_cannotConnectToURL, e);
                RPMUtils.showErrorDialog(shell, "Error", Messages.DownloadSources_cannotConnectToURL);
                return null;
            }
            URLConnection connection = url.openConnection();
            if (connection instanceof HttpURLConnection && ((HttpURLConnection)connection).getResponseCode() == 404) continue;
            connection.connect();
            int offset = url.toString().lastIndexOf("/");
            String filename = url.toString().substring(offset + 1);
            IFile file = rpj.getConfiguration().getSourcesFolder().getFile((IPath)new Path(filename));
            DownloadJob downloadJob = new DownloadJob(file, connection);
            downloadJob.setUser(true);
            downloadJob.schedule();
        }
        return null;
    }
}

