/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.container;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.felix.resolver.FelixResolveContext;
import org.apache.felix.resolver.Logger;
import org.apache.felix.resolver.ResolverImpl;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleDatabase;
import org.eclipse.osgi.container.ModuleRequirement;
import org.eclipse.osgi.container.ModuleResolutionReport;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.internal.container.InternalUtils;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.report.resolution.ResolutionReport;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.resolver.ResolutionException;
import org.osgi.service.resolver.ResolveContext;

final class ModuleResolver {
    static final String SEPARATOR = System.getProperty("line.separator");
    static final char TAB = '\t';
    private static final String OPTION_RESOLVER = "org.eclipse.osgi/resolver";
    private static final String OPTION_ROOTS = "org.eclipse.osgi/resolver/roots";
    private static final String OPTION_PROVIDERS = "org.eclipse.osgi/resolver/providers";
    private static final String OPTION_HOOKS = "org.eclipse.osgi/resolver/hooks";
    private static final String OPTION_USES = "org.eclipse.osgi/resolver/uses";
    private static final String OPTION_WIRING = "org.eclipse.osgi/resolver/wiring";
    private static final String OPTION_REPORT = "org.eclipse.osgi/resolver/report";
    boolean DEBUG_ROOTS = false;
    boolean DEBUG_PROVIDERS = false;
    boolean DEBUG_HOOKS = false;
    boolean DEBUG_USES = false;
    boolean DEBUG_WIRING = false;
    boolean DEBUG_REPORT = false;
    private final int DEFAULT_BATCH_SIZE = 1;
    final int resolverRevisionBatchSize;
    private static final Collection<String> NON_PAYLOAD_CAPABILITIES = Arrays.asList("osgi.identity");
    static final Collection<String> NON_PAYLOAD_REQUIREMENTS = Arrays.asList("osgi.wiring.host", "osgi.ee");
    final ThreadLocal<Boolean> threadResolving = new ThreadLocal();
    final ModuleContainerAdaptor adaptor;

    void setDebugOptions() {
        DebugOptions options = this.adaptor.getDebugOptions();
        if (options == null) {
            return;
        }
        boolean debugAll = options.getBooleanOption(OPTION_RESOLVER, false);
        this.DEBUG_ROOTS = debugAll || options.getBooleanOption(OPTION_ROOTS, false);
        this.DEBUG_PROVIDERS = debugAll || options.getBooleanOption(OPTION_PROVIDERS, false);
        this.DEBUG_HOOKS = debugAll || options.getBooleanOption(OPTION_HOOKS, false);
        this.DEBUG_USES = debugAll || options.getBooleanOption(OPTION_USES, false);
        this.DEBUG_WIRING = debugAll || options.getBooleanOption(OPTION_WIRING, false);
        this.DEBUG_REPORT = debugAll || options.getBooleanOption(OPTION_REPORT, false);
    }

    ModuleResolver(ModuleContainerAdaptor adaptor) {
        int tempBatchSize;
        this.adaptor = adaptor;
        this.setDebugOptions();
        String batchSizeConfig = this.adaptor.getProperty("equinox.resolver.revision.batch.size");
        try {
            tempBatchSize = batchSizeConfig == null ? 1 : Integer.parseInt(batchSizeConfig);
        }
        catch (NumberFormatException numberFormatException) {
            tempBatchSize = 1;
        }
        if (tempBatchSize < 1) {
            tempBatchSize = 1;
        }
        this.resolverRevisionBatchSize = tempBatchSize;
    }

    ModuleResolutionReport resolveDelta(Collection<ModuleRevision> triggers, boolean triggersMandatory, Collection<ModuleRevision> unresolved, Map<ModuleRevision, ModuleWiring> wiringCopy, ModuleDatabase moduleDatabase) {
        ResolveProcess resolveProcess = new ResolveProcess(unresolved, triggers, triggersMandatory, wiringCopy, moduleDatabase);
        return resolveProcess.resolve();
    }

    ModuleResolutionReport resolveDynamicDelta(ModuleRequirement.DynamicModuleRequirement dynamicReq, Collection<ModuleRevision> unresolved, Map<ModuleRevision, ModuleWiring> wiringCopy, ModuleDatabase moduleDatabase) {
        ResolveProcess resolveProcess = new ResolveProcess(unresolved, dynamicReq, wiringCopy, moduleDatabase);
        return resolveProcess.resolve();
    }

    Map<ModuleRevision, ModuleWiring> generateDelta(Map<Resource, List<Wire>> result, Map<ModuleRevision, ModuleWiring> wiringCopy) {
        ModuleWiring existingWiring;
        HashMap<ModuleRevision, Map<ModuleCapability, List<ModuleWire>>> provided = new HashMap<ModuleRevision, Map<ModuleCapability, List<ModuleWire>>>();
        HashMap<ModuleRevision, List<ModuleWire>> required = new HashMap<ModuleRevision, List<ModuleWire>>();
        for (Map.Entry<Resource, List<Wire>> resultEntry : result.entrySet()) {
            ModuleRevision revision = (ModuleRevision)resultEntry.getKey();
            ArrayList<ModuleWire> requiredWires = new ArrayList<ModuleWire>(resultEntry.getValue().size());
            for (Wire wire : resultEntry.getValue()) {
                ArrayList<ModuleWire> providedWires;
                ModuleWire moduleWire = new ModuleWire((ModuleCapability)wire.getCapability(), (ModuleRevision)wire.getProvider(), (ModuleRequirement)wire.getRequirement(), (ModuleRevision)wire.getRequirer());
                requiredWires.add(moduleWire);
                HashMap<ModuleCapability, ArrayList<ModuleWire>> providedWiresMap = (HashMap<ModuleCapability, ArrayList<ModuleWire>>)provided.get(moduleWire.getProvider());
                if (providedWiresMap == null) {
                    providedWiresMap = new HashMap<ModuleCapability, ArrayList<ModuleWire>>();
                    provided.put(moduleWire.getProvider(), providedWiresMap);
                }
                if ((providedWires = (ArrayList<ModuleWire>)providedWiresMap.get(moduleWire.getCapability())) == null) {
                    providedWires = new ArrayList<ModuleWire>();
                    providedWiresMap.put(moduleWire.getCapability(), providedWires);
                }
                providedWires.add(moduleWire);
            }
            required.put(revision, requiredWires);
        }
        HashMap<ModuleRevision, ModuleWiring> delta = new HashMap<ModuleRevision, ModuleWiring>();
        for (ModuleRevision revision : required.keySet()) {
            existingWiring = wiringCopy.get(revision);
            if (existingWiring == null) {
                delta.put(revision, this.createNewWiring(revision, provided, required));
                continue;
            }
            delta.put(revision, ModuleResolver.createWiringDelta(revision, existingWiring, (Map)provided.get(revision), (List)required.get(revision)));
        }
        for (ModuleRevision revision : provided.keySet()) {
            existingWiring = wiringCopy.get(revision);
            if (existingWiring == null || delta.containsKey(revision)) continue;
            delta.put(revision, ModuleResolver.createWiringDelta(revision, existingWiring, (Map)provided.get(revision), (List)required.get(revision)));
        }
        return delta;
    }

    private ModuleWiring createNewWiring(ModuleRevision revision, Map<ModuleRevision, Map<ModuleCapability, List<ModuleWire>>> provided, Map<ModuleRevision, List<ModuleWire>> required) {
        List<ModuleWire> requiredWires;
        Map<ModuleCapability, List<ModuleWire>> providedWireMap = provided.get(revision);
        if (providedWireMap == null) {
            providedWireMap = Collections.emptyMap();
        }
        if ((requiredWires = required.get(revision)) == null) {
            requiredWires = Collections.emptyList();
        }
        ArrayList<ModuleCapability> capabilities = new ArrayList<ModuleCapability>(revision.getModuleCapabilities(null));
        ListIterator<ModuleCapability> iCapabilities = capabilities.listIterator(capabilities.size());
        ArrayList<ModuleRequirement> requirements = new ArrayList<ModuleRequirement>(revision.getModuleRequirements(null));
        ListIterator<ModuleRequirement> iRequirements = requirements.listIterator(requirements.size());
        if ((1 & revision.getTypes()) != 0) {
            ModuleResolver.removePayloadContent(iCapabilities, iRequirements);
        } else {
            ModuleCapability hostCapability;
            List<ModuleCapability> hostCapabilities = revision.getModuleCapabilities("osgi.wiring.host");
            ModuleCapability moduleCapability = hostCapability = hostCapabilities.isEmpty() ? null : hostCapabilities.get(0);
            if (hostCapability != null) {
                ModuleResolver.addPayloadContent(providedWireMap.get(hostCapability), iCapabilities, iRequirements);
            }
        }
        this.removeNonEffectiveCapabilities(iCapabilities);
        ModuleResolver.removeNonEffectiveRequirements(iRequirements, requiredWires);
        Collection<String> substituted = ModuleResolver.removeSubstitutedCapabilities(iCapabilities, requiredWires);
        ArrayList<ModuleWire> providedWires = new ArrayList<ModuleWire>();
        ModuleResolver.addProvidedWires(providedWireMap, providedWires, capabilities);
        InternalUtils.filterCapabilityPermissions(capabilities);
        return new ModuleWiring(revision, capabilities, requirements, providedWires, requiredWires, substituted);
    }

    private static void removePayloadContent(ListIterator<ModuleCapability> iCapabilities, ListIterator<ModuleRequirement> iRequirements) {
        ModuleResolver.rewind(iCapabilities);
        while (iCapabilities.hasNext()) {
            if (NON_PAYLOAD_CAPABILITIES.contains(iCapabilities.next().getNamespace())) continue;
            iCapabilities.remove();
        }
        ModuleResolver.rewind(iRequirements);
        while (iRequirements.hasNext()) {
            if (NON_PAYLOAD_REQUIREMENTS.contains(iRequirements.next().getNamespace())) continue;
            iRequirements.remove();
        }
    }

    private static Collection<String> removeSubstitutedCapabilities(ListIterator<ModuleCapability> iCapabilities, List<ModuleWire> requiredWires) {
        ArrayList<String> substituted = null;
        for (ModuleWire moduleWire : requiredWires) {
            if (!"osgi.wiring.package".equals(moduleWire.getCapability().getNamespace())) continue;
            String packageName = (String)moduleWire.getCapability().getAttributes().get("osgi.wiring.package");
            ModuleResolver.rewind(iCapabilities);
            while (iCapabilities.hasNext()) {
                ModuleCapability capability = iCapabilities.next();
                if (!"osgi.wiring.package".equals(capability.getNamespace()) || !packageName.equals(capability.getAttributes().get("osgi.wiring.package"))) continue;
                iCapabilities.remove();
                if (substituted == null) {
                    substituted = new ArrayList<String>();
                }
                substituted.add(packageName);
                if (substituted.contains(packageName)) continue;
                substituted.add(packageName);
            }
        }
        return substituted == null ? Collections.emptyList() : substituted;
    }

    private static void removeNonEffectiveRequirements(ListIterator<ModuleRequirement> iRequirements, List<ModuleWire> requiredWires) {
        ModuleResolver.rewind(iRequirements);
        while (iRequirements.hasNext()) {
            ModuleRequirement requirement = iRequirements.next();
            String effective = requirement.getDirectives().get("effective");
            if (effective != null && !"resolve".equals(effective)) {
                iRequirements.remove();
                continue;
            }
            String resolution = requirement.getDirectives().get("resolution");
            if (!"optional".equals(resolution)) continue;
            boolean found = false;
            for (ModuleWire wire : requiredWires) {
                if (!wire.getRequirement().equals(requirement)) continue;
                found = true;
                break;
            }
            if (found) continue;
            iRequirements.remove();
        }
    }

    void removeNonEffectiveCapabilities(ListIterator<ModuleCapability> iCapabilities) {
        ModuleResolver.rewind(iCapabilities);
        while (iCapabilities.hasNext()) {
            Capability capability = iCapabilities.next();
            String effective = capability.getDirectives().get("effective");
            if (effective == null || "resolve".equals(effective)) continue;
            iCapabilities.remove();
            if (!this.DEBUG_PROVIDERS) continue;
            Debug.println("RESOLVER: Capability filtered because it was not effective" + SEPARATOR + '\t' + capability + SEPARATOR + '\t' + '\t' + "of resource" + SEPARATOR + '\t' + '\t' + '\t' + capability.getResource());
        }
    }

    private static void addPayloadContent(List<ModuleWire> hostWires, ListIterator<ModuleCapability> iCapabilities, ListIterator<ModuleRequirement> iRequirements) {
        if (hostWires == null) {
            return;
        }
        for (ModuleWire hostWire : hostWires) {
            String currentNamespace = null;
            List<ModuleCapability> fragmentCapabilities = hostWire.getRequirer().getModuleCapabilities(null);
            for (ModuleCapability fragmentCapability : fragmentCapabilities) {
                if (NON_PAYLOAD_CAPABILITIES.contains(fragmentCapability.getNamespace())) continue;
                if (!fragmentCapability.getNamespace().equals(currentNamespace)) {
                    currentNamespace = fragmentCapability.getNamespace();
                    ModuleResolver.fastForward(iCapabilities);
                    while (iCapabilities.hasPrevious()) {
                        if (!iCapabilities.previous().getNamespace().equals(currentNamespace)) continue;
                        iCapabilities.next();
                        break;
                    }
                }
                iCapabilities.add(fragmentCapability);
            }
            currentNamespace = null;
            List<ModuleRequirement> fragmentRequriements = hostWire.getRequirer().getModuleRequirements(null);
            for (ModuleRequirement fragmentRequirement : fragmentRequriements) {
                if (NON_PAYLOAD_REQUIREMENTS.contains(fragmentRequirement.getNamespace())) continue;
                if (!fragmentRequirement.getNamespace().equals(currentNamespace)) {
                    currentNamespace = fragmentRequirement.getNamespace();
                    boolean isDynamic = ModuleResolver.isDynamic(fragmentRequirement);
                    ModuleResolver.fastForward(iRequirements);
                    while (iRequirements.hasPrevious()) {
                        ModuleRequirement previous = iRequirements.previous();
                        if (!previous.getNamespace().equals(currentNamespace) || !isDynamic && ModuleResolver.isDynamic(previous)) continue;
                        iRequirements.next();
                        break;
                    }
                }
                iRequirements.add(fragmentRequirement);
            }
        }
    }

    static boolean isDynamic(Requirement requirement) {
        return "osgi.wiring.package".equals(requirement.getNamespace()) && "dynamic".equals(requirement.getDirectives().get("resolution"));
    }

    private static void addProvidedWires(Map<ModuleCapability, List<ModuleWire>> toAdd, List<ModuleWire> existing, final List<ModuleCapability> orderedCapabilities) {
        if (toAdd == null) {
            return;
        }
        int originalSize = existing.size();
        for (ModuleCapability capability : orderedCapabilities) {
            List<ModuleWire> newWires = toAdd.get(capability);
            if (newWires == null) continue;
            existing.addAll(newWires);
        }
        if (originalSize != 0) {
            Collections.sort(existing, new Comparator<ModuleWire>(){

                @Override
                public int compare(ModuleWire w1, ModuleWire w2) {
                    int index1 = orderedCapabilities.indexOf(w1.getCapability());
                    int index2 = orderedCapabilities.indexOf(w2.getCapability());
                    return index1 - index2;
                }
            });
        }
    }

    private static void addRequiredWires(List<ModuleWire> toAdd, List<ModuleWire> existing, final List<ModuleRequirement> orderedRequirements) {
        if (toAdd == null) {
            return;
        }
        int originalSize = existing.size();
        existing.addAll(toAdd);
        if (originalSize != 0) {
            Collections.sort(existing, new Comparator<ModuleWire>(){

                @Override
                public int compare(ModuleWire w1, ModuleWire w2) {
                    int index1 = orderedRequirements.indexOf(w1.getRequirement());
                    int index2 = orderedRequirements.indexOf(w2.getRequirement());
                    return index1 - index2;
                }
            });
        }
    }

    private static void fastForward(ListIterator<?> listIterator) {
        while (listIterator.hasNext()) {
            listIterator.next();
        }
    }

    static void rewind(ListIterator<?> listIterator) {
        while (listIterator.hasPrevious()) {
            listIterator.previous();
        }
    }

    private static ModuleWiring createWiringDelta(ModuleRevision revision, ModuleWiring existingWiring, Map<ModuleCapability, List<ModuleWire>> providedWireMap, List<ModuleWire> requiredWires) {
        List<ModuleWire> existingProvidedWires = existingWiring.getProvidedModuleWires(null);
        List<ModuleCapability> existingCapabilities = existingWiring.getModuleCapabilities(null);
        ModuleResolver.addProvidedWires(providedWireMap, existingProvidedWires, existingCapabilities);
        List<ModuleWire> existingRequiredWires = existingWiring.getRequiredModuleWires(null);
        List<ModuleRequirement> existingRequirements = existingWiring.getModuleRequirements(null);
        ModuleResolver.addRequiredWires(requiredWires, existingRequiredWires, existingRequirements);
        if (providedWireMap != null) {
            List<ModuleWire> newHostWires;
            List<ModuleCapability> hostCapabilities = revision.getModuleCapabilities("osgi.wiring.host");
            ModuleCapability hostCapability = hostCapabilities.isEmpty() ? null : hostCapabilities.get(0);
            List<ModuleWire> list = newHostWires = hostCapability == null ? null : providedWireMap.get(hostCapability);
            if (newHostWires != null) {
                ModuleResolver.addPayloadContent(newHostWires, existingCapabilities.listIterator(), existingRequirements.listIterator());
            }
        }
        InternalUtils.filterCapabilityPermissions(existingCapabilities);
        return new ModuleWiring(revision, existingCapabilities, existingRequirements, existingProvidedWires, existingRequiredWires, Collections.EMPTY_LIST);
    }

    static boolean isSingleton(ModuleRevision revision) {
        List<Capability> identities = revision.getCapabilities("osgi.identity");
        if (identities.isEmpty()) {
            return false;
        }
        return "true".equals(identities.get(0).getDirectives().get("singleton"));
    }

    static Version getVersion(Capability c) {
        String versionAttr = null;
        String namespace = c.getNamespace();
        versionAttr = "osgi.identity".equals(namespace) ? "version" : ("osgi.wiring.package".equals(namespace) ? "version" : ("osgi.wiring.bundle".equals(namespace) ? "bundle-version" : ("osgi.wiring.host".equals(namespace) ? "bundle-version" : "version")));
        Object version = c.getAttributes().get(versionAttr);
        return version instanceof Version ? (Version)version : Version.emptyVersion;
    }

    protected boolean threadResolving() {
        Boolean resolvingValue = this.threadResolving.get();
        if (resolvingValue == null) {
            return false;
        }
        return resolvingValue;
    }

    class ResolveProcess
    extends ResolveContext
    implements Comparator<Capability>,
    FelixResolveContext {
        private final ModuleResolutionReport.Builder reportBuilder = new ModuleResolutionReport.Builder();
        private final Collection<ModuleRevision> unresolved;
        private final Collection<ModuleRevision> disabled;
        private final Collection<ModuleRevision> triggers;
        private final List<ModuleRevision> optionals;
        private final boolean triggersMandatory;
        private final ModuleDatabase moduleDatabase;
        private final Map<ModuleRevision, ModuleWiring> wirings;
        private final Set<ModuleRevision> previouslyResolved;
        private final ModuleRequirement.DynamicModuleRequirement dynamicReq;
        private volatile ResolverHook hook = null;
        private volatile Map<String, Collection<ModuleRevision>> byName = null;
        private volatile List<Resource> currentlyResolving = null;
        private volatile boolean currentlyResolvingMandatory = false;
        private final Set<Resource> transitivelyResolveFailures = new LinkedHashSet<Resource>();
        private final Set<Resource> failedToResolve = new HashSet<Resource>();
        private final Map<Resource, Map<Requirement, Set<Capability>>> unresolvedProviders = new HashMap<Resource, Map<Requirement, Set<Capability>>>();

        ResolveProcess(Collection<ModuleRevision> unresolved, Collection<ModuleRevision> triggers, boolean triggersMandatory, Map<ModuleRevision, ModuleWiring> wirings, ModuleDatabase moduleDatabase) {
            this.unresolved = unresolved;
            this.disabled = new HashSet<ModuleRevision>(unresolved);
            this.triggers = new ArrayList<ModuleRevision>(triggers);
            this.triggersMandatory = triggersMandatory;
            this.optionals = new ArrayList<ModuleRevision>(unresolved);
            if (this.triggersMandatory) {
                this.optionals.removeAll(triggers);
            }
            this.wirings = new HashMap<ModuleRevision, ModuleWiring>(wirings);
            this.previouslyResolved = new HashSet<ModuleRevision>(wirings.keySet());
            this.moduleDatabase = moduleDatabase;
            this.dynamicReq = null;
        }

        ResolveProcess(Collection<ModuleRevision> unresolved, ModuleRequirement.DynamicModuleRequirement dynamicReq, Map<ModuleRevision, ModuleWiring> wirings, ModuleDatabase moduleDatabase) {
            this.unresolved = unresolved;
            this.disabled = new HashSet<ModuleRevision>(unresolved);
            ModuleRevision revision = dynamicReq.getRevision();
            this.triggers = new ArrayList<ModuleRevision>(1);
            this.triggers.add(revision);
            this.triggersMandatory = false;
            this.optionals = new ArrayList<ModuleRevision>(unresolved);
            this.wirings = wirings;
            this.previouslyResolved = new HashSet<ModuleRevision>(wirings.keySet());
            this.moduleDatabase = moduleDatabase;
            this.dynamicReq = dynamicReq;
        }

        @Override
        public List<Capability> findProviders(Requirement requirement) {
            return this.findProviders0(requirement, requirement);
        }

        private List<Capability> findProviders0(Requirement origReq, Requirement lookupReq) {
            if (ModuleResolver.this.DEBUG_PROVIDERS) {
                Debug.println("RESOLVER: Finding capabilities for requirement" + SEPARATOR + '\t' + origReq + SEPARATOR + '\t' + '\t' + "of resource" + SEPARATOR + '\t' + '\t' + '\t' + origReq.getResource());
            }
            List<ModuleCapability> candidates = this.moduleDatabase.findCapabilities(lookupReq);
            List<Capability> result = this.filterProviders(origReq, candidates);
            if (ModuleResolver.this.DEBUG_PROVIDERS) {
                StringBuilder builder = new StringBuilder("RESOLVER: Capabilities being returned to the resolver");
                int i = 0;
                for (Capability capability : result) {
                    builder.append(SEPARATOR).append('\t').append("[").append(++i).append("] ").append(capability).append(SEPARATOR).append('\t').append('\t').append("of resource").append(SEPARATOR).append('\t').append('\t').append('\t').append(capability.getResource());
                }
                Debug.println(builder.toString());
            }
            return result;
        }

        private List<Capability> filterProviders(Requirement requirement, List<ModuleCapability> candidates) {
            return this.filterProviders(requirement, candidates, true);
        }

        private List<Capability> filterProviders(Requirement requirement, List<ModuleCapability> candidates, boolean filterResolvedHosts) {
            ListIterator<ModuleCapability> iCandidates = candidates.listIterator();
            this.filterDisabled(iCandidates);
            ModuleResolver.this.removeNonEffectiveCapabilities(iCandidates);
            this.removeSubstituted(iCandidates);
            this.filterPermissions((BundleRequirement)requirement, iCandidates);
            ArrayList<ModuleCapability> filteredMatches = null;
            if (ModuleResolver.this.DEBUG_PROVIDERS || ModuleResolver.this.DEBUG_HOOKS) {
                filteredMatches = new ArrayList<ModuleCapability>(candidates);
            }
            this.hook.filterMatches((BundleRequirement)requirement, InternalUtils.asListBundleCapability(candidates));
            if (ModuleResolver.this.DEBUG_PROVIDERS || ModuleResolver.this.DEBUG_HOOKS) {
                filteredMatches.removeAll(candidates);
                if (!filteredMatches.isEmpty()) {
                    StringBuilder builder = new StringBuilder("RESOLVER: Capabilities filtered by ResolverHook.filterMatches");
                    int i = 0;
                    for (Capability capability : filteredMatches) {
                        builder.append(SEPARATOR).append('\t').append("[").append(++i).append("] ").append(capability).append(SEPARATOR).append('\t').append('\t').append("of resource").append(SEPARATOR).append('\t').append('\t').append('\t').append(capability.getResource());
                    }
                    Debug.println(builder.toString());
                }
            }
            this.filterResolvedHosts(requirement, candidates, filterResolvedHosts);
            if (candidates.isEmpty()) {
                if (!this.wirings.containsKey(requirement.getResource()) || ModuleResolver.isDynamic(requirement)) {
                    this.reportBuilder.addEntry(requirement.getResource(), ResolutionReport.Entry.Type.MISSING_CAPABILITY, requirement);
                    String resolution = requirement.getDirectives().get("resolution");
                    if (resolution == null || "mandatory".equals(resolution)) {
                        this.transitivelyResolveFailures.add(requirement.getResource());
                    }
                }
            } else {
                this.computeUnresolvedProviders(requirement, candidates);
            }
            this.filterFailedToResolve(candidates);
            Collections.sort(candidates, this);
            return InternalUtils.asListCapability(candidates);
        }

        private void filterFailedToResolve(List<ModuleCapability> candidates) {
            Iterator<ModuleCapability> iCandidates = candidates.iterator();
            while (iCandidates.hasNext()) {
                ModuleCapability capability = iCandidates.next();
                if (!this.failedToResolve.contains(capability.getRevision())) continue;
                iCandidates.remove();
                if (!ModuleResolver.this.DEBUG_PROVIDERS) continue;
                Debug.println("RESOLVER: Capability filtered because its resource was not resolved" + SEPARATOR + '\t' + capability + SEPARATOR + '\t' + '\t' + "of resource" + SEPARATOR + '\t' + '\t' + '\t' + capability.getResource());
            }
        }

        private void filterResolvedHosts(Requirement requirement, List<ModuleCapability> candidates, boolean filterResolvedHosts) {
            if (filterResolvedHosts && "osgi.wiring.host".equals(requirement.getNamespace())) {
                Iterator<ModuleCapability> iCandidates = candidates.iterator();
                while (iCandidates.hasNext()) {
                    if (!this.wirings.containsKey(iCandidates.next().getRevision())) continue;
                    iCandidates.remove();
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        private void filterPermissions(BundleRequirement requirement, ListIterator<ModuleCapability> iCandidates) {
            ModuleResolver.rewind(iCandidates);
            if (System.getSecurityManager() == null || !iCandidates.hasNext()) {
                return;
            }
            if (requirement.getRevision().getBundle() != null) ** GOTO lbl19
            return;
lbl-1000:
            // 1 sources

            {
                candidate = iCandidates.next();
                if ("osgi.wiring.package".equals(requirement.getNamespace()) && requirement.getRevision().equals(candidate.getRevision())) continue;
                requirePermission = InternalUtils.getRequirePermission(candidate);
                providePermission = InternalUtils.getProvidePermission(candidate);
                if (!requirement.getRevision().getBundle().hasPermission(requirePermission)) {
                    iCandidates.remove();
                    if (!ModuleResolver.this.DEBUG_PROVIDERS) continue;
                    Debug.println("RESOLVER: Capability filtered because requirer did not have permission" + ModuleResolver.SEPARATOR + '\t' + candidate + ModuleResolver.SEPARATOR + '\t' + '\t' + "of resource" + ModuleResolver.SEPARATOR + '\t' + '\t' + '\t' + candidate.getResource());
                    continue;
                }
                if (candidate.getRevision().getBundle().hasPermission(providePermission)) continue;
                iCandidates.remove();
                if (!ModuleResolver.this.DEBUG_PROVIDERS) continue;
                Debug.println("RESOLVER: Capability filtered because provider did not have permission" + ModuleResolver.SEPARATOR + '\t' + candidate + ModuleResolver.SEPARATOR + '\t' + '\t' + "of resource" + ModuleResolver.SEPARATOR + '\t' + '\t' + '\t' + candidate.getResource());
lbl19:
                // 7 sources

                ** while (iCandidates.hasNext())
            }
lbl20:
            // 1 sources

        }

        private void filterDisabled(ListIterator<ModuleCapability> iCandidates) {
            ModuleResolver.rewind(iCandidates);
            while (iCandidates.hasNext()) {
                Capability capability = iCandidates.next();
                if (!this.disabled.contains(capability.getResource())) continue;
                iCandidates.remove();
                if (!ModuleResolver.this.DEBUG_PROVIDERS) continue;
                Debug.println("RESOLVER: Capability filtered because it was disabled" + SEPARATOR + '\t' + capability + SEPARATOR + '\t' + '\t' + "of resource" + SEPARATOR + '\t' + '\t' + '\t' + capability.getResource());
            }
        }

        private void removeSubstituted(ListIterator<ModuleCapability> iCapabilities) {
            ModuleResolver.rewind(iCapabilities);
            while (iCapabilities.hasNext()) {
                ModuleCapability capability = iCapabilities.next();
                ModuleWiring wiring = this.wirings.get(capability.getRevision());
                if (wiring == null || !wiring.isSubtituted(capability)) continue;
                iCapabilities.remove();
                if (!ModuleResolver.this.DEBUG_PROVIDERS) continue;
                Debug.println("RESOLVER: Capability filtered because it was substituted" + SEPARATOR + '\t' + capability + SEPARATOR + '\t' + '\t' + "of resource" + SEPARATOR + '\t' + '\t' + '\t' + capability.getResource());
            }
        }

        @Override
        public int insertHostedCapability(List<Capability> capabilities, HostedCapability hostedCapability) {
            int index = Collections.binarySearch(capabilities, hostedCapability, this);
            if (index < 0) {
                index = -index - 1;
            }
            capabilities.add(index, hostedCapability);
            return index;
        }

        @Override
        public boolean isEffective(Requirement requirement) {
            String effective = requirement.getDirectives().get("effective");
            return effective == null || "resolve".equals(effective);
        }

        @Override
        public Map<Resource, Wiring> getWirings() {
            Map<ModuleRevision, ModuleWiring> raw = this.wirings;
            return Collections.unmodifiableMap(raw);
        }

        @Override
        public Collection<Resource> getMandatoryResources() {
            if (this.currentlyResolvingMandatory) {
                return Collections.unmodifiableList(this.currentlyResolving);
            }
            return Collections.emptyList();
        }

        @Override
        public Collection<Resource> getOptionalResources() {
            if (!this.currentlyResolvingMandatory) {
                return Collections.unmodifiableList(this.currentlyResolving);
            }
            return Collections.emptyList();
        }

        @Override
        public Collection<Resource> getOndemandResources(Resource host) {
            String hostBSN = ((ModuleRevision)host).getSymbolicName();
            if (hostBSN == null) {
                return Collections.emptyList();
            }
            List<ModuleCapability> hostCaps = ((ModuleRevision)host).getModuleCapabilities("osgi.wiring.host");
            if (hostCaps.isEmpty()) {
                return Collections.emptyList();
            }
            ModuleCapability hostCap = hostCaps.get(0);
            String matchFilter = "(equinox.fragment=" + hostBSN + ")";
            Requirement fragmentRequirement = ModuleContainer.createRequirement("equinox.fragment", Collections.singletonMap("filter", matchFilter), Collections.emptyMap());
            List<ModuleCapability> candidates = this.moduleDatabase.findCapabilities(fragmentRequirement);
            this.filterDisabled(candidates.listIterator());
            ArrayList<Resource> ondemandFragments = new ArrayList<Resource>(candidates.size());
            for (ModuleCapability candidate : candidates) {
                ModuleRequirement hostReq = candidate.getRevision().getModuleRequirements("osgi.wiring.host").get(0);
                if (!hostReq.matches(hostCap)) continue;
                ondemandFragments.add(candidate.getResource());
            }
            return ondemandFragments;
        }

        /*
         * Unable to fully structure code
         */
        ModuleResolutionReport resolve() {
            block30: {
                block27: {
                    block29: {
                        block28: {
                            if (ModuleResolver.this.threadResolving()) {
                                throw new IllegalStateException(Msg.ModuleResolver_RecursiveError);
                            }
                            ModuleResolver.this.threadResolving.set(Boolean.TRUE);
                            try {
                                this.hook = ModuleResolver.this.adaptor.getResolverHookFactory().begin(InternalUtils.asListBundleRevision((List)this.triggers));
                            }
                            catch (RuntimeException e) {
                                if (e.getCause() instanceof BundleException && (be = (BundleException)e.getCause()).getType() == 12) {
                                    var12_5 = new ModuleResolutionReport(null, Collections.<Resource, List<ResolutionReport.Entry>>emptyMap(), new ResolutionException(be));
                                    ModuleResolver.this.threadResolving.set(Boolean.FALSE);
                                    return var12_5;
                                }
                                throw e;
                            }
                            result = null;
                            re = null;
                            logger = new ResolveLogger();
                            try {
                                try {
                                    this.filterResolvable();
                                    this.selectSingletons();
                                    this.optionals.removeAll(this.disabled);
                                    if (this.triggers.removeAll(this.disabled) && this.triggersMandatory) {
                                        throw new ResolutionException(String.valueOf(Msg.ModuleResolver_SingletonDisabledError) + this.disabled);
                                    }
                                    if (this.dynamicReq != null) {
                                        result = this.resolveDynamic();
                                    } else {
                                        result = new HashMap<Resource, List<Wire>>();
                                        dynamicAttachWirings = this.resolveNonPayLoadFragments();
                                        this.applyInterimResultToWiringCopy(dynamicAttachWirings);
                                        if (!dynamicAttachWirings.isEmpty()) {
                                            fragmentResources = dynamicAttachWirings.keySet();
                                            this.triggers.removeAll(fragmentResources);
                                            this.optionals.removeAll(fragmentResources);
                                            result.putAll(dynamicAttachWirings);
                                        }
                                        if (this.triggersMandatory) {
                                            this.resolveRevisionsInBatch(this.triggers, true, logger, result);
                                        }
                                        this.resolveRevisionsInBatch(this.optionals, false, logger, result);
                                    }
                                    break block27;
                                }
                                catch (ResolutionException e) {
                                    re = e;
                                    this.computeUnresolvedProviderResolutionReportEntries(result);
                                    this.computeUsesConstraintViolations(logger.getUsesConstraintViolations());
                                    if (ModuleResolver.this.DEBUG_WIRING) {
                                        this.printWirings(result);
                                    }
                                    report = this.reportBuilder.build(result, re);
                                    if (!ModuleResolver.this.DEBUG_REPORT || (resources = report.getEntries().keySet()).isEmpty()) break block28;
                                    Debug.println("RESOLVER: Resolution report");
                                    ** for (resource : report.getEntries().keySet())
                                }
                            }
                            catch (Throwable var7_22) {
                                this.computeUnresolvedProviderResolutionReportEntries(result);
                                this.computeUsesConstraintViolations(logger.getUsesConstraintViolations());
                                if (ModuleResolver.this.DEBUG_WIRING) {
                                    this.printWirings(result);
                                }
                                report = this.reportBuilder.build(result, re);
                                if (!ModuleResolver.this.DEBUG_REPORT || (resources = report.getEntries().keySet()).isEmpty()) break block29;
                                Debug.println("RESOLVER: Resolution report");
                                ** for (resource : report.getEntries().keySet())
                            }
lbl-1000:
                            // 1 sources

                            {
                                Debug.println(report.getResolutionReportMessage(resource));
                                continue;
                            }
                        }
                        if (this.hook instanceof ResolutionReport.Listener) {
                            ((ResolutionReport.Listener)this.hook).handleResolutionReport(report);
                        }
                        this.hook.end();
                        break block30;
lbl-1000:
                        // 1 sources

                        {
                            Debug.println(report.getResolutionReportMessage(resource));
                            continue;
                        }
                    }
                    if (this.hook instanceof ResolutionReport.Listener) {
                        ((ResolutionReport.Listener)this.hook).handleResolutionReport(report);
                    }
                    this.hook.end();
                    throw var7_22;
                }
                this.computeUnresolvedProviderResolutionReportEntries(result);
                this.computeUsesConstraintViolations(logger.getUsesConstraintViolations());
                if (ModuleResolver.this.DEBUG_WIRING) {
                    this.printWirings(result);
                }
                report = this.reportBuilder.build(result, re);
                if (ModuleResolver.this.DEBUG_REPORT && !(resources = report.getEntries().keySet()).isEmpty()) {
                    Debug.println("RESOLVER: Resolution report");
                    for (Resource resource : report.getEntries().keySet()) {
                        Debug.println(report.getResolutionReportMessage(resource));
                    }
                }
                if (this.hook instanceof ResolutionReport.Listener) {
                    ((ResolutionReport.Listener)this.hook).handleResolutionReport(report);
                }
                this.hook.end();
            }
            var12_6 = report;
            return var12_6;
            finally {
                ModuleResolver.this.threadResolving.set(Boolean.FALSE);
            }
        }

        private void printWirings(Map<Resource, List<Wire>> wires) {
            StringBuilder builder = new StringBuilder("RESOLVER: Wirings for resolved bundles:");
            if (wires == null) {
                Debug.println(" null wires!");
                return;
            }
            for (Map.Entry<Resource, List<Wire>> entry : wires.entrySet()) {
                builder.append(SEPARATOR).append('\t').append("Resource").append(SEPARATOR).append('\t').append('\t').append(entry.getKey()).append(SEPARATOR).append('\t').append("Wiring");
                int i = 0;
                for (Wire wire : entry.getValue()) {
                    builder.append(SEPARATOR).append('\t').append('\t').append('[').append(++i).append("] ").append(wire);
                }
            }
            Debug.println(builder);
        }

        private void resolveRevisionsInBatch(Collection<ModuleRevision> revisions, boolean isMandatory, ResolveLogger logger, Map<Resource, List<Wire>> result) throws ResolutionException {
            long startTime = System.currentTimeMillis();
            long initialFreeMemory = Runtime.getRuntime().freeMemory();
            long maxUsedMemory = 0L;
            revisions = new LinkedList<ModuleRevision>(revisions);
            ArrayList<Resource> toResolve = new ArrayList<Resource>();
            Iterator<ModuleRevision> iResources = revisions.iterator();
            while (iResources.hasNext()) {
                ModuleRevision single = iResources.next();
                iResources.remove();
                if (!this.wirings.containsKey(single) && !this.failedToResolve.contains(single)) {
                    toResolve.add(single);
                }
                if (toResolve.size() == ModuleResolver.this.resolverRevisionBatchSize || !iResources.hasNext()) {
                    if (ModuleResolver.this.DEBUG_ROOTS) {
                        Debug.println("Resolver: resolving " + toResolve.size() + " in batch.");
                        for (Resource root : toResolve) {
                            Debug.println("    Resolving root bundle: " + root);
                        }
                    }
                    this.resolveRevisions(toResolve, isMandatory, logger, result);
                    toResolve.clear();
                }
                maxUsedMemory = Math.max(maxUsedMemory, Runtime.getRuntime().freeMemory() - initialFreeMemory);
            }
            if (ModuleResolver.this.DEBUG_ROOTS) {
                Debug.println("Resolver: resolve batch size:  " + ModuleResolver.this.resolverRevisionBatchSize);
                Debug.println("Resolver: time to resolve:  " + (System.currentTimeMillis() - startTime) + "ms");
                Debug.println("Resolver: max used memory: " + maxUsedMemory / 0x100000L + "Mo");
            }
        }

        private void resolveRevisions(List<Resource> revisions, boolean isMandatory, ResolveLogger logger, Map<Resource, List<Wire>> result) throws ResolutionException {
            this.currentlyResolving = revisions;
            this.currentlyResolvingMandatory = isMandatory;
            this.transitivelyResolveFailures.clear();
            Map<Resource, List<Wire>> interimResults = null;
            try {
                this.transitivelyResolveFailures.addAll(revisions);
                interimResults = new ResolverImpl(logger).resolve(this);
                this.applyInterimResultToWiringCopy(interimResults);
                if (ModuleResolver.this.DEBUG_ROOTS) {
                    Debug.println("Resolver: resolved " + interimResults.size() + " bundles.");
                }
                for (Map.Entry<Resource, List<Wire>> interimResultEntry : interimResults.entrySet()) {
                    List<Wire> existingWires;
                    if (ModuleResolver.this.DEBUG_ROOTS) {
                        Debug.println("    Resolved bundle: " + interimResultEntry.getKey());
                    }
                    if ((existingWires = result.get(interimResultEntry.getKey())) != null) {
                        existingWires.addAll((Collection<Wire>)interimResultEntry.getValue());
                        continue;
                    }
                    result.put(interimResultEntry.getKey(), interimResultEntry.getValue());
                }
            }
            finally {
                this.transitivelyResolveFailures.addAll(logger.getUsesConstraintViolations().keySet());
                if (interimResults != null) {
                    this.transitivelyResolveFailures.removeAll(interimResults.keySet());
                }
                this.failedToResolve.addAll(this.transitivelyResolveFailures);
                this.currentlyResolving = null;
                this.currentlyResolvingMandatory = false;
            }
        }

        private void applyInterimResultToWiringCopy(Map<Resource, List<Wire>> interimResult) {
            if (!interimResult.isEmpty()) {
                Map<ModuleRevision, ModuleWiring> updatedWirings = ModuleResolver.this.generateDelta(interimResult, this.wirings);
                for (Map.Entry<ModuleRevision, ModuleWiring> updatedWiring : updatedWirings.entrySet()) {
                    this.wirings.put(updatedWiring.getKey(), updatedWiring.getValue());
                }
            }
        }

        private void computeUsesConstraintViolations(Map<Resource, ResolutionException> usesConstraintViolations) {
            for (Map.Entry<Resource, ResolutionException> usesConstraintViolation : usesConstraintViolations.entrySet()) {
                this.reportBuilder.addEntry(usesConstraintViolation.getKey(), ResolutionReport.Entry.Type.USES_CONSTRAINT_VIOLATION, usesConstraintViolation.getValue());
            }
        }

        private void computeUnresolvedProviderResolutionReportEntries(Map<Resource, List<Wire>> resolution) {
            ArrayList<ModuleRevision> shouldHaveResolvedResources = new ArrayList<ModuleRevision>(this.unresolved);
            shouldHaveResolvedResources.removeAll(this.disabled);
            if (resolution != null) {
                shouldHaveResolvedResources.removeAll(resolution.keySet());
            }
            for (Resource resource : shouldHaveResolvedResources) {
                Map<Requirement, Set<Capability>> requirementToCapabilities = this.unresolvedProviders.get(resource);
                if (requirementToCapabilities == null) continue;
                if (resolution != null) {
                    Iterator<Set<Capability>> values = requirementToCapabilities.values().iterator();
                    while (values.hasNext()) {
                        Set<Capability> value = values.next();
                        Iterator<Capability> capabilities = value.iterator();
                        while (capabilities.hasNext()) {
                            if (!resolution.containsKey(capabilities.next().getResource())) continue;
                            capabilities.remove();
                        }
                        if (!value.isEmpty()) continue;
                        values.remove();
                    }
                }
                if (requirementToCapabilities.isEmpty()) continue;
                this.reportBuilder.addEntry(resource, ResolutionReport.Entry.Type.UNRESOLVED_PROVIDER, requirementToCapabilities);
            }
        }

        private void computeUnresolvedProviders(Requirement requirement, Collection<? extends Capability> capabilities) {
            Set<Capability> value;
            Resource requirer = requirement.getResource();
            Map<Requirement, Set<Capability>> requirementToCapabilities = this.unresolvedProviders.get(requirer);
            if (requirementToCapabilities == null) {
                requirementToCapabilities = new HashMap<Requirement, Set<Capability>>();
                this.unresolvedProviders.put(requirer, requirementToCapabilities);
            }
            if ((value = requirementToCapabilities.get(requirement)) == null) {
                value = new HashSet<Capability>(capabilities.size());
                requirementToCapabilities.put(requirement, value);
            }
            for (Capability capability : capabilities) {
                if (this.wirings.containsKey(capability.getResource())) continue;
                value.add(capability);
            }
        }

        private Map<Resource, List<Wire>> resolveNonPayLoadFragments() {
            ArrayList<ModuleRevision> nonPayLoadFrags = new ArrayList<ModuleRevision>();
            if (this.triggersMandatory) {
                for (ModuleRevision moduleRevision : this.triggers) {
                    if (!this.nonPayLoad(moduleRevision)) continue;
                    nonPayLoadFrags.add(moduleRevision);
                }
            }
            for (ModuleRevision moduleRevision : this.optionals) {
                if (!this.nonPayLoad(moduleRevision)) continue;
                nonPayLoadFrags.add(moduleRevision);
            }
            if (nonPayLoadFrags.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<Resource, List<Wire>> dynamicAttachment = new HashMap<Resource, List<Wire>>(0);
            for (ModuleRevision nonPayLoad : nonPayLoadFrags) {
                ArrayList allNonPayloadWires = new ArrayList(0);
                for (ModuleRequirement requirement : nonPayLoad.getModuleRequirements(null)) {
                    List<ModuleCapability> matching = this.moduleDatabase.findCapabilities(requirement);
                    ArrayList<ModuleWire> newWires = new ArrayList<ModuleWire>(0);
                    this.filterProviders(requirement, matching, false);
                    for (ModuleCapability candidate : matching) {
                        if ("osgi.wiring.host".equals(requirement.getNamespace())) {
                            boolean attachAlways;
                            String attachDirective = candidate.getDirectives().get("fragment-attachment");
                            boolean bl = attachAlways = attachDirective == null || "always".equals(attachDirective);
                            if (!attachAlways || this.wirings.get(candidate.getRevision()) == null) continue;
                        }
                        if (!newWires.isEmpty() && !"multiple".equals(requirement.getDirectives().get("cardinality"))) continue;
                        newWires.add(new ModuleWire(candidate, candidate.getRevision(), requirement, nonPayLoad));
                    }
                    if (newWires.isEmpty()) {
                        if ("optional".equals(requirement.getDirectives().get("resolution"))) continue;
                        allNonPayloadWires.clear();
                        break;
                    }
                    allNonPayloadWires.addAll(newWires);
                }
                if (allNonPayloadWires.isEmpty()) continue;
                dynamicAttachment.put(nonPayLoad, allNonPayloadWires);
            }
            return dynamicAttachment;
        }

        private boolean nonPayLoad(ModuleRevision moduleRevision) {
            if ((moduleRevision.getTypes() & 1) == 0) {
                return false;
            }
            for (Requirement req : moduleRevision.getRequirements(null)) {
                if (NON_PAYLOAD_REQUIREMENTS.contains(req.getNamespace())) continue;
                return false;
            }
            return true;
        }

        private Map<Resource, List<Wire>> resolveDynamic() throws ResolutionException {
            List<Capability> dynamicMatches = this.findProviders0(this.dynamicReq.getOriginal(), this.dynamicReq);
            return new ResolverImpl(new Logger(0)).resolve(this, this.dynamicReq.getRevision(), this.dynamicReq.getOriginal(), dynamicMatches);
        }

        private void filterResolvable() {
            ArrayList<ModuleRevision> enabledCandidates = new ArrayList<ModuleRevision>(this.unresolved);
            this.hook.filterResolvable(InternalUtils.asListBundleRevision((List<? extends BundleRevision>)enabledCandidates));
            this.disabled.removeAll(enabledCandidates);
            for (ModuleRevision revision : this.disabled) {
                this.reportBuilder.addEntry(revision, ResolutionReport.Entry.Type.FILTERED_BY_RESOLVER_HOOK, null);
                if (!ModuleResolver.this.DEBUG_HOOKS) continue;
                Debug.println("RESOLVER: Resource filtered by ResolverHook.filterResolvable: " + revision);
            }
        }

        private void selectSingletons() {
            HashMap selectedSingletons = new HashMap();
            for (ModuleRevision revision : this.unresolved) {
                String bsn;
                ArrayList<ModuleRevision> selected;
                if (!ModuleResolver.isSingleton(revision) || this.disabled.contains(revision) || (selected = (ArrayList<ModuleRevision>)selectedSingletons.get(bsn = revision.getSymbolicName())) != null) continue;
                selected = new ArrayList<ModuleRevision>(1);
                selectedSingletons.put(bsn, selected);
                Collection<ModuleRevision> sameBSN = this.getRevisions(bsn);
                if (sameBSN.size() < 2) {
                    selected.add(revision);
                    continue;
                }
                for (ModuleRevision singleton : sameBSN) {
                    if (!ModuleResolver.isSingleton(singleton) || !this.wirings.containsKey(singleton)) continue;
                    selected.add(singleton);
                }
                Map<ModuleRevision, Collection<ModuleRevision>> collisionMap = this.getCollisionMap(sameBSN);
                for (ModuleRevision singleton : sameBSN) {
                    Collection<ModuleRevision> collisions;
                    if (selected.contains(singleton) || (collisions = collisionMap.get(singleton)) == null || this.disabled.contains(singleton)) continue;
                    ArrayList<ModuleRevision> pickOneToResolve = new ArrayList<ModuleRevision>();
                    for (ModuleRevision moduleRevision : collisions) {
                        if (selected.contains(moduleRevision)) {
                            this.disabled.add(singleton);
                            this.reportBuilder.addEntry(singleton, ResolutionReport.Entry.Type.SINGLETON_SELECTION, moduleRevision);
                            break;
                        }
                        if (pickOneToResolve.contains(moduleRevision)) continue;
                        pickOneToResolve.add(moduleRevision);
                    }
                    if (!this.disabled.contains(singleton)) {
                        for (Map.Entry entry : collisionMap.entrySet()) {
                            if (entry.getKey() == singleton || !((Collection)entry.getValue()).contains(singleton)) continue;
                            if (selected.contains(entry.getKey())) {
                                this.disabled.add(singleton);
                                this.reportBuilder.addEntry(singleton, ResolutionReport.Entry.Type.SINGLETON_SELECTION, entry.getKey());
                                break;
                            }
                            if (pickOneToResolve.contains(entry.getKey())) continue;
                            pickOneToResolve.add((ModuleRevision)entry.getKey());
                        }
                    }
                    if (this.disabled.contains(singleton)) continue;
                    pickOneToResolve.add(singleton);
                    selected.add(this.pickOneToResolve(pickOneToResolve));
                }
            }
        }

        private Collection<ModuleRevision> getRevisions(String name) {
            Collection<ModuleRevision> result;
            Map<String, Collection<ModuleRevision>> current = this.byName;
            if (current == null) {
                HashSet<ModuleRevision> revisions = new HashSet<ModuleRevision>();
                revisions.addAll(this.unresolved);
                revisions.addAll(this.previouslyResolved);
                current = new HashMap<String, Collection<ModuleRevision>>();
                for (ModuleRevision revision : revisions) {
                    Collection<ModuleRevision> sameName = current.get(revision.getSymbolicName());
                    if (sameName == null) {
                        sameName = new ArrayList<ModuleRevision>();
                        current.put(revision.getSymbolicName(), sameName);
                    }
                    sameName.add(revision);
                }
                this.byName = current;
            }
            if ((result = current.get(name)) == null) {
                return Collections.emptyList();
            }
            return result;
        }

        private ModuleRevision pickOneToResolve(Collection<ModuleRevision> pickOneToResolve) {
            ModuleRevision selectedVersion = null;
            for (ModuleRevision singleton : pickOneToResolve) {
                boolean higherVersion;
                if (selectedVersion == null) {
                    selectedVersion = singleton;
                }
                boolean bl = higherVersion = selectedVersion.getVersion().compareTo(singleton.getVersion()) < 0;
                if (!higherVersion) continue;
                selectedVersion = singleton;
            }
            for (ModuleRevision singleton : pickOneToResolve) {
                if (singleton == selectedVersion) continue;
                this.disabled.add(singleton);
                this.reportBuilder.addEntry(singleton, ResolutionReport.Entry.Type.SINGLETON_SELECTION, selectedVersion);
            }
            return selectedVersion;
        }

        private Map<ModuleRevision, Collection<ModuleRevision>> getCollisionMap(Collection<ModuleRevision> sameBSN) {
            HashMap<ModuleRevision, Collection<ModuleRevision>> result = new HashMap<ModuleRevision, Collection<ModuleRevision>>();
            for (ModuleRevision singleton : sameBSN) {
                if (!ModuleResolver.isSingleton(singleton) || this.disabled.contains(singleton)) continue;
                ArrayList<BundleCapability> capabilities = new ArrayList<BundleCapability>(sameBSN.size() - 1);
                for (ModuleRevision collision : sameBSN) {
                    if (collision == singleton || !ModuleResolver.isSingleton(collision) || this.disabled.contains(collision)) continue;
                    capabilities.add(this.getIdentity(collision));
                }
                this.hook.filterSingletonCollisions(this.getIdentity(singleton), capabilities);
                ArrayList<ModuleRevision> collisionCandidates = new ArrayList<ModuleRevision>(capabilities.size());
                for (BundleCapability identity : capabilities) {
                    collisionCandidates.add((ModuleRevision)identity.getRevision());
                }
                if (ModuleResolver.this.DEBUG_HOOKS) {
                    ArrayList<ModuleRevision> filteredSingletons = new ArrayList<ModuleRevision>(sameBSN);
                    filteredSingletons.removeAll(collisionCandidates);
                    filteredSingletons.remove(singleton);
                    if (!filteredSingletons.isEmpty()) {
                        StringBuilder builder = new StringBuilder("RESOLVER: Resources filtered by ResolverHook.filterSingletonCollisions").append(SEPARATOR).append('\t').append("Singleton").append(SEPARATOR).append('\t').append('\t').append(singleton).append(" [id=").append(singleton.getRevisions().getModule().getId()).append(", location=").append(singleton.getRevisions().getModule().getLocation()).append(']').append(SEPARATOR).append('\t').append("Collisions");
                        int i = 0;
                        for (ModuleRevision revision : filteredSingletons) {
                            builder.append(SEPARATOR).append('\t').append('\t').append("[").append(++i).append("] ").append(revision).append(" [id=").append(revision.getRevisions().getModule().getId()).append(", location=").append(revision.getRevisions().getModule().getLocation()).append(']');
                        }
                        Debug.println(builder.toString());
                    }
                }
                result.put(singleton, collisionCandidates);
            }
            return result;
        }

        private BundleCapability getIdentity(ModuleRevision bundle) {
            List<BundleCapability> identities = bundle.getDeclaredCapabilities("osgi.identity");
            return identities.isEmpty() ? null : identities.get(0);
        }

        @Override
        public int compare(Capability c1, Capability c2) {
            Long id2;
            Version v2;
            boolean resolved2;
            boolean resolved1 = this.previouslyResolved.contains(c1.getResource());
            if (resolved1 != (resolved2 = this.previouslyResolved.contains(c2.getResource()))) {
                return resolved1 ? -1 : 1;
            }
            Version v1 = ModuleResolver.getVersion(c1);
            int versionCompare = -v1.compareTo(v2 = ModuleResolver.getVersion(c2));
            if (versionCompare != 0) {
                return versionCompare;
            }
            ModuleRevision m1 = this.getModuleRevision(c1);
            ModuleRevision m2 = this.getModuleRevision(c2);
            Long id1 = m1.getRevisions().getModule().getId();
            if (id1.equals(id2 = m2.getRevisions().getModule().getId()) && !m1.equals(m2)) {
                List<ModuleRevision> revisions = m1.getRevisions().getModuleRevisions();
                int index1 = revisions.indexOf(m1);
                int index2 = revisions.indexOf(m2);
                return index2 - index1;
            }
            return id1.compareTo(id2);
        }

        ModuleRevision getModuleRevision(Capability c) {
            if (c instanceof HostedCapability) {
                c = ((HostedCapability)c).getDeclaredCapability();
            }
            if (c instanceof ModuleCapability) {
                return ((ModuleCapability)c).getRevision();
            }
            return null;
        }

        class ResolveLogger
        extends Logger {
            private Map<Resource, ResolutionException> errors;

            public ResolveLogger() {
                super(0);
                this.errors = null;
            }

            @Override
            public void logUsesConstraintViolation(Resource resource, ResolutionException error) {
                if (this.errors == null) {
                    this.errors = new HashMap<Resource, ResolutionException>();
                }
                this.errors.put(resource, error);
                if (((ResolveProcess)ResolveProcess.this).ModuleResolver.this.DEBUG_USES) {
                    Debug.println("RESOLVER: Uses constraint violation" + SEPARATOR + '\t' + "Resource" + SEPARATOR + '\t' + '\t' + resource + SEPARATOR + '\t' + "Error" + SEPARATOR + '\t' + '\t' + error.getMessage());
                }
            }

            Map<Resource, ResolutionException> getUsesConstraintViolations() {
                return this.errors == null ? Collections.emptyMap() : this.errors;
            }
        }
    }
}

