/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.builder;

import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;

class HtmlEntities {
    private static HtmlEntities instance = new HtmlEntities();
    private final ListMultimap<String, String> nameToNumericEntityReferences = HtmlEntities.readHtmlEntities();

    private static ListMultimap<String, String> readHtmlEntities() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(HtmlDocumentBuilder.class.getResourceAsStream("html-entity-references.txt"), Charsets.UTF_8));){
            String line;
            Splitter splitter = Splitter.on((CharMatcher)CharMatcher.WHITESPACE).trimResults().omitEmptyStrings();
            while ((line = reader.readLine()) != null) {
                List lineItems = splitter.splitToList((CharSequence)line);
                Preconditions.checkState((lineItems.size() > 1 ? 1 : 0) != 0);
                int x = 1;
                while (x < lineItems.size()) {
                    builder.put((Object)((String)lineItems.get(0)), (Object)((String)lineItems.get(x)));
                    ++x;
                }
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return builder.build();
    }

    public static HtmlEntities instance() {
        return instance;
    }

    private HtmlEntities() {
    }

    public List<String> nameToEntityReferences(String name) {
        return this.nameToNumericEntityReferences.get((Object)name);
    }
}

