/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.actions;

import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.actions.DsfCommandRunnable;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.debug.core.commands.IRestartHandler;

public class GdbRestartCommand
implements IRestartHandler {
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;
    private final ILaunch fLaunch;

    public GdbRestartCommand(DsfSession session, ILaunch launch) {
        this.fExecutor = session.getExecutor();
        this.fLaunch = launch;
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    public void canExecute(final IEnabledStateRequest request) {
        if (request.getElements().length != 1) {
            request.setEnabled(false);
            request.done();
            return;
        }
        this.fExecutor.submit((Runnable)new DsfCommandRunnable(this.fTracker, request.getElements()[0], (IDebugCommandRequest)request){

            public void doExecute() {
                IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)this.getContext(), IRunControl.IContainerDMContext.class);
                IGDBProcesses procService = (IGDBProcesses)GdbRestartCommand.this.fTracker.getService(IGDBProcesses.class);
                if (procService != null) {
                    procService.canRestart(containerDmc, (DataRequestMonitor)new DataRequestMonitor<Boolean>((Executor)GdbRestartCommand.this.fExecutor, null){

                        protected void handleCompleted() {
                            request.setEnabled(this.isSuccess() && (Boolean)this.getData() != false);
                            request.done();
                        }
                    });
                } else {
                    request.setEnabled(false);
                    request.done();
                }
            }
        });
    }

    public boolean execute(final IDebugCommandRequest request) {
        if (request.getElements().length != 1) {
            request.done();
            return false;
        }
        Object element = request.getElements()[0];
        if (!(element instanceof IDMVMContext)) {
            request.done();
            return false;
        }
        final IRunControl.IContainerDMContext containerDmc = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)((IDMVMContext)element).getDMContext(), IRunControl.IContainerDMContext.class);
        this.fExecutor.submit((Runnable)new DsfRunnable(){

            public void run() {
                IGDBProcesses procService = (IGDBProcesses)GdbRestartCommand.this.fTracker.getService(IGDBProcesses.class);
                if (procService != null) {
                    Map attributes = null;
                    try {
                        attributes = GdbRestartCommand.this.fLaunch.getLaunchConfiguration().getAttributes();
                    }
                    catch (CoreException coreException) {}
                    procService.restart(containerDmc, attributes, (DataRequestMonitor)new DataRequestMonitor<IRunControl.IContainerDMContext>((Executor)GdbRestartCommand.this.fExecutor, null){

                        protected void handleCompleted() {
                            request.done();
                        }
                    });
                } else {
                    request.done();
                }
            }
        });
        return false;
    }
}

