/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.debug.core.model.IConnectHandler;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.actions.IConnect;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.actions.ProcessInfo;
import org.eclipse.cdt.dsf.gdb.internal.ui.commands.RefreshableDebugCommand;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.LaunchUIMessages;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.NewExecutableInfo;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.ProcessPrompter;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.IProcessExtendedInfo;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class GdbConnectCommand
extends RefreshableDebugCommand
implements IConnectHandler,
IConnect {
    private final ILaunch fLaunch;
    private final DsfExecutor fExecutor;
    private final DsfServicesTracker fTracker;
    private Map<String, String> fProcessNameToBinaryMap = new HashMap<String, String>();

    public GdbConnectCommand(DsfSession session, ILaunch launch) {
        this.fLaunch = launch;
        this.fExecutor = session.getExecutor();
        this.fTracker = new DsfServicesTracker(GdbUIPlugin.getBundleContext(), session.getId());
    }

    public void dispose() {
        this.fTracker.dispose();
    }

    protected boolean isExecutable(Object[] targets, IProgressMonitor monitor, IEnabledStateRequest request) throws CoreException {
        return this.canConnect();
    }

    public boolean canConnect() {
        Query<Boolean> canConnectQuery = new Query<Boolean>(){

            public void execute(DataRequestMonitor<Boolean> rm) {
                IProcesses procService = (IProcesses)GdbConnectCommand.this.fTracker.getService(IProcesses.class);
                ICommandControlService commandControl = (ICommandControlService)GdbConnectCommand.this.fTracker.getService(ICommandControlService.class);
                if (procService != null && commandControl != null) {
                    procService.isDebuggerAttachSupported((IDMContext)commandControl.getContext(), rm);
                } else {
                    rm.setData((Object)false);
                    rm.done();
                }
            }
        };
        try {
            this.fExecutor.execute((Runnable)canConnectQuery);
            return (Boolean)canConnectQuery.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException executionException) {
        }
        catch (RejectedExecutionException rejectedExecutionException) {}
        return false;
    }

    /*
     * Exception decompiling
     */
    protected void doExecute(Object[] targets, IProgressMonitor monitor, IRequest request) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void connect(final RequestMonitor rm) {
        this.fExecutor.execute((Runnable)new DsfRunnable(){

            public void run() {
                final IProcesses procService = (IProcesses)GdbConnectCommand.this.fTracker.getService(IProcesses.class);
                ICommandControlService commandControl = (ICommandControlService)GdbConnectCommand.this.fTracker.getService(ICommandControlService.class);
                IGDBBackend backend = (IGDBBackend)GdbConnectCommand.this.fTracker.getService(IGDBBackend.class);
                if (procService != null && commandControl != null && backend != null) {
                    final ICommandControlService.ICommandControlDMContext controlCtx = commandControl.getContext();
                    final boolean remote = backend.getSessionType() == SessionType.REMOTE;
                    procService.isDebugNewProcessSupported((IDMContext)controlCtx, (DataRequestMonitor)new DataRequestMonitor<Boolean>((Executor)GdbConnectCommand.this.fExecutor, rm){

                        protected void handleCompleted() {
                            final boolean newProcessSupported = this.isSuccess() && (Boolean)this.getData() != false;
                            procService.getRunningProcesses((IDMContext)controlCtx, (DataRequestMonitor)new DataRequestMonitor<IProcesses.IProcessDMContext[]>((Executor)GdbConnectCommand.this.fExecutor, rm){

                                protected void handleSuccess() {
                                    final ArrayList<ProcessInfo> procInfoList = new ArrayList<ProcessInfo>();
                                    final CountingRequestMonitor countingRm = new CountingRequestMonitor((Executor)GdbConnectCommand.this.fExecutor, rm){

                                        protected void handleSuccess() {
                                            new PromptForPidJob(LaunchUIMessages.getString("ProcessPrompter.PromptJob"), newProcessSupported, remote, procInfoList.toArray(new IProcessExtendedInfo[procInfoList.size()]), new DataRequestMonitor<Object>((Executor)GdbConnectCommand.this.fExecutor, rm){

                                                protected void handleCancel() {
                                                    rm.cancel();
                                                    rm.done();
                                                }

                                                protected void handleSuccess() {
                                                    Object data = this.getData();
                                                    if (data instanceof NewExecutableInfo) {
                                                        GdbConnectCommand.this.startNewProcess(controlCtx, (NewExecutableInfo)data, rm);
                                                    } else if (data instanceof IProcessExtendedInfo[]) {
                                                        GdbConnectCommand.this.attachToProcesses(controlCtx, (IProcessExtendedInfo[])data, rm);
                                                    } else {
                                                        rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10005, "Invalid return type for process prompter", null));
                                                    }
                                                }
                                            }).schedule();
                                        }
                                    };
                                    if (((IProcesses.IProcessDMContext[])this.getData()).length > 0 && ((IProcesses.IProcessDMContext[])this.getData())[0] instanceof IProcesses.IThreadDMData) {
                                        IProcesses.IProcessDMContext[] iProcessDMContextArray = (IProcesses.IProcessDMContext[])this.getData();
                                        int n = iProcessDMContextArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            IProcesses.IProcessDMContext processCtx = iProcessDMContextArray[n2];
                                            IProcesses.IThreadDMData processData = (IProcesses.IThreadDMData)processCtx;
                                            int pid = 0;
                                            try {
                                                pid = Integer.parseInt(processData.getId());
                                            }
                                            catch (NumberFormatException numberFormatException) {}
                                            String[] cores = null;
                                            String owner = null;
                                            if (processData instanceof IGDBProcesses.IGdbThreadDMData) {
                                                cores = ((IGDBProcesses.IGdbThreadDMData)processData).getCores();
                                                owner = ((IGDBProcesses.IGdbThreadDMData)processData).getOwner();
                                            }
                                            procInfoList.add(new ProcessInfo(pid, processData.getName(), cores, owner));
                                            ++n2;
                                        }
                                        countingRm.setDoneCount(0);
                                    } else {
                                        IProcesses procService = (IProcesses)GdbConnectCommand.this.fTracker.getService(IProcesses.class);
                                        if (procService != null) {
                                            countingRm.setDoneCount(((IProcesses.IProcessDMContext[])this.getData()).length);
                                            IProcesses.IProcessDMContext[] iProcessDMContextArray = (IProcesses.IProcessDMContext[])this.getData();
                                            int n = iProcessDMContextArray.length;
                                            int n3 = 0;
                                            while (n3 < n) {
                                                IProcesses.IProcessDMContext processCtx = iProcessDMContextArray[n3];
                                                procService.getExecutionData((IProcesses.IThreadDMContext)processCtx, (DataRequestMonitor)new DataRequestMonitor<IProcesses.IThreadDMData>((Executor)GdbConnectCommand.this.fExecutor, (RequestMonitor)countingRm){

                                                    protected void handleSuccess() {
                                                        IProcesses.IThreadDMData processData = (IProcesses.IThreadDMData)this.getData();
                                                        int pid = 0;
                                                        try {
                                                            pid = Integer.parseInt(processData.getId());
                                                        }
                                                        catch (NumberFormatException numberFormatException) {}
                                                        String[] cores = null;
                                                        String owner = null;
                                                        if (processData instanceof IGDBProcesses.IGdbThreadDMData) {
                                                            cores = ((IGDBProcesses.IGdbThreadDMData)processData).getCores();
                                                            owner = ((IGDBProcesses.IGdbThreadDMData)processData).getOwner();
                                                        }
                                                        procInfoList.add(new ProcessInfo(pid, processData.getName(), cores, owner));
                                                        countingRm.done();
                                                    }
                                                });
                                                ++n3;
                                            }
                                        } else {
                                            countingRm.setDoneCount(0);
                                        }
                                    }
                                }
                            });
                        }
                    });
                } else {
                    rm.done();
                }
            }
        });
    }

    private void startNewProcess(ICommandControlService.ICommandControlDMContext controlDmc, NewExecutableInfo info, RequestMonitor rm) {
        IGDBProcesses procService = (IGDBProcesses)this.fTracker.getService(IGDBProcesses.class);
        try {
            Map attributes = this.fLaunch.getLaunchConfiguration().getAttributes();
            attributes.put("org.eclipse.cdt.dsf.gdb.REMOTE_BINARY", info.getTargetPath());
            attributes.put("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", info.getArguments());
            procService.debugNewProcess((IDMContext)controlDmc, info.getHostPath(), attributes, new DataRequestMonitor((Executor)this.fExecutor, rm));
        }
        catch (CoreException e) {
            rm.setStatus(e.getStatus());
            rm.done();
        }
    }

    private void attachToProcesses(ICommandControlService.ICommandControlDMContext controlDmc, IProcessExtendedInfo[] processes, RequestMonitor rm) {
        IGDBProcesses procService = (IGDBProcesses)this.fTracker.getService(IGDBProcesses.class);
        IGDBBackend backend = (IGDBBackend)this.fTracker.getService(IGDBBackend.class);
        if (procService != null && backend != null) {
            ArrayList<IProcessExtendedInfo> procList = new ArrayList<IProcessExtendedInfo>(Arrays.asList(processes));
            class AttachToProcessRequestMonitor
            extends ImmediateDataRequestMonitor<IDMContext> {
                private final /* synthetic */ List val$procList;
                private final /* synthetic */ IGDBProcesses val$procService;
                private final /* synthetic */ ICommandControlService.ICommandControlDMContext val$controlDmc;
                private final /* synthetic */ RequestMonitor val$rm;
                private final /* synthetic */ IGDBBackend val$backend;

                public AttachToProcessRequestMonitor(List list, IGDBProcesses iGDBProcesses, ICommandControlService.ICommandControlDMContext iCommandControlDMContext, RequestMonitor requestMonitor, IGDBBackend iGDBBackend) {
                    this.val$procList = list;
                    this.val$procService = iGDBProcesses;
                    this.val$controlDmc = iCommandControlDMContext;
                    this.val$rm = requestMonitor;
                    this.val$backend = iGDBBackend;
                }

                protected void handleCompleted() {
                    this.isSuccess();
                    if (!this.val$procList.isEmpty()) {
                        this.val$procService.isDebuggerAttachSupported((IDMContext)this.val$controlDmc, (DataRequestMonitor)new ImmediateDataRequestMonitor<Boolean>(){

                            protected void handleCompleted() {
                                if (this.isSuccess() && ((Boolean)this.getData()).booleanValue()) {
                                    IProcessExtendedInfo process = (IProcessExtendedInfo)val$procList.remove(0);
                                    String pidStr = Integer.toString(process.getPid());
                                    if (val$backend.getSessionType() == SessionType.REMOTE) {
                                        IPath binaryPath;
                                        if (GdbConnectCommand.this.fProcessNameToBinaryMap.isEmpty() && (binaryPath = val$backend.getProgramPath()) != null && !binaryPath.isEmpty()) {
                                            GdbConnectCommand.this.fProcessNameToBinaryMap.put(binaryPath.lastSegment(), binaryPath.toOSString());
                                        }
                                        Path processPath = new Path(process.getName());
                                        String processShortName = processPath.lastSegment();
                                        new PromptAndAttachToProcessJob(pidStr, String.valueOf(LaunchUIMessages.getString("ProcessPrompterDialog.TitlePrefix")) + process.getName(), processShortName, (RequestMonitor)new AttachToProcessRequestMonitor(val$procList, val$procService, val$controlDmc, val$rm, val$backend)).schedule();
                                    } else {
                                        IProcesses.IProcessDMContext procDmc = val$procService.createProcessContext(val$controlDmc, pidStr);
                                        val$procService.attachDebuggerToProcess(procDmc, null, (DataRequestMonitor)new AttachToProcessRequestMonitor(val$procList, val$procService, val$controlDmc, val$rm, val$backend));
                                    }
                                } else {
                                    val$rm.done();
                                }
                            }
                        });
                    } else {
                        this.val$rm.done();
                    }
                }
            }
            new AttachToProcessRequestMonitor(procList, procService, controlDmc, rm, backend).done();
        } else {
            rm.done((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10005, "Cannot find service", null));
        }
    }

    protected Object getTarget(Object element) {
        if (element instanceof GdbLaunch || element instanceof IDMVMContext) {
            return element;
        }
        return null;
    }

    protected boolean isRemainEnabled(IDebugCommandRequest request) {
        return false;
    }

    private class PromptAndAttachToProcessJob
    extends UIJob {
        private final String fPid;
        private final RequestMonitor fRm;
        private final String fTitle;
        private final String fProcName;

        public PromptAndAttachToProcessJob(String pid, String title, String procName, RequestMonitor rm) {
            super("");
            this.fPid = pid;
            this.fTitle = title;
            this.fProcName = procName;
            this.fRm = rm;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Shell shell;
            String binaryPath = (String)GdbConnectCommand.this.fProcessNameToBinaryMap.get(this.fProcName);
            if (binaryPath == null && (shell = Display.getCurrent().getActiveShell()) != null) {
                FileDialog fd = new FileDialog(shell, 0);
                fd.setText(this.fTitle);
                binaryPath = fd.open();
            }
            if (binaryPath == null) {
                this.fRm.done();
            } else {
                final String finalBinaryPath = binaryPath;
                GdbConnectCommand.this.fExecutor.execute((Runnable)new DsfRunnable(){

                    public void run() {
                        IGDBProcesses procService = (IGDBProcesses)GdbConnectCommand.this.fTracker.getService(IGDBProcesses.class);
                        ICommandControlService commandControl = (ICommandControlService)GdbConnectCommand.this.fTracker.getService(ICommandControlService.class);
                        if (procService != null && commandControl != null) {
                            IProcesses.IProcessDMContext procDmc = procService.createProcessContext(commandControl.getContext(), PromptAndAttachToProcessJob.this.fPid);
                            procService.attachDebuggerToProcess(procDmc, finalBinaryPath, (DataRequestMonitor)new DataRequestMonitor<IDMContext>((Executor)GdbConnectCommand.this.fExecutor, PromptAndAttachToProcessJob.this.fRm){

                                protected void handleSuccess() {
                                    if (PromptAndAttachToProcessJob.this.fProcName != null && !PromptAndAttachToProcessJob.this.fProcName.isEmpty()) {
                                        GdbConnectCommand.this.fProcessNameToBinaryMap.put(PromptAndAttachToProcessJob.this.fProcName, finalBinaryPath);
                                    }
                                    PromptAndAttachToProcessJob.this.fRm.done();
                                }
                            });
                        } else {
                            PromptAndAttachToProcessJob.this.fRm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb.ui", 10005, "Cannot find services", null));
                            PromptAndAttachToProcessJob.this.fRm.done();
                        }
                    }
                });
            }
            return Status.OK_STATUS;
        }
    }

    protected class PromptForPidJob
    extends UIJob {
        IProcessExtendedInfo[] fProcessList;
        DataRequestMonitor<Object> fRequestMonitor;
        boolean fNewProcessSupported;
        boolean fRemote;

        public PromptForPidJob(String name, boolean newProcessSupported, boolean remote, IProcessExtendedInfo[] procs, DataRequestMonitor<Object> rm) {
            super(name);
            this.fProcessList = null;
            this.fNewProcessSupported = newProcessSupported;
            this.fRemote = remote;
            this.fProcessList = procs;
            this.fRequestMonitor = rm;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            Status NO_PID_STATUS = new Status(4, "org.eclipse.cdt.dsf.gdb.ui", -1, LaunchMessages.getString((String)"LocalAttachLaunchDelegate.No_Process_ID_selected"), null);
            try {
                ProcessPrompter.PrompterInfo info = new ProcessPrompter.PrompterInfo(this.fNewProcessSupported, this.fRemote, this.fProcessList);
                Object result = new ProcessPrompter().handleStatus(null, info);
                if (result == null) {
                    this.fRequestMonitor.cancel();
                } else if (result instanceof IProcessExtendedInfo[] || result instanceof NewExecutableInfo) {
                    this.fRequestMonitor.setData(result);
                } else if (result instanceof Integer) {
                    this.fRequestMonitor.setData((Object)new IProcessExtendedInfo[]{new ProcessInfo((Integer)result, "")});
                } else {
                    this.fRequestMonitor.setStatus((IStatus)NO_PID_STATUS);
                }
            }
            catch (CoreException coreException) {
                this.fRequestMonitor.setStatus((IStatus)NO_PID_STATUS);
            }
            this.fRequestMonitor.done();
            return Status.OK_STATUS;
        }
    }
}

