/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.jaxb.control.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ptp.internal.rm.jaxb.control.core.JAXBControlCorePlugin;
import org.eclipse.ptp.internal.rm.jaxb.control.core.messages.Messages;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteProcessService;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class RemoteServicesDelegate {
    private static final String COSP = ": ";
    private static final int UNDEFINED = -1;
    private static final int COPY_BUFFER_SIZE = 65536;
    private final String remoteConnectionTypeId;
    private final String remoteConnectionName;
    private IRemoteConnectionType remoteConnectionType;
    private IRemoteConnectionType localConnectionType;
    private IRemoteConnection remoteConnection;
    private IRemoteConnection localConnection;
    private static Map<String, RemoteServicesDelegate> fDelegates = Collections.synchronizedMap(new HashMap());

    public static void copy(IRemoteFileService from, String source, IRemoteFileService to, String target, int mkParent, IProgressMonitor progress) throws CoreException {
        if (from == null) {
            throw RemoteServicesDelegate.newException(Messages.RemoteServicesDelegate_Copy_Operation_NullSourceFileManager, null);
        }
        if (to == null) {
            throw RemoteServicesDelegate.newException(Messages.RemoteServicesDelegate_Copy_Operation_NullTargetFileManager, null);
        }
        if (source == null) {
            throw RemoteServicesDelegate.newException(Messages.RemoteServicesDelegate_Copy_Operation_NullSource, null);
        }
        if (target == null) {
            throw RemoteServicesDelegate.newException(Messages.RemoteServicesDelegate_Copy_Operation_NullTarget, null);
        }
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress, (int)15);
        IFileStore lres = from.getResource(source);
        if (!lres.fetchInfo(0, (IProgressMonitor)subProgress.newChild(5)).exists()) {
            throw RemoteServicesDelegate.newException(String.valueOf(Messages.RemoteServicesDelegate_Copy_Operation_Local_resource_does_not_exist) + COSP + lres.getName(), null);
        }
        if (mkParent != -1) {
            to.getResource(target).getParent().mkdir(mkParent, (IProgressMonitor)subProgress.newChild(5));
        }
        if (subProgress.isCanceled()) {
            return;
        }
        IFileStore rres = to.getResource(target);
        lres.copy(rres, 2, (IProgressMonitor)subProgress.newChild(5));
    }

    private static IStatus getErrorStatus(String message, Throwable t) {
        if (t != null) {
            JAXBControlCorePlugin.log(t);
        }
        return new Status(4, JAXBControlCorePlugin.getUniqueIdentifier(), 4, message, t);
    }

    public static boolean isStable(IRemoteFileService fileSvc, String path, int intervalInSecs, IProgressMonitor progress) throws CoreException {
        if (fileSvc == null) {
            throw RemoteServicesDelegate.newException(Messages.RemoteServicesDelegate_Read_Operation_NullSourceFileManager, null);
        }
        if (path == null) {
            throw RemoteServicesDelegate.newException(Messages.RemoteServicesDelegate_Read_Operation_NullPath, null);
        }
        IFileStore lres = fileSvc.getResource(path);
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress, (int)10);
        IFileInfo info = lres.fetchInfo(0, (IProgressMonitor)subProgress.newChild(5));
        if (subProgress.isCanceled()) {
            return false;
        }
        if (!info.exists()) {
            return false;
        }
        long l0 = info.getLength();
        try {
            Thread.sleep(1000 * intervalInSecs);
        }
        catch (InterruptedException interruptedException) {}
        info = lres.fetchInfo(0, (IProgressMonitor)subProgress.newChild(5));
        if (subProgress.isCanceled()) {
            return false;
        }
        long l1 = info.getLength();
        return l0 == l1;
    }

    private static CoreException newException(String message, Throwable t) {
        return new CoreException(RemoteServicesDelegate.getErrorStatus(message, t));
    }

    public static String read(IRemoteFileService fileSvc, String path, IProgressMonitor progress) throws CoreException {
        SubMonitor subProgress;
        if (fileSvc == null) {
            throw RemoteServicesDelegate.newException(Messages.RemoteServicesDelegate_Read_Operation_NullSourceFileManager, null);
        }
        if (path == null) {
            throw RemoteServicesDelegate.newException(Messages.RemoteServicesDelegate_Read_Operation_NullPath, null);
        }
        IFileStore lres = fileSvc.getResource(path);
        if (!lres.fetchInfo(0, (IProgressMonitor)(subProgress = SubMonitor.convert((IProgressMonitor)progress, (int)100)).newChild(5)).exists()) {
            throw RemoteServicesDelegate.newException(String.valueOf(Messages.RemoteServicesDelegate_Read_Operation_resource_does_not_exist) + COSP + lres.getName(), null);
        }
        BufferedInputStream is = new BufferedInputStream(lres.openInputStream(0, progress));
        StringBuffer sb = new StringBuffer();
        byte[] buffer = new byte[65536];
        int rcvd = 0;
        try {
            try {
                do {
                    try {
                        rcvd = is.read(buffer, 0, 65536);
                    }
                    catch (EOFException eOFException) {
                        break;
                    }
                    if (rcvd == -1) {
                        break;
                    }
                    sb.append(new String(buffer, 0, rcvd));
                } while (!subProgress.isCanceled());
            }
            catch (IOException iOException) {
                throw RemoteServicesDelegate.newException(String.valueOf(Messages.RemoteServicesDelegate_Read_OperationFailed) + path, null);
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {
                JAXBControlCorePlugin.log(ioe);
            }
        }
        return sb.toString();
    }

    public static void write(IRemoteFileService fileSvc, String path, String contents, IProgressMonitor progress) throws CoreException {
        if (contents == null) {
            return;
        }
        if (fileSvc == null) {
            throw RemoteServicesDelegate.newException(Messages.RemoteServicesDelegate_Write_Operation_NullSourceFileManager, null);
        }
        if (path == null) {
            throw RemoteServicesDelegate.newException(Messages.RemoteServicesDelegate_Write_Operation_NullPath, null);
        }
        IFileStore lres = fileSvc.getResource(path);
        BufferedOutputStream os = new BufferedOutputStream(lres.openOutputStream(0, progress));
        if (!progress.isCanceled()) {
            try {
                try {
                    os.write(contents.getBytes());
                    os.flush();
                }
                catch (IOException ioe) {
                    throw RemoteServicesDelegate.newException(String.valueOf(Messages.RemoteServicesDelegate_Write_OperationFailed) + path, ioe);
                }
            }
            finally {
                try {
                    os.close();
                }
                catch (IOException ioe) {
                    JAXBControlCorePlugin.log(ioe);
                }
            }
        }
    }

    public static RemoteServicesDelegate getDelegate(String remoteConectionTypeId, String remoteConnectionName, IProgressMonitor monitor) throws CoreException {
        RemoteServicesDelegate delegate = fDelegates.get(String.valueOf(remoteConectionTypeId) + "." + remoteConnectionName);
        if (delegate == null) {
            delegate = new RemoteServicesDelegate(remoteConectionTypeId, remoteConnectionName);
            fDelegates.put(String.valueOf(remoteConectionTypeId) + "." + remoteConnectionName, delegate);
        }
        delegate.initialize(monitor);
        return delegate;
    }

    private RemoteServicesDelegate(String remoteConectionTypeId, String remoteConnectionName) {
        this.remoteConnectionTypeId = remoteConectionTypeId;
        this.remoteConnectionName = remoteConnectionName;
    }

    public IRemoteConnection getLocalConnection() {
        return this.localConnection;
    }

    public IRemoteFileService getLocalFileService() {
        return (IRemoteFileService)this.localConnection.getService(IRemoteFileService.class);
    }

    public URI getLocalHome() {
        IRemoteFileService fileSvc = this.getLocalFileService();
        return fileSvc.toURI(fileSvc.getBaseDirectory());
    }

    public IRemoteConnection getRemoteConnection() {
        return this.remoteConnection;
    }

    public IRemoteFileService getRemoteFileService() {
        return (IRemoteFileService)this.remoteConnection.getService(IRemoteFileService.class);
    }

    public URI getRemoteHome() {
        IRemoteFileService fileSvc = this.getRemoteFileService();
        return fileSvc.toURI(fileSvc.getBaseDirectory());
    }

    public IRemoteProcessBuilder getLocalProcessBuilder(List<String> command) {
        return ((IRemoteProcessService)this.localConnection.getService(IRemoteProcessService.class)).getProcessBuilder(command);
    }

    public IRemoteProcessBuilder getRemoteProcessBuilder(List<String> command) {
        return ((IRemoteProcessService)this.remoteConnection.getService(IRemoteProcessService.class)).getProcessBuilder(command);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        if (JAXBControlCorePlugin.getDefault() == null) {
            return;
        }
        IRemoteServicesManager svcsManager = RemoteServicesDelegate.getService(IRemoteServicesManager.class);
        this.localConnectionType = svcsManager.getLocalConnectionType();
        this.localConnection = (IRemoteConnection)this.localConnectionType.getConnections().get(0);
        if (this.remoteConnectionTypeId != null) {
            this.remoteConnectionType = svcsManager.getConnectionType(this.remoteConnectionTypeId);
            if (this.remoteConnectionType == null) throw new CoreException((IStatus)new Status(4, JAXBControlCorePlugin.getUniqueIdentifier(), Messages.RemoteServicesDelegate_3));
            this.remoteConnection = this.remoteConnectionType.getConnection(this.remoteConnectionName);
            if (this.remoteConnection == null) throw new CoreException((IStatus)new Status(4, JAXBControlCorePlugin.getUniqueIdentifier(), Messages.RemoteServicesDelegate_2));
            if (!this.remoteConnection.hasService(IRemoteFileService.class)) {
                throw new CoreException((IStatus)new Status(4, JAXBControlCorePlugin.getUniqueIdentifier(), Messages.RemoteServicesDelegate_0));
            }
            if (!this.remoteConnection.hasService(IRemoteProcessService.class)) {
                throw new CoreException((IStatus)new Status(4, JAXBControlCorePlugin.getUniqueIdentifier(), Messages.RemoteServicesDelegate_1));
            }
        } else {
            this.remoteConnectionType = this.localConnectionType;
            this.remoteConnection = this.localConnection;
        }
        if (this.remoteConnection.isOpen()) return;
        this.remoteConnection.open((IProgressMonitor)progress.newChild(1));
    }

    public static <T> T getService(Class<T> service) {
        BundleContext context = JAXBControlCorePlugin.getDefault().getBundle().getBundleContext();
        ServiceReference ref = context.getServiceReference(service);
        return (T)(ref != null ? context.getService(ref) : null);
    }
}

