/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.job;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.Repository;

public class RuleUtil {
    public static ISchedulingRule getRule(Repository repository) {
        IProject[] projects = RuleUtil.getProjects(repository);
        if (projects.length == 0) {
            return null;
        }
        return new MultiRule((ISchedulingRule[])projects);
    }

    public static ISchedulingRule getRuleForRepositories(Collection<Repository> repositories) {
        ISchedulingRule result = null;
        for (Repository repository : repositories) {
            ISchedulingRule rule = RuleUtil.getRule(repository);
            result = MultiRule.combine(result, (ISchedulingRule)rule);
        }
        return result;
    }

    public static ISchedulingRule getRuleForRepositories(IResource[] resources) {
        ISchedulingRule result = null;
        HashSet<Repository> repositories = new HashSet<Repository>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            RepositoryMapping mapping = RepositoryMapping.getMapping(resource);
            if (mapping != null) {
                repositories.add(mapping.getRepository());
            }
            ++n2;
        }
        for (Repository repository : repositories) {
            ISchedulingRule rule = RuleUtil.getRule(repository);
            result = MultiRule.combine(result, (ISchedulingRule)rule);
        }
        return result;
    }

    public static ISchedulingRule getRuleForContainers(Collection<IPath> paths) {
        ArrayList<ISchedulingRule> rules = new ArrayList<ISchedulingRule>();
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        for (IPath path : paths) {
            IContainer container;
            ISchedulingRule rule;
            IResource resource = ResourceUtil.getResourceForLocation(path);
            if (resource == null || (rule = ruleFactory.modifyRule((IResource)(container = resource.getParent()))) == null) continue;
            rules.add(rule);
        }
        if (rules.size() == 0) {
            return null;
        }
        return new MultiRule(rules.toArray(new ISchedulingRule[rules.size()]));
    }

    private static IProject[] getProjects(Repository repository) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> result = new ArrayList<IProject>();
        File parentFile = repository.getWorkTree();
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            IPath projectLocation = p.getLocation();
            if (projectLocation != null && projectLocation.toFile().getAbsolutePath().startsWith(parentFile.getAbsolutePath())) {
                result.add(p);
            }
            ++n2;
        }
        return result.toArray(new IProject[result.size()]);
    }
}

